//
//  Reachability.swift
//  iEstimate
//
//  Created by Tushar Premal on 14/03/19.
//  Copyright © 2019 Tushar Premal. All rights reserved.
//

import Foundation
import SystemConfiguration
import Network

public class Reachabilities {
    
    static let shared = Reachabilities()
    let monitor = NWPathMonitor()
    private var status: NWPath.Status = .requiresConnection
    var isReachable: Bool { status == .satisfied }
    var isReachableOnCellular: Bool = true
    var isInternetAlertShown = false
    
    private init() {
        
    }
    func isConnectedToNetwork() -> Bool {
        return isReachable
    }
    
    func startMonitoring() {
        monitor.pathUpdateHandler = { [unowned self] path in
            self.status = path.status
            self.isReachableOnCellular = path.isExpensive
            
            if path.status == .satisfied {
                print("We're connected!")
                // post connected notification
                if AppConstants.userData != nil{
                    SocketService.shared?.startSocket()
                }
            } else {
                print("No connection.")
                // post disconnected notification
                if !isInternetAlertShown{
                    isInternetAlertShown = true
                    DispatchQueue.main.async {
                        if let VC = UIApplication.topViewController(){
                            AppValidation().showAlertView(parentVC: VC, withAlertTile: "Error", withAlertMsg: "Please check your internet connection. If the internet is not avilable, your orders will not sync with other devices.", withActionsTitle: ["Confirm"]) { (index) in
                                self.isInternetAlertShown = false
                            }
                        }
                    }
                }
                SocketService.shared?.stopSocket()
                
            }
            print(path.isExpensive)
        }
        
        let queue = DispatchQueue(label: "NetworkMonitor")
        monitor.start(queue: queue)
    }
    
    func stopMonitoring() {
        monitor.cancel()
    }
}

