//
//  WebServiceManager.swift
//   Carbidding
//
//  Created by Tushar Premal on 5/29/18.
//  Copyright © 2018 TiffinTom. All rights reserved.
//

import Foundation
import UIKit
import MobileCoreServices
import StripeTerminal
import FirebaseMessaging

public class WebServiceManager: NSObject,ConnectionTokenProvider{
    
    func requestAPI(params:[String:Any],fileParam:NSMutableDictionary? = nil, urlString : String, method: String, isAdminURL: Bool = false, saveAdminToken: Bool = false, isRestaurantAPI: Bool = false, postCompleted : @escaping (_ msg: String, _ responsedata: Any?) -> ()){
        if Reachabilities.shared.isConnectedToNetwork(){
            var strURL = urlString
            
            //create url connection from url
            var request:URLRequest!
            if let url = URL(string:strURL){
                request = URLRequest(url:url)
            }else if let url = URL(string:strURL.addingPercentEncoding(withAllowedCharacters: .urlHostAllowed) ?? ""){
                request = URLRequest(url:url)
            }else{
                postCompleted("Invalid URL", nil)
            }
            
            request.httpMethod = method
            request.timeoutInterval = 30
            
            var jsonString = ""
            
            
            if method == "GET"{
                if params.count > 0{
                    let jsonString = params.reduce("") { "\($0)\($1.0)=\($1.1)&" }.dropLast()
                    strURL = "\(urlString)?\(jsonString)"
                }
                if let url = URL(string:strURL){
                    request = URLRequest(url:url)
                }else if let url = URL(string:strURL.addingPercentEncoding(withAllowedCharacters: .urlPathAllowed) ?? ""){
                    request = URLRequest(url:url)
                }
            }else{
                if fileParam != nil{
                    let boundary : NSString = "---------------------------14737809831466499882746641449"
                    if let FileData = fileParam{
                        var body = Data()
                        for (key, value) in params {
                            body.append("--\(boundary)\r\n".data(using: String.Encoding(rawValue: String.Encoding.utf8.rawValue))!)
                            body.append("Content-Disposition: form-data; name=\"\(key)\"\r\n\r\n".data(using: String.Encoding(rawValue: String.Encoding.utf8.rawValue))!)
                            body.append("\(value)\r\n".data(using: String.Encoding(rawValue: String.Encoding.utf8.rawValue))!)
                        }
                        
                        let contentType : NSString = NSString(format:"multipart/form-data; boundary=%@",boundary)
                        
                        request.addValue(contentType as String, forHTTPHeaderField: "Content-Type")
                        
                        guard let keys = FileData["keys"] as? [String] else {
                            return
                        }
                        guard let names = FileData["names"] as? [String] else {
                            return
                        }
                        guard let files = FileData["files"] as? [Data] else {
                            return
                        }
                        
                        for i in 0..<keys.count {
                            let mimetype = mimeTypeForPath(path: names[i])
                            body.append("--\(boundary)\r\n".data(using: String.Encoding(rawValue: String.Encoding.utf8.rawValue))!)
                            body.append("Content-Disposition: form-data; name=\"\(keys[i])\"; filename=\"\(names[i])\"\r\n".data(using: String.Encoding(rawValue: String.Encoding.utf8.rawValue))!)
                            body.append("Content-Type: \(mimetype)\r\n\r\n".data(using: String.Encoding(rawValue: String.Encoding.utf8.rawValue))!)
                            body.append(files[i])
                            body.append("\r\n".data(using: String.Encoding(rawValue: String.Encoding.utf8.rawValue))!)
                        }
                        
                        body.append("--\(boundary)\r\n".data(using: String.Encoding(rawValue: String.Encoding.utf8.rawValue))!)
                        
                        request.httpBody = body
                        
                        request.setValue("\(body.count)", forHTTPHeaderField:"Content-Length")
                    }else{
                        request.addValue("application/json", forHTTPHeaderField:"Content-Type")
                        request.httpBody = jsonString.data(using: .utf8, allowLossyConversion: false)
                    }
                }else{
                    if params.count > 0{
                        jsonString = getPostString(params: params)
                    }
                    let jsonData = jsonString.data(using: .utf8, allowLossyConversion: false)!
                    request.httpBody  = jsonData
                }
            }
            
            request.setValue(Bundle.main.bundleIdentifier ?? "", forHTTPHeaderField: "package-name")
            
            
            if let id = AppConstants.businessData?.id{
                request.setValue("\(id)", forHTTPHeaderField: "business-id")
            }
            if let id = AppConstants.webResId, isRestaurantAPI{
                request.setValue(id, forHTTPHeaderField: "restaurant-id")
            }
            
            if isAdminURL{
                if let token = AppCommonMethods.readObjfromUserDefault(withKey: AppConstants.userDefaultKey.kAdminRefreshHeaderToken) as? String{
                    request.setValue(token, forHTTPHeaderField: "x-refresh-token")
                }
                if let token = AppCommonMethods.readObjfromUserDefault(withKey: AppConstants.userDefaultKey.kAdminHeaderToken) as? String{
                    request.setValue(token, forHTTPHeaderField: "x-token")
                }
            }else{
                if let token = AppCommonMethods.readObjfromUserDefault(withKey: AppConstants.userDefaultKey.kRefreshHeaderToken) as? String{
                    request.setValue(token, forHTTPHeaderField: "x-refresh-token")
                }else{
                    if let user = AppConstants.userData{
                        callLoginAPI(user: user, params: params, fileParam: fileParam, urlString: urlString, method: method, isAdminURL: isAdminURL, saveAdminToken: saveAdminToken, isRestaurantAPI: isRestaurantAPI) { msg, response in
                            postCompleted(msg, response)
                        }
                        return
                    }
                }
                if let token = AppCommonMethods.readObjfromUserDefault(withKey: AppConstants.userDefaultKey.kHeaderToken) as? String{
                    request.setValue(token, forHTTPHeaderField: "x-token")
                }
            }
            
            
            let task = URLSession.shared.dataTask(with: request) { (data, response, error) in
                if (error != nil){
                    print("Failed:", error?.localizedDescription ?? "")
                    postCompleted(error!.localizedDescription, nil) //completion handler with error message
                }else{
                    //parse jsondata into dictionary
                    if let httpResponse = response as? HTTPURLResponse, var data = data{
                        if AppConstants.isInDevlopmentMode{
                            print("Parameter:",jsonString)
                            print("Request:",request ?? "")
                            print("data:", String.init(data: data, encoding: .utf8) ?? "")
                        }
                        if httpResponse.statusCode == 200{
                            if var string = String.init(data: data, encoding: .utf8){
                                if string.count > 87{
                                    for _ in 1...15{
                                        let index = string.index(string.startIndex, offsetBy: string.count - 4, limitedBy: string.endIndex)!
                                        string.remove(at: index)
                                    }
                                    string.removeFirst(15)
                                    for _ in 1...7{
                                        let index = string.index(string.startIndex, offsetBy: 8, limitedBy: string.endIndex)!
                                        string.remove(at: index)
                                    }
                                    for _ in 1...8{
                                        let index = string.index(string.startIndex, offsetBy: 14, limitedBy: string.endIndex)!
                                        string.remove(at: index)
                                    }
                                    for _ in 1...6{
                                        let index = string.index(string.startIndex, offsetBy: 22, limitedBy: string.endIndex)!
                                        string.remove(at: index)
                                    }
                                    for _ in 1...7{
                                        let index = string.index(string.startIndex, offsetBy: 28, limitedBy: string.endIndex)!
                                        string.remove(at: index)
                                    }
                                }
                                if let newData = string.data(using: .utf8){
                                    let aes = EasyAES.init(key: AppConstants.keyForAPI, bit: 256, andIV: AppConstants.ivForAPI)
                                    data = aes.decryptData(newData)
                                }
                            }
                        }
                        let jsonData: Any?
                        do {
                            jsonData = try JSONSerialization.jsonObject(with: data, options:JSONSerialization.ReadingOptions.mutableContainers )
                            if AppConstants.isInDevlopmentMode{
                                if jsonData != nil{
                                    print("Response:",jsonData!)
                                }
                            }
                            
                            if httpResponse.statusCode == 200{
                                if let xRefreshToken = httpResponse.allHeaderFields["x-refresh-token"] as? String {
                                    print("xRefreshToken",xRefreshToken)
                                    if saveAdminToken{
                                        AppCommonMethods.saveDataIntoUserDefault(value: xRefreshToken, withKey: AppConstants.userDefaultKey.kAdminRefreshHeaderToken)
                                    }else{
                                        AppCommonMethods.saveDataIntoUserDefault(value: xRefreshToken, withKey: AppConstants.userDefaultKey.kRefreshHeaderToken)
                                    }
                                    
                                }
                                if let xToken = httpResponse.allHeaderFields["x-token"] as? String {
                                    print("xToken",xToken, saveAdminToken)
                                    if saveAdminToken{
                                        AppCommonMethods.saveDataIntoUserDefault(value: xToken, withKey: AppConstants.userDefaultKey.kAdminHeaderToken)
                                    }else{
                                        AppCommonMethods.saveDataIntoUserDefault(value: xToken, withKey: AppConstants.userDefaultKey.kHeaderToken)
                                    }
                                }
                                postCompleted("SUCCESS",jsonData)
                            }else{
                                if httpResponse.statusCode == 401{
                                    DispatchQueue.main.async {
                                        AppCommonMethods.stopProgressBar()
                                        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kUserData)
                                        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kRefreshHeaderToken)
                                        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kHeaderToken)
                                        AppConstants.isAdminLogin = false
                                        AppConstants.isSupervisorLogin = false
                                        SocketService.shared?.stopSocket()
                                        SocketService.destroySharedManager()
                                        if isAdminURL{
                                            AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kAdminUserData)
                                            AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kBusinessData)
                                            Messaging.messaging().unsubscribe(fromTopic: "business_\(AppConstants.businessData?.id ?? 0)") { error in
                                                if error != nil{
                                                    print("Error topic: \(error?.localizedDescription ?? "")")
                                                }else{
                                                    print("Unsubscribed to topic")
                                                }
                                            }
                                            AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kAdminRefreshHeaderToken)
                                            AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kAdminHeaderToken)
                                            if let VC = AdminLoginVC.instance(){
                                                let navc = UINavigationController.init(rootViewController: VC)
                                                navc.isNavigationBarHidden = true
                                                AppConstants.appDelegate.window?.rootViewController = navc
                                            }
                                        }else{
                                            if let VC = LoginVC.instance(){
                                                let navc = UINavigationController.init(rootViewController: VC)
                                                navc.isNavigationBarHidden = true
                                                AppConstants.appDelegate.window?.rootViewController = navc
                                            }
                                        }
                                        if let dictResponse = jsonData as? NSDictionary{
                                            AppCommonMethods.showToastAlert(message: dictResponse.getStringValue("message") ?? "")
                                        }
                                    }
                                }else{
                                    if let dictResponse = jsonData as? NSDictionary{
                                        postCompleted(dictResponse.getStringValue("message") ?? AppConstants.GlobalAlert.kServerErrorMsg, nil)
                                    }else{
                                        postCompleted(AppConstants.GlobalAlert.kServerErrorMsg, nil)
                                    }
                                }
                            }
                        } catch let error {
                            jsonData = nil
                            postCompleted(error.localizedDescription, nil)
                        }
                    }
                }
            }
            task.resume()
        }else{
            postCompleted("", nil)
        }
        
    }
    
    func getPostString(params:[String:Any]) -> String{
        var data = [String]()
        for(key, value) in params{
            if value is NSDictionary{
                
            }else{
                data.append(key + "=\(value)")
            }
        }
        return data.map { String($0) }.joined(separator: "&")
    }
    
    func postAPIForStripe(params:[String:Any], urlString : String, postCompleted : @escaping (_ msg: String, _ responsedata: Any?) -> ()){
        if Reachabilities.shared.isConnectedToNetwork(){
            
            //create url connection from url
            var request:URLRequest!
            if let url = URL(string:urlString){
                request = URLRequest(url:url)
            }else if let url = URL(string:urlString.addingPercentEncoding(withAllowedCharacters: .urlPathAllowed) ?? ""){
                request = URLRequest(url:url)
            }
            request.httpMethod = "POST"
            request.timeoutInterval = 30
            
            let jsonString = params.reduce("") { "\($0)\($1.0)=\($1.1)&" }.dropLast()
            let jsonData = jsonString.data(using: .utf8, allowLossyConversion: false)!
            request.httpBody = jsonData
            
            if let siteSettings = UserDefaults.siteSettings{
                if siteSettings.finance_stripe_mode.lowercased() == "live"{
                    request.setValue("Bearer \(siteSettings.finance_stripe_secretkey)", forHTTPHeaderField: "Authorization")
                }else{
                    request.setValue("Bearer \(siteSettings.finance_stripe_secretkeyTest)", forHTTPHeaderField: "Authorization")
                }
            }
            request.setValue("application/x-www-form-urlencoded", forHTTPHeaderField: "Content-Type")
            
            let task = URLSession.shared.dataTask(with: request) { (data, response, error) in
                if (error != nil){
                    postCompleted(error!.localizedDescription, nil) //completion handler with error message
                }
                else{
                    let jsonData: Any?
                    do {
                        jsonData = try JSONSerialization.jsonObject(with: data!, options:JSONSerialization.ReadingOptions.mutableContainers )
                        if AppConstants.isInDevlopmentMode{
                            if jsonData != nil{
                                print("Parameter:",params)
                                print("URL:",response?.url?.absoluteString ?? "")
                                print("Response:",jsonData!)
                            }
                        }
                        postCompleted("SUCCESS",jsonData)
                    } catch let error {
                        jsonData = nil
                        postCompleted(error.localizedDescription, nil)
                    }
                }
            }
            task.resume()
        }else{
            postCompleted(AppConstants.GlobalAlert.kNoInternetMsg, nil)
        }
        
    }
    
    public func fetchConnectionToken(_ completion: @escaping ConnectionTokenCompletionBlock) {
        let config = URLSessionConfiguration.default
        let session = URLSession(configuration: config)
        guard let url = URL(string: AppConstants.APIURL.kConnectionTokenAPI) else {
            print("invalid url")
            return
        }
        var locationId = ""
        if AppConstants.selectedReader?.sLocationId ?? "" != ""{
            locationId = AppConstants.selectedReader?.sLocationId ?? ""
        }else if AppConstants.selectedStripeReader?.locationId ?? "" != ""{
            locationId = AppConstants.selectedStripeReader?.locationId ?? ""
        }
        let params = ["business_id":AppConstants.businessData?.id ?? 0, "s_location_id": locationId] as [String : Any]
        let jsonString = getPostString(params: params)
        let jsonData = jsonString.data(using: .utf8, allowLossyConversion: false)!
        
        var request = URLRequest(url: url)
        request.httpBody  = jsonData
        request.httpMethod = "POST"
        let task = session.dataTask(with: request) { (data, response, error) in
            if var data = data {
                if var string = String.init(data: data, encoding: .utf8){
                    if string.count > 87{
                        for _ in 1...15{
                            let index = string.index(string.startIndex, offsetBy: string.count - 4, limitedBy: string.endIndex)!
                            string.remove(at: index)
                        }
                        string.removeFirst(15)
                        for _ in 1...7{
                            let index = string.index(string.startIndex, offsetBy: 8, limitedBy: string.endIndex)!
                            string.remove(at: index)
                        }
                        for _ in 1...8{
                            let index = string.index(string.startIndex, offsetBy: 14, limitedBy: string.endIndex)!
                            string.remove(at: index)
                        }
                        for _ in 1...6{
                            let index = string.index(string.startIndex, offsetBy: 22, limitedBy: string.endIndex)!
                            string.remove(at: index)
                        }
                        for _ in 1...7{
                            let index = string.index(string.startIndex, offsetBy: 28, limitedBy: string.endIndex)!
                            string.remove(at: index)
                        }
                    }
                    if let newData = string.data(using: .utf8){
                        let aes = EasyAES.init(key: AppConstants.keyForAPI, bit: 256, andIV: AppConstants.ivForAPI)
                        data = aes.decryptData(newData)
                    }
                }
                do {
                    if let json = try JSONSerialization.jsonObject(with: data, options: []) as? NSDictionary, let token = json.getStringValue("token"){
                        completion(token, nil)
                    }else{
                        let error = NSError(domain: "com.stripe-terminal-ios.example", code: 2000, userInfo: [NSLocalizedDescriptionKey: "Missing `secret` in ConnectionToken JSON response"])
                        completion(nil, error)
                    }
                }
                catch {
                    completion(nil, error)
                }
            }else {
                let error = NSError(domain: "com.stripe-terminal-ios.example", code: 1000, userInfo: [NSLocalizedDescriptionKey: "No data in response from ConnectionToken endpoint"])
                completion(nil, error)
            }
        }
        task.resume()
    }
    
    func queryString(parameters : NSDictionary) -> String{
        var firstPass = true
        var result = ""
        for (key, value) in parameters{
            
            let encodedKey = (key as! NSString).addingPercentEncoding(withAllowedCharacters: .urlHostAllowed)!
            let encodedValue = (value as! NSString).addingPercentEncoding(withAllowedCharacters: .urlHostAllowed)!
            result += firstPass ? "\(encodedKey)=\(encodedValue)" : "&\(encodedKey)=\(encodedValue)"
            firstPass = false;
        }
        
        return result
    }
    
    func mimeTypeForPath(path: String) -> String {
        let pathExtension = path.pathExtension
        var stringMimeType = "application/octet-stream";
        if let uti = UTTypeCreatePreferredIdentifierForTag(kUTTagClassFilenameExtension, pathExtension! as CFString, nil)?.takeRetainedValue() {
            if let mimetype = UTTypeCopyPreferredTagWithClass(uti, kUTTagClassMIMEType)?.takeRetainedValue() {
                stringMimeType = mimetype as NSString as String
            }
        }
        return stringMimeType;
    }
    
    func callLoginAPI(user:UserModel, params:[String:Any],fileParam:NSMutableDictionary? = nil, urlString : String, method: String, isAdminURL: Bool = false, saveAdminToken: Bool = false, isRestaurantAPI: Bool = false, postCompleted : @escaping (_ msg: String, _ responsedata: Any?) -> ()){
        if let user = AppConstants.userData{
            var dictParam = [String:String]()
            dictParam["username"] = user.username ?? ""
            dictParam["password"] = user.password ?? ""
            requestAPI(params: dictParam, urlString: AppConstants.APIURL.kLogin, method: "POST", isAdminURL: true, saveAdminToken: false) { (message, result) in
                DispatchQueue.main.async {
                    if let response = result as? NSDictionary{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let aLoginData = try? jsonDecoder.decode(UserModel.self, from: data){
                            if let encoded = AppCommonMethods.getjsonDataFromCodable(object: aLoginData) {
                                AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kUserData)
                            }
                            AppCommonMethods.saveDataIntoUserDefault(value: Int(Date().timeIntervalSince1970), withKey: AppConstants.userDefaultKey.kLoginTimeStamp)
                            self.requestAPI(params: params, fileParam: fileParam, urlString: urlString, method: method, isAdminURL: isAdminURL, saveAdminToken: saveAdminToken, isRestaurantAPI: isRestaurantAPI) { msg, responsedata in
                                postCompleted(msg,responsedata)
                                DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
                                    AppCommonMethods.FetchUserProfile()
                                }
                            }
                            return
                        }
                    }
                    AppCommonMethods.stopProgressBar()
                    AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kUserData)
                    AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kRefreshHeaderToken)
                    AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kHeaderToken)
                    AppConstants.isAdminLogin = false
                    AppConstants.isSupervisorLogin = false
                    if let VC = LoginVC.instance(){
                        let navc = UINavigationController.init(rootViewController: VC)
                        navc.isNavigationBarHidden = true
                        AppConstants.appDelegate.window?.rootViewController = navc
                    }
                }
            }
        }
    }
}

extension String {
    var ns: NSString {
        return self as NSString
    }
    var pathExtension: String? {
        return ns.pathExtension
    }
    var lastPathComponent: String? {
        return ns.lastPathComponent
    }
}
