//
//  SocketDemo.swift
//  EPOS
//
//  Created by MacBook on 23/03/23.
//

import Foundation
import UIKit
import SocketIO

extension UserDefaults {
    enum Keys: String {
        case LastOrderSyncTime
    }

    static var LastOrderSyncTime: Double? {
        get {
            return standard.double(forKey: Keys.LastOrderSyncTime.rawValue)
        }
        set {
            standard.setValue(newValue, forKey: Keys.LastOrderSyncTime.rawValue)
        }
    }
    
    static var siteSettings:TiffintomSiteSettingModel?{
        get{
            if let data = standard.value(forKey: "tiffintom_site_settings") as? Data{
                let decoder = JSONDecoder()
                return try? decoder.decode(TiffintomSiteSettingModel.self, from: data)
            }
            return nil
        }
        set{
            if let newValue{
                if let encoded = AppCommonMethods.getjsonDataFromCodable(object: newValue) {
                    standard.setValue(encoded, forKey: "tiffintom_site_settings")
                }
            }else{
                standard.removeObject(forKey: "tiffintom_site_settings")
            }
        }
        
    }
}


class SocketService:NSObject{
    
    private static var sharedInstance: SocketService?
    var socketIO: SocketIOClient?
    var manager: SocketManager?
    var currentOrderId:String?
    var currentTableId:Int?
    var isSocketAlertShown = false
    var isSocketConnectedOnce = false
    
    class var shared : SocketService? {
        if AppConstants.DataSyncMode == "Auto"{
            guard let sharedInstance = self.sharedInstance else {
                let sharedInstance = SocketService()
                self.sharedInstance = sharedInstance
                return sharedInstance
            }
            return sharedInstance
        }
        return nil
    }
    
    class func destroySharedManager() {
        sharedInstance = nil
    }
    
    private override init() {
        super.init()
    }
    
    func startSocket(){
        //"http://soc1.ubsidi.com:3000"
        let url = AppCommonMethods.fetchSiteSettingValue(key: "restaurant_website", lowercased: false) ?? ""
        print("socket URL:", url)
        if url.isEmpty{
            return
        }
        manager = SocketManager(socketURL: URL(string: url)!, config: [.log(true), .compress, .connectParams(["businessId":"\(AppConstants.businessData?.id ?? 0)"])])
        socketIO = manager?.defaultSocket
        
        if(socketIO?.status == .disconnected || socketIO?.status == .notConnected){
            socketIO?.on("createOrder", callback: { (data, ack) in
                print("socket order receive:",data)
                if let data = data.first as? [String:Any]{
                    let jsonDecoder = JSONDecoder()
                    if let order = AppCommonMethods.convertToJson(object: data), let newOrder = try? jsonDecoder.decode(OrderModel.self, from: order){
                        newOrder.isNewOrder = 0
                        if newOrder.table != nil{
                            let tabel = newOrder.table!
                            tabel.lastOrderId = newOrder.id ?? 0
                            tabel.lastOrderTime = newOrder.createdDate?.getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'") ?? ""
                            tabel.lastOrderTotal = newOrder.total ?? 0
                            SQLiteManage.updateTableSocket(model: tabel)
                            NotificationCenter.default.post(name: AppConstants.notifications.kTableUpdated, object: nil)
                        }
                        newOrder.arrProducts.forEach {
                            if $0.product?.id == nil{
                                if let product = CoreDataHelper.shared.fetchProductObejct(prodcutId: $0.prodcutId ?? 0){
                                    $0.product = product
                                }
                            }
                        }
                        if self.currentOrderId ?? "" == newOrder.uniqueId{
                            newOrder.arrProducts.forEach { $0.isItemUpdated = 0 }
                            SQLiteManage.SaveOrderIntoDatabase(order: newOrder, updated: 0, isFromAPI: true)
                            NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(self.orderSendFailed), object: nil)
                            NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: ["unique_id":self.currentOrderId!])
                            self.currentOrderId = nil
                        }else{
                            SQLiteManage.SaveOrderIntoDatabase(order: newOrder, updated: 0, isFromAPI: true)
                            NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: ["unique_id":newOrder.uniqueId])
                        }
                    }
                }
            })
            socketIO?.on("onlineOrderCreate", callback: { (data, ack) in
                print("socket online order receive:",data)
                if AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1{
                    let jsonDecoder = JSONDecoder()
                    if let arrO = data.first as? NSDictionary, let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode(WebOrderModel.self, from: data){
                        if let time = arrO.getStringValue("preparation_time"), !time.isEmpty{
                            self.changeOrderStatus(order: aData, prepTime: time)
                        }else{
                            if var VC = UIApplication.topViewController(){
                                if let sheetVC = VC as? SheetViewController{
                                    if let controller = UIApplication.topViewController(controller: sheetVC.presentingViewController){
                                        VC = controller
                                    }
                                }
                                if let sideController = VC as? SideMenuVC, let lastVC = sideController.children.last{
                                    VC = lastVC
                                }
                                if let VC = VC as? OrderListVC{
                                    VC.addNewOnlineOrder(order: aData, isNewOrder: true)
                                }
                                if let VC = VC as? HomeViewController{
                                    VC.addNewOnlineOrder(order: aData, isNewOrder: true)
                                }
                            }
                            if let _ = NewOnlineOrderVC.showPopup(order: aData, orderType: aData.orderType ?? ""){
                                
                            }
                        }
                    }
                }
            })
            socketIO?.on("pending_count", callback: { (data, ack) in
                print("socket pending count order receive:",data)
                if AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1{
                    if let data = data.first as? [String:Any], let dict = data["pending_count"] as? NSDictionary{
                        BadgeManager().checkAndPlayAudio(result: dict)
                    }
                }
            })
            if AppConstants.DataSyncMode == "Auto"{
                socketIO?.on("updateTable", callback: { (data, ack) in
                    print("socket table receive:",data)
                    if let data = data.first as? [String:Any]{
                        if let _ = data["_last_order_id"] as? Int{
                            return
                        }
                        let jsonDecoder = JSONDecoder()
                        if let jsonData = AppCommonMethods.convertToJson(object: data), let table = try? jsonDecoder.decode(TableModel.self, from: jsonData){
                            if self.currentTableId == table.id{
                                NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(self.tableSendFailed), object: nil)
                                self.currentTableId = nil
                            }
                            if table.tableStatus?.status?.lowercased() ?? "" == "vacant"{
                                let orders = SQLiteManage.FetchOrdersForTable(table: table)
                                if let order = orders.first{
                                    table.lastOrderId = order.id
                                    table.lastOrderTime = order.createdDate?.getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'") ?? ""
                                    table.lastOrderTotal = order.total ?? 0
                                    if order.orderStatusId ?? 0 == 4{
                                        if let status = CoreDataHelper.shared.fetchTableStatusData(name: "Served and paid").first{
                                            table.tableStatus = status
                                            table.tableStatusId = status.id
                                        }
                                    }else if order.orderStatusId ?? 0 == 12{
                                        if let status = CoreDataHelper.shared.fetchTableStatusData(name: "Order Taken").first{
                                            table.tableStatus = status
                                            table.tableStatusId = status.id
                                        }
                                    }else{
                                        if let status = CoreDataHelper.shared.fetchTableStatusData(name: "Taking Order").first{
                                            table.tableStatus = status
                                            table.tableStatusId = status.id
                                        }
                                    }
                                    SQLiteManage.updateTableStatus(tableId: table.id ?? 0, statusId: table.tableStatusId, lastOrderId: order.id, lastOrderTotal: table.lastOrderTotal, lastOrderTime: table.lastOrderTime)
                                    AppCommonMethods.SaveTable(table: table, statusId: table.tableStatusId, lastOrderId: order.id)
                                }
                            }
                            SQLiteManage.updateTableSocket(model: table)
                            NotificationCenter.default.post(name: AppConstants.notifications.kTableUpdated, object: nil)
                        }
                    }
                })
            }
            socketIO?.on("deleteOrder", callback: { (data, ack) in
                print("socket delete order receive:",data)
                if let data = data.first as? String{
                    if let order = SQLiteManage.fetchOrderDataByUniqueId(orderId: data){
                        SQLiteManage.deleteOrder(orderId: order.id ?? 0, isFromAPI: true)
                        if self.currentOrderId ?? "" == data{
                            NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(self.orderSendFailed), object: nil)
                            NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: ["unique_id":self.currentOrderId!])
                            self.currentOrderId = nil
                        }else{
                            NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: ["unique_id":order.uniqueId])
                        }
                    }
                }
            })
            socketIO?.on(clientEvent: .statusChange, callback: { (data, ack) in
                print("socket status changed:", self.socketIO?.status.rawValue ?? "")
            })
            socketIO?.on(clientEvent: .error) { data, _ in
                if let error = data.first {
                    print("Socket.IO Error: \(error)")
                    NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(self.orderSendFailed), object: nil)
                    self.orderSendFailed()
                }
            }

            // Log connection failure
            socketIO?.on(clientEvent: .connect) { data, _ in
                if let error = data.first {
                    print("Connection Error: \(error)")
                }
                if self.isSocketConnectedOnce && AppConstants.userData != nil{
                    BGAPIExecution.shared.fetchAllOfflineOrders()
                    DispatchQueue.main.asyncAfter(deadline: .now()+0.5) {
                        self.FetchUnSynncedOrders()
                    }
                    self.isSocketConnectedOnce = true
                }
            }

            // Log disconnection
            socketIO?.on(clientEvent: .disconnect) { data, _ in
                print("Disconnected: \(data)")
                self.currentOrderId = nil
                self.currentTableId = nil
                UserDefaults.LastOrderSyncTime = Date().timeIntervalSinceReferenceDate
                if !self.isSocketAlertShown && AppConstants.userData != nil{
                    self.isSocketAlertShown = true
                    DispatchQueue.main.async {
                        MarqueeManager.shared.show(text: "The sync process has been intrupted, preventing data from syncing to other devices. Please check your internet connection.")
                        if let VC = UIApplication.topViewController(){
                            AppValidation().showAlertView(parentVC: VC, withAlertTile: "Connection Error", withAlertMsg: "The sync process has been interrupted, preventing data from syncing to other devices. Please check your internet connection. The process will automatically reconnect once the internet is restored, or you can manually restart to reconnect the service.", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_CANCEL, "Restart"]) { (index) in
                                if index == 1{
                                    if let VC = LoginVC.instance(){
                                        let navc = UINavigationController.init(rootViewController: VC)
                                        navc.isNavigationBarHidden = true
                                        AppConstants.appDelegate.window?.rootViewController = navc
                                    }
                                }
                                self.isSocketAlertShown = false
                            }
                        }
                    }
                }
            }
            
            self.socketIO?.connect()
        }
    }
    
    func changeOrderStatus(order:WebOrderModel, prepTime:String){
        var dictParam = [String:Any]()
        dictParam["preparation"] = prepTime
        let strURL = "\(AppConstants.APIURL.kOnlineOrder)\(order.id ?? 0)/change-status"
        dictParam["status"] = "Accepted"
        WebServiceManager().requestAPI(params: dictParam,  urlString: strURL, method: "POST", isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                let jsonDecoder = JSONDecoder()
                if let arrO = result as? NSDictionary, let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode(WebOrderModel.self, from: data){
                    if var VC = UIApplication.topViewController(){
                        if let sheetVC = VC as? SheetViewController{
                            if let controller = UIApplication.topViewController(controller: sheetVC.presentingViewController){
                                VC = controller
                            }
                        }
                        if let sideController = VC as? SideMenuVC, let lastVC = sideController.children.last{
                            VC = lastVC
                        }
                        if let VC = VC as? OrderListVC{
                            VC.addNewOnlineOrder(order: aData, isNewOrder: false)
                        }
                        if let VC = VC as? HomeViewController{
                            VC.addNewOnlineOrder(order: aData, isNewOrder: false)
                        }
                    }
                    if let _ = NewOnlineOrderVC.showPopup(order: aData, orderType: aData.orderType ?? ""){
                        
                    }
                }
            }
        }
    }
    
    func stopSocket(){
        if socketIO?.status == .connected || socketIO?.status == .connecting{
            self.socketIO?.disconnect()
        }
    }
    
    func sendOrderToSocket(data:[String:Any], id:String){
        self.currentOrderId = id
        self.perform(#selector(orderSendFailed), with: nil, afterDelay: 30)
        if socketIO?.status == .connected{
            print("order send:",data)
            socketIO?.emit("createOrder", AppCommonMethods.convertJsontoString(json: data, prettyPrinted: true, shouldEncode: false))
        }
    }
    
    func deleteOrderToSocket(id:String, isDeleteFromRunningOrder:Bool){
        self.currentOrderId = id
        self.perform(#selector(orderSendFailed), with: nil, afterDelay: 30)
        if socketIO?.status == .connected{
            print("delete order send:",["unique_id":id, "isDeleteFromRunningOrder" : isDeleteFromRunningOrder])
            socketIO?.emit("deleteOrder", ["unique_id":id, "isDeleteFromRunningOrder" : isDeleteFromRunningOrder])
        }
    }
    
    func sendTableToSocket(data:[String:Any], id:Int){
        self.currentTableId = id
        self.perform(#selector(tableSendFailed), with: nil, afterDelay: 30)
        if socketIO?.status == .connected && AppConstants.DataSyncMode == "Auto"{
            print("table send:",data)
            socketIO?.emit("updateTable", AppCommonMethods.convertJsontoString(json: data, prettyPrinted: true, shouldEncode: false))
        }
    }
    
    @objc func orderSendFailed(){
        print("orderSendFailed")
        if let id = self.currentOrderId{
            SQLiteManage.updateOrderFailedStatus(failed: 1, orderId: id)
            NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: ["unique_id":id])
            self.currentOrderId = nil
        }
    }
    
    @objc func tableSendFailed(){
        self.currentTableId = nil
    }
    
    func FetchUnSynncedOrders(){
        if let timeStamp = UserDefaults.LastOrderSyncTime, let id = AppConstants.businessData?.id{
            //http://ubsidi.in:3000/v1/orders/unsyncedOrders?businessId=1012&lastSyncTime=2025-03-04T19:25:32.075000Z&timezone=Asia/Kolkata
            let date = Date.init(timeIntervalSinceReferenceDate: timeStamp)
            var dictParam = [String:Any]()
            dictParam["businessId"] = id
            dictParam["lastSyncTime"] = date.getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
            dictParam["timezone"] = TimeZone.current.identifier
            WebServiceManager().requestAPI(params: dictParam, urlString: "http://soc1.ubsidi.com:3000/v1/orders/unsyncedOrders", method: "GET") { (message, result) in
                if let response = result as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([OrderModel].self, from: data){
                        aData.forEach { order in
                            order.arrProducts.forEach { product in
                                product.arrIngriedent.forEach { ingrident in
                                    ingrident.name = CoreDataHelper.shared.fetchIngredientDataFromId(id: ingrident.productIngredientId ?? 0)?.name ?? ""
                                }
                            }
                            let statusId = order.orderStatusId ?? 0
                            if order.table != nil && statusId != 11 && statusId != 10 && statusId != 9 && statusId != 5{
                                let tabel = order.table!
                                tabel.lastOrderId = order.id ?? 0
                                tabel.lastOrderTime = order.createdDate?.getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'") ?? ""
                                tabel.lastOrderTotal = order.total ?? 0
                                SQLiteManage.updateTableSocket(model: tabel)
                                NotificationCenter.default.post(name: AppConstants.notifications.kTableUpdated, object: nil)
                            }
                        }
                        SQLiteManage.SaveOrderIntoDatabase(arrOrder: aData, shouldDelete: false)
                    }
                }
            }
        }
    }
}
