//
//  OrderTableView.swift
//  EPOS
//
//  Created by Tushar Premal on 15/04/25.
//

import UIKit

class OrderTableView: UIView, UITableViewDelegate, UITableViewDataSource {

    @IBOutlet weak var lblTable:UILabel!
    @IBOutlet weak var lblPrice:UILabel!
    @IBOutlet weak var tblOrderItems:UITableView!
    @IBOutlet weak var btnOrder:UIButton!
    var order = OrderModel()
    var arrSection = [String]()
    var orderItems = [String:[OrderProductModel]]()
    
    static var instance:OrderTableView?{
        guard let view = Bundle.main.loadNibNamed("OrderTableView", owner: self, options: nil)?.first as? OrderTableView else { return nil }
        return view
    }
    
    func setViewData(order:OrderModel){
        tblOrderItems.sectionHeaderTopPadding = 0
        self.order = order
        self.lblTable.text = "\(order.table!.number ?? "")\n\(order.noGuest ?? 0)"
        self.lblPrice.text = String.init(format: "  %@ %.2f  ", AppConstants.currencySign, order.total ?? 0)
        self.tblOrderItems.register(UINib.init(nibName: "MultiOrderItemCell", bundle: nil), forCellReuseIdentifier: "MultiOrderItemCell")
        order.arrProducts.forEach { model in
            if let category = CoreDataHelper.shared.fetchCategoryById(id: model.product?.categoryId ?? 0){
                if var array = self.orderItems[category.name ?? ""]{
                    array.append(model)
                    self.orderItems[category.name ?? ""] = array
                }else{
                    self.orderItems[category.name ?? ""] = [model]
                    self.arrSection.append(category.name ?? "")
                }
            }
        }
        let totalItem = CGFloat(order.arrProducts.count) + CGFloat(self.arrSection.count)
        NSLayoutConstraint.activate([
            self.widthAnchor.constraint(equalToConstant: (UIScreen.main.bounds.width - 50)/3),
            self.heightAnchor.constraint(equalToConstant: (totalItem * 44) + 120)
        ])
        self.tblOrderItems.reloadData()
    }
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return arrSection.count
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        guard let cell = tableView.dequeueReusableCell(withIdentifier: "MultiOrderItemCell") as? MultiOrderItemCell else { return nil }
        cell.lblItemName.textColor = AppConstants.Colors.kAppThemeAquaColor
        cell.lblItemName.text = arrSection[section]
        return cell
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return orderItems[arrSection[section]]?.count ?? 0
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        guard let cell = tableView.dequeueReusableCell(withIdentifier: "MultiOrderItemCell", for: indexPath) as? MultiOrderItemCell else { return UITableViewCell() }
        let item = orderItems[arrSection[indexPath.section]]![indexPath.row]
        cell.lblItemName.text = "\(item.quantity ?? 0)x \(item.product?.shortName ?? "")"
        return cell
    }
}
