//
//  DesignableUITextField.swift
//  SkyApp
//
//  Created by Tushar Premal on 12/16/16.
//  Copyright © 2016 Tushar Premal. All rights reserved.
//

import UIKit

@IBDesignable
class UITextFieldX: UITextField {
    
    enum LINE_POSITION {
        case LINE_POSITION_TOP
        case LINE_POSITION_BOTTOM
    }
    
    
    @IBInspectable var leftPadding: CGFloat = 0 {
        didSet {
            self.layoutSubviews()
        }
    }
   
    @IBInspectable var rightPadding: CGFloat = 0 {
        didSet {
            self.layoutSubviews()
        }
    }
    
    
    @IBInspectable var borderColor: UIColor = .clear {
        didSet {
            layer.borderColor = borderColor.cgColor
        }
    }
    
    @IBInspectable var borderWidth: CGFloat = 0 {
        didSet {
            layer.borderWidth = borderWidth
        }
    }
    
    @IBInspectable var lineWidth: Float = 0 {
        didSet {
            updateView()
        }
    }
    
    
    // MARK: - Corner Radius
    @IBInspectable var cornerRadius: CGFloat = 0 {
        didSet {
            self.layer.cornerRadius = cornerRadius
        }
    }
    
    // MARK: - Shadow
    
    @IBInspectable public var shadowOpacity: CGFloat = 0 {
        didSet {
            layer.shadowOpacity = Float(shadowOpacity)
        }
    }
    
    @IBInspectable public var shadowColor: UIColor = UIColor.clear {
        didSet {
            layer.shadowColor = shadowColor.cgColor
        }
    }
    
    @IBInspectable public var shadowRadius: CGFloat = 0 {
        didSet {
            layer.shadowRadius = shadowRadius
        }
    }
    
    @IBInspectable public var shadowOffsetY: CGFloat = 0 {
        didSet {
            layer.shadowOffset.height = shadowOffsetY
        }
    }
    
    @IBInspectable var placeHolderColor: UIColor? {
        didSet {
            if placeHolderColor != nil{
                self.attributedPlaceholder = NSAttributedString(string:self.placeholder != nil ? self.placeholder! : "", attributes:[NSAttributedString.Key.foregroundColor: placeHolderColor!])
            }
        }
    }
    
    private var _borderPosition: LINE_POSITION = .LINE_POSITION_BOTTOM
    var borderPosition: LINE_POSITION {
        get {
            return _borderPosition
        }
        set {
            _borderPosition = newValue
            updateView()
        }
    }
    
    func updateView() {
//        setLeftImage()
//        setRightImage()
        addLineToView()
        // Placeholder text color
        //attributedPlaceholder = NSAttributedString(string: placeholder != nil ?  placeholder! : "", attributes:[NSAttributedString.Key.foregroundColor: UIColor.init(named: "ThemeTintColor")!])
    }
    
    // MARK: - Helper Methods
    override func textRect(forBounds bounds: CGRect) -> CGRect {
        super.textRect(forBounds: bounds)
        let rect = CGRect(
            x: leftPadding,
            y: 0,
            width: bounds.size.width-leftPadding-rightPadding,
            height: bounds.size.height
        )
        return rect
    }
   
    override func editingRect(forBounds bounds: CGRect) -> CGRect {
        super.editingRect(forBounds: bounds)
        let rect = CGRect(
            x: leftPadding,
            y: 0,
            width: bounds.size.width-leftPadding-rightPadding,
            height: bounds.size.height
        )
        return rect
    }
    
    func addLineToView() {
        let lineView = UIView()
        
        lineView.backgroundColor = borderColor
        lineView.translatesAutoresizingMaskIntoConstraints = false // This is important!
        self.addSubview(lineView)
        
        let metrics = ["width" : NSNumber(value: lineWidth)]
        let views = ["lineView" : lineView]
        self.addConstraints(NSLayoutConstraint.constraints(withVisualFormat: "H:|[lineView]|", options:NSLayoutConstraint.FormatOptions(rawValue: 0), metrics:metrics, views:views))
        
        switch borderPosition {
        case .LINE_POSITION_TOP:
            self.addConstraints(NSLayoutConstraint.constraints(withVisualFormat: "V:|[lineView(width)]", options:NSLayoutConstraint.FormatOptions(rawValue: 0), metrics:metrics, views:views))
            break
        case .LINE_POSITION_BOTTOM:
            self.addConstraints(NSLayoutConstraint.constraints(withVisualFormat: "V:[lineView(width)]|", options:NSLayoutConstraint.FormatOptions(rawValue: 0), metrics:metrics, views:views))
            break
        }
    }
}
