//
//  AppFeeModel.swift
//  EPOS
//
//  Created by Tushar Premal on 20/10/21.
//

import Foundation

class CardBrandModel: Codable {
    
    var id: Int?
    var code: String?
    
    enum CodingKeys: String, CodingKey {
        case id, code
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        code = values.getStringValue(key: CodingKeys.code)
    }
}

class CardBrandComissionModel: Codable {
    
    var id: Int?
    var cardBrandId: Int?
    var other: Int?
    var stripeFixed: Double?
    var stripePercentage: Double?
    
    enum CodingKeys: String, CodingKey {
        case id, other
        case stripeFixed = "stripe_fixed"
        case stripePercentage = "stripe_percentage"
        case cardBrandId = "card_brand_id"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        cardBrandId = values.getIntValue(key: CodingKeys.cardBrandId)
        other = values.getIntValue(key: CodingKeys.other)
        stripeFixed = values.getDoubleValue(key: CodingKeys.stripeFixed)
        stripePercentage = values.getDoubleValue(key: CodingKeys.stripePercentage)
    }
}

class CountryComissionModel: Codable {
    
    var id: Int?
    var country: CountryModel?
    var other: Int?
    var stripeFixed: Double?
    var stripePercentage: Double?
    
    enum CodingKeys: String, CodingKey {
        case id, other, country
        case stripeFixed = "stripe_fixed"
        case stripePercentage = "stripe_percentage"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        country = try? values.decode(CountryModel.self, forKey: .country)
        other = values.getIntValue(key: CodingKeys.other)
        stripeFixed = values.getDoubleValue(key: CodingKeys.stripeFixed)
        stripePercentage = values.getDoubleValue(key: CodingKeys.stripePercentage)
    }
}
