//
//  FloorModel.swift
//  EPOS
//
//  Created by Apple on 09/04/21.
//

import Foundation
import CoreData

class FloorModel:Codable{
    
    var id: Int?
    var name: String?
    var totalTable: Int?
    var tableData:[TableModel]?
    var sequence:Int?
    
    enum CodingKeys: String, CodingKey {
        case id, name, sequence
        case tableData = "tables"
        case totalTable = "total_tables"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        name = values.getStringValue(key: CodingKeys.name)
        id = values.getIntValue(key: CodingKeys.id)
        sequence = values.getIntValue(key: CodingKeys.sequence)
        totalTable = values.getIntValue(key: CodingKeys.totalTable)
        tableData = try? values.decode([TableModel].self, forKey: .tableData)
    }
    
    init(_ floor:NSManagedObject) {
        self.id = floor.value(forKey: "id") as? Int
//        self.sequence = floor.value(forKey: "sequence") as? Int
        self.name = floor.value(forKey: "name") as? String
        self.totalTable = floor.value(forKey: "total_tables") as? Int
    }
}

class TableModel:Codable{
    
    var id: Int?
    var number: String?
    var tableStatus: TableStatusModel?
    var tableStatusId:Int?
    var lastOrderId:Int?
    var floorId:Int?
    var floorName:String?
    var offline = 0
    var sequence = 0
    var lastOrderTotal:Double?
    var lastOrderTime:String?
    var disabled:Bool = false
    var locked:Bool = false
    var mergeTableId = 0
    var updaterId = 0
    
    enum CodingKeys: String, CodingKey {
        case id, number, sequence, disabled, locked
        case floorName = "floor_name"
        case tableStatus = "table_status"
        case tableStatusId = "table_status_id"
        case lastOrderId = "last_order_id"
        case floorId = "floor_id"
        case lastOrderTotal = "last_order_total"
        case lastOrderTime = "last_order_created_at"
        case mergeTableId = "merge_table_id"
        case updaterId = "updater_id"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        number = values.getStringValue(key: CodingKeys.number)
        id = values.getIntValue(key: CodingKeys.id)
        locked = values.getBoolValue(key: CodingKeys.locked)
        sequence = values.getIntValue(key: CodingKeys.sequence) ?? 0
        tableStatusId = values.getIntValue(key: CodingKeys.tableStatusId)
        lastOrderId = values.getIntValue(key: CodingKeys.lastOrderId)
        floorId = values.getIntValue(key: CodingKeys.floorId)
        floorName = values.getStringValue(key: CodingKeys.floorName)
        lastOrderTotal = values.getDoubleValue(key: CodingKeys.lastOrderTotal)
        tableStatus = try? values.decode(TableStatusModel.self, forKey: .tableStatus)
        disabled = values.getBoolValue(key: CodingKeys.disabled)
        mergeTableId = values.getIntValue(key: CodingKeys.mergeTableId) ?? 0
        updaterId = values.getIntValue(key: CodingKeys.updaterId) ?? 0
        lastOrderTime = values.getStringValue(key: CodingKeys.lastOrderTime) ?? ""
    }
    
    init() {
        
    }
}

class TableStatusModel:Codable{
    
    var id:Int?
    var status: String?
    var topColor: String?
    var bottomColor: String?
    
    enum CodingKeys: String, CodingKey {
        case status, id
        case topColor = "top_color"
        case bottomColor = "bottom_color"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        status = values.getStringValue(key: CodingKeys.status)
        topColor = values.getStringValue(key: CodingKeys.topColor)
        bottomColor = values.getStringValue(key: CodingKeys.bottomColor)
    }
    
    init(_ table:NSManagedObject) {
        self.id = table.value(forKey: "id") as? Int
        self.status = table.value(forKey: "status") as? String
        self.topColor = table.value(forKey: "top_color") as? String
        self.bottomColor = table.value(forKey: "bottom_color") as? String
    }
}

class PrepLocationModel:Codable{
    
    var id: Int?
    var printerId: Int?
    var name: String?
    var printerIP: String?
    var disabled: Int?
    
    enum CodingKeys: String, CodingKey {
        case id, name, disabled
        case printerId = "printer_id"
        case printerIP = "printer_ip"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        name = values.getStringValue(key: CodingKeys.name)
        id = values.getIntValue(key: CodingKeys.id)
        printerId = values.getIntValue(key: CodingKeys.printerId)
        printerIP = values.getStringValue(key: CodingKeys.printerIP)
        disabled = values.getIntValue(key: CodingKeys.disabled)
    }
    
    init(_ table:NSManagedObject) {
        self.id = table.value(forKey: "id") as? Int
        self.disabled = table.value(forKey: "disabled") as? Int
        self.printerId = table.value(forKey: "printer_id") as? Int
        self.name = table.value(forKey: "name") as? String
        self.printerIP = table.value(forKey: "printer_ip") as? String
    }
}
