//
//  MenusModel.swift
//  EPOS
//
//  Created by Tushar Premal on 15/11/22.
//

import Foundation

class OnlineCategoryModel:Codable{
    
    var name: String?
    var description: String?
    var sortorder: Int?
    var status: Int?
    var id: Int?
    
    enum CodingKeys: String, CodingKey {
        case id, description, sortorder, status
        case name = "category_name"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        status = values.getIntValue(key: CodingKeys.status)
        sortorder = values.getIntValue(key: CodingKeys.sortorder)
        name = values.getStringValue(key: CodingKeys.name)
        description = values.getStringValue(key: CodingKeys.description)
    }
}

class OnlineProductModel:Codable{
    
    var menuName: String?
    var menuImage: String?
    var sortorder: Int?
    var status: Int?
    var id: Int?
    var crustaceans: Int?
    var eggs: Int?
    var featured: String?
    var fish: Int?
    var milk: Int?
    var molluscs: Int?
    var mustard: Int?
    var vegetarian: Int?
    var vegan: Int?
    var categoryId: Int?
    var containsNuts: Int?
    var glutenFree: Int?
    var isSuggest: Int?
    var menuAddon: String?
    var menuDescription: String?
    var categoryName:String?
    var shortName: String?
    var sulphurDioxide: Int?
    var Sulphites: Int?
    var productPercentage: Double?
    var priceOption: String?
    var menuDetails:[MenuDetailModel]?
    var subAddons = [SubAddOnsModel]()
    
    enum CodingKeys: String, CodingKey {
        case productPercentage = "product_percentage"
        case menuDetails = "variants"
        case menuImage = "menu_image"
        case menuName = "menu_name"
        case categoryId = "category_id"
        case categoryName = "category_name"
        case containsNuts = "contains_nuts"
        case glutenFree = "gluten_free"
        case isSuggest = "is_suggest"
        case menuAddon = "menu_addon"
        case menuDescription = "menu_description"
        case shortName = "short_name"
        case sulphurDioxide = "sulphur_dioxide"
        case priceOption = "price_option"
        case subAddons = "menu_addons"
        case crustaceans, eggs, featured, fish, milk, molluscs, mustard, sortorder, status, vegetarian, vegan, id, Sulphites
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        status = values.getIntValue(key: CodingKeys.status)
        sortorder = values.getIntValue(key: CodingKeys.sortorder)
        crustaceans = values.getIntValue(key: CodingKeys.crustaceans)
        eggs = values.getIntValue(key: CodingKeys.eggs)
        fish = values.getIntValue(key: CodingKeys.fish)
        molluscs = values.getIntValue(key: CodingKeys.molluscs)
        milk = values.getIntValue(key: CodingKeys.milk)
        mustard = values.getIntValue(key: CodingKeys.mustard)
        vegetarian = values.getIntValue(key: CodingKeys.vegetarian)
        vegan = values.getIntValue(key: CodingKeys.vegan)
        Sulphites = values.getIntValue(key: CodingKeys.Sulphites)
        sulphurDioxide = values.getIntValue(key: CodingKeys.sulphurDioxide)
        isSuggest = values.getIntValue(key: CodingKeys.isSuggest)
        glutenFree = values.getIntValue(key: CodingKeys.glutenFree)
        containsNuts = values.getIntValue(key: CodingKeys.containsNuts)
        categoryId = values.getIntValue(key: CodingKeys.categoryId)
        productPercentage = values.getDoubleValue(key: CodingKeys.productPercentage)
        
        menuName = values.getStringValue(key: CodingKeys.menuName)
        menuImage = values.getStringValue(key: CodingKeys.menuImage)
        featured = values.getStringValue(key: CodingKeys.featured)
        menuAddon = values.getStringValue(key: CodingKeys.menuAddon)
        menuDescription = values.getStringValue(key: CodingKeys.menuDescription)
        priceOption = values.getStringValue(key: CodingKeys.priceOption)
        shortName = values.getStringValue(key: CodingKeys.shortName)
        categoryName = values.getStringValue(key: CodingKeys.categoryName)
        menuDetails = try? values.decode([MenuDetailModel].self, forKey: .menuDetails)
        subAddons = (try? values.decode([SubAddOnsModel].self, forKey: .subAddons)) ?? [SubAddOnsModel]()
    }
    
    init() {
        
    }
}

class MenuDetailModel:Codable{
    
    var subName: String?
    var orginalPrice: Double?
    var menuId: Int?
    var id: Int?
    var isSelected = true
    var selectedAddon = SubAddOnsModel()
    var menuAddons = [SubAddOnsModel]()
    var mainAddons = [MainAddOnModel]()
    
    enum CodingKeys: String, CodingKey {
        case id
        case mainAddons = "main_addons"
        case subName = "sub_name"
        case menuId = "menu_id"
        case orginalPrice = "orginal_price"
        case menuAddons = "menu_addons"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        menuId = values.getIntValue(key: CodingKeys.menuId)
        orginalPrice = values.getDoubleValue(key: CodingKeys.orginalPrice)
        subName = values.getStringValue(key: CodingKeys.subName)
        mainAddons = (try? values.decode([MainAddOnModel].self, forKey: .mainAddons)) ?? [MainAddOnModel]()
        menuAddons = (try? values.decode([SubAddOnsModel].self, forKey: .menuAddons)) ?? [SubAddOnsModel]()
    }
    
    init() {
        
    }
}

class SubAddOnsModel:Codable{
    
    var id:Int?
    var subAddonId:Int?
    var priceOption: String?
    var subAddonsPrice: Double?
    var menuId: Int?
    var categoryId: Int?
    var mainAddonsId: Int?
    var menuDetailsId: Int?
    var restaurantId: Int?
    var status: Int = 0
    var subAddonsName: String?
    var mainAddOnName = ""
    var isFromAddon = true
    
    enum CodingKeys: String, CodingKey {
        case id, status
        case subAddonId = "subaddons_id"
        case menuId = "menu_id"
        case categoryId = "category_id"
        case mainAddonsId = "mainaddons_id"
        case menuDetailsId = "menudetails_id"
        case priceOption = "price_option"
        case restaurantId = "restaurant_id"
        case subAddonsPrice = "subaddons_price"
        case subAddonsName = "subaddons_name"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        subAddonId = values.getIntValue(key: CodingKeys.subAddonId)
        categoryId = values.getIntValue(key: CodingKeys.categoryId)
        mainAddonsId = values.getIntValue(key: CodingKeys.mainAddonsId)
        menuDetailsId = values.getIntValue(key: CodingKeys.menuDetailsId)
        restaurantId = values.getIntValue(key: CodingKeys.restaurantId)
        menuId = values.getIntValue(key: CodingKeys.menuId)
        subAddonsPrice = values.getDoubleValue(key: CodingKeys.subAddonsPrice)
        priceOption = values.getStringValue(key: CodingKeys.priceOption)
        subAddonsName = values.getStringValue(key: CodingKeys.subAddonsName)
        status = values.getIntValue(key: CodingKeys.status) ?? 0
    }
    
    init() {
        
    }
}

class MainAddOnModel:Codable{
    
    var mainAddonsName: String?
    var mainAddonsId: Int?
    var subAddons = [SubAddOnsModel]()
    var id:Int?
    var categoryName:String?
    var adminName:String?
    var status:Int?
    var sortOrder:Int?
    var mainaddonsCount:Int?
    var mainaddonsMiniCount:Int?
    var categoryId:Int?
    var restaurantId:Int?
    
    enum CodingKeys: String, CodingKey {
        case id, status
        case restaurantId = "restaurant_id"
        case categoryName = "category_name"
        case mainAddonsName = "mainaddons_name"
        case mainAddonsId = "mainaddons_id"
        case subAddons = "sub_addonses"
        case adminName = "admin_name"
        case sortOrder = "sortorder"
        case mainaddonsCount = "mainaddons_count"
        case mainaddonsMiniCount = "mainaddons_mini_count"
        case categoryId = "category_id"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        mainAddonsId = values.getIntValue(key: CodingKeys.mainAddonsId)
        id = values.getIntValue(key: CodingKeys.id)
        restaurantId = values.getIntValue(key: CodingKeys.restaurantId)
        sortOrder = values.getIntValue(key: CodingKeys.sortOrder)
        status = values.getIntValue(key: CodingKeys.status)
        mainaddonsCount = values.getIntValue(key: CodingKeys.mainaddonsCount)
        mainaddonsMiniCount = values.getIntValue(key: CodingKeys.mainaddonsMiniCount)
        mainAddonsName = values.getStringValue(key: CodingKeys.mainAddonsName)
        adminName = values.getStringValue(key: CodingKeys.adminName)
        subAddons = (try? values.decode([SubAddOnsModel].self, forKey: .subAddons)) ?? [SubAddOnsModel]()
        categoryName = values.getStringValue(key: CodingKeys.categoryName)
        categoryId = values.getIntValue(key: CodingKeys.categoryId)
    }
    
    init() {
        
    }
}
