//
//  Models.swift
//  EPOS
//
//  Created by Apple on 28/08/21.
//

import Foundation

enum SideMenuCellType{
    case kOverView
    case kNewOrder
    case kActiveOrder
    case kTables
    case kMessages
    case kPayments
    case kCashDrawer
    case kVoucher
    case kSettings
    case kTableStatues
    case kOnlineOrders
    case kCustomers
    case kWaiting
    case kCollection
    case kDelivery
    case kOrderHistory
    case kNotification
    case kReservation
    case kPullDataBase
    case kPullCustomer
    case kPushDataBase
    case kMenu
    case kChangeTheme
}

enum SettingsType {
    case kRestaurantDetails
    case kRestaurantManagement
    case kProfile
    case kBankAccountDetails
    case kFeedback
    case kContactTiffinTom
    case kDataManagement
    case kUserManagement
    case kOrderSyncMode
    case kRemoteDevice
    case kChangeBusiness
    case kSendDBFile
}

enum SettingManagementType {
    case kFactoryDataReset
    case kEreaseAllOrders
    case kEraseAllReservation
    case kEraseCashDrawerLog
    case kEraseCallerIDLog
    case kOpeningHours
    case kOrderOptions
    case kReservationOptions
    case kDeliveryHour
    case kCollectionHour
    case kPreOrderOptions
    case kDineInOptions
    case kOffers
    case kDeliveryFee
    case kOrderRequirement
    case kAutoDiscount
    case kDiscountCode
}

enum PaymentCellType: Int {
    case kOverview = 1
    case kPaymentSMS
    case QRCode
    case kMotoPayment
    case kCardReaderPayment
    case kArchive
    case kReport
    case kRefundTransaction
    case kTransaction
    case kStatement
    case kLogin
    case kLogout
}

enum AlertType {
    case kEnterPassword
    case kEnterAdminPassword
    case kEnterEPOSPassword
    case kEnterSupervisorPassword
    case kEnterUserPassword
    case kAcceptReservation
    case kCancelReservation
    case kDeliverOrder
    case kRejectOrder
    case kRetryPayment
    case kNormal
    case kEnterPercentage
    case kEnterAmount
    case kApplyVoucher
    case kReadyToCollect
    case kMarkAsCollect
    case SendReport
}

enum MessageType {
    case kTextMessage
    case kImageMessage
    case kAudioMessage
    case kSupportBoardMessage
    case kOrderBoardMessage
}

enum PaymentViewType {
    case kCash
    case kCreditCard
    case kCheque
    case kAccount
    case kVoucher
    case kLoyaltyCard
}

enum PaymentFailedType {
    case kCardReader
    case kMoto
}

enum CancelViewType {
    case kOrder
    case kReservation
    case kOrderSyncType
    case kRemoteDevice
}

enum NewOrderViewType {
    case newOrder
    case changeCustomer
    case convertOrder
}

enum GratityViewType {
    case kGratuity
    case kServiceCharge
    case kDiscount
    case kDeliveryCharge
}

struct RerportType {
    static let kFullReport = 1
    static let kFullArchivedReport = 2
    static let kProductSaleReport = 3
    static let kSelectedUserReport = 4
    static let kProductCategoryReport = 5
    static let kOnlineOrderReport = 6
    static let kReportSettings = 7
    static let ZReport = 8
    static let FullReportBeta = 9
    static let MerchantReport = 10
}

class MessagesCellData{
    
    var strMessage = ""
    var messageURL = ""
    var imgMessage:UIImage?
    var audioFile:Data?
    var isAttach = 0
    var date = ""
    var created = ""
    var isAdmin = 1
    var isFailed = false
    var isPlaying = false
    var isQuestionMessage = false
    var isOrderMessage = false
    var type = MessageType.kTextMessage
    var id = 0
    
}

struct alertViewData {
    var value = ""
    var orderId:Int?
    var orderTpe:String?
    
    init(value:String,orderId:Int? = nil,orderTpe:String?=nil) {
        self.value = value
        self.orderTpe = orderTpe
        self.orderId = orderId
    }
}

struct AlertSetting {
    var confirmTitle = "Confirm"
    var alertTitle = ""
    var alertMessage = ""
    var alertAnimation = ""
    var alertBoldMessage = ""
    var alertBoldMessageColor = AppConstants.Colors.kAppDarkGreenColor
    var cancelTitle = "Cancel"
    var cancelColor = UIColor.white
    var confirmColor = UIColor.white
    var cancelBGColor = AppConstants.Colors.kAppThemeRedColor
    var confirmBGColor = AppConstants.Colors.kAppDarkGreenColor
    var textPlcaeholder = ""
    var textTitle = ""
    var textType = UIKeyboardType.decimalPad
    var titleColor = AppConstants.Colors.kAppThemeTextColor
    var type = AlertType.kNormal
    var orderId:Int?
    var orderTpe:String?
    var maxAmount:Double?
}

struct RerportCellData {
    var title = ""
    var type = RerportType.kFullReport
}

struct SideMenuCellData {
    var title = ""
    var image = ""
    var type = SideMenuCellType.kOverView
}

struct SettingsCellData {
    var title = ""
    var type = SettingsType.kRestaurantDetails
    
    init(_ title:String,_ type:SettingsType) {
        self.title = title
        self.type = type
    }
}

struct ManagementCellData {
    var title = ""
    var type = SettingManagementType.kFactoryDataReset
    
    init(_ title:String,_ type:SettingManagementType) {
        self.title = title
        self.type = type
    }
}

struct AutoDiscountCellData {
    
    var spentAmount:Double = 0
    var offerAmount:Double = 0
    var isPercentageOffer = false
    var voucherCode = ""
    var offerType = 0 // 0 - Delivery, 1 - Collection, 2 - DineIn
    var fromTime = Date()
    var toTime = Date().addingTimeInterval(24*60*60)
}

struct PreOrderCellData {
    var weekDay = ""
    var preOrderTime = 1
    var isTakingPreOrder = false
}

struct PaymentCellData {
    var title = ""
    var type = PaymentCellType.kOverview
}
