//
//  OrderModel.swift
//  EPOS
//
//  Created by Apple on 22/04/21.
//

import Foundation
import CoreData

class OrderModel:Codable{
    
    var id: Int?
    var customerId: Int?
    var updaterId: Int?
    var tableId: Int?
    var noGuest: Int?
    var orderTypeId: Int? //2 - pickup, 3 - delivery, 5 - waiting, 1 - dinein
    var orderType:String?
    var orderStatusId: Int?
    var orderActionId: Int?
    var subTotal: Double?
    var tax: Double?
    var serviceCharge: Double?
    var deliveryCharge:Double?
    
    var gratuity:Double?
    var discount:Double?
    var total:Double?
    var totalPaid:Double?
    var deliveryDate:String?
    var comment:String?
    var customerName:String?
    var arrProducts = [OrderProductModel]()
    var arrOrderSplit = [OrderGroupModel]()
    var arrOrderPayments = [PaymentOrderModel]()
    
    var orderId:Int?
    var customer:CustomerModel?
    var table:TableModel?
    var splitCount:Int?
    var isNewOrder = 1
    var isUpdated = 0
    var isDeleted = 0
    var distance:Double?
    var calculateLoyaltyPoint:Double?
    var calculateLoyaltyAmount:Double?
    var isArchived = false
    var isBackEnabled = false
    var orderStatus:OrderStatusModel?
    var uniqueId = ""
    var createdDate:Date?
    var _id = 0
    var splitType = ""
    var isAutoServiceChargeRemove = false
    var displayOrderId = ""
    var deliveryCollectionTimeSlot = ""
    var isDeliveryCollectionAsk = false
    
    enum CodingKeys: String, CodingKey {
        case tax, id, gratuity, discount, total, comment, customer, distance, isNewOrder, table, isUpdated, isDeleted, _id
        case deliveryCollectionTimeSlot = "delivery_collection_time_slot"
        case isDeliveryCollectionAsk = "is_delivery_collection_ask"
        case displayOrderId = "display_order_id"
        case isAutoServiceChargeRemove = "is_auto_service_charge_remove"
        case splitType = "split_type"
        case createdDate = "created_at"
        case uniqueId = "unique_id"
        case updaterId = "updater_id"
        case isArchived = "is_archived"
        case arrOrderSplit = "order_splits"
        case arrOrderPayments = "order_payments"
        case noGuest = "no_guest"
        case calculateLoyaltyAmount = "calculate_loyalty_amount"
        case calculateLoyaltyPoint = "calculate_loyalty_point"
        case deliveryDate = "delivery_date"
        case totalPaid = "total_paid"
        case deliveryCharge = "delivery_charge"
        case serviceCharge = "service_charge"
        case subTotal = "sub_total"
        case orderStatusId = "order_status_id"
        case orderTypeId = "order_type_id"
        case tableId = "table_id"
        case customerId = "customer_id"
        case customerName = "customer_name"
        case orderActionId = "order_action_id"
        case arrProducts = "order_items"
        case orderId = "order_id"
        case orderType = "order_type"
        case splitCount = "split_count"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        displayOrderId = values.getStringValue(key: CodingKeys.displayOrderId) ?? ""
        comment = values.getStringValue(key: CodingKeys.comment)
        orderType = values.getStringValue(key: CodingKeys.orderType)
        if let id = values.getIntValue(key: CodingKeys.orderId){
            self.id = id
        }else if let id = values.getIntValue(key: CodingKeys.id){
            self.id = id
        }
        if let id = values.getIntValue(key: CodingKeys._id){
            _id = id
        }else{
            let id = (SQLiteManage.fetchLastOrder()?._id ?? 0)+1
            _id = id
        }
        isDeliveryCollectionAsk = values.getBoolValue(key: CodingKeys.isDeliveryCollectionAsk)
        deliveryCollectionTimeSlot = values.getStringValue(key: CodingKeys.deliveryCollectionTimeSlot) ?? ""
        uniqueId = values.getStringValue(key: CodingKeys.uniqueId) ?? ""
        splitType = values.getStringValue(key: CodingKeys.splitType) ?? ""
        print("uniqueId",uniqueId)
        isArchived = values.getBoolValue(key: CodingKeys.isArchived)
        customerId = values.getIntValue(key: CodingKeys.customerId)
        tableId = values.getIntValue(key: CodingKeys.tableId)
        noGuest = values.getIntValue(key: CodingKeys.noGuest)
        splitCount = values.getIntValue(key: CodingKeys.splitCount)
        updaterId = values.getIntValue(key: CodingKeys.updaterId)
        orderTypeId = values.getIntValue(key: CodingKeys.orderTypeId)
        orderActionId = values.getIntValue(key: CodingKeys.orderActionId)
        tax = values.getDoubleValue(key: CodingKeys.tax)
        distance = values.getDoubleValue(key: CodingKeys.distance)
        subTotal = values.getDoubleValue(key: CodingKeys.subTotal)
        calculateLoyaltyPoint = values.getDoubleValue(key: CodingKeys.calculateLoyaltyPoint)
        calculateLoyaltyAmount = values.getDoubleValue(key: CodingKeys.calculateLoyaltyAmount)
        serviceCharge = values.getDoubleValue(key: CodingKeys.serviceCharge)
        deliveryCharge = values.getDoubleValue(key: CodingKeys.deliveryCharge)
        totalPaid = values.getDoubleValue(key: CodingKeys.totalPaid)
        total = values.getDoubleValue(key: CodingKeys.total)
        discount = values.getDoubleValue(key: CodingKeys.discount)
        gratuity = values.getDoubleValue(key: CodingKeys.gratuity)
        deliveryDate = values.getStringValue(key: CodingKeys.deliveryDate)
        customerName = values.getStringValue(key: CodingKeys.customerName)
        orderStatusId = values.getIntValue(key: CodingKeys.orderStatusId)
        isNewOrder = values.getIntValue(key: CodingKeys.isNewOrder) ?? 0
        isUpdated = values.getIntValue(key: CodingKeys.isUpdated) ?? 0
        isDeleted = values.getIntValue(key: CodingKeys.isDeleted) ?? 0
        arrProducts = (try? values.decode([OrderProductModel].self, forKey: .arrProducts)) ?? [OrderProductModel]()
        arrOrderSplit = (try? values.decode([OrderGroupModel].self, forKey: .arrOrderSplit)) ?? [OrderGroupModel]()
        arrOrderPayments = (try? values.decode([PaymentOrderModel].self, forKey: .arrOrderPayments)) ?? [PaymentOrderModel]()
        customer = try? values.decode(CustomerModel.self, forKey: .customer)
        table = try? values.decode(TableModel.self, forKey: .table)
        if self.orderStatusId ?? 0 != 0{
            orderStatus = SQLiteManage.fetchOrderStatuseById(id: self.orderStatusId!)
        }
        let createdAt = (values.getStringValue(key: CodingKeys.createdDate) ?? "").components(separatedBy: ".").first ?? ""
        self.createdDate = createdAt.getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss")
        isAutoServiceChargeRemove = values.getBoolValue(key: CodingKeys.isAutoServiceChargeRemove)
    }
    
    init() {
        
    }
}

class OrderProductModel:Codable{
    
    var id: Int?
    var uniqueId = ""
    var quantity: Int?
    var specialInstruction: String?
    var instructionPrice: Double?
    var price: Double?
    var arrAddons = [OrderAddOnModel]()
    var arrIngriedent = [OrderIngredientModel]()
    var orderId: Int?
    var prodcutId: Int?
    var productName: String?
    var orderSplitId:Int?
    var isItemUpdated = 1
    var subTotal:Double?
    var addonPrice:Double?
    var ingredientsPrice:Double?
    var total:Double?
    var itemModified = 1
    var misc:Int?
    var product:ProductModel?
    var prepLocationId:Int?
    var groupOffline = 1
    var sentToKitchen = false
    var updaterId:Int?
    var groupUniqueId = ""
    var isDelete = false
    var updatedAt = ""
    var sentToKitchenQuantity = 0
    
    enum CodingKeys: String, CodingKey {
        case id, quantity, price, total, misc, product, groupOffline, isItemUpdated
        case sentToKitchenQuantity = "sent_to_kitchen_quantity"
        case updatedAt = "updated_at"
        case isDelete = "is_delete"
        case uniqueId = "item_unique_id"
        case groupUniqueId = "unique_id"
        case updaterId = "updater_id"
        case specialInstruction = "special_instruction"
        case instructionPrice = "instruction_price"
        case arrAddons = "order_item_addons"
        case arrIngriedent = "order_item_ingredients"
        case orderId = "order_id"
        case prodcutId = "product_id"
        case productName = "product_name"
        case orderSplitId = "order_split_id"
        case subTotal = "sub_total"
        case addonPrice = "addons_price"
        case ingredientsPrice = "ingredients_price"
        case prepLocationId = "preparation_location_id"
        case sentToKitchen = "sent_to_kitchen"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        isDelete = values.getBoolValue(key: CodingKeys.isDelete)
        uniqueId = values.getStringValue(key: CodingKeys.uniqueId) ?? ""
        updaterId = values.getIntValue(key: CodingKeys.updaterId)
        misc = values.getIntValue(key: CodingKeys.misc)
        groupOffline = values.getIntValue(key: CodingKeys.groupOffline) ?? 0
        orderId = values.getIntValue(key: CodingKeys.orderId)
        quantity = values.getIntValue(key: CodingKeys.quantity)
        prodcutId = values.getIntValue(key: CodingKeys.prodcutId)
        sentToKitchen = values.getBoolValue(key: CodingKeys.sentToKitchen)
        isItemUpdated = values.getIntValue(key: CodingKeys.isItemUpdated) ?? 0
        price = values.getDoubleValue(key: CodingKeys.price)
        groupUniqueId = values.getStringValue(key: CodingKeys.groupUniqueId) ?? ""
        instructionPrice = values.getDoubleValue(key: CodingKeys.instructionPrice)
        specialInstruction = values.getStringValue(key: CodingKeys.specialInstruction)
        productName = values.getStringValue(key: CodingKeys.productName)
        orderSplitId = values.getIntValue(key: CodingKeys.orderSplitId)
        prepLocationId = values.getIntValue(key: CodingKeys.prepLocationId)
        addonPrice = values.getDoubleValue(key: CodingKeys.addonPrice)
        ingredientsPrice = values.getDoubleValue(key: CodingKeys.ingredientsPrice)
        subTotal = values.getDoubleValue(key: CodingKeys.subTotal)
        total = values.getDoubleValue(key: CodingKeys.total)
        arrAddons = (try? values.decode([OrderAddOnModel].self, forKey: .arrAddons)) ?? [OrderAddOnModel]()
        arrIngriedent = (try? values.decode([OrderIngredientModel].self, forKey: .arrIngriedent)) ?? [OrderIngredientModel]()
        product = try? values.decode(ProductModel.self, forKey: .product)
        sentToKitchenQuantity = values.getIntValue(key: CodingKeys.sentToKitchenQuantity) ?? 0
        updatedAt = values.getStringValue(key: CodingKeys.updatedAt) ?? ""
    }
    
    init() {
        
    }
}

class OrderAddOnModel:Codable{
    
    var id: Int?
    var AddonId: Int?
    var price: Double?
    var total: Double?
    var name: String?
    var isNewOrder = 1
    var updaterId:Int?
    var arrAddons = [OrderAddOnModel]()
    var quantity = 1
    
    enum CodingKeys: String, CodingKey {
        case id, price, total, isNewOrder, quantity
        case updaterId = "updater_id"
        case name = "addon_name"
        case AddonId = "addon_id"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        updaterId = values.getIntValue(key: CodingKeys.updaterId)
        price = values.getDoubleValue(key: CodingKeys.price)
        isNewOrder = values.getIntValue(key: CodingKeys.isNewOrder) ?? 0
        total = values.getDoubleValue(key: CodingKeys.total)
        name = values.getStringValue(key: CodingKeys.name)
        AddonId = values.getIntValue(key: CodingKeys.AddonId)
        quantity = values.getIntValue(key: CodingKeys.quantity) ?? 1
    }
    
    init() {
        
    }
}

class OrderIngredientModel:Codable{

    var id: Int?
    var with: Int?
    var without: Int?
    var quantity: Int?
    var productIngredientId: Int?
    var price: Double?
    var total: Double?
    var name: String?
    var isNewOrder = 1
    var updaterId:Int?
    
    enum CodingKeys: String, CodingKey {
        case id, price, quantity, total, with, without, isNewOrder
        case updaterId = "updater_id"
        case productIngredientId = "product_ingredient_id"
        case name = "ingredient_name"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        updaterId = values.getIntValue(key: CodingKeys.updaterId)
        isNewOrder = values.getIntValue(key: CodingKeys.isNewOrder) ?? 0
        productIngredientId = values.getIntValue(key: CodingKeys.productIngredientId)
        quantity = values.getIntValue(key: CodingKeys.quantity)
        with = values.getIntValue(key: CodingKeys.with)
        without = values.getIntValue(key: CodingKeys.without)
        price = values.getDoubleValue(key: CodingKeys.price)
        total = values.getDoubleValue(key: CodingKeys.total)
        name = values.getStringValue(key: CodingKeys.name)
    }
    
    init() {
        
    }
}

class OrderTypesModel:Codable{
    
    var id: Int?
    var type: String?
    var topColor: String?
    var bottomColor: String?
    
    enum CodingKeys: String, CodingKey {
        case id, type
        case topColor = "top_color"
        case bottomColor = "bottom_color"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        type = values.getStringValue(key: CodingKeys.type)
        topColor = values.getStringValue(key: CodingKeys.topColor)
        bottomColor = values.getStringValue(key: CodingKeys.bottomColor)
    }
    
    init() {
        
    }
}

class PaymentMethodModel:Codable{
    
    var id: Int?
    var paymentMethodName: String?
    var disabled:Int?
    
    enum CodingKeys: String, CodingKey {
        case id, disabled
        case paymentMethodName = "name"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        disabled = values.getIntValue(key: CodingKeys.disabled)
        paymentMethodName = values.getStringValue(key: CodingKeys.paymentMethodName)
    }
    
    init() {
    }
}

class OrderStatusModel:Codable{
    
    var id: Int?
    var status: String?
    var topColor: String?
    var bottomColor: String?
    
    enum CodingKeys: String, CodingKey {
        case id, status
        case topColor = "top_color"
        case bottomColor = "bottom_color"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        status = values.getStringValue(key: CodingKeys.status)
        topColor = values.getStringValue(key: CodingKeys.topColor)
        bottomColor = values.getStringValue(key: CodingKeys.bottomColor)
    }
    
    init() {
        
    }
}

class WebOrderModel: Codable {
    
    var id: Int?
    var orderNumber: String?
    var customerName: String?
    var customerEmail: String?
    var customerImage: String?
    var customerId:Int?
    var orderType:String?
    var displayOrderType = ""
    var paymentMethod: String?
    var deliveryTime: String?
    var paymentStatus: String?
    var paymentWallet: String?
    var splitPayment: String?
    var address: String?
    var status: String?
    var created: String?
    var deliveryDate: String?
    var tableNo: String?
    var guestCount: Int?
    var preparation: String?
    var distance: String?
    var assoonas: String?
    var orderGrandTotal: Double?
    var orderInstruction: String?
    var arrProducts: [WebProductDetailModel]?
    var subTotal: Double?
    var driverTip: Double?
    var tipAmount: Double?
    var serviceCharge: Double?
    var deliveryFee: Double?
    var offerPrice: Double?
    var voucherAmount: Double?
    var offerPercentage: Double?
    var rewardOffer: Double?
    var charity: Double?
    var taxAmount: Double?
    var walletAmount: Double?
    var gratuity: Double?
    var deliveryInstuction: String?
    var failedReason: String?
    var phone: String?
    var paymentType:String?
    var cardView:CardModel?
    
    var orderDate:String?
    var orderStatus:String?
    var grandTotal:Double?
    var calculatedFees:CalculateFeeModel?
    var user = OnlineUserModel()
    var surcharges = [SurchargeModel]()
    
    enum CodingKeys: String, CodingKey {
        case id, address, status, created, preparation, distance, assoonas, gratuity, user, surcharges
        case cardView = "card_view"
        case phone = "customer_phone"
        case customerEmail = "customer_email"
        case customerId = "customer_id"
        case orderNumber = "order_number"
        case orderType = "order_type"
        case paymentMethod = "payment_method"
        case customerName = "customer_name"
        case deliveryTime = "delivery_time"
        case paymentStatus = "payment_status"
        case paymentWallet = "payment_wallet"
        case splitPayment = "split_payment"
        case deliveryDate = "delivery_date"
        case tableNo = "table_no"
        case guestCount = "no_of_guest"
        case orderGrandTotal = "order_grand_total"
        case orderInstruction = "order_description"
        case arrProducts = "cart_view"
        case subTotal = "order_sub_total"
        case driverTip = "driver_tip"
        case serviceCharge = "service_charge"
        case deliveryFee = "delivery_charge"
        case offerPrice = "offer_amount"
        case charity = "charity_amount"
        case taxAmount = "tax_amount"
        case walletAmount = "wallet_amount"
        case deliveryInstuction = "delivery_instruction"
        case failedReason = "failed_reason"
        case tipAmount = "tip_amount"
        case voucherAmount = "voucher_amount"
        case offerPercentage = "offer_percentage"
        case rewardOffer = "reward_offer"
        
        case orderDate = "order_date"
        case orderStatus = "order_status"
        case grandTotal = "grand_total"
        case calculatedFees = "calculated_fees"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        status = values.getStringValue(key: CodingKeys.status)
        splitPayment = values.getStringValue(key: CodingKeys.splitPayment)
        paymentWallet = values.getStringValue(key: CodingKeys.paymentWallet)
        id = values.getIntValue(key: CodingKeys.id)
        customerId = values.getIntValue(key: CodingKeys.customerId)
        paymentStatus = values.getStringValue(key: CodingKeys.paymentStatus)
        preparation = values.getStringValue(key: CodingKeys.preparation)
        deliveryTime = values.getStringValue(key: CodingKeys.deliveryTime)
        paymentMethod = values.getStringValue(key: CodingKeys.paymentMethod)
        orderType = values.getStringValue(key: CodingKeys.orderType)
        customerName = values.getStringValue(key: CodingKeys.customerName)
        customerEmail = values.getStringValue(key: CodingKeys.customerEmail)
        orderNumber = values.getStringValue(key: CodingKeys.orderNumber)
        address = values.getStringValue(key: CodingKeys.address)
        created = values.getStringValue(key: CodingKeys.created)
        deliveryDate = values.getStringValue(key: CodingKeys.deliveryDate)
        tableNo = values.getStringValue(key: CodingKeys.tableNo)
        guestCount = values.getIntValue(key: CodingKeys.guestCount)
        splitPayment = values.getStringValue(key: CodingKeys.splitPayment)
        paymentWallet = values.getStringValue(key: CodingKeys.paymentWallet)
        created = values.getStringValue(key: CodingKeys.created)
        id = values.getIntValue(key: CodingKeys.id)
        distance = values.getStringValue(key: CodingKeys.distance)
        paymentStatus = values.getStringValue(key: CodingKeys.paymentStatus)
        deliveryTime = values.getStringValue(key: CodingKeys.deliveryTime)
        phone = values.getStringValue(key: CodingKeys.phone)
        assoonas = values.getStringValue(key: CodingKeys.assoonas)
        orderType = values.getStringValue(key: CodingKeys.orderType)
        customerName = values.getStringValue(key: CodingKeys.customerName)
        orderNumber = values.getStringValue(key: CodingKeys.orderNumber)
        address = values.getStringValue(key: CodingKeys.address)
        failedReason = values.getStringValue(key: CodingKeys.failedReason)
        preparation = values.getStringValue(key: CodingKeys.preparation)
        grandTotal = values.getDoubleValue(key: CodingKeys.grandTotal)
        subTotal = values.getDoubleValue(key: CodingKeys.subTotal)
        if let tip = values.getDoubleValue(key: CodingKeys.driverTip){
            self.driverTip = tip
        }else if let tip = values.getDoubleValue(key: CodingKeys.gratuity){
            self.driverTip = tip
        }else if let tip = values.getDoubleValue(key: CodingKeys.tipAmount){
            self.driverTip = tip
        }
        self.cardView = try? values.decode(CardModel.self, forKey: .cardView)
        serviceCharge = values.getDoubleValue(key: CodingKeys.serviceCharge)
        deliveryFee = values.getDoubleValue(key: CodingKeys.deliveryFee)
        offerPrice = values.getDoubleValue(key: CodingKeys.offerPrice)
        voucherAmount = values.getDoubleValue(key: CodingKeys.voucherAmount)
        offerPercentage = values.getDoubleValue(key: CodingKeys.offerPercentage)
        rewardOffer = values.getDoubleValue(key: CodingKeys.rewardOffer)
        walletAmount = values.getDoubleValue(key: CodingKeys.walletAmount)
        charity = values.getDoubleValue(key: CodingKeys.charity)
        taxAmount = values.getDoubleValue(key: CodingKeys.taxAmount)
        orderInstruction = values.getStringValue(key: CodingKeys.orderInstruction)
        deliveryInstuction = values.getStringValue(key: CodingKeys.deliveryInstuction)
        guestCount = values.getIntValue(key: CodingKeys.guestCount)
        tableNo = values.getStringValue(key: CodingKeys.tableNo)
        status = values.getStringValue(key: CodingKeys.status)
        arrProducts = try? values.decodeIfPresent([WebProductDetailModel].self, forKey: .arrProducts)
        
        orderDate = values.getStringValue(key: CodingKeys.orderDate)
        orderStatus = values.getStringValue(key: CodingKeys.orderStatus)
        orderGrandTotal = values.getDoubleValue(key: CodingKeys.orderGrandTotal)
        self.calculatedFees = try? values.decode(CalculateFeeModel.self, forKey: .calculatedFees)
        user = (try? values.decode(OnlineUserModel.self, forKey: .user)) ?? OnlineUserModel()
        surcharges = (try? values.decodeIfPresent([SurchargeModel].self, forKey: .surcharges)) ?? [SurchargeModel]()
        if (self.orderInstruction ?? "").contains("Parking number:- "){
            displayOrderType =  "Park & Eat"
        }else{
            if orderType?.lowercased() ?? "" == "pickup"{
                displayOrderType = "Collection"
            }else{
                displayOrderType = self.orderType?.capitalized ?? ""
            }
        }
    }
}

class SurchargeModel: Codable {
    
    var id = 0
    var surchargeAmount: Double = 0
    var surchargeName = ""
    var status = 0
    
    enum CodingKeys: String, CodingKey {
        case id, status
        case surchargeAmount = "surcharge_amount"
        case surchargeName = "surcharge_name"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        surchargeAmount = values.getDoubleValue(key: CodingKeys.surchargeAmount) ?? 0
        id = values.getIntValue(key: CodingKeys.id) ?? 0
        status = values.getIntValue(key: CodingKeys.status) ?? 0
        surchargeName = values.getStringValue(key: CodingKeys.surchargeName) ?? ""
    }
}

class WebProductDetailModel: Codable {

    var id: Int?
    var menuName: String?
    var quantity: Int?
    var totalPrice: Double?
    var subAddonsName: String?
    
    enum CodingKeys: String, CodingKey {
        case id, quantity
        case menuName = "menu_name"
        case totalPrice = "total_price"
        case subAddonsName = "subaddons_name"
    }

    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        menuName = values.getStringValue(key: CodingKeys.menuName)
        subAddonsName = values.getStringValue(key: CodingKeys.subAddonsName)
        id = values.getIntValue(key: CodingKeys.id)
        quantity = values.getIntValue(key: CodingKeys.quantity)
        totalPrice = values.getDoubleValue(key: CodingKeys.totalPrice)
    }
}

class CalculateFeeModel: Codable {
    
    var totalFee: Double?
    
    enum CodingKeys: String, CodingKey {
        case totalFee = "total_fee"
    }

    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        totalFee = values.getDoubleValue(key: CodingKeys.totalFee)
    }
}

class CardModel: Codable {
    
    var cardNo: String?
    
    enum CodingKeys: String, CodingKey {
        case cardNo = "card_number"
    }

    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        cardNo = values.getStringValue(key: CodingKeys.cardNo)
    }
}
