//
//  ProductModel.swift
//  EPOS
//
//  Created by Apple on 12/04/21.
//

import Foundation
import CoreData

class ProductModel:Codable{
    
    var id: Int?
    var name: String?
    var shortName: String?
    var preparationLocationId: Int?
    var deliveryPreparationLocationId: Int?
    var banquetPreparationLocationId: Int?
    var takeawayPreparationLocationId: Int?
    var description: String?
    var imageUrl: String?
    var price: Double? //This will be dinin price
    var takeawayPrice: Double? //This will be collection and waiting price
    var waitingPrice: Double? //This will be banquet price
    var deliveryPrice: Double?
    var categoryId: Int?
    var totalAddOn:Int?
    var disabled:Int?
    var isBanquet:Int?
    var isCollection:Int?
    var isDelivery:Int?
    var isDineIn:Int?
    var autoAddon:Int?
    var autoModify:Int?
    var categoryName:String?
    var quantity = 0
    var totalPrice = 0.0
    var specialInstruction:String?
    var instructionPrice:Double?
    var arrSelectedIngrident:[IngredientModel]?
    var itemModified = 1
    var arrSelectedAddOn:[AddOnModel]?
    var topColor:String?
    var fontColor:String?
    var isNewOrder = 1
    
    enum CodingKeys: String, CodingKey {
        case name, id, description, price, disabled
        case categoryName = "category_name"
        case autoAddon = "auto_addon"
        case autoModify = "auto_modify"
        case shortName = "short_name"
        case categoryId = "category_id"
        case fontColor = "font_color"
        case preparationLocationId = "preparation_location_id"
        case deliveryPreparationLocationId = "delivery_preparation_location_id"
        case takeawayPreparationLocationId = "collection_preparation_location_id"
        case banquetPreparationLocationId = "banquet_preparation_location_id"
        case deliveryPrice = "delivery_price"
        case takeawayPrice = "takeaway_price"
        case totalAddOn = "total_addons"
        case topColor = "top_color"
        case imageUrl = "image_url"
        case arrSelectedAddOn = "product_addons"
        case arrSelectedIngrident = "product_ingredients"
        case isBanquet = "is_banquet"
        case isDineIn = "is_dinein"
        case isDelivery = "is_delivery"
        case isCollection = "is_collection"
        case waitingPrice = "waiting_price"
        case quantity, totalPrice, specialInstruction, instructionPrice, itemModified
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        name = values.getStringValue(key: CodingKeys.name)
        shortName = values.getStringValue(key: CodingKeys.shortName)
        fontColor = values.getStringValue(key: CodingKeys.fontColor)
        categoryName = values.getStringValue(key: CodingKeys.categoryName)
        id = values.getIntValue(key: CodingKeys.id)
        autoAddon = values.getIntValue(key: CodingKeys.autoAddon)
        autoModify = values.getIntValue(key: CodingKeys.autoModify)
        preparationLocationId = values.getIntValue(key: CodingKeys.preparationLocationId)
        deliveryPreparationLocationId = values.getIntValue(key: CodingKeys.deliveryPreparationLocationId)
        takeawayPreparationLocationId = values.getIntValue(key: CodingKeys.takeawayPreparationLocationId)
        banquetPreparationLocationId = values.getIntValue(key: CodingKeys.banquetPreparationLocationId)
        categoryId = values.getIntValue(key: CodingKeys.categoryId)
        totalAddOn = values.getIntValue(key: CodingKeys.totalAddOn)
        isDineIn = values.getIntValue(key: CodingKeys.isDineIn)
        isDelivery = values.getIntValue(key: CodingKeys.isDelivery)
        isCollection = values.getIntValue(key: CodingKeys.isCollection)
        isBanquet = values.getIntValue(key: CodingKeys.isBanquet)
        disabled = values.getIntValue(key: CodingKeys.disabled)
        description = values.getStringValue(key: CodingKeys.description)
        price = values.getDoubleValue(key: CodingKeys.price)
        deliveryPrice = values.getDoubleValue(key: CodingKeys.deliveryPrice)
        waitingPrice = values.getDoubleValue(key: CodingKeys.waitingPrice)
        takeawayPrice = values.getDoubleValue(key: CodingKeys.takeawayPrice)
        topColor = values.getStringValue(key: CodingKeys.topColor)
        imageUrl = values.getStringValue(key: CodingKeys.imageUrl)
        
        quantity = values.getIntValue(key: CodingKeys.quantity) ?? 0
        totalPrice = values.getDoubleValue(key: CodingKeys.totalPrice) ?? 0
        instructionPrice = values.getDoubleValue(key: CodingKeys.instructionPrice)
        itemModified = values.getIntValue(key: CodingKeys.itemModified) ?? 1
        specialInstruction = values.getStringValue(key: CodingKeys.specialInstruction)
        arrSelectedIngrident = try? values.decode([IngredientModel].self, forKey: .arrSelectedIngrident)
        arrSelectedAddOn = try? values.decode([AddOnModel].self, forKey: .arrSelectedAddOn)
    }
    
    init(_ product:NSManagedObject) {
        self.id = product.value(forKey: "id") as? Int
        self.name = product.value(forKey: "name") as? String
        self.shortName = product.value(forKey: "short_name") as? String
        self.preparationLocationId = product.value(forKey: "preparation_location_id") as? Int
        self.deliveryPreparationLocationId = product.value(forKey: "delivery_preparation_location_id") as? Int
        self.takeawayPreparationLocationId = product.value(forKey: "takeaway_preparation_location_id") as? Int
        self.banquetPreparationLocationId = product.value(forKey: "banquet_preparation_location_id") as? Int
        self.categoryId = product.value(forKey: "category_id") as? Int
        self.autoAddon = product.value(forKey: "auto_addon") as? Int
        self.autoModify = product.value(forKey: "auto_modify") as? Int
        self.totalAddOn = product.value(forKey: "total_addons") as? Int
        self.isCollection = product.value(forKey: "is_collection") as? Int
        self.isBanquet = product.value(forKey: "is_banquet") as? Int
        self.isDelivery = product.value(forKey: "is_delivery") as? Int
        self.isDineIn = product.value(forKey: "is_dinein") as? Int
        self.description = product.value(forKey: "product_description") as? String
        self.topColor = product.value(forKey: "top_color") as? String
        self.fontColor = product.value(forKey: "font_color") as? String
        self.imageUrl = product.value(forKey: "image_url") as? String
        self.price = product.value(forKey: "price") as? Double
        self.deliveryPrice = product.value(forKey: "delivery_price") as? Double
        self.takeawayPrice = product.value(forKey: "takeaway_price") as? Double
        self.waitingPrice = product.value(forKey: "waiting_price") as? Double
        self.disabled = product.value(forKey: "disabled") as? Int
    }
    
    init() {
        
    }
}

class AddOnModel:Codable{
    
    var id: Int?
    var name: String?
    var addOnName: String?
    var productId: Int?
    var maxQuantity: Int?
    var price: Double?
    var takeawayPrice: Double?
    var deliveryPrice: Double?
    var waitingPrice: Double?
    var minQuantity: Int?
    var quantity = 0
    var addon:[AddOnModel]?
    var children:[AddOnModel]?
    var parentId: Int?
    var addOnId: Int?
    var isNewOrder = 1
    var disabled:Int?
    var selectedAddonCount = 0
    var selectedAddon = [OrderAddOnModel]()
    
    enum CodingKeys: String, CodingKey {
        case id, price, addon, children, name, quantity, disabled
        case productId = "product_id"
        case minQuantity = "min_quantity"
        case maxQuantity = "max_quantity"
        case addOnName = "addon_name"
        case deliveryPrice = "delivery_price"
        case takeawayPrice = "takeaway_price"
        case waitingPrice = "waiting_price"
        case parentId = "parent_id"
        case addOnId = "addon_id"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        if let name = values.getStringValue(key: CodingKeys.name){
            self.name = name
        }else if let name = values.getStringValue(key: CodingKeys.addOnName){
            self.name = name
        }
        if let id = values.getIntValue(key: CodingKeys.addOnId){
            self.id = id
        }else if let id = values.getIntValue(key: CodingKeys.id){
            self.id = id
        }
        disabled = values.getIntValue(key: CodingKeys.disabled)
        parentId = values.getIntValue(key: CodingKeys.parentId)
        productId = values.getIntValue(key: CodingKeys.productId)
        quantity = values.getIntValue(key: CodingKeys.quantity) ?? 0
        minQuantity = values.getIntValue(key: CodingKeys.minQuantity)
        maxQuantity = values.getIntValue(key: CodingKeys.maxQuantity)
        price = values.getDoubleValue(key: CodingKeys.price)
        deliveryPrice = values.getDoubleValue(key: CodingKeys.deliveryPrice)
        takeawayPrice = values.getDoubleValue(key: CodingKeys.takeawayPrice)
        waitingPrice = values.getDoubleValue(key: CodingKeys.waitingPrice)
        if let model = try? values.decode(AddOnModel.self, forKey: .addon){
            self.children = model.children
        }else if let children = try? values.decode([AddOnModel].self, forKey: .children){
            self.children = children
        }
    }
    
    init(_ product:NSManagedObject) {
        self.id = product.value(forKey: "id") as? Int
        self.name = product.value(forKey: "addon_name") as? String
        self.price = product.value(forKey: "price") as? Double
        self.deliveryPrice = product.value(forKey: "delivery_price") as? Double
        self.takeawayPrice = product.value(forKey: "takeaway_price") as? Double
        self.waitingPrice = product.value(forKey: "waiting_price") as? Double
        self.parentId = product.value(forKey: "parent_id") as? Int
        self.disabled = product.value(forKey: "disabled") as? Int
    }
    
    init() {
        
    }
}

class IngredientModel:Codable{
    
    var id: Int?
    var ingriedetnId: Int?
    var name: String?
    var productId: Int?
    var price: Double?
    var priceWithout: Double?
    var with: Int?
    var quantity = 0
    var without: Int?
    var isNewOrder = 1
    var disabled:Int?
    
    enum CodingKeys: String, CodingKey {
        case id, price, with, ingriedetnId, without, disabled
        case productId = "product_id"
        case name = "ingredient_name"
        case priceWithout = "price_without"
        case quantity
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        name = values.getStringValue(key: CodingKeys.name)
        id = values.getIntValue(key: CodingKeys.id)
        ingriedetnId = values.getIntValue(key: CodingKeys.id)
        productId = values.getIntValue(key: CodingKeys.productId)
        with = values.getIntValue(key: CodingKeys.with)
        disabled = values.getIntValue(key: CodingKeys.disabled)
        without = values.getIntValue(key: CodingKeys.without)
        price = values.getDoubleValue(key: CodingKeys.price)
        priceWithout = values.getDoubleValue(key: CodingKeys.priceWithout)
        quantity = values.getIntValue(key: CodingKeys.quantity) ?? 0
    }
    
    init(_ product:NSManagedObject) {
        self.id = product.value(forKey: "id") as? Int
        self.name = product.value(forKey: "name") as? String
        self.productId = product.value(forKey: "product_id") as? Int
        self.with = product.value(forKey: "with") as? Int
        self.without = product.value(forKey: "without") as? Int
        self.price = product.value(forKey: "price") as? Double
        self.priceWithout = product.value(forKey: "price_without") as? Double
        self.disabled = product.value(forKey: "disabled") as? Int
    }
    
    init() {
        
    }
}
