//
//  ReportModel.swift
//  EPOS
//
//  Created by Apple on 08/06/21.
//

import Foundation

class FullReportModel:Codable{
    
    var onlineOrderPayment: [ReportModel]?
    var onlineOrderType: [ReportModel]?
    var orderPaymentWise: [ReportModel]?
    var orderStatusWise: [ReportModel]?
    var orderTypeWise: [ReportModel]?
    var iOSOnlineOrder: [ReportModel]?
    var webOnlineOrder: [ReportModel]?
    var androidOnlineOrder: [ReportModel]?
    var onlineReservationCount:Int?
    var onlineOrderCount:Int?
    var orderCount:Int?
    var ordersTotalProduct:Int?
    var totalNoGuest:Int?
    var totalNoTable:Int?
    var onlineOrderTotalBusiness:Double?
    var totalGratuity:Double?
    var onlineOrderCalculatedCommission:Double?
    var ordersAmountProduct:Double?
    var totalDiscount:Double?
    var totalServiceCharge:Double?
    var allocatedVoucher:Int?
    var allocatedVoucherValue:Double?
    var deletedOrderItems = 0
    var deletedOrderItemsAmount = 0.0
    
    enum CodingKeys: String, CodingKey {
        case deletedOrderItems = "deleted_order_items"
        case deletedOrderItemsAmount = "deleted_order_items_amount"
        case onlineOrderPayment = "online_order_payment"
        case onlineOrderType = "online_order_type"
        case orderPaymentWise = "order_payment_wise"
        case orderStatusWise = "order_status_wise"
        case orderTypeWise = "order_type_wise"
        case ordersAmountProduct = "orders_amount_product"
        case totalDiscount = "total_discount"
        case ordersTotalProduct = "orders_total_product"
        case totalNoGuest = "total_no_guest"
        case totalNoTable = "total_no_table"
        case orderCount = "order_count"
        case onlineOrderCalculatedCommission = "online_order_calculated_commission"
        case onlineOrderCount = "online_order_count"
        case onlineOrderTotalBusiness = "online_order_total_business"
        case onlineReservationCount = "online_reservation_count"
        case totalGratuity = "total_gratuity"
        case totalServiceCharge = "total_service_charge"
        case allocatedVoucherValue = "allocated_voucher_value"
        case allocatedVoucher = "allocated_voucher"
        case iOSOnlineOrder = "ios_online_order_count"
        case androidOnlineOrder = "android_online_order_count"
        case webOnlineOrder = "web_online_order_count"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        onlineOrderPayment = try? values.decode([ReportModel].self, forKey: .onlineOrderPayment)
        onlineOrderType = try? values.decode([ReportModel].self, forKey: .onlineOrderType)
        orderPaymentWise = try? values.decode([ReportModel].self, forKey: .orderPaymentWise)
        orderStatusWise = try? values.decode([ReportModel].self, forKey: .orderStatusWise)
        orderTypeWise = try? values.decode([ReportModel].self, forKey: .orderTypeWise)
        iOSOnlineOrder = try? values.decode([ReportModel].self, forKey: .iOSOnlineOrder)
        androidOnlineOrder = try? values.decode([ReportModel].self, forKey: .androidOnlineOrder)
        webOnlineOrder = try? values.decode([ReportModel].self, forKey: .webOnlineOrder)
        
        deletedOrderItems = values.getIntValue(key: CodingKeys.deletedOrderItems) ?? 0
        deletedOrderItemsAmount = values.getDoubleValue(key: CodingKeys.deletedOrderItemsAmount) ?? 0
        onlineReservationCount = values.getIntValue(key: CodingKeys.onlineReservationCount)
        totalNoGuest = values.getIntValue(key: CodingKeys.totalNoGuest)
        totalNoTable = values.getIntValue(key: CodingKeys.totalNoTable)
        ordersTotalProduct = values.getIntValue(key: CodingKeys.ordersTotalProduct)
        orderCount = values.getIntValue(key: CodingKeys.orderCount)
        onlineOrderCount = values.getIntValue(key: CodingKeys.onlineOrderCount)
        allocatedVoucher = values.getIntValue(key: CodingKeys.allocatedVoucher)
        onlineOrderTotalBusiness = values.getDoubleValue(key: CodingKeys.onlineOrderTotalBusiness)
        totalDiscount = values.getDoubleValue(key: CodingKeys.totalDiscount)
        ordersAmountProduct = values.getDoubleValue(key: CodingKeys.ordersAmountProduct)
        totalGratuity = values.getDoubleValue(key: CodingKeys.totalGratuity)
        onlineOrderCalculatedCommission = values.getDoubleValue(key: CodingKeys.onlineOrderCalculatedCommission)
        totalServiceCharge = values.getDoubleValue(key: CodingKeys.totalServiceCharge)
        allocatedVoucherValue = values.getDoubleValue(key: CodingKeys.allocatedVoucherValue)
    }
}

class ReportModel:Codable{
    
    var count: Int?
    var status: String?
    var type: String?
    var total: Double?
    var name: String?
    var productName: String?
    var categoryName: String?
    var orderType: String?
    var paymentMethod: String?
    var rowType = 0 //0 - Amount, 1 - Value, 2 - Title
    var showAll = false
    
    enum CodingKeys: String, CodingKey {
        case count, status, total, type, name
        case productName = "product_name"
        case categoryName = "category_name"
        case orderType = "order_type"
        case paymentMethod = "payment_method"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        if let status = values.getStringValue(key: CodingKeys.status){
            self.status = status
        }else if let status = values.getStringValue(key: CodingKeys.type){
            self.status = status
        }else if let status = values.getStringValue(key: CodingKeys.name){
            self.status = status
        }else if let status = values.getStringValue(key: CodingKeys.productName){
            self.status = status
        }else if let status = values.getStringValue(key: CodingKeys.categoryName){
            self.status = status
        }else if let status = values.getStringValue(key: CodingKeys.orderType){
            self.status = status
        }else if let status = values.getStringValue(key: CodingKeys.paymentMethod){
            self.status = status
        }
        
        count = values.getIntValue(key: CodingKeys.count)
        total = values.getDoubleValue(key: CodingKeys.total)
    }
    
    init(status:String, total:Double? = nil, count:Int? = nil, rowType:Int = 0, showAll:Bool = false) {
        self.status = status
        self.total = total
        self.count = count
        self.rowType = rowType
        self.showAll = showAll
    }
}

class PaypalTransactionModel:Codable{
    
    var id: Int?
    var transactionAmount: Double?
    var saleState: String?
    var refundedAmount: Double?
    var saleCreatedAt: String?
    
    enum CodingKeys: String, CodingKey {
        case saleState = "sale_state"
        case transactionAmount = "transaction_amount"
        case refundedAmount = "refunded_amount"
        case saleCreatedAt = "sale_created_at"
        case id
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        refundedAmount = values.getDoubleValue(key: CodingKeys.refundedAmount)
        transactionAmount = values.getDoubleValue(key: CodingKeys.transactionAmount)
        id = values.getIntValue(key: CodingKeys.id)
        saleCreatedAt = values.getStringValue(key: CodingKeys.saleCreatedAt)
        saleState = values.getStringValue(key: CodingKeys.saleState)
        
    }
}

class TransactionModel:Codable{
    
    var archived: Int?
    var created: String?
    var id: Int?
    var amount: Int?
    var cardBrand: String?
    var type: String?
    var cardNumber: String?
    var txnId: String?
    var refunded: Int?
    var transactionDateTime: String?
    
    enum CodingKeys: String, CodingKey {
        case amount, archived, type, id, created, refunded
        case cardBrand = "card_brand"
        case cardNumber = "card_number"
        case transactionDateTime = "transaction_date_time"
        case txnId = "txn_id"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        type = values.getStringValue(key: CodingKeys.type)
        cardBrand = values.getStringValue(key: CodingKeys.cardBrand)
        amount = values.getIntValue(key: CodingKeys.amount)
        id = values.getIntValue(key: CodingKeys.id)
        archived = values.getIntValue(key: CodingKeys.archived)
        created = values.getStringValue(key: CodingKeys.created)
        cardNumber = values.getStringValue(key: CodingKeys.cardNumber)
        txnId = values.getStringValue(key: CodingKeys.txnId)
        transactionDateTime = values.getStringValue(key: CodingKeys.transactionDateTime)
        refunded = values.getIntValue(key: CodingKeys.refunded)
    }
}

class StatementModel:Codable{
    
    var transactionType: String?
    var toDate: String?
    var id: Int?
    var netTotal: Double?
    
    enum CodingKeys: String, CodingKey {
        case id
        case toDate = "to_date"
        case transactionType = "transaction_type"
        case netTotal = "net_total"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        toDate = values.getStringValue(key: CodingKeys.toDate)
        transactionType = values.getStringValue(key: CodingKeys.transactionType)
        id = values.getIntValue(key: CodingKeys.id)
        netTotal = values.getDoubleValue(key: CodingKeys.netTotal)
    }
}

class PaymentLinkModel: Codable {
    
    var amount: Double?
    var status: String?
    var phone: String?
    var created: String?
    var id: Int?
    var link = ""
    
    enum CodingKeys: String, CodingKey {
        case amount, status, created, id, phone, link
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        phone = values.getStringValue(key: CodingKeys.phone)
        status = values.getStringValue(key: CodingKeys.status)
        created = values.getStringValue(key: CodingKeys.created)
        id = values.getIntValue(key: CodingKeys.id)
        amount = values.getDoubleValue(key: CodingKeys.amount)
        link = values.getStringValue(key: CodingKeys.link) ?? ""
    }
}
