//
//  ReservationModel.swift
//  EPOS
//
//  Created by Apple on 27/05/21.
//

import Foundation
import CoreData

class DepositTypeModel:Codable{
    
    var id: Int?
    var type: String?
    
    enum CodingKeys: String, CodingKey {
        case id, type
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        type = values.getStringValue(key: CodingKeys.type)
        id = values.getIntValue(key: CodingKeys.id)
    }
    
    init(_ deposit:NSManagedObject) {
        self.id = deposit.value(forKey: "id") as? Int
        self.type = deposit.value(forKey: "type") as? String
    }
}

class ReservationModel:Codable{
    
    var id: Int?
    var customerId: Int?
    var depositAmount: Double?
    var depositTypeId: Int?
    var diners: Int?
    var reservationDateTime: String?
    var reservationStatusId: Int?
    var specialInstruction: String?
    var tableId: Int?
    var customer: CustomerModel?
    var tableNumber: String?
    var offline = 1
    var isDelete = 0
    var updaterId:Int?
    var uniqueId = ""
    
    enum CodingKeys: String, CodingKey {
        case id, diners, customer
        case updaterId = "updater_id"
        case customerId = "customer_id"
        case depositAmount = "deposit_amount"
        case reservationDateTime = "reservation_date_time"
        case reservationStatusId = "reservation_status_id"
        case specialInstruction = "special_instruction"
        case tableId = "table_id"
        case uniqueId = "unique_id"
        case tableNumber = "table_number"
        case depositTypeId = "deposit_type_id"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        reservationDateTime = values.getStringValue(key: CodingKeys.reservationDateTime)
        specialInstruction = values.getStringValue(key: CodingKeys.specialInstruction)
        id = values.getIntValue(key: CodingKeys.id)
        updaterId = values.getIntValue(key: CodingKeys.updaterId)
        diners = values.getIntValue(key: CodingKeys.diners)
        customerId = values.getIntValue(key: CodingKeys.customerId)
        reservationStatusId = values.getIntValue(key: CodingKeys.reservationStatusId)
        tableId = values.getIntValue(key: CodingKeys.tableId)
        depositAmount = values.getDoubleValue(key: CodingKeys.depositAmount)
        customer = try? values.decode(CustomerModel.self, forKey: .customer)
        tableNumber = values.getStringValue(key: CodingKeys.tableNumber)
        depositTypeId = values.getIntValue(key: CodingKeys.depositTypeId)
        uniqueId = values.getStringValue(key: CodingKeys.uniqueId) ?? ""
    }
    
    init(_ reservation:NSManagedObject) {
        self.id = reservation.value(forKey: "id") as? Int
        self.customerId = reservation.value(forKey: "customer_id") as? Int
        self.updaterId = reservation.value(forKey: "updater_id") as? Int
        self.depositAmount = reservation.value(forKey: "deposit_amount") as? Double
        self.reservationStatusId = reservation.value(forKey: "reservation_status_id") as? Int
        self.specialInstruction = reservation.value(forKey: "special_instruction") as? String
        self.tableId = reservation.value(forKey: "table_id") as? Int
        self.diners = reservation.value(forKey: "diners") as? Int
        self.depositTypeId = reservation.value(forKey: "deposit_type_id") as? Int
        self.customer = CoreDataHelper.shared.fetchCustomerObect(id: self.customerId ?? 0)
        self.tableNumber = reservation.value(forKey: "table_number") as? String
        if let timstamp = reservation.value(forKey: "reservation_date_time") as? Int{
            self.reservationDateTime = (Date.init(timeIntervalSince1970: Double(timstamp))).getDateInString(format: "yyyy-MM-dd HH:mm:ss")
        }
        self.offline = reservation.getIntValue("offline") ?? 1
        self.uniqueId = reservation.getStringValue("unique_id") ?? ""
    }
}


class OnlineReservationModel: Codable {
    
    var bookingId: String?
    var custId: Int?
    var id: Int?
    var bookingEmail: String?
    var bookingPhone: String?
    var guestCount: Int?
    var customerName: String?
    var bookingInstruction: String?
    var bookingDate: String?
    var bookingTime: String?
    var status: String?
    var cancelReason: String?
    
    enum CodingKeys: String, CodingKey {
        case status, id
        case custId = "customer_id"
        case bookingId = "booking_id"
        case bookingEmail = "booking_email"
        case bookingPhone = "booking_phone"
        case guestCount = "guest_count"
        case customerName = "customer_name"
        case bookingInstruction = "booking_instruction"
        case bookingDate = "booking_date"
        case bookingTime = "booking_time"
        case cancelReason = "cancel_reason"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        status = values.getStringValue(key: CodingKeys.status)
        custId = values.getIntValue(key: CodingKeys.custId)
        id = values.getIntValue(key: CodingKeys.id)
        guestCount = values.getIntValue(key: CodingKeys.guestCount)
        bookingId = values.getStringValue(key: CodingKeys.bookingId)
        bookingEmail = values.getStringValue(key: CodingKeys.bookingEmail)
        bookingPhone = values.getStringValue(key: CodingKeys.bookingPhone)
        customerName = values.getStringValue(key: CodingKeys.customerName)
        bookingInstruction = values.getStringValue(key: CodingKeys.bookingInstruction)
        bookingDate = values.getStringValue(key: CodingKeys.bookingDate)
        bookingTime = values.getStringValue(key: CodingKeys.bookingTime)
        cancelReason = values.getStringValue(key: CodingKeys.cancelReason)
    }
}
