//
//  RestaurantModel.swift
//  EPOS
//
//  Created by Apple on 15/06/21.
//

import Foundation

class RestaurantDetailModel: Codable {
    
    var RTC: String?
    var id: Int?
    var smartMpsId: Int?
    var storename: String?
    var address: String?
    var bookingEnable: String?
    var orderEnable: String?
    var dineIn: Int?
    var logo: String?
    var bookingStatus: String?
    var restaurantDescription: String?
    var email: String?
    var phone: String?
    var deliverySetting:[deliverySettingsModel]?
    var minOrder: Int?
    var gratuity: Int?
    var contactName: String?
    var username: String?
    var storePhone: String?
    var appSetting: String?
    var deviceId: String?
    var bankDetail: BankInfoModel?
    var pickupTime: PickupTiming?
    var restaurantDelivery: String?
    var serviceChargeStatus: String?
        
    var mondayFirstOpentime: String? = ""
    var mondaySecondOpentime: String? = ""
    var mondayFirstClosetime: String? = ""
    var mondaySecondClosetime: String? = ""
    var tuesdayFirstOpentime: String? = ""
    var tuesdaySecondOpentime: String? = ""
    var tuesdayFirstClosetime: String? = ""
    var tuesdaySecondClosetime: String? = ""
    var wednesdayFirstOpentime: String? = ""
    var wednesdaySecondOpentime: String? = ""
    var wednesdayFirstClosetime: String? = ""
    var wednesdaySecondClosetime: String? = ""
    var thursdayFirstOpentime: String? = ""
    var thursdaySecondOpentime: String? = ""
    var thursdayFirstClosetime: String? = ""
    var thursdaySecondClosetime: String? = ""
    var fridayFirstOpentime: String? = ""
    var fridaySecondOpentime: String? = ""
    var fridayFirstClosetime: String? = ""
    var fridaySecondClosetime: String? = ""
    var saturdayFirstOpentime: String? = ""
    var saturdaySecondOpentime: String? = ""
    var saturdayFirstClosetime: String? = ""
    var saturdaySecondClosetime: String? = ""
    var sundayFirstOpentime: String? = ""
    var sundaySecondOpentime: String? = ""
    var sundayFirstClosetime: String? = ""
    var sundaySecondClosetime: String? = ""
    
    var mondayStatus: String? = ""
    var tuesdayStatus: String? = ""
    var wednesdayStatus: String? = ""
    var thursdayStatus: String? = ""
    var fridayStatus: String? = ""
    var saturdayStatus: String? = ""
    var sundayStatus: String? = ""
    
    enum CodingKeys: String, CodingKey {
        case id, RTC, gratuity, username
        case restaurantDelivery = "restaurant_delivery"
        case phone = "contact_phone"
        case email = "contact_email"
        case address = "contact_address"
        case smartMpsId = "smart_mps_id"
        case dineIn = "dine_in"
        case storename = "restaurant_name"
        case storePhone = "restaurant_phone"
        case bookingEnable = "restaurant_booktable"
        case orderEnable = "online_order"
        case logo = "restaurant_logo"
        case bookingStatus = "booking_status"
        case restaurantDescription = "restaurant_about"
        case deliverySetting = "delivery_setting"
        case minOrder = "minimum_order"
        case contactName = "contact_name"
        case appSetting = "app_setting"
        case bankDetail = "bank_detail"
        case serviceChargeStatus = "service_charge_status"
        case deviceId = "device_id"
        case mondayFirstOpentime = "monday_first_opentime"
        case mondaySecondOpentime = "monday_second_opentime"
        case mondayFirstClosetime = "monday_first_closetime"
        case mondaySecondClosetime = "monday_second_closetime"
        case tuesdayFirstOpentime = "tuesday_first_opentime"
        case tuesdaySecondOpentime = "tuesday_second_opentime"
        case tuesdayFirstClosetime = "tuesday_first_closetime"
        case tuesdaySecondClosetime = "tuesday_second_closetime"
        case wednesdayFirstOpentime = "wednesday_first_opentime"
        case wednesdaySecondOpentime = "wednesday_second_opentime"
        case wednesdayFirstClosetime = "wednesday_first_closetime"
        case wednesdaySecondClosetime = "wednesday_second_closetime"
        case thursdayFirstOpentime = "thursday_first_opentime"
        case thursdaySecondOpentime = "thursday_second_opentime"
        case thursdayFirstClosetime = "thursday_first_closetime"
        case thursdaySecondClosetime = "thursday_second_closetime"
        case fridayFirstOpentime = "friday_first_opentime"
        case fridaySecondOpentime = "friday_second_opentime"
        case fridayFirstClosetime = "friday_first_closetime"
        case fridaySecondClosetime = "friday_second_closetime"
        case saturdayFirstOpentime = "saturday_first_opentime"
        case saturdaySecondOpentime = "saturday_second_opentime"
        case saturdayFirstClosetime = "saturday_first_closetime"
        case saturdaySecondClosetime = "saturday_second_closetime"
        case sundayFirstOpentime = "sunday_first_opentime"
        case sundaySecondOpentime = "sunday_second_opentime"
        case sundayFirstClosetime = "sunday_first_closetime"
        case sundaySecondClosetime = "sunday_second_closetime"
        case mondayStatus = "monday_status"
        case tuesdayStatus = "tuesday_status"
        case wednesdayStatus = "wednesday_status"
        case thursdayStatus = "thursday_status"
        case fridayStatus = "friday_status"
        case saturdayStatus = "saturday_status"
        case sundayStatus = "sunday_status"
        case pickupTime = "restaurant_timing"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        serviceChargeStatus = values.getStringValue(key: CodingKeys.serviceChargeStatus)
        contactName = values.getStringValue(key: CodingKeys.contactName)
        username = values.getStringValue(key: CodingKeys.username)
        storePhone = values.getStringValue(key: CodingKeys.storePhone)
        deviceId = values.getStringValue(key: CodingKeys.deviceId)
        restaurantDelivery = values.getStringValue(key: CodingKeys.restaurantDelivery)
        RTC = values.getStringValue(key: CodingKeys.RTC)
        id = values.getIntValue(key: CodingKeys.id)
        gratuity = values.getIntValue(key: CodingKeys.gratuity)
        dineIn = values.getIntValue(key: CodingKeys.dineIn)
        smartMpsId = values.getIntValue(key: CodingKeys.smartMpsId)
        storename = values.getStringValue(key: CodingKeys.storename)
        address = values.getStringValue(key: CodingKeys.address)
        bookingEnable = values.getStringValue(key: CodingKeys.bookingEnable)
        bookingStatus = values.getStringValue(key: CodingKeys.bookingStatus)
        orderEnable = values.getStringValue(key: CodingKeys.orderEnable)
        logo = values.getStringValue(key: CodingKeys.logo)
        restaurantDescription = values.getStringValue(key: CodingKeys.restaurantDescription)
        phone = values.getStringValue(key: CodingKeys.phone)
        email = values.getStringValue(key: CodingKeys.email)
        minOrder = values.getIntValue(key: CodingKeys.minOrder)
        appSetting = values.getStringValue(key: CodingKeys.appSetting)
        
        mondayFirstOpentime = values.getStringValue(key: CodingKeys.mondayFirstOpentime)
        mondaySecondOpentime = values.getStringValue(key: CodingKeys.mondaySecondOpentime)
        mondayFirstClosetime = values.getStringValue(key: CodingKeys.mondayFirstClosetime)
        mondaySecondClosetime = values.getStringValue(key: CodingKeys.mondaySecondClosetime)
        
        tuesdayFirstOpentime = values.getStringValue(key: CodingKeys.tuesdayFirstOpentime)
        tuesdaySecondOpentime = values.getStringValue(key: CodingKeys.tuesdaySecondOpentime)
        tuesdayFirstClosetime = values.getStringValue(key: CodingKeys.tuesdayFirstClosetime)
        tuesdaySecondClosetime = values.getStringValue(key: CodingKeys.tuesdaySecondClosetime)
        
        wednesdayFirstOpentime = values.getStringValue(key: CodingKeys.wednesdayFirstOpentime)
        wednesdaySecondOpentime = values.getStringValue(key: CodingKeys.wednesdaySecondOpentime)
        wednesdayFirstClosetime = values.getStringValue(key: CodingKeys.wednesdayFirstClosetime)
        wednesdaySecondClosetime = values.getStringValue(key: CodingKeys.wednesdaySecondClosetime)
        
        thursdayFirstOpentime = values.getStringValue(key: CodingKeys.thursdayFirstOpentime)
        thursdaySecondOpentime = values.getStringValue(key: CodingKeys.thursdaySecondOpentime)
        thursdayFirstClosetime = values.getStringValue(key: CodingKeys.thursdayFirstClosetime)
        thursdaySecondClosetime = values.getStringValue(key: CodingKeys.thursdaySecondClosetime)
        
        fridayFirstOpentime = values.getStringValue(key: CodingKeys.fridayFirstOpentime)
        fridaySecondOpentime = values.getStringValue(key: CodingKeys.fridaySecondOpentime)
        fridayFirstClosetime = values.getStringValue(key: CodingKeys.fridayFirstClosetime)
        fridaySecondClosetime = values.getStringValue(key: CodingKeys.fridaySecondClosetime)
        
        saturdayFirstOpentime = values.getStringValue(key: CodingKeys.saturdayFirstOpentime)
        saturdaySecondOpentime = values.getStringValue(key: CodingKeys.saturdaySecondOpentime)
        saturdayFirstClosetime = values.getStringValue(key: CodingKeys.saturdayFirstClosetime)
        saturdaySecondClosetime = values.getStringValue(key: CodingKeys.saturdaySecondClosetime)
        
        sundayFirstOpentime = values.getStringValue(key: CodingKeys.sundayFirstOpentime)
        sundaySecondOpentime = values.getStringValue(key: CodingKeys.sundaySecondOpentime)
        sundayFirstClosetime = values.getStringValue(key: CodingKeys.sundayFirstClosetime)
        sundaySecondClosetime = values.getStringValue(key: CodingKeys.sundaySecondClosetime)
        
        mondayStatus = values.getStringValue(key: CodingKeys.mondayStatus)
        tuesdayStatus = values.getStringValue(key: CodingKeys.tuesdayStatus)
        wednesdayStatus = values.getStringValue(key: CodingKeys.wednesdayStatus)
        thursdayStatus = values.getStringValue(key: CodingKeys.thursdayStatus)
        fridayStatus = values.getStringValue(key: CodingKeys.fridayStatus)
        saturdayStatus = values.getStringValue(key: CodingKeys.saturdayStatus)
        sundayStatus = values.getStringValue(key: CodingKeys.sundayStatus)
        
        deliverySetting = try? values.decode([deliverySettingsModel].self, forKey: .deliverySetting)
        bankDetail = try? values.decode(BankInfoModel.self, forKey: .bankDetail)
        pickupTime = try? values.decode(PickupTiming.self, forKey: .pickupTime)
        
    }
}

class deliverySettingsModel:Codable{
    
    var deliveryCharge: Double?
    var deliveryMile: Double?
    
    enum CodingKeys: String, CodingKey {
        case deliveryCharge = "delivery_charge"
        case deliveryMile = "delivery_miles"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        deliveryCharge = values.getDoubleValue(key: CodingKeys.deliveryCharge)
        deliveryMile = values.getDoubleValue(key: CodingKeys.deliveryMile)
    }
    
    init(deliveryCharge:Double,deliveryMile:Double) {
        self.deliveryMile = deliveryMile
        self.deliveryCharge = deliveryCharge
    }
}

class PickupTiming:Codable{
    
    var id:Int?
    var pickWorkingTime:String?
    
    var mondayFirstOpentime: String? = ""
    var mondaySecondOpentime: String? = ""
    var mondayFirstClosetime: String? = ""
    var mondaySecondClosetime: String? = ""
    var tuesdayFirstOpentime: String? = ""
    var tuesdaySecondOpentime: String? = ""
    var tuesdayFirstClosetime: String? = ""
    var tuesdaySecondClosetime: String? = ""
    var wednesdayFirstOpentime: String? = ""
    var wednesdaySecondOpentime: String? = ""
    var wednesdayFirstClosetime: String? = ""
    var wednesdaySecondClosetime: String? = ""
    var thursdayFirstOpentime: String? = ""
    var thursdaySecondOpentime: String? = ""
    var thursdayFirstClosetime: String? = ""
    var thursdaySecondClosetime: String? = ""
    var fridayFirstOpentime: String? = ""
    var fridaySecondOpentime: String? = ""
    var fridayFirstClosetime: String? = ""
    var fridaySecondClosetime: String? = ""
    var saturdayFirstOpentime: String? = ""
    var saturdaySecondOpentime: String? = ""
    var saturdayFirstClosetime: String? = ""
    var saturdaySecondClosetime: String? = ""
    var sundayFirstOpentime: String? = ""
    var sundaySecondOpentime: String? = ""
    var sundayFirstClosetime: String? = ""
    var sundaySecondClosetime: String? = ""
    
    var mondayStatus: String? = ""
    var tuesdayStatus: String? = ""
    var wednesdayStatus: String? = ""
    var thursdayStatus: String? = ""
    var fridayStatus: String? = ""
    var saturdayStatus: String? = ""
    var sundayStatus: String? = ""
    
    enum CodingKeys: String, CodingKey {
        case id
        case pickWorkingTime = "pick_working_time"
        case mondayFirstOpentime = "pick_monday_first_opentime"
        case mondaySecondOpentime = "pick_monday_second_opentime"
        case mondayFirstClosetime = "pick_monday_first_closetime"
        case mondaySecondClosetime = "pick_monday_second_closetime"
        case tuesdayFirstOpentime = "pick_tuesday_first_opentime"
        case tuesdaySecondOpentime = "pick_tuesday_second_opentime"
        case tuesdayFirstClosetime = "pick_tuesday_first_closetime"
        case tuesdaySecondClosetime = "pick_tuesday_second_closetime"
        case wednesdayFirstOpentime = "pick_wednesday_first_opentime"
        case wednesdaySecondOpentime = "pick_wednesday_second_opentime"
        case wednesdayFirstClosetime = "pick_wednesday_first_closetime"
        case wednesdaySecondClosetime = "pick_wednesday_second_closetime"
        case thursdayFirstOpentime = "pick_thursday_first_opentime"
        case thursdaySecondOpentime = "pick_thursday_second_opentime"
        case thursdayFirstClosetime = "pick_thursday_first_closetime"
        case thursdaySecondClosetime = "pick_thursday_second_closetime"
        case fridayFirstOpentime = "pick_friday_first_opentime"
        case fridaySecondOpentime = "pick_friday_second_opentime"
        case fridayFirstClosetime = "pick_friday_first_closetime"
        case fridaySecondClosetime = "pick_friday_second_closetime"
        case saturdayFirstOpentime = "pick_saturday_first_opentime"
        case saturdaySecondOpentime = "pick_saturday_second_opentime"
        case saturdayFirstClosetime = "pick_saturday_first_closetime"
        case saturdaySecondClosetime = "pick_saturday_second_closetime"
        case sundayFirstOpentime = "pick_sunday_first_opentime"
        case sundaySecondOpentime = "pick_sunday_second_opentime"
        case sundayFirstClosetime = "pick_sunday_first_closetime"
        case sundaySecondClosetime = "pick_sunday_second_closetime"
        
        case mondayStatus = "pick_monday_status"
        case tuesdayStatus = "pick_tuesday_status"
        case wednesdayStatus = "pick_wednesday_status"
        case thursdayStatus = "pick_thursday_status"
        case fridayStatus = "pick_friday_status"
        case saturdayStatus = "pick_saturday_status"
        case sundayStatus = "pick_sunday_status"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        pickWorkingTime = values.getStringValue(key: CodingKeys.pickWorkingTime)
        id = values.getIntValue(key: CodingKeys.id)
        mondayFirstOpentime = values.getStringValue(key: CodingKeys.mondayFirstOpentime)
        mondaySecondOpentime = values.getStringValue(key: CodingKeys.mondaySecondOpentime)
        mondayFirstClosetime = values.getStringValue(key: CodingKeys.mondayFirstClosetime)
        mondaySecondClosetime = values.getStringValue(key: CodingKeys.mondaySecondClosetime)
        
        tuesdayFirstOpentime = values.getStringValue(key: CodingKeys.tuesdayFirstOpentime)
        tuesdaySecondOpentime = values.getStringValue(key: CodingKeys.tuesdaySecondOpentime)
        tuesdayFirstClosetime = values.getStringValue(key: CodingKeys.tuesdayFirstClosetime)
        tuesdaySecondClosetime = values.getStringValue(key: CodingKeys.tuesdaySecondClosetime)
        
        wednesdayFirstOpentime = values.getStringValue(key: CodingKeys.wednesdayFirstOpentime)
        wednesdaySecondOpentime = values.getStringValue(key: CodingKeys.wednesdaySecondOpentime)
        wednesdayFirstClosetime = values.getStringValue(key: CodingKeys.wednesdayFirstClosetime)
        wednesdaySecondClosetime = values.getStringValue(key: CodingKeys.wednesdaySecondClosetime)
        
        thursdayFirstOpentime = values.getStringValue(key: CodingKeys.thursdayFirstOpentime)
        thursdaySecondOpentime = values.getStringValue(key: CodingKeys.thursdaySecondOpentime)
        thursdayFirstClosetime = values.getStringValue(key: CodingKeys.thursdayFirstClosetime)
        thursdaySecondClosetime = values.getStringValue(key: CodingKeys.thursdaySecondClosetime)
        
        fridayFirstOpentime = values.getStringValue(key: CodingKeys.fridayFirstOpentime)
        fridaySecondOpentime = values.getStringValue(key: CodingKeys.fridaySecondOpentime)
        fridayFirstClosetime = values.getStringValue(key: CodingKeys.fridayFirstClosetime)
        fridaySecondClosetime = values.getStringValue(key: CodingKeys.fridaySecondClosetime)
        
        saturdayFirstOpentime = values.getStringValue(key: CodingKeys.saturdayFirstOpentime)
        saturdaySecondOpentime = values.getStringValue(key: CodingKeys.saturdaySecondOpentime)
        saturdayFirstClosetime = values.getStringValue(key: CodingKeys.saturdayFirstClosetime)
        saturdaySecondClosetime = values.getStringValue(key: CodingKeys.saturdaySecondClosetime)
        
        sundayFirstOpentime = values.getStringValue(key: CodingKeys.sundayFirstOpentime)
        sundaySecondOpentime = values.getStringValue(key: CodingKeys.sundaySecondOpentime)
        sundayFirstClosetime = values.getStringValue(key: CodingKeys.sundayFirstClosetime)
        sundaySecondClosetime = values.getStringValue(key: CodingKeys.sundaySecondClosetime)
        
        mondayStatus = values.getStringValue(key: CodingKeys.mondayStatus)
        tuesdayStatus = values.getStringValue(key: CodingKeys.tuesdayStatus)
        wednesdayStatus = values.getStringValue(key: CodingKeys.wednesdayStatus)
        thursdayStatus = values.getStringValue(key: CodingKeys.thursdayStatus)
        fridayStatus = values.getStringValue(key: CodingKeys.fridayStatus)
        saturdayStatus = values.getStringValue(key: CodingKeys.saturdayStatus)
        sundayStatus = values.getStringValue(key: CodingKeys.sundayStatus)
    }
}

class restaurantModel:Codable{
    
    var company: String?
    var resId: Int?
    var testMode: String?
    
    enum CodingKeys: String, CodingKey {
        case resId = "res_id"
        case company = "Company"
        case testMode = "test_mode"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        company = values.getStringValue(key: CodingKeys.company)
        resId = values.getIntValue(key: CodingKeys.resId)
        testMode = values.getStringValue(key: CodingKeys.testMode)
    }
}

class BankInfoModel: Codable {
    
    var accountName: String?
    var accountNumber: String?
    var accountType: String?
    var bankName: String?
    var sortCode: String?
    
    enum CodingKeys: String, CodingKey {
        case accountName = "account_name"
        case accountNumber = "account_number"
        case accountType = "account_type"
        case bankName = "bank_name"
        case sortCode = "sort_code"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        accountName = values.getStringValue(key: CodingKeys.accountName)
        accountNumber = values.getStringValue(key: CodingKeys.accountNumber)
        accountType = values.getStringValue(key: CodingKeys.accountType)
        bankName = values.getStringValue(key: CodingKeys.bankName)
        sortCode = values.getStringValue(key: CodingKeys.sortCode)
    }
}

class RestaurantSiteSettingsModel: Codable {
    
    var contactEmail: String?
    var contactPhone: String?
    
    enum CodingKeys: String, CodingKey {
        case contactPhone = "contact_phone"
        case contactEmail = "contact_us_email"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        contactEmail = values.getStringValue(key: CodingKeys.contactEmail)
        contactPhone = values.getStringValue(key: CodingKeys.contactPhone)
    }
}

class OfferModel: Codable {
    
    var id: Int?
    var offerFrom: String?
    var offerTo: String?
    var resid: Int?
    var deliveryType: Int?
    var pickupType: Int?
    var dineinType: Int?
    var normalPercentage: Double?
    var normalPrice: Double?
    var normal: String?
    var status: Int?
    var firstUser: String?
    var freePercentage:Double?
    var freePrice:Double?
    var offerMode: String?
    
    enum CodingKeys: String, CodingKey {
        case id, normal, resid, status
        case freePrice = "free_price"
        case freePercentage = "free_percentage"
        case firstUser = "first_user"
        case offerFrom = "offer_from"
        case offerTo = "offer_to"
        case deliveryType = "delivery_type"
        case pickupType = "pickup_type"
        case dineinType = "dinein_type"
        case normalPercentage = "normal_percentage"
        case normalPrice = "normal_price"
        case offerMode = "offer_mode"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        firstUser = values.getStringValue(key: CodingKeys.firstUser)
        normal = values.getStringValue(key: CodingKeys.normal)
        offerFrom = values.getStringValue(key: CodingKeys.offerFrom)
        offerTo = values.getStringValue(key: CodingKeys.offerTo)
        offerMode = values.getStringValue(key: CodingKeys.offerMode)
        resid = values.getIntValue(key: CodingKeys.resid)
        deliveryType = values.getIntValue(key: CodingKeys.deliveryType)
        pickupType = values.getIntValue(key: CodingKeys.pickupType)
        status = values.getIntValue(key: CodingKeys.status)
        dineinType = values.getIntValue(key: CodingKeys.dineinType)
        normalPercentage = values.getDoubleValue(key: CodingKeys.normalPercentage)
        freePercentage = values.getDoubleValue(key: CodingKeys.freePercentage)
        normalPrice = values.getDoubleValue(key: CodingKeys.normalPrice)
        freePrice = values.getDoubleValue(key: CodingKeys.freePrice)
    }
    
    init() {
        
    }
}

class RestaurantVoucherModel: Codable {
    
    var id: Int?
    var voucherCode: String?
    var voucherFrom: String?
    var voucherTo: String?
    var resId: Int?
    var deliveryType: Int?
    var pickupType: Int?
    var dineinType: Int?
    var multipleValue: Int?
    var minOrder: Double?
    var offerMode: String?
    var offerValue: Double?
    var typeOffer: String?
    var deviceType: String?
    var day: String?
    var status:Int?
    
    enum CodingKeys: String, CodingKey {
        case id, status, day
        case voucherCode = "voucher_code"
        case voucherFrom = "voucher_from"
        case voucherTo = "voucher_to"
        case resId = "restaurant_id"
        case deliveryType = "delivery_type"
        case pickupType = "pickup_type"
        case dineinType = "dinein_type"
        case minOrder = "minimum_value"
        case offerMode = "offer_mode"
        case offerValue = "offer_value"
        case typeOffer = "type_offer"
        case deviceType = "device_type"
        case multipleValue = "multiple_value"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        status = values.getIntValue(key: CodingKeys.status)
        day = values.getStringValue(key: CodingKeys.day)
        id = values.getIntValue(key: CodingKeys.id)
        voucherCode = values.getStringValue(key: CodingKeys.voucherCode)
        voucherFrom = values.getStringValue(key: CodingKeys.voucherFrom)
        voucherTo = values.getStringValue(key: CodingKeys.voucherTo)
        offerMode = values.getStringValue(key: CodingKeys.offerMode)
        typeOffer = values.getStringValue(key: CodingKeys.typeOffer)
        deviceType = values.getStringValue(key: CodingKeys.deviceType)
        resId = values.getIntValue(key: CodingKeys.resId)
        deliveryType = values.getIntValue(key: CodingKeys.deliveryType)
        pickupType = values.getIntValue(key: CodingKeys.pickupType)
        dineinType = values.getIntValue(key: CodingKeys.dineinType)
        multipleValue = values.getIntValue(key: CodingKeys.multipleValue)
        minOrder = values.getDoubleValue(key: CodingKeys.minOrder)
        offerValue = values.getDoubleValue(key: CodingKeys.offerValue)
    }
    
    init() {
        
    }
}
