//
//  AdminLoginVC.swift
//  EPOS
//
//  Created by Apple on 09/04/21.
//

import UIKit

class AdminLoginVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var txtUserName:UITextField!
    @IBOutlet weak var txtPassword:UITextField!
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
//        if UIDevice.current.userInterfaceIdiom == .phone{
//            txtUserName.text = "admin@tiffintom.com"
//            txtPassword.text = "08712884044"
//            CallLoginAPI()
//        }
    }
    
    //MARK: Create ViewController Instance
    static func instance()->AdminLoginVC?{
        return UIStoryboard.init(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "AdminLoginVC") as? AdminLoginVC
    }
    
    //MARK:  Button Actions
    @IBAction func btnLoginAction(_ sender:UIButton){
        self.view.endEditing(true)
        if (txtUserName.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_EMAILID, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                _ = self.txtUserName.becomeFirstResponder()
            }
            return
        }else if !AppValidation().isValidRegEx(txtUserName.text ?? "", RegEx.email){
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_VALID_EMAIL, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                _ = self.txtUserName.becomeFirstResponder()
            }
            return
        }else if (txtPassword.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                _ = self.txtPassword.becomeFirstResponder()
            }
            return
        }
        CallLoginAPI()
    }
    
    //MARK: WebService Methods
    func CallLoginAPI(){
        var dictParam = [String:String]()
        dictParam["username"] = txtUserName.text ?? ""
        dictParam["password"] = txtPassword.text ?? ""
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kAdminLogin, method: "POST", isAdminURL: true, saveAdminToken: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let response = result as? NSDictionary{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aLoginData = try? jsonDecoder.decode(AdminModel.self, from: data){
                        aLoginData.password = self.txtPassword.text ?? ""
                        if let encoded = AppCommonMethods.getjsonDataFromCodable(object: aLoginData) {
                            AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kAdminUserData)
                        }
                        if let VC = SelectBusinessVC.instance(){
                            AppCommonMethods.FetchCardBrand()
                            self.navigationController?.pushViewController(VC, animated: true)
                        }
                        return
                    }
                }
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
}

//MARK: UITextFieldDelegate
extension AdminLoginVC:UITextFieldDelegate{
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        return textField.resignFirstResponder()
    }
}
