//
//  SelectBusinessVC.swift
//  EPOS
//
//  Created by Apple on 10/04/21.
//

import UIKit
import Stripe
import FirebaseMessaging

class SelectBusinessVC: UIViewController {
    
    //MARK:  IBOutlets
    @IBOutlet weak var tblBusiness:UITableView!
    @IBOutlet weak var lblViewTitle:UILabel!
    
    //MARK:  Instances
    var arrBusiness = [BusinessModel]()
    var selectedBusiness:BusinessModel?
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        
        self.arrBusiness = AppConstants.adminData?.arrBusiness ?? [BusinessModel]()
        AppCommonMethods.FetchBusinessData { (arr) in
            self.arrBusiness = arr ?? [BusinessModel]()
            self.tblBusiness.reloadData()
        }
    }
    
    //MARK: Create ViewController Instance
    static func instance()->SelectBusinessVC?{
        return UIStoryboard.init(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "SelectBusinessVC") as? SelectBusinessVC
    }
    
    //MARK:  Button Actions
    @IBAction func btnConfirmAction(_ sender:UIButton){
        if selectedBusiness == nil{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_SELECT_BUSINESS, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
        }else{
            if let encoded = AppCommonMethods.getjsonDataFromCodable(object: selectedBusiness!) {
                AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kBusinessData)
            }
            Messaging.messaging().subscribe(toTopic: "business_\(selectedBusiness!.id ?? 0)") { error in
                if error != nil{
                    print("Error topic: \(error?.localizedDescription ?? "")")
                }else{
                    print("Subscribed to topic")
                }
            }
            if selectedBusiness!.connectService ?? 0 == 1{
                AppCommonMethods.FetchCardBrandComission()
                AppCommonMethods.FetchCountryComission()
            }
            AppCommonMethods.startProgressBar()
            AppCommonMethods.FetchSiteSettings { success in
                AppCommonMethods.stopProgressBar()
                if let VC = LoginVC.instance(){
                    VC.isFromLogout = false
                    self.navigationController?.pushViewController(VC, animated: true)
                }
            }
        }
        
    }
}

//MARK:  UITableViewDataSource
extension SelectBusinessVC:UITableViewDataSource,UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrBusiness.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "BusinessListCell", for: indexPath) as! BusinessListCell
        let model = arrBusiness[indexPath.row]
        cell.lblName.text = model.name ?? ""
        cell.imgSelect.image = #imageLiteral(resourceName: "ic_radio_unselected")
        if selectedBusiness != nil{
            if model.id ?? 0 == selectedBusiness?.id ?? 0{
                cell.imgSelect.image = #imageLiteral(resourceName: "ic_radio_selected")
            }
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        selectedBusiness = arrBusiness[indexPath.row]
        
        tblBusiness.reloadData()
    }
}
