//
//  EditRestaurantVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 20/11/20.
//

import UIKit

class EditRestaurantVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var txtRestDescription:UITextView!
    @IBOutlet weak var lblRestDescriptionPlaceHolder:UILabel!
    @IBOutlet weak var lblRestDescriptionCount:UILabel!
    
    //MARK: Instances
    var delegate:EditRestaurantDelegate?
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        txtRestDescription.text = String((AppConstants.restaurantData?.restaurantDescription ?? "").suffix(300))
        setRestDescriptionTextView()
    }
    
    //MARK: Create Viewcontrlloer instance
    static func show()->SheetViewController?{
        guard let controller = UIStoryboard.init(name: "BottomPopup", bundle: nil).instantiateViewController(withIdentifier: "EditRestaurantVC") as? EditRestaurantVC else { return nil }
        let height:CGFloat = 465 + AppConstants.ScreenSize.bottomPadding
        return SheetViewController(controller: controller, sizes: [.fixed(height)], options: SheetOptions(useInlineMode: false))
    }
    
    //MARK: General Methods
    func setRestDescriptionTextView(){
        if txtRestDescription.text == ""{
            lblRestDescriptionPlaceHolder.isHidden = false
            lblRestDescriptionCount.text = "0/300"
        }else{
            lblRestDescriptionPlaceHolder.isHidden = true
            lblRestDescriptionCount.text = "\(txtRestDescription.text.count)/300"
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnCloseAction(_ sender:UIButton){
        self.dismiss(animated: true, completion: nil)
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        if (txtRestDescription.text?.trimmingCharacters(in: .whitespaces).isEmpty)!
        {
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_EMPTY_REST_DESC, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in

            }
        }else{
            CallEditRestaurantAPI()
        }
    }
    
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.dismiss(animated: true, completion: nil)
    }
    
    //MARK: WebService Methods
    func CallEditRestaurantAPI(){
        var dictParam = [String:Any]()
        dictParam["restaurant_about"] = txtRestDescription.text ?? ""
        
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kRestaurant)\(AppConstants.webResId ?? "")", method: "POST", isRestaurantAPI:true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let result = response as? NSDictionary, let jsonData = AppCommonMethods.convertToJson(object: result), let aLoginData = try? jsonDecoder.decode(RestaurantDetailModel.self, from: jsonData){
                    var settings = BottomAlertSettings()
                    settings.strMessage = "Restaurant has been updated"
                    AppValidation().showBottomAlertView(settings: settings)
                    if let encoded = AppCommonMethods.getjsonDataFromCodable(object: aLoginData) {
                        AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kUserData)
                    }
                    if self.delegate != nil{
                        self.delegate!.restaurantUpdated()
                    }
                    self.dismiss(animated: true, completion: nil)
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
}

//MARK: UITextViewDelegate
extension EditRestaurantVC:UITextViewDelegate{
    func textViewDidChange(_ textView: UITextView) {
        setRestDescriptionTextView()
    }
    
   func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
        if text == ""{
            return true
        }
        if textView.text.count >= 300{
            return false
        }
        return true
    }
}
