//
//  SelectTimeSlotVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 03/11/20.
//

import UIKit
import ActionSheetPicker_3_0

class SelectTimeSlotVC: UIViewController {
    
    //MARK: IBOutlet
    @IBOutlet weak var lblViewTitle:UILabel!
    @IBOutlet weak var lblSelectedDate:UILabel!
    @IBOutlet weak var lblViewDescription:UILabel!
    @IBOutlet weak var collectionTimeSlot:UICollectionView!
    @IBOutlet weak var lblOrderTime:UILabel!
    @IBOutlet weak var lblOrderType:UILabel!
    @IBOutlet weak var lblDistance:UILabel!
    @IBOutlet weak var viewForDistance:UIView!
    @IBOutlet weak var tblCarts:UITableView!
    
    //MARK: Instances
    var arrTimeSlot = [String]()
    weak var delegate:OrderActionDelegate!
    var selectedTimeSlot:String?
    var customTimeSlot = ""
    var orderDetails:WebOrderModel!
    var isDelayTime = false
    var preparationTime = ""
    var orderDate = ""
    var arrCarts = [WebProductDetailModel]()
    var parentVC:SideMenuVC!
    var isEstimatedTime = false
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        if !isEstimatedTime{
            if isDelayTime{
                lblViewTitle.text = "Delay order"
                lblViewDescription.text = "Delay order"
                if (orderDetails?.orderType ?? "").lowercased() == "pickup"{
                    lblViewDescription.text = "Please select a new time for collection of the order"
                }else{
                    lblViewDescription.text = "Please select a new time for delivery of the order"
                }
            }else{
                if (orderDetails?.orderType ?? "").lowercased() == "pickup"{
                    lblViewTitle.text = "Select Collection Time"
                    lblViewDescription.text = "Select Collection Time"
                }else{
                    lblViewTitle.text = "Select Delivery Time"
                    lblViewDescription.text = "Select Delivery Time"
                }
                self.arrCarts = self.orderDetails.arrProducts ?? [WebProductDetailModel]()
                setOrderDataFromDetails()
            }
            let date = (orderDetails.created ?? "").components(separatedBy: "T").first ?? ""
            orderDate = date.changeDateFormat(fromFormat: "yyyy-MM-dd", toFormat: "dd-MM-yyyy") ?? Date().getDateInString(format: "dd-MM-yyyy")
        }else{
            guard
                let reservationOpening = AppCommonMethods.fetchSiteSettingValue(key: "business_morning_start_time"),
                let reservationClosing = AppCommonMethods.fetchSiteSettingValue(key: "business_evening_end_time"),
                !reservationOpening.isEmpty,
                !reservationClosing.isEmpty
            else {
                return
            }
            
            let reservationSlotGap = AppCommonMethods.fetchSiteSettingValue(key: "reservation_slot_gap")
            
            let currentTime = Date()
            let dateFormatter = DateFormatter()
            dateFormatter.dateFormat = "dd-MM-yyyy"
            let dateString = dateFormatter.string(from: currentTime)
            
            // Parse opening time
            let dateTimeFormatter = DateFormatter()
            dateTimeFormatter.dateFormat = "dd-MM-yyyy HH:mm"
            
            guard
                let startTime = dateTimeFormatter.date(from: "\(dateString) \(reservationOpening)"),
                let endTime = dateTimeFormatter.date(from: "\(dateString) \(reservationClosing)")
            else {
                return
            }
            
            arrTimeSlot.removeAll()
            
            var slotTime = startTime
            let calendar = Calendar.current
            let gapMinutes = Int(reservationSlotGap ?? "15") ?? 15
            
            while slotTime <= endTime {
                if slotTime > currentTime {
                    let slotFormatter = DateFormatter()
                    slotFormatter.dateFormat = "HH:mm"
                    arrTimeSlot.append(slotFormatter.string(from: slotTime))
                }
                slotTime = calendar.date(byAdding: .minute, value: gapMinutes, to: slotTime) ?? slotTime
            }
        }
    }
    
    //MARK: create viewcontroller instance
    static func show(order:WebOrderModel,isDelayTime:Bool = false,arrTimeSlot:[String], parentVC:SideMenuVC)->SelectTimeSlotVC?{
        guard let controller = UIStoryboard.init(name: "BottomPopup", bundle: nil).instantiateViewController(withIdentifier: isDelayTime ? "DelaySelectTimeSlotVC" : "SelectTimeSlotVC") as? SelectTimeSlotVC else { return nil }
        controller.orderDetails = order
        controller.isDelayTime = isDelayTime
        controller.arrTimeSlot = arrTimeSlot
        controller.parentVC = parentVC
        parentVC.addChild(controller)
        parentVC.viewForSideContainer.addSubview(controller.view)
        var width:CGFloat = 865
        if isDelayTime{
            width = 590
        }
        parentVC.constSideViewLeadingSpace.constant = AppConstants.ScreenSize.SCREEN_WIDTH - width
        UIView.animate(withDuration: 0.25) {
            parentVC.viewForSideBG.alpha = 1.0
            parentVC.view.layoutIfNeeded()
        }
        controller.view.frame = CGRect.init(x: 0, y: 0, width: width, height: parentVC.viewForContainer.frame.height)
        return controller
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController, time:String)->SelectTimeSlotVC?{
        guard let controller = UIStoryboard.init(name: "BottomPopup", bundle: nil).instantiateViewController(withIdentifier: "EstimatedTimeSlotVC") as? SelectTimeSlotVC else { return nil }
        controller.isEstimatedTime = true
        parentVC.addChild(controller)
        parentVC.view.addSubview(controller.view)
        controller.view.alpha = 0
        UIView.animate(withDuration: 0.2) {
            controller.view.alpha = 1
        }
        controller.view.frame = parentVC.view.bounds
        return controller
    }
    
    //MARK: General Methods
    func setOrderDataFromDetails(){
        var strTiming = ""
        viewForDistance.isHidden = true
        if (orderDetails.orderType ?? "").lowercased() == "delivery"{
            if orderDetails.distance ?? "" != ""{
                viewForDistance.isHidden = false
                lblDistance.text = "\(orderDetails.distance ?? "") Away"
            }
        }
        
        if let date = ((orderDetails.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "HH:mm"){
            strTiming = "Ordered at: \(date)"
        }
        if (orderDetails.orderType ?? "").lowercased() == "dine in"{
            strTiming = "\(strTiming)\nServe by: ASAP"
        }
        
        
        let strPaid = (orderDetails.paymentStatus ?? "" == "P") ? "Paid" : "Unpaid"
        
        self.lblOrderType.text = "\(orderDetails.displayOrderType) - \(strPaid)"
        
        var cDate = ""
        if (orderDetails.orderType ?? "").lowercased() == "dine in"{
            cDate = ((orderDetails.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
        }else{
            cDate = "\((orderDetails.deliveryDate ?? "").components(separatedBy: "T").first ?? "") \(orderDetails.deliveryTime ?? "")"
        }
        if let date = cDate.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil), orderDetails.status ?? "" != "Delivered"{
            var strDate = "ASAP"
            if (orderDetails.assoonas ?? "" != "now"){
                strDate = date.getDateInString(format: "HH:mm")
            }
            
            if let time = orderDetails.preparation, time != "", let preparation = time.getDateFromString(format: "hh:mm a"){
                let current = Date().getDateInString(format: "hh:mm a").getDateFromString(format: "hh:mm a") ?? Date()
                if preparation < current{
                    lblOrderTime.textColor = AppConstants.Colors.kAppThemeRedColor
                    if (orderDetails.orderType ?? "").lowercased() == "delivery"{
                        strTiming = "\(strTiming)\nDelayed - Deliver by: \(strDate)"
                    }else if (orderDetails.orderType ?? "").lowercased() == "pickup"{
                        strTiming = "\(strTiming)\nDelayed - Collect by: \(strDate)"
                    }
                }else{
                    if (orderDetails.orderType ?? "").lowercased() == "delivery"{
                        strTiming = "\(strTiming)\nDeliver by: \(strDate)"
                    }else if (orderDetails.orderType ?? "").lowercased() == "pickup"{
                        strTiming = "\(strTiming)\nCollect by: \(strDate)"
                    }
                }
            }else{
                if (orderDetails.orderType ?? "").lowercased() == "delivery"{
                    strTiming = "\(strTiming)\nDeliver by: \(strDate)"
                }else if (orderDetails.orderType ?? "").lowercased() == "pickup"{
                    strTiming = "\(strTiming)\nCollect by: \(strDate)"
                }
            }
        }
        
        if (orderDetails.orderType ?? "").lowercased() == "delivery"{
            self.lblOrderType.textColor = AppConstants.Colors.kAppDarkGreenColor
        }else if (orderDetails.orderType ?? "").lowercased() == "pickup"{
            self.lblOrderType.textColor = AppConstants.Colors.kAppThemeBlueColor
        }else if (orderDetails.orderType ?? "").lowercased() == "dine in"{
            self.lblOrderType.textColor = AppConstants.Colors.kAppThemeYellowColor
        }
        
        if orderDetails.preparation ?? "" != ""{
            if orderDetails.status ?? "" == "Accepted"{
                strTiming = "\(strTiming)\nPreparation time: \((orderDetails.preparation ?? "").changeDateFormat(fromFormat: "hh:mm a", toFormat: "HH:mm") ?? "")"
            }else{
                if (orderDetails.orderType ?? "").lowercased() == "delivery"{
                    strTiming = "\(strTiming)\nDelivered at: \((orderDetails.preparation ?? "").changeDateFormat(fromFormat: "hh:mm a", toFormat: "HH:mm") ?? "")"
                }else if (orderDetails.orderType ?? "").lowercased() == "pickup"{
                    strTiming = "\(strTiming)\nCollected at: \((orderDetails.preparation ?? "").changeDateFormat(fromFormat: "hh:mm a", toFormat: "HH:mm") ?? "")"
                }else{
                    strTiming = "\(strTiming)\nServed at: \((orderDetails.preparation ?? "").changeDateFormat(fromFormat: "hh:mm a", toFormat: "HH:mm") ?? "")"
                }
            }
        }
        
        if orderDetails.status ?? "" == "Pending"{
            if let strDate = orderDetails.deliveryDate{
                let cDate = strDate.components(separatedBy: "T").first ?? ""
                if let date = cDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                    let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil)!
                    if date > currentDate{
                        self.lblOrderType.text = "Preorder for \(date.getDateInString(format: "dd/MM/yyyy"))\n\(orderDetails.displayOrderType) - \(strPaid)"
                        self.lblOrderType.textColor = AppConstants.Colors.kAppThemeRedColor
                        if let arrReminder = AppCommonMethods.readObjfromUserDefault(withKey: AppConstants.userDefaultKey.kReminderData) as? [NSDictionary]{
                            let dictReminder = arrReminder.first { (dict) -> Bool in
                                return dict.getIntValue("orderId") ?? 0 == self.orderDetails.id ?? 0
                            }
                            if dictReminder != nil{
                                strTiming = "\(strTiming)\nReminder: \(dictReminder?.getStringValue("date") ?? "")"
                            }
                        }
                    }
                }
            }
        }
        
        self.lblOrderTime.text = strTiming
    }
    
    func closePopup(){
        if isEstimatedTime{
            self.removePopupview()
        }else{
            parentVC.constSideViewLeadingSpace.constant = AppConstants.ScreenSize.SCREEN_WIDTH
            UIView.animate(withDuration: 0.25) {
                self.parentVC.viewForSideBG.alpha = 0.0
                self.parentVC.view.layoutIfNeeded()
            } completion: { (status) in
                self.view.removeFromSuperview()
                self.removeFromParent()
            }
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnCloseAction(_ sender:UIButton){
        self.closePopup()
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        if selectedTimeSlot == nil{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_SELECT_TIMESLOT, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return
        }else{
            if selectedTimeSlot != "ASAP"{
                let day = orderDate.components(separatedBy: "T").first ?? ""
                let currentDate = Date()
                let date = "\(day) \(selectedTimeSlot!)".getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil) ?? Date()
                if date < currentDate{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_TIMESLOT_GREATER_DATE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                    return
                }
            }
        }
        self.closePopup()
        if self.delegate != nil{
            self.delegate!.timeSlotSelected(strTimeslot: self.selectedTimeSlot, isDelayTime: self.isDelayTime)
        }
    }
    
    @IBAction func btnTimeSlotAction(_ sender:UIButton){
        if sender.tag == arrTimeSlot.count{
            let datePicker = ActionSheetDatePicker(title: "Select time", datePickerMode: UIDatePicker.Mode.time, selectedDate: Date(), doneBlock: {
                picker, value, index in
                if !self.isEstimatedTime{
                    self.customTimeSlot = (value as! Date).getDateInString(format: "hh:mm a")
                    self.selectedTimeSlot = (value as! Date).getDateInString(format: "hh:mm a")
                }else{
                    self.customTimeSlot = (value as! Date).getDateInString(format: "HH:mm")
                    self.selectedTimeSlot = (value as! Date).getDateInString(format: "HH:mm")
                }
                self.collectionTimeSlot.reloadData()
                if self.isDelayTime{
                    if (self.orderDetails?.orderType ?? "").lowercased() == "pickup"{
                        self.lblSelectedDate.text = "New collection time \(self.selectedTimeSlot ?? "") Selected"
                    }else{
                        self.lblSelectedDate.text = "New delivery time \(self.selectedTimeSlot ?? "") Selected"
                    }
                }else{
                    self.lblSelectedDate.text = "\(self.selectedTimeSlot ?? "") Selected"
                }
            }, cancel: { ActionStringCancelBlock in return }, origin: sender)
            datePicker?.minimumDate =  Date()
            datePicker?.show()
        }else{
            selectedTimeSlot = arrTimeSlot[sender.tag]
            self.collectionTimeSlot.reloadData()
            if !self.isEstimatedTime{
                if self.isDelayTime{
                    if (self.orderDetails?.orderType ?? "").lowercased() == "pickup"{
                        self.lblSelectedDate.text = "New collection time \(self.selectedTimeSlot ?? "") Selected"
                    }else{
                        self.lblSelectedDate.text = "New delivery time \(self.selectedTimeSlot ?? "") Selected"
                    }
                }else{
                    self.lblSelectedDate.text = "\(self.selectedTimeSlot ?? "") Selected"
                }
            }
        }
        
    }
    
}

//MARK: UICollectionViewDataSource
extension SelectTimeSlotVC:UICollectionViewDataSource,UICollectionViewDelegate{
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return arrTimeSlot.count + 1
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "TimseSlotViewCell", for: indexPath) as! TimseSlotViewCell
        cell.btnTimeSlot.tag = indexPath.row
        if indexPath.row == arrTimeSlot.count{
            if self.customTimeSlot != ""{
                if isEstimatedTime{
                    cell.lblTimeSlot.text = self.customTimeSlot
                }else{
                    cell.lblTimeSlot.text = self.customTimeSlot.changeDateFormat(fromFormat: "hh:mm a", toFormat: "HH:mm") ?? ""
                }
            }else{
                cell.lblTimeSlot.text = "Custom"
            }
        }else{
            if arrTimeSlot[indexPath.row] == "ASAP"{
                cell.lblTimeSlot.text = "ASAP"
            }else{
                if isDelayTime || isEstimatedTime{
                    cell.lblTimeSlot.text = arrTimeSlot[indexPath.row]
                }else{
                    cell.lblTimeSlot.text = arrTimeSlot[indexPath.row].changeDateFormat(fromFormat: "hh:mm a", toFormat: "HH:mm") ?? ""
                }
            }
        }
        cell.lblTimeSlot.superview?.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
        if selectedTimeSlot != nil{
            if selectedTimeSlot == "ASAP" && indexPath.row == 0{
                cell.lblTimeSlot.superview?.backgroundColor = AppConstants.Colors.kAppThemeDarkAquaColor
            }else{
                if isDelayTime || isEstimatedTime{
                    if selectedTimeSlot! == cell.lblTimeSlot.text ?? ""{
                        cell.lblTimeSlot.superview?.backgroundColor = AppConstants.Colors.kAppThemeDarkAquaColor
                    }
                }else{
                    if selectedTimeSlot!.changeDateFormat(fromFormat: "hh:mm a", toFormat: "HH:mm") ?? "" == cell.lblTimeSlot.text ?? ""{
                        cell.lblTimeSlot.superview?.backgroundColor = AppConstants.Colors.kAppThemeDarkAquaColor
                    }
                }
            }
        }
        return cell
    }
}

//MARK: UITableViewDataSource
extension SelectTimeSlotVC:UITableViewDataSource,UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if orderDetails == nil{
            return 0
        }
        return arrCarts.count+1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if indexPath.row == arrCarts.count{
            let cell = tableView.dequeueReusableCell(withIdentifier: "OrderPriceInfoCell", for: indexPath) as! OrderPriceInfoCell
            
            let method = orderDetails.paymentMethod ?? ""
            cell.lblPaymentMode.textColor = AppConstants.Colors.kAppDarkGreenColor
            if method.lowercased() == "stripe"{
                cell.lblPaymentMode.text = "Paid via Credit/Debit card"
            }else if method.lowercased() == "cod"{
                cell.lblPaymentMode.textColor = AppConstants.Colors.kAppThemeRedColor
                cell.lblPaymentMode.text = (orderDetails.orderType ?? "").lowercased() == "dine in" ? "Due to be paid at restaurant" : "Cash on \(orderDetails.displayOrderType)"
            }else if method.lowercased() == "wallet"{
                cell.lblPaymentMode.text = "Paid via TiffinTom Credit"
            }else{
                cell.lblPaymentMode.text = "Paid via \(method.capitalized)"
            }
            cell.arrSurcharge = orderDetails.surcharges
            cell.tblSurcharge.reloadData()
            cell.constSurchargeHeight.constant = CGFloat(orderDetails.surcharges.count) * 30
            let walletAmt = orderDetails.walletAmount ?? 0
            if walletAmt != 0{
                cell.lblWalletAmount.superview?.isHidden = false
                cell.lblWalletAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign,walletAmt)
                if method.lowercased() == "cod" && ((orderDetails.orderType ?? "").lowercased() == "dine in"){
                    cell.lblPaymentMode.text = "TiffinTom Credit + \(cell.lblPaymentMode.text ?? "")"
                }else{
                    cell.lblPaymentMode.text = "\(cell.lblPaymentMode.text ?? "") + TiffinTom Credit"
                }
            }else{
                cell.lblWalletAmount.superview?.isHidden = true
            }
            cell.lblSubTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign,orderDetails.subTotal ?? 0)
            if orderDetails.driverTip ?? 0 == 0{
                cell.lblDriverTip.superview!.isHidden = true
            }else{
                cell.lblDriverTip.superview!.isHidden = false
                cell.lblDriverTip.text = String.init(format: "%@%.2f", AppConstants.currencySign,orderDetails.driverTip ?? 0)
            }
            if orderDetails.serviceCharge ?? 0 == 0{
                cell.lblServiceFee.superview!.isHidden = true
            }else{
                cell.lblServiceFee.superview!.isHidden = false
                cell.lblServiceFee.text = String.init(format: "%@%.2f", AppConstants.currencySign,orderDetails.serviceCharge ?? 0)
            }
            if orderDetails.deliveryFee ?? 0 == 0{
                cell.lblDeliveryFee.superview!.isHidden = true
            }else{
                cell.lblDeliveryFee.superview!.isHidden = false
                cell.lblDeliveryFee.text = String.init(format: "%@%.2f", AppConstants.currencySign,orderDetails.deliveryFee ?? 0)
            }
            if orderDetails.offerPrice ?? 0 == 0 && orderDetails.voucherAmount ?? 0 == 0{
                cell.lblDiscount.superview!.isHidden = true
            }else{
                if orderDetails.offerPrice ?? 0 != 0{
                    if let pcerntage = orderDetails.offerPercentage, pcerntage != 0{
                        cell.lblDiscountTitle.text = String.init(format: "Offer Applied (%.0f%@ Off)", pcerntage, "%")
                    }
                    cell.lblDiscount.text = String.init(format: "-%@%.2f", AppConstants.currencySign,orderDetails.offerPrice ?? 0)

                }else if orderDetails.voucherAmount ?? 0 != 0{
                    cell.lblDiscount.text = String.init(format: "-%@%.2f", AppConstants.currencySign,orderDetails.voucherAmount ?? 0)
                }
                cell.lblDiscount.superview!.isHidden = false
            }
            let reward = orderDetails.rewardOffer ?? 0
            if reward != 0{
                cell.lblRewardDiscount.text = String.init(format: "-%@%.2f", AppConstants.currencySign,reward)
                cell.lblRewardDiscount.superview?.isHidden = false
            }else{
                cell.lblRewardDiscount.superview?.isHidden = true
            }
            let charity = orderDetails.charity ?? 0
            if charity != 0{
                cell.lblCharity.text = String.init(format: "%@%.2f", AppConstants.currencySign,charity)
                cell.lblCharity.superview?.isHidden = false
            }else{
                cell.lblCharity.superview?.isHidden = true
            }
            if orderDetails.cardView?.cardNo ?? "" != ""{
                cell.lblCardNo.text = "**** \(orderDetails.cardView?.cardNo ?? "")"
            }
            cell.lblTotalPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, (orderDetails.orderGrandTotal ?? 0) + charity)
            let tax = orderDetails.taxAmount ?? 0
            if tax != 0{
                cell.lblRestaurantTax.text = String.init(format: "%@%.2f", AppConstants.currencySign,tax)
                cell.lblRestaurantTax.superview?.isHidden = false
            }else{
                cell.lblRestaurantTax.superview?.isHidden = true
            }
            return cell
        }
        let cell = tableView.dequeueReusableCell(withIdentifier: "CartViewCell", for: indexPath) as! CartViewCell
        let cart = arrCarts[indexPath.row]
        cell.lblItemName.text = cart.menuName ?? ""
        let price = cart.totalPrice ?? 0
        if price == 0{
            cell.lblItemPrice.text = "Free"
        }else{
            cell.lblItemPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign,price)
        }
        cell.lblItemQuantity.text = "\(cart.quantity ?? 0)x"
        cell.lblAddons.text = cart.subAddonsName ?? ""
        return cell
    }
}
