//
//  CategoriesVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 31/03/21.
//

import UIKit
protocol CategoryDelegate: AnyObject {
    func categoryUpdated()
    func deleteCategory()
}

class CategoryViewCell: UITableViewCell {
    
    @IBOutlet weak var lblProductName:UILabel!
    @IBOutlet weak var lblCategoryName:UILabel!
    @IBOutlet weak var lblStatus:UILabel!
    @IBOutlet weak var btnAssign:UIButton!
    @IBOutlet weak var btnExpandChild:UIButton!
    @IBOutlet weak var switchEnable:UISwitch!
    
    override class func awakeFromNib() {
        
    }
}

class CategoriesVC: UIViewController {

    //MARK: IBOutlet Instances
    @IBOutlet weak var tblCategories:UITableView!
    
    //MARK: Other Instances
    var arrCategories = [OnlineCategoryModel]()
    var selectedRow = -1
    var parentVC:SideMenuVC!
    
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        CallGetCategory()
    }
    
    //MARK:  ViewController Instance
    static func addToParentView(parentVC:SideMenuVC)->CategoriesVC?{
        guard let VC = UIStoryboard.init(name: "Menus", bundle: nil).instantiateViewController(withIdentifier: "EPOSProductsVC") as? CategoriesVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    @IBAction func btnAddMoreAction(_ sender:UIButton){
        selectedRow = -1
//        if let VC = AddCategoryVC.showPopup(parentVC: self){
//            VC.delegate = self
//        }
    }
    
    @IBAction func switchEnableChangedAction(_ sender:UISwitch){
        let dictParam = [String:Any]()
        var strURL = "\(AppConstants.APIURL.kOnlineCategories)\(arrCategories[sender.tag].id ?? 0)/disable"
        if sender.isOn{
            strURL = "\(AppConstants.APIURL.kOnlineCategories)\(arrCategories[sender.tag].id ?? 0)/enable"
        }
        arrCategories[sender.tag].status = sender.isOn ? 1 : 0
        self.tblCategories.reloadData()
        WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST", isRestaurantAPI: true) { (message, response) in
            
        }
    }
    
    func CallDeleteCateogry(){
        let dictParam = [String:Any]()
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kOnlineCategories)\(arrCategories[selectedRow].id ?? 0)", method: "DELETE", isRestaurantAPI: true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let result = response as? NSDictionary, let data = AppCommonMethods.convertToJson(object: result), let _ = try? jsonDecoder.decode(OnlineCategoryModel.self, from: data){
                    self.arrCategories.remove(at: self.selectedRow)
                    self.tblCategories.reloadData()
                    var settings = BottomAlertSettings()
                    settings.strMessage = "Category has been deleted successfully"
                    AppValidation().showBottomAlertView(settings: settings)
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func CallGetCategory(){
        var dictParam = [String:Any]()
        dictParam["restaurant_id"] = AppConstants.webResId ?? ""
        dictParam["nopaginate"] = "1"
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kOnlineCategories, method: "GET", isRestaurantAPI: true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                self.arrCategories.removeAll()
                if let result = response as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: result), let aData = try? jsonDecoder.decode([OnlineCategoryModel].self, from: data){
                    self.arrCategories = aData
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "No categories found", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
                self.tblCategories.reloadData()
            }
        }
    }
}

extension CategoriesVC:UITableViewDelegate,UITableViewDataSource{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrCategories.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "CategoryViewCell", for: indexPath) as! CategoryViewCell
        cell.switchEnable.tag = indexPath.row
        let model = arrCategories[indexPath.row]
        cell.lblCategoryName.text = model.name ?? ""
        if model.status ?? 0 == 1{
            cell.switchEnable.isOn = true
            cell.lblStatus.text = "Active"
            cell.lblStatus.textColor = AppConstants.Colors.kAppDarkGreenColor
        }else{
            cell.switchEnable.isOn = false
            cell.lblStatus.text = "Inactive"
            cell.lblStatus.textColor = AppConstants.Colors.kAppThemeRedColor
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        selectedRow = indexPath.row
//        if let VC = AddCategoryVC.showPopup(parentVC: self,category: arrCategories[indexPath.row]){
//            VC.delegate = self
//        }
    }
}

extension CategoriesVC:CategoryDelegate{
    func categoryUpdated() {
        CallGetCategory()
    }
    
    func deleteCategory(){
        var settings = AlertSetting()
        settings.alertMessage = "Please enter your password to delete category"
        settings.alertTitle = "Delete category"
        settings.type = .kEnterAdminPassword
        settings.textPlcaeholder = "password"
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        if let VC = AlertViewController.showPopup(parentVC: self, setting: settings){
            VC.delegate = self
        }
    }
}

extension CategoriesVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if type == .kEnterAdminPassword{
            CallDeleteCateogry()
        }
    }
}
