//
//  CategoriesVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 31/03/21.
//

import UIKit

protocol AddOnsDelegate: AnyObject {
    func addOnUpdated()
    func deleteAddOn()
}

class EPOSCategoryVC: UIViewController {
    
    //MARK: IBOutlet Instances
    @IBOutlet weak var tblCategories:UITableView!
    @IBOutlet weak var lblViewTitle:UILabel!
    
    //MARK: Other Instances
    var arrEPOSCategories = [CategoryModel]()
    var arrSelectedCategories = [CategoryModel]()
    var arrEPOSAddons = [AddOnModel]()
    var arrSelectedAddons = [AddOnModel]()
    var isCategoryPage = true
    var parentVC:SideMenuVC!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        if isCategoryPage{
            CallGetCategory()
        }else{
            CallGetAddons()
            lblViewTitle.text = "Addons"
        }
    }
    
    //MARK:  ViewController Instance
    static func addToParentView(parentVC:SideMenuVC, isCategoryPage:Bool = true)->EPOSCategoryVC?{
        guard let VC = UIStoryboard.init(name: "Menus", bundle: nil).instantiateViewController(withIdentifier: "EPOSCategoryVC") as? EPOSCategoryVC else {
            return nil
        }
        VC.isCategoryPage = isCategoryPage
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: General methods
    
    @IBAction func btnAddMoreAction(_ sender:UIButton){
        self.view.endEditing(true)
//        if isCategoryPage{
//            if let VC = AddEPOSCategoryVC.instance(categories: self.arrEPOSCategories){
//                if let controller = (VC.childViewController as! UINavigationController).viewControllers.first as? AddEPOSCategoryVC{
//                    controller.delegate = self
//                }
//                self.present(VC, animated: true)
//            }
//        }else{
//            if let VC = AddEPOSAddOnVC.instance(addons: arrEPOSAddons){
//                if let controller = (VC.childViewController as! UINavigationController).viewControllers.first as? AddEPOSAddOnVC{
//                    controller.delegate = self
//                }
//                self.present(VC, animated: true)
//            }
//        }
    }
    
    @IBAction func btnExpandCategoryAction(_ sender:UIButton){
        self.view.endEditing(true)
        if isCategoryPage{
            let category = arrEPOSCategories[sender.tag]
            let index = arrSelectedCategories.firstIndex { model in
                return model.id ?? 0 == category.id ?? 0
            }
            if index != nil{
                arrSelectedCategories.remove(at: index!)
            }else{
                arrSelectedCategories.append(category)
            }
        }else{
            let addon = arrEPOSAddons[sender.tag]
            let index = arrSelectedAddons.firstIndex { model in
                return model.id ?? 0 == addon.id ?? 0
            }
            if index != nil{
                arrSelectedAddons.remove(at: index!)
            }else{
                arrSelectedAddons.append(addon)
            }
        }
        self.tblCategories.reloadData()
    }
    
    @IBAction func switchCategoryChanges(_ sender:UISwitch){
        self.view.endEditing(true)
        var strURL = ""
        let row = Int(sender.accessibilityIdentifier ?? "") ?? 0
        if isCategoryPage{
            var category = self.arrEPOSCategories[sender.tag]
            if row != 0{
                category = category.arrChildCategory![row-1]
            }
            strURL = "\(AppConstants.APIURL.kCategoryList)\(category.id ?? 0)/disable"
            if !sender.isOn{
                category.disabled = 1
            }else{
                category.disabled = 0
                strURL = "\(AppConstants.APIURL.kCategoryList)\(category.id ?? 0)/enable"
            }
        }else{
            var addon = self.arrEPOSAddons[sender.tag]
            if row != 0{
                addon = addon.addon![row-1]
            }
            strURL = "\(AppConstants.APIURL.kAddOnsList)\(addon.id ?? 0)/disable"
            if !sender.isOn{
                addon.disabled = 1
            }else{
                addon.disabled = 0
                strURL = "\(AppConstants.APIURL.kAddOnsList)\(addon.id ?? 0)/enable"
            }
            
        }
        self.tblCategories.reloadData()
        let dictParam = [String:Any]()
        WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST") { (message, response) in
            
        }
    }
    
    func CallGetCategory(){
        var dictParam = [String:Any]()
        dictParam["nopaginate"] = "1"
        dictParam["prefilled"] = "1"
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kCategoryList, method: "GET") { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                self.arrEPOSCategories = [CategoryModel]()
                if let result = response as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: result), let aData = try? jsonDecoder.decode([CategoryModel].self, from: data){
                    self.arrEPOSCategories = aData
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "No categories found", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
                self.tblCategories.reloadData()
            }
        }
    }
    
    func CallGetAddons(){
        var dictParam = [String:Any]()
        dictParam["nopaginate"] = "1"
        dictParam["prefilled"] = "1"
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kAddOnsList, method: "GET") { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                self.arrEPOSAddons = [AddOnModel]()
                if let result = response as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: result), let aData = try? jsonDecoder.decode([AddOnModel].self, from: data){
                    self.arrEPOSAddons = aData
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "No addons found", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
                self.tblCategories.reloadData()
            }
        }
    }
}

extension EPOSCategoryVC:UITableViewDelegate,UITableViewDataSource{
    func numberOfSections(in tableView: UITableView) -> Int {
        return isCategoryPage ?  arrEPOSCategories.count : arrEPOSAddons.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if isCategoryPage{
            let category = arrEPOSCategories[section]
            if arrSelectedCategories.contains(where: { model in
                return model.id ?? 0 == category.id ?? 0
            }){
                return (arrEPOSCategories[section].arrChildCategory?.count ?? 0) + 1
            }
        }else{
            let addon = arrEPOSAddons[section]
            if arrSelectedAddons.contains(where: { model in
                return model.id ?? 0 == addon.id ?? 0
            }){
                return (arrEPOSAddons[section].addon?.count ?? 0) + 1
            }
        }
        return 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if isCategoryPage{
            if indexPath.row == 0{
                let model = arrEPOSCategories[indexPath.section]
                var identifier = "CategoryViewCell"
                if model.arrChildCategory?.count ?? 0 > 0{
                    identifier = "ParentCategoryViewCell"
                }
                let cell = tableView.dequeueReusableCell(withIdentifier: identifier, for: indexPath) as! CategoryViewCell
                cell.lblCategoryName.text = model.name ?? ""
                cell.switchEnable.tag = indexPath.section
                cell.switchEnable.accessibilityIdentifier = "\(indexPath.row)"
                if model.disabled ?? 0 == 0{
                    cell.lblStatus.text = "Active"
                    cell.switchEnable.isOn = true
                    cell.lblStatus.textColor = AppConstants.Colors.kAppDarkGreenColor
                }else{
                    cell.lblStatus.text = "Inactive"
                    cell.switchEnable.isOn = false
                    cell.lblStatus.textColor = AppConstants.Colors.kAppThemeRedColor
                }
                cell.btnExpandChild?.tag = indexPath.section
                if arrSelectedCategories.contains(where: { category in
                    return model.id ?? 0 == category.id ?? 0
                }){
                    cell.btnExpandChild?.isSelected = true
                }else{
                    cell.btnExpandChild?.isSelected = false
                }
                return cell
            }
            let cell = tableView.dequeueReusableCell(withIdentifier: "ChildCategoryViewCell", for: indexPath) as! CategoryViewCell
            cell.switchEnable.accessibilityIdentifier = "\(indexPath.row)"
            cell.switchEnable.tag = indexPath.section
            let model = arrEPOSCategories[indexPath.section].arrChildCategory![indexPath.row-1]
            cell.lblCategoryName.text = model.name ?? ""
            if model.disabled ?? 0 == 0{
                cell.lblStatus.text = "Active"
                cell.switchEnable.isOn = true
                cell.lblStatus.textColor = AppConstants.Colors.kAppDarkGreenColor
            }else{
                cell.lblStatus.text = "Inactive"
                cell.switchEnable.isOn = false
                cell.lblStatus.textColor = AppConstants.Colors.kAppThemeRedColor
            }
            return cell
        }else{
            if indexPath.row == 0{
                let model = arrEPOSAddons[indexPath.section]
                var identifier = "CategoryViewCell"
                if model.addon?.count ?? 0 > 0{
                    identifier = "ParentCategoryViewCell"
                }
                let cell = tableView.dequeueReusableCell(withIdentifier: identifier, for: indexPath) as! CategoryViewCell
                cell.lblCategoryName.text = model.name ?? ""
                cell.switchEnable.tag = indexPath.section
                cell.switchEnable.accessibilityIdentifier = "\(indexPath.row)"
                if model.disabled ?? 0 == 0{
                    cell.lblStatus.text = "Active"
                    cell.switchEnable.isOn = true
                    cell.lblStatus.textColor = AppConstants.Colors.kAppDarkGreenColor
                }else{
                    cell.lblStatus.text = "Inactive"
                    cell.switchEnable.isOn = false
                    cell.lblStatus.textColor = AppConstants.Colors.kAppThemeRedColor
                }
                cell.btnExpandChild?.tag = indexPath.section
                if arrSelectedAddons.contains(where: { addon in
                    return model.id ?? 0 == addon.id ?? 0
                }){
                    cell.btnExpandChild?.isSelected = true
                }else{
                    cell.btnExpandChild?.isSelected = false
                }
                return cell
            }
            let cell = tableView.dequeueReusableCell(withIdentifier: "ChildCategoryViewCell", for: indexPath) as! CategoryViewCell
            cell.switchEnable.accessibilityIdentifier = "\(indexPath.row)"
            cell.switchEnable.tag = indexPath.section
            let model = arrEPOSAddons[indexPath.section].addon![indexPath.row-1]
            cell.lblCategoryName.text = model.name ?? ""
            if model.disabled ?? 0 == 0{
                cell.lblStatus.text = "Active"
                cell.switchEnable.isOn = true
                cell.lblStatus.textColor = AppConstants.Colors.kAppDarkGreenColor
            }else{
                cell.lblStatus.text = "Inactive"
                cell.switchEnable.isOn = false
                cell.lblStatus.textColor = AppConstants.Colors.kAppThemeRedColor
            }
            return cell
        }
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        self.view.endEditing(true)
        if isCategoryPage{
            var category = arrEPOSCategories[indexPath.section]
            if indexPath.row != 0{
                category = arrEPOSCategories[indexPath.section].arrChildCategory![indexPath.row-1]
            }
//            if let VC = AddEPOSCategoryVC.instance(categories: self.arrEPOSCategories, category: category){
//                if let controller = (VC.childViewController as! UINavigationController).viewControllers.first as? AddEPOSCategoryVC{
//                    controller.delegate = self
//                }
//                self.present(VC, animated: true)
//            }
        }else{
            var addon = arrEPOSAddons[indexPath.section]
            if indexPath.row != 0{
                addon = arrEPOSAddons[indexPath.section].addon![indexPath.row-1]
            }
//            if let VC = AddEPOSAddOnVC.instance(addons: arrEPOSAddons, addon: addon){
//                if let controller = (VC.childViewController as! UINavigationController).viewControllers.first as? AddEPOSAddOnVC{
//                    controller.delegate = self
//                }
//                self.present(VC, animated: true)
//            }
        }
    }
}

extension EPOSCategoryVC:CategoryDelegate{
    func categoryUpdated() {
        CallGetCategory()
    }
    
    func deleteCategory(){
    }
}

extension EPOSCategoryVC:AddOnsDelegate{
    func addOnUpdated() {
        self.CallGetAddons()
    }
    
    func deleteAddOn() {
    }
}
