//
//  MenuViewController.swift
//  EPOS
//
//  Created by Tushar Premal on 14/11/22.
//

import UIKit

enum MenuViewType {
    case kMenu
    case kEPOSMenu
    case kOnlineMenu
}

class MenuViewController: UIViewController {

    @IBOutlet weak var lblViewTitle:UILabel!
    @IBOutlet weak var viewForIngriedent:UIView!
    @IBOutlet weak var viewForProduct:UIView!
    @IBOutlet weak var viewForCategory:UIView!
    @IBOutlet weak var viewForAddon:UIView!
    @IBOutlet weak var viewForOnlineMenu:UIView!
    @IBOutlet weak var viewForEPOSMenu:UIView!
    
    var viewType = MenuViewType.kMenu
    var parentVC:SideMenuVC!
    
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        if viewType == .kEPOSMenu{
            viewForIngriedent.isHidden = false
            viewForProduct.isHidden = false
            viewForCategory.isHidden = false
            viewForAddon.isHidden = false
            lblViewTitle.text = "EPOS Menu"
        }else if viewType == .kOnlineMenu{
            lblViewTitle.text = "Online Menu"
            viewForProduct.isHidden = false
            viewForCategory.isHidden = false
            viewForAddon.isHidden = false
        }else{
            viewForEPOSMenu.isHidden = false
            viewForOnlineMenu.isHidden = false
        }
    }
    
    //MARK:  ViewController Instance
    static func addToParentView(parentVC:SideMenuVC, viewType:MenuViewType = .kMenu)->MenuViewController?{
        guard let VC = UIStoryboard.init(name: "Menus", bundle: nil).instantiateViewController(withIdentifier: "MenuViewController") as? MenuViewController else {
            return nil
        }
        VC.viewType = viewType
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    @IBAction func btnMenuAction(_ sender:UIButton){
        if let _ = MenuViewController.addToParentView(parentVC: self.parentVC, viewType: sender.tag == 0 ? .kOnlineMenu : .kEPOSMenu){
            
        }
    }
    
    @IBAction func btnCategoriesAction(_ sender:UIButton){
        if viewType == .kEPOSMenu{
            if let _ = EPOSCategoryVC.addToParentView(parentVC: self.parentVC){
                
            }
        }else{
            if let _ = CategoriesVC.addToParentView(parentVC: self.parentVC){
                
            }
        }
    }
    
    @IBAction func btnProductsAction(_ sender:UIButton){
        if viewType == .kEPOSMenu{
//            if let VC = EPOSProductsVC.instance(){
//                self.navigationController?.pushViewController(VC, animated: true)
//            }
        }else{
//            if let VC = ProductsVC.instance(){
//                self.navigationController?.pushViewController(VC, animated: true)
//            }
        }
    }
    
    @IBAction func btnAddOnsAction(_ sender:UIButton){
        if viewType == .kEPOSMenu{
            if let _ = EPOSCategoryVC.addToParentView(parentVC: self.parentVC, isCategoryPage: false){
                
            }
        }else{
//            if let VC = ProductsVC.instance(){
//                VC.isProductView = false
//                self.navigationController?.pushViewController(VC, animated: true)
//            }
        }
    }
    
    @IBAction func btnIngreidentAction(_ sender:UIButton){
//        if let VC = EPOSProductsVC.instance(){
//            VC.viewType = .kIngredient
//            self.navigationController?.pushViewController(VC, animated: true)
//        }
    }
}
