//
//  AddOnsVC.swift
//  EPOS
//
//  Created by Apple on 14/04/21.
//

import UIKit

class AddOnTheme2VC: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var collectionAddOns:UICollectionView!
    @IBOutlet weak var lblAddons:UILabel!
    @IBOutlet weak var lblAddonsLine:UILabel!
    @IBOutlet weak var btnAdd:UIButton!
    @IBOutlet weak var lblIngriedents:UILabel!
    @IBOutlet weak var lblIngriedentLine:UILabel!
    @IBOutlet weak var lblInstuctions:UILabel!
    @IBOutlet weak var lblInstuctionsLine:UILabel!
    @IBOutlet weak var lblProductDesc:UILabel!
    @IBOutlet weak var lblProductName:UILabel!
    @IBOutlet weak var lblProductPrice:UILabel!
    @IBOutlet weak var txtProductquantity:UITextField!
    @IBOutlet weak var txtProductModified:UITextField!
    @IBOutlet weak var imgProduct:UIImageView!
    @IBOutlet weak var lblNoModifyItem:UILabel!
    @IBOutlet weak var txtInstructionPrice:UITextField!
    @IBOutlet weak var txtInstruction:UITextView!
    @IBOutlet weak var viewForInstruction:UIView!
    @IBOutlet weak var btnBack:UIButton!
    @IBOutlet weak var tblAddons:UITableView!
    
    //MARK:  Instances
    var arrAddOns = [AddOnModel]()
    var arrSelectedAddOns = [OrderAddOnModel]()
    var arrSubAddOns = [AddOnModel]()
    var selectedProduct = ProductModel()
    var orderType:OrderTypesModel!
    var selectedAddonIndex = 0
    weak var delegate:ProductDelegate?
    var isBanquetOrder = false
    var productQty = 1
    var itemModify = 1
    var arrIngredients = [IngredientModel]()
    var arrSelectedIngredients = [OrderIngredientModel]()
    var parentVC:CreateOrderVC!
    var productIndex:Int?
    var selectedOrderProduct:OrderProductModel?
    var selectedViewIndex = 0
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        selectedAddonIndex = 0
        txtInstructionPrice.text = "0.00"
        setProductData()
        if selectedOrderProduct == nil{
            if selectedProduct.totalAddOn ?? 0 > 0 && AppConstants.userData?.permissions?.addons?.actions?.list ?? 0 == 1 && selectedProduct.autoAddon ?? 0 == 1{
                if arrIngredients.count == 0 || AppConstants.userData?.permissions?.modify?.actions?.list ?? 0 == 0 || selectedProduct.autoModify ?? 0 == 0{
                    lblIngriedents.superview?.isHidden = true
                }
            }else{
                lblAddons.superview?.isHidden = true
                selectedViewIndex = 1
            }
        }else{
            if selectedOrderProduct!.product?.totalAddOn ?? 0 > 0 && AppConstants.userData?.permissions?.addons?.actions?.list ?? 0 == 1{
                if arrIngredients.count == 0 || AppConstants.userData?.permissions?.modify?.actions?.list ?? 0 == 0{
                    lblIngriedents.superview?.isHidden = true
                }
            }else{
                lblAddons.superview?.isHidden = true
                selectedViewIndex = 1
            }
        }
        setTabView()
    }
    
    //MARK: create viewcontroller instance
    static func addToChildView(parentVC:CreateOrderVC, index:Int? = nil, orderType:OrderTypesModel, product:ProductModel = ProductModel(), isBanquetOrder:Bool, orderProduct:OrderProductModel? = nil)->AddOnTheme2VC?{
        guard let VC = UIStoryboard.init(name: "Orders", bundle: nil).instantiateViewController(withIdentifier: "AddOnTheme2VC") as? AddOnTheme2VC else{
            return nil
        }
        VC.productIndex = index
        VC.selectedOrderProduct = orderProduct
        VC.orderType = orderType
        VC.selectedProduct = AppCommonMethods.Copy(of: product) ?? product
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK:  General Methods
    func setProductData(){
        if selectedOrderProduct != nil{
            arrIngredients = CoreDataHelper.shared.fetchIngredientData(productId: self.selectedOrderProduct!.prodcutId ?? 0)
            arrSelectedAddOns = selectedOrderProduct!.arrAddons
            self.lblProductName.text = selectedOrderProduct!.productName ?? ""
            if selectedOrderProduct!.product?.description ?? "" == ""{
                self.lblProductDesc.isHidden = true
            }else{
                self.lblProductDesc.isHidden = false
                self.lblProductDesc.text = selectedOrderProduct!.product?.description ?? ""
            }
            self.lblProductPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign,selectedOrderProduct!.price ?? 0)
            self.txtInstruction.text = selectedOrderProduct?.specialInstruction ?? ""
            txtInstructionPrice.text = String.init(format: "%.2f", selectedOrderProduct?.instructionPrice ?? 0)
            itemModify = selectedOrderProduct!.quantity ?? 0
            productQty = selectedOrderProduct!.quantity ?? 0
            arrSelectedIngredients = selectedOrderProduct!.arrIngriedent
            txtProductModified.text = "\(itemModify)"
            imgProduct.superview?.isHidden = true
            if selectedOrderProduct!.product?.imageUrl ?? "" != "" && AppCommonMethods.fetchSiteSettingValue(key: "product_image_visible") ?? "" == "yes"{
                if let _ = URL.init(string: selectedOrderProduct!.product?.imageUrl ?? ""){
                    imgProduct.superview?.isHidden = false
                    imgProduct.SetImageFromURL(strURL: selectedOrderProduct!.product?.imageUrl ?? "")
                }
            }
            txtProductquantity.text = "\(productQty)"
            arrAddOns = CoreDataHelper.shared.fetchAddOnData(productId: self.selectedOrderProduct!.prodcutId ?? 0).filter{ $0.children?.count ?? 0 > 0 }
            arrSubAddOns = arrAddOns.first?.children ?? [AddOnModel]()
            arrAddOns.forEach { (addon1) in
                var totalCount = 0
                addon1.children?.forEach { (addon2) in
                    let index = self.arrSelectedAddOns.firstIndex { (addon3) -> Bool in
                        return addon3.AddonId ?? 0 == addon2.id ?? 0
                    }
                    if index != nil{
                        totalCount += (self.arrSelectedAddOns[index!].quantity)
                    }
                }
                addon1.selectedAddonCount = totalCount
            }
        }else{
            arrAddOns = CoreDataHelper.shared.fetchAddOnData(productId: self.selectedProduct.id ?? 0).filter{ $0.children?.count ?? 0 > 0 }
            arrSubAddOns = arrAddOns.first?.children ?? [AddOnModel]()
            if selectedProduct.description ?? "" == ""{
                self.lblProductDesc.isHidden = true
            }else{
                self.lblProductDesc.isHidden = false
                self.lblProductDesc.text = selectedProduct.description ?? ""
            }
            self.lblProductName.text = selectedProduct.name ?? ""
            if isBanquetOrder{
                lblProductPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedProduct.waitingPrice ?? 0)
            }else{
                if self.orderType.id ?? 0 == 3{
                    lblProductPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedProduct.deliveryPrice ?? 0)
                }else if self.orderType.id ?? 0 == 2 || self.orderType.id ?? 0 == 5{
                    lblProductPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedProduct.takeawayPrice ?? 0)
                }else{
                    lblProductPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedProduct.price ?? 0)
                }
            }
            txtProductquantity.text = "\(productQty)"
            imgProduct.superview?.isHidden = true
            if selectedProduct.imageUrl ?? "" != "" && AppCommonMethods.fetchSiteSettingValue(key: "product_image_visible") ?? "" == "yes"{
                if let _ = URL.init(string: selectedProduct.imageUrl ?? ""){
                    imgProduct.superview?.isHidden = false
                    imgProduct.SetImageFromURL(strURL: selectedProduct.imageUrl ?? "")
                }
            }
            
            arrIngredients = CoreDataHelper.shared.fetchIngredientData(productId: self.selectedProduct.id ?? 0)
        }
    }
    
    func removeChildAddOn(addon:AddOnModel){
        if addon.children != nil{
            addon.children!.forEach { (model) in
                let index = arrSelectedAddOns.firstIndex { (subAddon) -> Bool in
                    return model.id ?? 0 == subAddon.AddonId ?? 0
                }
                if index != nil{
                    arrSelectedAddOns.remove(at: index!)
                }
                removeChildAddOn(addon: model)
            }
        }
    }
    
    func setTabView(){
        viewForInstruction.isHidden = true
        collectionAddOns.superview?.isHidden = false
        lblAddons.textColor = AppConstants.Colors.kAppLightGrayColor
        lblAddonsLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblIngriedents.textColor = AppConstants.Colors.kAppLightGrayColor
        lblIngriedentLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblInstuctions.textColor = AppConstants.Colors.kAppLightGrayColor
        lblInstuctionsLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        if selectedViewIndex == 0{
            lblAddons.textColor = AppConstants.Colors.kAppThemeTextColor
            lblAddonsLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            lblNoModifyItem.text = ""
            selectedAddonIndex = 0
            let addon = arrAddOns[selectedAddonIndex]
            if addon.children != nil{
                arrSubAddOns = addon.children!
            }
            self.btnAdd.isSelected = false
        }else if selectedViewIndex == 1{
            if arrIngredients.count == 0{
                lblNoModifyItem.text = "\n\n\nTheres are no ingredients available for\nselected product to modify"
            }else{
                lblNoModifyItem.text = "Add or remove ingredients"
            }
            lblIngriedents.textColor = AppConstants.Colors.kAppThemeTextColor
            lblIngriedentLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnAdd.isSelected = true
        }else{
            collectionAddOns.superview?.isHidden = true
            viewForInstruction.isHidden = false
            lblInstuctions.textColor = AppConstants.Colors.kAppThemeTextColor
            lblInstuctionsLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnAdd.isSelected = true
        }
        self.btnBack.isHidden = true
        self.tblAddons.reloadData()
        self.collectionAddOns.reloadData()
    }
    
    func checkforRequiredAddon()->Bool{
        if let max = arrAddOns[selectedAddonIndex].maxQuantity{
            if arrAddOns[selectedAddonIndex].selectedAddonCount >= max{
                return true
            }
        }
        if arrAddOns[selectedAddonIndex].selectedAddonCount >= arrAddOns[selectedAddonIndex].children?.count ?? 0{
            return true
        }
        return false
    }
    
    func createOrderIngridentModel(ingrident:IngredientModel, with:Int, without:Int)->OrderIngredientModel?{
        let dictAddon = NSMutableDictionary()
        dictAddon["product_ingredient_id"] = "\(ingrident.id ?? 0)"
        dictAddon["with"] = with
        dictAddon["id"] = Date().millisecondsSince1970
        dictAddon["without"] = without
        dictAddon["quantity"] = 1
        dictAddon["ingredient_name"] = ingrident.name ?? ""
        dictAddon["updater_id"] = AppConstants.userData?.id ?? 0
        if with == 1{
            dictAddon["price"] = "\(ingrident.price ?? 0)"
            dictAddon["total"] = "\(ingrident.price ?? 0)"
        }else{
            dictAddon["price"] = "\(ingrident.priceWithout ?? 0)"
            dictAddon["total"] = "\(ingrident.priceWithout ?? 0)"
        }
        
        let jsonDecoder = JSONDecoder()
        if let data = AppCommonMethods.convertToJson(object: dictAddon), let aData = try? jsonDecoder.decode(OrderIngredientModel.self, from: data){
            aData.isNewOrder = 1
            return aData
        }
        return nil
    }
    
    func createOrderAddonModel(addon:AddOnModel)->OrderAddOnModel?{
        let dictAddon = NSMutableDictionary()
        dictAddon["id"] = addon.addOnId ?? Date().millisecondsSince1970
        dictAddon["addon_id"] = "\(addon.id ?? 0)"
        dictAddon["addon_name"] = addon.name ?? ""
        dictAddon["updater_id"] = AppConstants.userData?.id ?? 0
        if isBanquetOrder{
            dictAddon["total"] = "\(addon.waitingPrice ?? 0)"
            dictAddon["price"] = "\(addon.waitingPrice ?? 0)"
        }else{
            if orderType.id ?? 0 == 3{
                dictAddon["total"] = "\(addon.deliveryPrice ?? 0)"
                dictAddon["price"] = "\(addon.deliveryPrice ?? 0)"
            }else if orderType.id ?? 0 == 2 || orderType.id ?? 0 == 5{
                dictAddon["total"] = "\(addon.takeawayPrice ?? 0)"
                dictAddon["price"] = "\(addon.takeawayPrice ?? 0)"
            }else{
                dictAddon["total"] = "\(addon.price ?? 0)"
                dictAddon["price"] = "\(addon.price ?? 0)"
            }
        }
        dictAddon["quantity"] = addon.quantity
        
        let jsonDecoder = JSONDecoder()
        if let data = AppCommonMethods.convertToJson(object: dictAddon), let aData = try? jsonDecoder.decode(OrderAddOnModel.self, from: data){
            aData.isNewOrder = 1
            return aData
        }
        return nil
    }
    
    func createOrderPoructModel(model:ProductModel)->OrderProductModel?{
        let dictProduct = NSMutableDictionary()
        dictProduct["id"] = Date().millisecondsSince1970
        dictProduct["product_id"] = "\(model.id ?? 0)"
        dictProduct["product_name"] = model.name ?? ""
        dictProduct["quantity"] = "\(model.quantity)"
        dictProduct["special_instruction"] = ""
        dictProduct["instruction_price"] = 0
        dictProduct["updater_id"] = AppConstants.userData?.id ?? 0
        
        if isBanquetOrder{
            dictProduct["preparation_location_id"] = model.banquetPreparationLocationId ?? 0
            dictProduct["price"] = "\(model.waitingPrice ?? 0)"
            dictProduct["sub_total"] = "\(Double(model.quantity) * (model.waitingPrice ?? 0))"
        }else{
            if orderType.id ?? 0 == 2 || orderType.id ?? 0 == 5{
                dictProduct["preparation_location_id"] = model.takeawayPreparationLocationId ?? 0
                dictProduct["price"] = "\(model.takeawayPrice ?? 0)"
                dictProduct["sub_total"] = "\(Double(model.quantity) * (model.takeawayPrice ?? 0))"
            }else if orderType.id ?? 0 == 3{
                dictProduct["preparation_location_id"] = model.deliveryPreparationLocationId ?? 0
                dictProduct["price"] = "\(model.deliveryPrice ?? 0)"
                dictProduct["sub_total"] = "\(Double(model.quantity) * (model.deliveryPrice ?? 0))"
            }else{
                dictProduct["preparation_location_id"] = model.preparationLocationId ?? 0
                dictProduct["price"] = "\(model.price ?? 0)"
                dictProduct["sub_total"] = "\(Double(model.quantity) * (model.price ?? 0))"
            }
        }
        
        let jsonDecoder = JSONDecoder()
        if let data = AppCommonMethods.convertToJson(object: dictProduct), let aData = try? jsonDecoder.decode(OrderProductModel.self, from: data){
            aData.product = model
            aData.isItemUpdated = 1
            return aData
        }
        return nil
    }
    
    //MARK:  Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.parentVC.constContainerLeadingSpace.constant = AppConstants.ScreenSize.SCREEN_WIDTH
        UIView.animate(withDuration: 0.25) {
            self.parentVC.view.layoutIfNeeded()
            self.parentVC.viewForBG.alpha = 0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    @IBAction func btnBackAction(_ sender:UIButton){
        self.view.endEditing(true)
        if selectedAddonIndex > 0{
            selectedAddonIndex -= 1
            let addon = arrAddOns[selectedAddonIndex]
            if addon.children != nil{
                arrSubAddOns = addon.children!
            }else{
                arrSubAddOns.removeAll()
            }
            self.collectionAddOns.reloadData()
        }else{
            self.btnBack.isHidden = true
        }
        if selectedAddonIndex == 0{
            self.btnBack.isHidden = true
        }else{
            self.btnBack.isHidden = false
        }
        if selectedAddonIndex == arrAddOns.count-1{
            self.btnAdd.isSelected = true
        }else{
            self.btnAdd.isSelected = false
        }
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        self.view.endEditing(true)
        if selectedViewIndex == 0{
            var addon = arrAddOns[selectedAddonIndex]
            if let min = addon.minQuantity{
                if addon.selectedAddonCount < min{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "Please add minimum \(min) quantity for \(addon.name ?? "")", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                    return
                }
            }
            if selectedAddonIndex < arrAddOns.count-1{
                self.btnBack.isHidden = false
                selectedAddonIndex += 1
                addon = arrAddOns[selectedAddonIndex]
                if addon.children != nil{
                    arrSubAddOns = addon.children!
                }else{
                    arrSubAddOns.removeAll()
                }
                self.collectionAddOns.reloadData()
                if selectedAddonIndex == arrAddOns.count-1{
                    self.btnAdd.isSelected = true
                }else{
                    self.btnAdd.isSelected = false
                }
                return
            }
        }
        
        for i in 0..<arrAddOns.count{
            let addon = arrAddOns[i]
            if let min = addon.minQuantity{
                if addon.selectedAddonCount < min{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "Please add minimum \(min) quantity for \(addon.name ?? "")", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                    return
                }
            }
        }
        var orderProdcut:OrderProductModel!
        if selectedOrderProduct == nil{
            if let product = createOrderPoructModel(model: selectedProduct){
                orderProdcut = product
            }
        }else{
            orderProdcut = selectedOrderProduct!
        }
        orderProdcut.quantity = productQty
        orderProdcut.itemModified = itemModify
        orderProdcut.arrAddons = arrSelectedAddOns
        orderProdcut.specialInstruction = txtInstruction.text ?? ""
        if !(txtInstruction.text ?? "").trimmingCharacters(in: .whitespacesAndNewlines).isEmpty{
            orderProdcut.instructionPrice = Double(txtInstructionPrice.text ?? "") ?? 0
        }else{
            orderProdcut.instructionPrice = 0
        }
        orderProdcut.arrIngriedent = arrSelectedIngredients
        if delegate != nil{
            self.delegate?.productModified(product: orderProdcut, index: productIndex)
        }
        self.parentVC.constContainerLeadingSpace.constant = AppConstants.ScreenSize.SCREEN_WIDTH
        UIView.animate(withDuration: 0.25) {
            self.parentVC.view.layoutIfNeeded()
            self.parentVC.viewForBG.alpha = 0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    @IBAction func btnItemQuantityAction(_ sender:UIButton){
        self.view.endEditing(true)
        if sender.tag == 0{
            if productQty > 1{
                productQty -= 1
            }
        }else{
            productQty += 1
        }
        txtProductquantity.text = "\(productQty)"
    }
    
    @IBAction func btnViewTabAction(_ sender:UIButton){
        self.view.endEditing(true)
        selectedViewIndex = sender.tag
        setTabView()
    }
    
    @IBAction func btnItemModificationAction(_ sender:UIButton){
        self.view.endEditing(true)
        if sender.tag == 0{
            if itemModify > 1{
                itemModify -= 1
            }
        }else{
            if itemModify < productQty{
                itemModify += 1
            }
        }
        txtProductModified.text = "\(itemModify)"
    }
    
    @IBAction func btnProductAddAction(_ sender:UIButton){
        self.view.endEditing(true)
        let ingredient = arrIngredients[sender.tag]
        
        let removeIndex = arrSelectedIngredients.firstIndex { (model) -> Bool in
            return ingredient.id ?? 0 == model.productIngredientId ?? 0 && model.with ?? 0 == 0
        }
        if removeIndex != nil{
            arrSelectedIngredients.remove(at: removeIndex!)
        }else{
            let index = arrSelectedIngredients.firstIndex { (model) -> Bool in
                return ingredient.id ?? 0 == model.productIngredientId ?? 0 && model.with ?? 0 == 1
            }
            if index != nil{
                arrSelectedIngredients[index!].quantity = (arrSelectedIngredients[index!].quantity ?? 0) + 1
            }else{
                if let model = createOrderIngridentModel(ingrident: ingredient,  with: 1, without: 0){
                    arrSelectedIngredients.append(model)
                }
            }
        }
        self.collectionAddOns.reloadData()
        self.tblAddons.reloadData()
    }
    
    @IBAction func btnProductMinusAction(_ sender:UIButton){
        self.view.endEditing(true)
        let ingredient = arrIngredients[sender.tag]
        let index = arrSelectedIngredients.firstIndex { (model) -> Bool in
            return ingredient.id ?? 0 == model.productIngredientId ?? 0
        }
        if index != nil{
            if ingredient.without ?? 0 == 1{
                return
            }
            if sender.accessibilityIdentifier ?? "" == "101"{
                let quantity = (arrSelectedIngredients[index!].quantity ?? 0) - 1
                if quantity <= 0{
                    arrSelectedIngredients.remove(at: index!)
                }else{
                    arrSelectedIngredients[index!].quantity = (arrSelectedIngredients[index!].quantity ?? 0) - 1
                }
            }else{
                arrSelectedIngredients.remove(at: index!)
            }
        }else{
            if ingredient.without ?? 0 == 1{
                if let model = createOrderIngridentModel(ingrident: ingredient, with: 0, without: 1){
                    arrSelectedIngredients.append(model)
                }
            }
        }
        self.collectionAddOns.reloadData()
        self.tblAddons.reloadData()
    }
    
    @IBAction func btnPlusFromTableAction(_ sender:UIButton){
        self.view.endEditing(true)
        if selectedViewIndex == 1{
            let subAddon = arrSelectedIngredients[sender.tag]
            if subAddon.with ?? 0 == 1{
                subAddon.quantity! += 1
            }
        }else{
            let subAddon = arrSelectedAddOns[sender.tag]
            if let index = arrAddOns.firstIndex(where: { addon in
                if let arr = addon.children{
                    return arr.contains { model in
                        return model.id ?? 0 == subAddon.AddonId ?? 0
                    }
                }
                return false
            }){
                if let max = arrAddOns[index].maxQuantity{
                    if arrAddOns[index].selectedAddonCount >= max{
                        AppCommonMethods.showToastAlert(message: "You can select maximum \(max) addons")
                        return
                    }
                }
                arrAddOns[index].selectedAddonCount += 1
            }
            subAddon.quantity += 1
        }
        self.tblAddons.reloadData()
        self.collectionAddOns.reloadData()
    }
    
    @IBAction func btnMinusFromTableAction(_ sender:UIButton){
        self.view.endEditing(true)
        if selectedViewIndex == 1{
            let subAddon = arrSelectedIngredients[sender.tag]
            if subAddon.with ?? 0 == 1{
                subAddon.quantity! -= 1
                if subAddon.quantity == 0{
                    arrSelectedIngredients.remove(at: sender.tag)
                }
            }else{
                arrSelectedIngredients.remove(at: sender.tag)
            }
        }else{
            let subAddon = arrSelectedAddOns[sender.tag]
            if let index = arrAddOns.firstIndex(where: { addon in
                if let arr = addon.children{
                    return arr.contains { model in
                        return model.id ?? 0 == subAddon.AddonId ?? 0
                    }
                }
                return false
            }){
                arrAddOns[index].selectedAddonCount -= 1
            }
            subAddon.quantity -= 1
            if subAddon.quantity == 0{
                arrSelectedAddOns.remove(at: sender.tag)
            }
        }
        self.tblAddons.reloadData()
        self.collectionAddOns.reloadData()
    }
    
    @IBAction func btnDeleteFromTableAction(_ sender:UIButton){
        self.view.endEditing(true)
        if selectedViewIndex == 1{
            let subAddon = arrSelectedIngredients[sender.tag]
            subAddon.quantity = 0
            arrSelectedIngredients.remove(at: sender.tag)
        }else{
            let subAddon = arrSelectedAddOns[sender.tag]
            if let index = arrAddOns.firstIndex(where: { addon in
                if let arr = addon.children{
                    return arr.contains { model in
                        return model.id ?? 0 == subAddon.AddonId ?? 0
                    }
                }
                return false
            }){
                arrAddOns[index].selectedAddonCount -= subAddon.quantity
            }
            subAddon.quantity = 0
            arrSelectedAddOns.remove(at: sender.tag)
        }
        self.tblAddons.reloadData()
        self.collectionAddOns.reloadData()
    }
    
}

extension AddOnTheme2VC: UITableViewDataSource, UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if selectedViewIndex == 0{
            return arrSelectedAddOns.count
        }
//        else if selectedViewIndex == 1{
//            return arrSelectedIngredients.count
//        }
        return 0
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "ProductsListCell", for: indexPath) as! ProductsListCell
        if selectedViewIndex == 1{
            let addon = arrSelectedIngredients[indexPath.row]
            cell.lblName.text = addon.name ?? ""
            cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, addon.price ?? 0 * Double(addon.quantity ?? 0))
            cell.txtQuantity.text = addon.quantity?.description ?? ""
        }else{
            let addon = arrSelectedAddOns[indexPath.row]
            cell.lblName.text = addon.name ?? ""
            cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, addon.price ?? 0 * Double(addon.quantity))
            cell.txtQuantity.text = addon.quantity.description
        }
        cell.txtQuantity.tag = indexPath.row
        cell.btnPlus.tag = indexPath.row
        cell.btnMinus.tag = indexPath.row
        cell.btnDelete.tag = indexPath.row
        return cell
    }
}

//MARK:  UICollectionViewDataSource
extension AddOnTheme2VC: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout{
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if selectedViewIndex == 1{
            return arrIngredients.count
        }else if selectedViewIndex == 2{
            return 0
        }
        return arrSubAddOns.count+1
    }

    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        if selectedViewIndex == 1{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "IngredientCollectionCell", for: indexPath) as! ProductsCollectionCell
            cell.btnAdd.tag = indexPath.row
            cell.btnMinus.tag = indexPath.row
            cell.btnRemove.tag = indexPath.row
            
            cell.btnMinus.accessibilityIdentifier = "101"
            
            let model = arrIngredients[indexPath.row]
            
            if model.with ?? 0 == 1{
                cell.lblPlus.superview?.isHidden = false
                cell.constPlusSpace.constant = 40
            }else{
                cell.lblPlus.superview?.isHidden = true
                cell.constPlusSpace.constant = 15
            }
            
            if model.without ?? 0 == 1{
                cell.lblMinus.superview?.isHidden = false
                cell.constMinusSpace.constant = 40
            }else{
                cell.lblMinus.superview?.isHidden = true
                cell.constMinusSpace.constant = 15
            }
            let index = arrSelectedIngredients.firstIndex(where: { (ingrident) -> Bool in
                return ingrident.with ?? 0 == 1 && model.id ?? 0 == ingrident.productIngredientId ?? 0
            })
            
            cell.lblMinus.isHidden = false
            cell.imgDelete.isHidden = true
            cell.btnRemove.alpha = 1
            cell.lblQuantity.textColor = AppConstants.Colors.kAppThemeTextColor
            cell.lblMinus.superview?.backgroundColor = AppConstants.Colors.kAppThemeRedColor
            if index != nil{
                cell.lblQuantity.text = "\(arrSelectedIngredients[index!].quantity ?? 0)"
                cell.btnRemove.alpha = 0
            }else{
                let removeIndex = arrSelectedIngredients.firstIndex(where: { (ingrident) -> Bool in
                    return ingrident.without ?? 0 == 1 && model.id ?? 0 == ingrident.productIngredientId ?? 0
                })
                if removeIndex != nil{
                    cell.lblMinus.superview?.backgroundColor = AppConstants.Colors.kAppLightGrayColor
                    cell.btnRemove.alpha = 0
                    cell.lblQuantity.text = "Removed"
                    cell.lblQuantity.textColor = AppConstants.Colors.kAppThemeRedColor
                }else{
                    cell.lblMinus.isHidden = true
                    cell.imgDelete.isHidden = false
                    cell.lblQuantity.text = "0"
                }
            }
            
            cell.lblName.text = model.name ?? ""
            if model.with ?? 0 == 1{
                cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign,model.price ?? 0 )
            }else{
                cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign,model.priceWithout ?? 0 )
            }
            
            return cell
        }
        if indexPath.row == 0{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "ProductHeaderCollectionCell", for: indexPath) as! ProductHeaderCollectionCell
            let addon = arrAddOns[selectedAddonIndex]
            var addonString = ""
            var strMinMax = ""
            if addon.minQuantity ?? 0 > 0{
                strMinMax = "Min. \(addon.minQuantity ?? 0)"
                addonString = " (Required)"
            }else{
                addonString = " (Optional)"
            }
            if addon.maxQuantity ?? 0 > 0{
                if strMinMax == ""{
                    strMinMax = "Max. \(addon.maxQuantity ?? 0)"
                }else{
                    strMinMax = "\(strMinMax)\nMax. \(addon.maxQuantity ?? 0)"
                }
            }
            cell.lblMaxQuantity.text = strMinMax
            cell.lblTitle.text = addon.name ?? ""
            cell.lblTitle.text = "\(addon.name ?? "")\(addonString)"
            cell.lblTitle.textColor = AppConstants.Colors.kAppThemeAquaColor
            cell.lblMaxQuantity.textColor = AppConstants.Colors.kAppThemeTextColor
            return cell
        }
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "ProductsCollectionCell", for: indexPath) as! ProductsCollectionCell
        let model = arrSubAddOns[indexPath.row-1]
        cell.lblName.text = model.name ?? ""
        var price = model.price ?? 0
        if isBanquetOrder{
            price = model.waitingPrice ?? 0
        }else{
            if orderType.id ?? 0 == 3{
                price = model.deliveryPrice ?? 0
            }else if orderType.id ?? 0 == 2 || orderType.id ?? 0 == 5{
                price = model.takeawayPrice ?? 0
            }
        }
        if let _ = arrSelectedAddOns.firstIndex(where: { (subAddon) -> Bool in
            return model.id ?? 0 == subAddon.AddonId ?? 0
        }){
            cell.lblName.textColor = .white
            cell.lblPrice.textColor = .white
            cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
        }else{
            cell.lblName.textColor = .black
            cell.lblPrice.textColor = .black
            cell.viewForBG.backgroundColor = .white
        }
        
        cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, price)
        return cell
    }

    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        let width = ((AppConstants.ScreenSize.SCREEN_WIDTH - 25)*0.6)-30
        if selectedViewIndex == 0{
            if indexPath.row == 0{
                return CGSize.init(width: width, height: 50)
            }else{
                if AppConstants.ScreenSize.SCREEN_HEIGHT >= 1024{
                    return CGSize.init(width: width/4, height: 125)
                }else{
                    return CGSize.init(width: width/3, height: 125)
                }
            }
        }else{
            if AppConstants.ScreenSize.SCREEN_HEIGHT >= 1024{
                return CGSize.init(width: width/4, height: 125)
            }else{
                return CGSize.init(width: width/3, height: 125)
            }
        }
    }

    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if selectedViewIndex == 0{
            if indexPath.row != 0{
                if !checkforRequiredAddon(){
                    let subAddon = arrSubAddOns[indexPath.row-1]
                    let index = arrSelectedAddOns.firstIndex { (model) -> Bool in
                        return subAddon.id ?? 0 == model.AddonId ?? 0
                    }
                    arrAddOns[selectedAddonIndex].selectedAddonCount += 1
                    if index != nil{
                        arrSelectedAddOns.remove(at: index!)
                    }else{
                        if let model = createOrderAddonModel(addon: subAddon){
                            model.quantity = 1
                            arrSelectedAddOns.append(model)
                        }
                    }
                    if checkforRequiredAddon() && selectedAddonIndex < arrAddOns.count-1{
                        selectedAddonIndex += 1
                        let addon = arrAddOns[selectedAddonIndex]
                        if addon.children != nil{
                            arrSubAddOns = addon.children!
                        }else{
                            arrSubAddOns.removeAll()
                        }
                        self.btnBack.isHidden = false
                        if selectedAddonIndex == arrAddOns.count-1{
                            self.btnAdd.isSelected = true
                        }else{
                            self.btnAdd.isSelected = false
                        }
                    }
                    collectionView.reloadData()
                    self.tblAddons.reloadData()
                }else{
                    if selectedAddonIndex < arrAddOns.count-1{
                        selectedAddonIndex += 1
                        let addon = arrAddOns[selectedAddonIndex]
                        if addon.children != nil{
                            arrSubAddOns = addon.children!
                        }else{
                            arrSubAddOns.removeAll()
                        }
                        self.collectionAddOns.reloadData()
                        self.btnBack.isHidden = false
                        if selectedAddonIndex == arrAddOns.count-1{
                            self.btnAdd.isSelected = true
                        }else{
                            self.btnAdd.isSelected = false
                        }
                    }
                    AppCommonMethods.showToastAlert(message: "You can select maximum \(arrAddOns[selectedAddonIndex].maxQuantity ?? 0) addons")
                }
            }
        }
    }
}

extension AddOnTheme2VC:UITextFieldDelegate{
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        return textField.resignFirstResponder()
    }
    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        if textField == txtInstructionPrice{
            let allowedCharacters = CharacterSet(charactersIn:"0123456789")
            let characterSet = CharacterSet(charactersIn: string)
            if allowedCharacters.isSuperset(of: characterSet){
                var strText = (textField.text!).replacingOccurrences(of: ".", with: "")
                if string == ""{
                    if strText != "000"{
                        if strText.count == 3{
                            strText.removeLast()
                            strText = "0\(strText)"
                        }else{
                            strText.removeLast()
                        }
                        strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                        textField.text = "\(strText)"
                    }
                }else{
                    if strText.first! == "0"{
                        strText.removeFirst()
                        strText = "\(strText)\(string)"
                    }else{
                        strText = "\(strText)\(string)"
                    }
                    strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                    textField.text = "\(strText)"
                }
            }
            return false
        }
        return true
    }
    
    func textFieldDidEndEditing(_ textField: UITextField) {
        if textField != txtInstructionPrice{
//            let quantity = Int(textField.text ?? "") ?? 0
//            if quantity == 0{
//                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "Quantity can not be zero.", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
//                    
//                }
//                return
//            }
//            if selectedViewIndex == 1{
//                let subAddon = arrSelectedIngredients[textField.tag]
//                if subAddon.with ?? 0 == 1{
//                    subAddon.quantity! = quantity
//                }
//            }else{
//                let subAddon = arrSelectedAddOns[textField.tag]
//                let oldQuantity = subAddon.quantity
//                if let index = arrAddOns.firstIndex(where: { addon in
//                    if let arr = addon.children{
//                        return arr.contains { model in
//                            return model.id ?? 0 == subAddon.AddonId ?? 0
//                        }
//                    }
//                    return false
//                }){
//                    if let max = arrAddOns[index].maxQuantity{
//                        if arrAddOns[index].selectedAddonCount >= max{
//                            return
//                        }
//                    }
//                    if oldQuantity > quantity{
//                        
//                    }else{
//                        
//                    }
////                    arrAddOns[index].selectedAddonCount -= ()
//                }
//                subAddon.quantity = quantity
//            }
//            self.tblAddons.reloadData()
        }
    }
}
