//
//  CreateOrderVC.swift
//  EPOS
//
//  Created by Apple on 01/03/21.
//

import UIKit
import CoreData

class CreateOrderVC: UIViewController {
    
    //MARK: IBOutlets
    @IBOutlet weak var tblProducts:UITableView!
    @IBOutlet weak var collectionProduct:UICollectionView!
    @IBOutlet weak var collectionSubCategory:UICollectionView!
    @IBOutlet weak var collectionMainCategory:UICollectionView!
    @IBOutlet weak var constSubCategoryHeight:NSLayoutConstraint!
    @IBOutlet weak var constActionTrailingSpace:NSLayoutConstraint!
    @IBOutlet weak var txtSearch:UITextField!
    @IBOutlet weak var lblSubTotal:UILabel!
    @IBOutlet weak var lblDeliveryCharge:UILabel!
    @IBOutlet weak var lblGratuity:UILabel!
    @IBOutlet weak var lblServiceCharge:UILabel!
    @IBOutlet weak var lblDiscount:UILabel!
    @IBOutlet weak var lblOrderInTransit:UILabel!
    @IBOutlet weak var lblOrderComment:UILabel!
    @IBOutlet weak var lblGrandTotal:UILabel!
    @IBOutlet weak var lblSplit:UILabel!
    @IBOutlet weak var btnExpand:UIButton!
    @IBOutlet weak var btnOrderType:UIButton!
    @IBOutlet weak var btnAddGratuity:UIButton!
    @IBOutlet weak var btnDiscount:UIButton!
    @IBOutlet weak var btnSplit:UIButton!
    @IBOutlet weak var btnServiceCharge:UIButton!
    @IBOutlet weak var btnSwapTable:UIButton!
    @IBOutlet weak var btnRemoveDiscount:UIButton!
    @IBOutlet weak var btnRemoveServiceCharge:UIButton!
    @IBOutlet weak var btnRemoveGratuity:UIButton!
    @IBOutlet weak var btnChangeOrder:UIButton!
    @IBOutlet weak var btnChangeCustomer:UIButton!
    @IBOutlet weak var btnTableNo:UIButton!
    @IBOutlet weak var btnDeliveryCharge:UIButton!
    @IBOutlet weak var btnOrderTransit:UIButton!
    @IBOutlet weak var btnCancelOrder:UIButton!
    @IBOutlet weak var btnDeleteOrder:UIButton!
    @IBOutlet weak var btnMisc:UIButton!
    @IBOutlet weak var viewForEdit:UIView!
    @IBOutlet weak var viewForContainer:UIView!
    @IBOutlet weak var viewForDiscountContainer:UIView!
    @IBOutlet weak var viewForBG:UIView!
    @IBOutlet weak var viewForComment:UIView!
    @IBOutlet weak var constContainerLeadingSpace:NSLayoutConstraint!
    @IBOutlet weak var btnComment:UIButton!
    @IBOutlet weak var btnVoucher:UIButton!
    @IBOutlet weak var btnCompleteOrder:UIButton!
    @IBOutlet weak var btnPayCard:UIButton!
    @IBOutlet weak var btnPayCash:UIButton!
    @IBOutlet weak var btnOrderDetail:UIButton!
    @IBOutlet weak var btnHome:UIButton!
    @IBOutlet weak var btnPriceBreakupShow:UIButton!
    @IBOutlet weak var btnPriceBreakupHide:UIButton!
    @IBOutlet weak var viewForPriceBreakupSperator:UIView!
    @IBOutlet weak var btnSendOrder:UIButton!
    @IBOutlet weak var btnPrintBill:UIButton!
    @IBOutlet weak var btnMergeTables:UIButton!
    @IBOutlet weak var btnEstimatedTime:UIButton!
    
    //MARK: Instances
    var selectedMainCategory:CategoryModel?
    var arrCategory = [CategoryModel]()
    var arrSubCategory = [CategoryModel]()
    var selectedSubCategory:CategoryModel?
    var arrProducts = [ProductModel]()
    var arrSearchProducts = [ProductModel]()
    var arrNormalProducts = [OrderProductModel]()
    var isSearchEnabled = false
    var orderType:OrderTypesModel!
    var selectedCustomer:CustomerModel?
    var selectedLocation:PrepLocationModel?
    var gratuity = 0.0
    var discount = 0.0
    var totalPrice = 0.0
    var grandAmount = 0.0
    var serviceCharge = 0.0
    var distance = 0.0
    var deliveryCharge = 0.0
    var noOfGuest:Int?
    var selectedTable:TableModel?
    var orderData:OrderModel?
    var orderId:Int?
    var orderComment = ""
    var shouldDisplayImage = false
    var isBanquetOrder = false
    var isAutoDiscount = false
    var isAutoServiceCharge = false
    var isEditOrder = false
    var arrGroups = [OrderGroupModel]()
    var selectedGroupIndex:Int? = nil
    var isPriceBreakupShow = false
    var passwordType = 0 // 0 - delete order, 1 - cancel order, 2 - discount, 3 - payment done
    
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        checkForBanquetType()
        FetchCategoryList()
        getProductFromDataBase()
        if orderData?.isNewOrder == nil && orderId == nil{
            setOrderView()
        }else{
            fetchOrderFromDB()
        }
        PrintManager.shared.printingStoped = {
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
            }
            if !PrintManager.shared.isPrintingBill && PrintManager.shared.dictFailedProduct.count > 0{
                if let _ = FailedPrintVC.showPopup(order: self.orderData!, dictProducts: PrintManager.shared.dictFailedProduct){
                    
                }
                PrintManager.shared.dictFailedProduct.removeAll()
                return
            }
            self.fetchOrderFromDB()
            if self.orderData?.orderStatusId ?? 0 <= 2{
                self.CallCreateOrderAPI(orderStatusId: 2, action: 3, shouldPrint: true)
            }else{
                self.CallCreateOrderAPI(action: 3, shouldPrint: true)
            }
            PrintManager.shared.printingStoped = nil
        }
        if orderData?.orderStatusId ?? 0 <= 2{
            CallCreateOrderAPI(orderStatusId: 1, action:9)
        }
        if orderData?.orderTypeId ?? 0 == 1{
            self.btnTableNo.superview?.isHidden = false
            self.btnTableNo.setTitle(self.selectedTable?.number ?? "", for: .normal)
        }else{
            self.btnTableNo.superview?.isHidden = true
        }
        shouldDisplayImage = (AppCommonMethods.fetchSiteSettingValue(key: "product_image_visible") ?? "" == "yes")
        self.constContainerLeadingSpace.constant = AppConstants.ScreenSize.SCREEN_WIDTH
    }
    
    override func viewDidAppear(_ animated: Bool) {
        print(isMovingToParent)
        print(isMovingFromParent)
        if selectedTable != nil{
            if (selectedTable?.tableStatus?.status ?? "").lowercased() == "vacant"{
                if let status = CoreDataHelper.shared.fetchTableStatusData(name: "taking order").first{
                    AppCommonMethods.SaveTable(table: selectedTable!, statusId: status.id, locked: 1)
                    selectedTable?.tableStatus = status
                    selectedTable?.tableStatusId = status.id ?? 0
                    orderData?.table = selectedTable
                    SQLiteManage.updateTableStatus(tableId: selectedTable?.id ?? 0, statusId: status.id, locked: 1)
                }else{
                    AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                }
            }else{
                SQLiteManage.updateTableStatus(tableId: selectedTable?.id ?? 0, locked: 1)
                AppCommonMethods.SaveTable(table: selectedTable!, locked: 1)
            }
        }
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        if self.isMovingFromParent{
            if selectedTable != nil{
                SQLiteManage.updateTableStatus(tableId: selectedTable?.id ?? 0, locked: 0)
                AppCommonMethods.SaveTable(table: selectedTable!, locked: 0)
            }
        }
        NotificationCenter.default.removeObserver(self, name: AppConstants.notifications.kDatabasePushed, object: nil)
    }
    
    override func viewWillAppear(_ animated: Bool) {
        isEditOrder = false
        fetchOrderFromDB()
        tblProducts.reloadData()
        viewForEdit.isHidden = true
        NotificationCenter.default.addObserver(self, selector: #selector(reloadPageData(_:)), name: AppConstants.notifications.kDatabasePushed, object: nil)
    }
    
    //MARK: Create ViewController Instance
    static func instance()->CreateOrderVC?{
        return UIStoryboard.init(name: "Orders", bundle: nil).instantiateViewController(withIdentifier: "CreateOrderVC") as? CreateOrderVC
    }
    
    //MARK:  General Methods
    @objc func reloadPageData(_ notification:Notification){
        if let data = notification.object as? [String:Int], let id = data["old_id"], let newId = data["order_id"],id == (orderId ?? 0){
            self.orderId = newId
            fetchOrderFromDB()
        }
        if let data = notification.object as? [String:String], let id = data["unique_id"], id == self.orderData?.uniqueId ?? ""{
            AppCommonMethods.stopProgressBar()
            if let order = SQLiteManage.fetchOrderDataByUniqueId(orderId: id){
                self.orderId = order.id ?? 0
                self.selectedCustomer = order.customer
                self.orderData = order
                self.discount = order.discount ?? 0
                self.deliveryCharge = order.deliveryCharge ?? 0
                self.noOfGuest = order.noGuest ?? 0
                self.selectedTable = order.table
                self.gratuity = order.gratuity ?? 0
                self.serviceCharge = order.serviceCharge ?? 0
                self.distance = order.distance ?? 0
                self.orderComment = order.comment ?? ""
                self.arrNormalProducts = order.arrProducts.filter({ product in
                    return product.orderSplitId ?? 0 == 0
                })
                if order.splitCount ?? 0 == 0{
                    self.arrGroups = order.arrOrderSplit
                    for group in arrGroups {
                        group.paidAmount = SQLiteManage.fetchSumOfTable(feild: "amount", whereString: "WHERE order_split_id = '\(group.id ?? 0)' AND order_id = '\(order.id ?? 0)'", tableName: "OrderPayment")
                        group.arrProducts = order.arrProducts.filter({ product in
                            return product.groupUniqueId == group.uniqueId
                        })
                    }
                }
                self.setOrderView()
                self.collectionProduct.reloadData()
            }
        }
    }
    
    func checkForBanquetType(){
        let banquetDay = AppCommonMethods.fetchSiteSettingValue(key: "banquet_day") ?? ""
        let banquetType = AppCommonMethods.fetchSiteSettingValue(key: "banquet_type") ?? ""
        let today = Date().getDateInString(format: "EEEE").lowercased()
        let orderType = (self.orderType.type ?? "").lowercased()
        if banquetDay.contains(today) && banquetType.contains(orderType){
            isBanquetOrder = true
            PrintManager.shared.isBanquetOrder = true
        }else{
            isBanquetOrder = false
            PrintManager.shared.isBanquetOrder = false
        }
    }
    
    func checkForAutoDiscountType(){
        if isAutoDiscount{
            isAutoDiscount = false
            self.discount = 0
        }
        if let arrD = AppConstants.autoDiscount{
            for discount in arrD{
                let discountDay = discount.weekDay ?? ""
                let discountOrderType = discount.orderTypeId ?? ""
                let startDate = discount.startDate ?? ""
                let endDate = discount.endDate ?? ""
                let discountType = discount.discountType ?? ""
                let discountAmount = discount.discount ?? 0
                let orderType = "\(self.orderType.id ?? 0)"
                let today = Date().getDateInString(format: "EEEE").lowercased()
                
                if let minOrder = discount.minimumValue{
                    if let sDate = startDate.getDateFromString(format: "yyyy-MM-dd HH:mm:ss"), let eDate = endDate.getDateFromString(format: "yyyy-MM-dd HH:mm:ss"){
                        let currentDate = Date().startOfDate() ?? Date()
                        if totalPrice >= minOrder && (sDate ... eDate).contains(currentDate) && discountOrderType.contains(orderType) && discountDay.contains(today){
                            if discountType == "flat"{
                                self.discount = discountAmount
                            }else{
                                self.discount = totalPrice*discountAmount/100
                            }
                            isAutoDiscount = true
                            break
                        }
                    }
                }else{
                    if let sDate = startDate.getDateFromString(format: "yyyy-MM-dd HH:mm:ss"), let eDate = endDate.getDateFromString(format: "yyyy-MM-dd HH:mm:ss"){
                        if (sDate ... eDate).contains(Date()) && discountOrderType.contains(orderType) && discountDay.contains(today){
                            if discountType == "flat"{
                                self.discount = discountAmount
                            }else{
                                self.discount = totalPrice*discountAmount/100
                            }
                            isAutoDiscount = true
                            break
                        }
                    }
                }
            }
        }
    }
    
    func checkForServiceCharge(){
        if let order = self.orderData, order.isAutoServiceChargeRemove{
            
        }else{
            if AppCommonMethods.fetchSiteSettingValue(key: "is_service_charge") ?? "" == "true" && (AppCommonMethods.fetchSiteSettingValue(key: "service_charge_order_type") ?? "").contains((self.orderType.type ?? "").lowercased()){
                if AppCommonMethods.fetchSiteSettingValue(key: "service_charge_type_option") ?? "" == "auto"{
                    let serviceC = Double(AppCommonMethods.fetchSiteSettingValue(key: "service_charge") ?? "") ?? 0
                    if AppCommonMethods.fetchSiteSettingValue(key: "service_charge_type") ?? "" == "flat"{
                        serviceCharge = serviceC.getRoundFigure()
                    }else{
                        serviceCharge = (serviceC*totalPrice/100).getRoundFigure()
                    }
                    isAutoServiceCharge = true
                }else{
                    if isAutoServiceCharge{
                        serviceCharge = 0
                    }
                    isAutoServiceCharge = false
                }
            }
        }
    }
    
    func setOrderButtons(){
        btnChangeOrder.superview?.superview?.isHidden = false
        btnSwapTable.superview?.superview?.isHidden = false
        btnSplit.superview?.isHidden = false
        btnAddGratuity.superview?.superview?.isHidden = false
        btnDiscount.superview?.isHidden = false
        btnOrderTransit.superview?.superview?.isHidden = false
        btnVoucher.superview?.superview?.isHidden = false
        btnCancelOrder.superview?.isHidden = false
        btnDeleteOrder.superview?.isHidden = false
        btnCompleteOrder.superview?.superview?.isHidden = true
        btnPayCard.isHidden = false
        btnPayCash.isHidden = false
        btnOrderDetail.isHidden = true
        btnServiceCharge.superview?.superview?.isHidden = false
        btnOrderTransit.superview?.superview?.isHidden = true
        btnMergeTables.superview?.superview?.isHidden = false
        
        if AppCommonMethods.fetchSiteSettingValue(key: "delivery_charge_type_option") ?? "" == "manual" && orderType?.id ?? 0 == 3{
            btnDeliveryCharge.superview?.superview?.isHidden = false
        }else{
            btnDeliveryCharge.superview?.superview?.isHidden = true
        }
        
        if orderData?.totalPaid ?? 0 >= orderData?.total ?? 0 && orderData?.total ?? 0 > 0{
            btnCompleteOrder.superview?.superview?.isHidden = false
        }
        
        if orderType.id ?? 0 != 1{
            btnMergeTables.superview?.superview?.isHidden = true
            btnSwapTable.superview?.superview?.isHidden = true
        }
        
        if AppConstants.userData?.permissions?.mergeTable?.actions?.list ?? 0 == 0{
            btnMergeTables.superview?.superview?.isHidden = true
        }
        
        if orderData?.totalPaid ?? 0 > 0{
            btnChangeOrder.superview?.superview?.isHidden = true
            btnSwapTable.superview?.superview?.isHidden = true
            if self.arrGroups.count == 0 && orderData?.splitCount ?? 0 == 0{
                btnSplit.superview?.isHidden = true
            }
        }
        
        if orderData?.orderStatusId ?? 0 == 4{
            self.btnRemoveDiscount.isHidden = true
            self.btnRemoveGratuity.isHidden = true
            self.btnRemoveServiceCharge.isHidden = true
            btnAddGratuity.superview?.superview?.isHidden = true
            btnDeliveryCharge.superview?.superview?.isHidden = true
            btnDiscount.superview?.isHidden = true
            btnServiceCharge.superview?.superview?.isHidden = true
            btnPayCard.isHidden = true
            if orderType.id ?? 0 == 3{
                if AppCommonMethods.fetchSiteSettingValue(key: "is_on_the_way") ?? "" == "true"{
                    btnOrderTransit.superview?.superview?.isHidden = false
                }
                lblOrderInTransit.text = "On the way"
            }else if orderType.id ?? 0 == 2{
                if AppCommonMethods.fetchSiteSettingValue(key: "is_ready_to_collect") ?? "" == "true"{
                    btnOrderTransit.superview?.superview?.isHidden = false
                }
                lblOrderInTransit.text = "Ready to collect"
            }
            btnPayCash.isHidden = true
            btnOrderDetail.isHidden = false
            btnVoucher.superview?.superview?.isHidden = true
        }
        
        if orderData?.orderStatusId ?? 0 == 10{
            self.btnRemoveDiscount.isHidden = true
            self.btnRemoveGratuity.isHidden = true
            self.btnRemoveServiceCharge.isHidden = true
            btnCompleteOrder.superview?.superview?.isHidden = true
            btnOrderTransit.superview?.superview?.isHidden = true
            btnSplit.superview?.isHidden = true
            btnAddGratuity.superview?.superview?.isHidden = true
            btnDeliveryCharge.superview?.superview?.isHidden = true
            btnDiscount.superview?.isHidden = true
            btnServiceCharge.superview?.superview?.isHidden = true
            btnPayCard.isHidden = true
            btnPayCash.isHidden = true
            btnOrderDetail.isHidden = false
            btnVoucher.superview?.superview?.isHidden = true
        }
        
        if orderData?.orderStatusId ?? 0 == 5{
            self.btnRemoveDiscount.isHidden = true
            self.btnRemoveGratuity.isHidden = true
            self.btnRemoveServiceCharge.isHidden = true
            btnCompleteOrder.superview?.superview?.isHidden = true
            btnOrderTransit.superview?.superview?.isHidden = true
            btnSplit.superview?.isHidden = true
            btnAddGratuity.superview?.superview?.isHidden = true
            btnDeliveryCharge.superview?.superview?.isHidden = true
            btnDiscount.superview?.isHidden = true
            btnServiceCharge.superview?.superview?.isHidden = true
            btnPayCard.isHidden = true
            btnPayCash.isHidden = true
            btnOrderDetail.isHidden = false
            btnVoucher.superview?.superview?.isHidden = true
        }
        
        if orderData?.orderStatusId ?? 0 == 6{
            self.btnRemoveDiscount.isHidden = true
            self.btnRemoveGratuity.isHidden = true
            self.btnRemoveServiceCharge.isHidden = true
            btnOrderTransit.superview?.superview?.isHidden = true
            btnSplit.superview?.isHidden = true
            btnAddGratuity.superview?.superview?.isHidden = true
            btnDeliveryCharge.superview?.superview?.isHidden = true
            btnDiscount.superview?.isHidden = true
            btnServiceCharge.superview?.superview?.isHidden = true
            btnPayCard.isHidden = true
            btnPayCash.isHidden = true
            btnOrderDetail.isHidden = false
            btnVoucher.superview?.superview?.isHidden = true
        }
        
        if checkOrderSplite(){
            btnVoucher.superview?.superview?.isHidden = true
            lblSplit.text = "Unsplit"
            btnChangeOrder.superview?.superview?.isHidden = true
            btnSwapTable.superview?.superview?.isHidden = true
        }else{
            lblSplit.text = "Split"
        }
        
        if isAutoDiscount{
            btnDiscount.superview?.isHidden = true
        }
        
        if isAutoServiceCharge && self.serviceCharge > 0{
            btnServiceCharge.superview?.superview?.isHidden = true
        }
        
        if isBanquetOrder{
            btnChangeOrder.superview?.superview?.isHidden = true
        }
        
        if AppCommonMethods.fetchSiteSettingValue(key: "gratuity") ?? "" != "true"{
            btnAddGratuity.superview?.superview?.isHidden = true
        }
        
        if AppConstants.userData?.permissions?.sendOrder?.actions?.list ?? 0 == 1{
            btnSendOrder.superview?.isHidden = false
        }else{
            btnSendOrder.superview?.isHidden = true
        }
        if (AppCommonMethods.fetchSiteSettingValue(key: "is_printbill") ?? "" == "true" && AppConstants.userData?.permissions?.printBill?.actions?.list ?? 0 == 1) || (AppCommonMethods.fetchSiteSettingValue(key: "is_printall") ?? "" == "true" && AppConstants.userData?.permissions?.printAll?.actions?.list ?? 0 == 1){
            btnPrintBill.superview?.isHidden = false
        }else{
            btnPrintBill.superview?.isHidden = true
        }
        if (orderData?.totalPaid ?? 0).getRoundFigure() >= (orderData?.total ?? 0).getRoundFigure(), orderData?.total ?? 0 > 0{
            btnVoucher.superview?.superview?.isHidden = true
            self.btnRemoveDiscount.isHidden = true
            self.btnRemoveDiscount.isHidden = true
            self.btnRemoveServiceCharge.isHidden = true
            btnAddGratuity.superview?.superview?.isHidden = true
            btnDeliveryCharge.superview?.superview?.isHidden = true
            btnDiscount.superview?.isHidden = true
            btnSendOrder.superview?.isHidden = true
            btnPrintBill.superview?.isHidden = true
        }
        if orderData?.orderStatusId ?? 0 == 10 || orderData?.orderStatusId ?? 0 == 5 || orderData?.orderStatusId ?? 0 == 4{
            btnSendOrder.superview?.isHidden = true
            btnPrintBill.superview?.isHidden = true
        }
        
        if AppCommonMethods.fetchSiteSettingValue(key: "is_service_charge") ?? "" == "true" && (AppCommonMethods.fetchSiteSettingValue(key: "service_charge_order_type") ?? "").contains((self.orderType.type ?? "").lowercased()){
            if AppCommonMethods.fetchSiteSettingValue(key: "service_charge_type_option") ?? "" == "auto"{
                //                btnServiceCharge.superview?.superview?.isHidden = true
            }
        }else{
            btnServiceCharge.superview?.superview?.isHidden = true
        }
        
        let isVoucherAvaiable = AppConstants.arrPaymentMethods.contains { (model) -> Bool in
            return model.id ?? 0 == 5
        }
        if !isVoucherAvaiable{
            btnVoucher.superview?.superview?.isHidden = true
        }
        
        if orderData?.orderStatusId ?? 0 == 10{
            btnCancelOrder.superview?.isHidden = true
        }
        
        if orderData?.totalPaid ?? 0 >= orderData?.total ?? 0 && orderData?.total ?? 0 > 0{
            if AppConstants.userData?.permissions?.cancelOrderAfterPayment?.actions?.list ?? 0 == 0{
                btnCancelOrder.superview?.isHidden = true
            }
        }else{
            if AppConstants.userData?.permissions?.cancelOrder?.actions?.list ?? 0 == 0{
                btnCancelOrder.superview?.isHidden = true
            }
        }
        
        if AppConstants.userData?.permissions?.deleteOrder?.actions?.list ?? 0 == 0{
            btnDeleteOrder.superview?.isHidden = true
        }
        
        if AppConstants.userData?.permissions?.vouchers?.actions?.list ?? 0 == 0{
            btnVoucher.superview?.superview?.isHidden = true
        }
        
        if AppConstants.userData?.permissions?.swapTable?.actions?.list ?? 0 == 0{
            btnSwapTable.superview?.superview?.isHidden = true
        }
        
        if AppConstants.userData?.permissions?.discount?.actions?.list ?? 0 == 0{
            btnDiscount.superview?.isHidden = true
        }
        
        if AppConstants.userData?.permissions?.convertOrder?.actions?.list ?? 0 == 0{
            btnChangeOrder.superview?.superview?.isHidden = true
        }
        
        if AppConstants.userData?.permissions?.split?.actions?.list ?? 0 == 0{
            btnSplit.superview?.isHidden = true
        }
        
        if AppConstants.userData?.permissions?.gratutity?.actions?.list ?? 0 == 0{
            btnAddGratuity.superview?.superview?.isHidden = true
        }
        if self.orderType.id ?? 0 == 1{
            btnEstimatedTime.superview?.isHidden = true
        }else{
            btnEstimatedTime.superview?.isHidden = false
        }
        if self.orderType.id ?? 0 == 2{
            if AppCommonMethods.fetchSiteSettingValue(key: "is_waiting") ?? "" == "false" && AppConstants.userData?.permissions?.waiting?.actions?.list ?? 0 == 0 && AppCommonMethods.fetchSiteSettingValue(key: "is_delivery") ?? "" == "false" && AppConstants.userData?.permissions?.delivery?.actions?.list ?? 0 == 0 && AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "false" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 0 && AppCommonMethods.fetchSiteSettingValue(key: "is_dinein") ?? "" == "false" && AppConstants.userData?.permissions?.dinein?.actions?.list ?? 0 == 0{
                btnChangeOrder.superview?.superview?.isHidden = true
            }
        }else if self.orderType.id ?? 0 == 5{
            if AppCommonMethods.fetchSiteSettingValue(key: "is_collection") ?? "" == "false" && AppConstants.userData?.permissions?.collection?.actions?.list ?? 0 == 0 && AppCommonMethods.fetchSiteSettingValue(key: "is_delivery") ?? "" == "false" && AppConstants.userData?.permissions?.delivery?.actions?.list ?? 0 == 0 && AppCommonMethods.fetchSiteSettingValue(key: "is_dinein") ?? "" == "false" && AppConstants.userData?.permissions?.dinein?.actions?.list ?? 0 == 0{
                btnChangeOrder.superview?.superview?.isHidden = true
            }
        }else if self.orderType.id ?? 0 == 3{
            if AppCommonMethods.fetchSiteSettingValue(key: "is_collection") ?? "" == "false" && AppConstants.userData?.permissions?.collection?.actions?.list ?? 0 == 0 && AppCommonMethods.fetchSiteSettingValue(key: "is_waiting") ?? "" == "false" && AppConstants.userData?.permissions?.waiting?.actions?.list ?? 0 == 0 && AppCommonMethods.fetchSiteSettingValue(key: "is_dinein") ?? "" == "false" && AppConstants.userData?.permissions?.dinein?.actions?.list ?? 0 == 0{
                btnChangeOrder.superview?.superview?.isHidden = true
            }
        }else{
            if AppCommonMethods.fetchSiteSettingValue(key: "is_collection") ?? "" == "false" && AppConstants.userData?.permissions?.collection?.actions?.list ?? 0 == 0 && AppCommonMethods.fetchSiteSettingValue(key: "is_waiting") ?? "" == "false" && AppConstants.userData?.permissions?.waiting?.actions?.list ?? 0 == 0 && AppCommonMethods.fetchSiteSettingValue(key: "is_delivery") ?? "" == "false" && AppConstants.userData?.permissions?.delivery?.actions?.list ?? 0 == 0{
                btnChangeOrder.superview?.superview?.isHidden = true
            }
        }
        
        if AppConstants.userData?.permissions?.misc?.actions?.list ?? 0 == 0{
            btnMisc.superview?.superview?.isHidden = true
        }else{
            btnMisc.superview?.superview?.isHidden = false
        }
        
        if AppConstants.userData?.permissions?.comment?.actions?.list ?? 0 == 0{
            btnComment.superview?.superview?.isHidden = true
        }else{
            btnComment.superview?.superview?.isHidden = false
        }
        
        if orderData?.total ?? 0 == 0{
            btnPayCash.superview?.isHidden = true
        }else{
            btnPayCash.superview?.isHidden = false
        }
    }
    
    func checkOrderSplite()->Bool{
        if orderData == nil{
            return false
        }
        if arrGroups.count > 0 || orderData?.splitCount ?? 0 > 0{
            return true
        }
        return false
    }
    
    func setOrderView(){
        totalPrice = 0.0
        self.arrNormalProducts = self.arrNormalProducts.sorted{ $0.updatedAt > $1.updatedAt }
        arrGroups.forEach { model in
            model.arrProducts = model.arrProducts.sorted{ $0.updatedAt > $1.updatedAt }
        }
        let shouldUpdateDiscount = !arrGroups.contains { $0.autoDiscountRemove && $0.discount > 0 }
        let shouldUpdateServiceCharge = !arrGroups.contains { $0.autoServiceChargeRemove && $0.serviceCharge > 0 }
        let shouldUpdateGratuity = !arrGroups.contains { $0.autoGratuityRemove && $0.gratuity > 0 }
        var totalNewPrice = 0.0
        if self.orderData?.splitCount ?? 0 > 0{
            for i in 0..<self.orderData!.arrOrderSplit.count{
                let noOfPerson = self.orderData?.splitCount ?? 0
                let group = self.orderData!.arrOrderSplit[i]
                if group.subTotal == 0{
                    let subTotal = ((self.orderData!.subTotal ?? 0)/Double(noOfPerson)).getFloorFigure()
                    let serviceCharge = ((self.orderData!.serviceCharge ?? 0)/Double(noOfPerson)).getFloorFigure()
                    let gratuity = ((self.orderData!.gratuity ?? 0)/Double(noOfPerson)).getFloorFigure()
                    let discount = ((self.orderData!.discount ?? 0)/Double(noOfPerson)).getFloorFigure()
                    if i+1 == noOfPerson{
                        group.subTotal = ((self.orderData!.subTotal ?? 0) - (subTotal*Double(noOfPerson-1))).getFloorFigure()
                        group.serviceCharge = ((self.orderData!.serviceCharge ?? 0) - (serviceCharge*Double(noOfPerson-1))).getFloorFigure()
                        group.gratuity = ((self.orderData!.gratuity ?? 0) - (gratuity*Double(noOfPerson-1))).getFloorFigure()
                        group.discount = ((self.orderData!.discount ?? 0) - (discount*Double(noOfPerson-1))).getFloorFigure()
                    }else{
                        group.subTotal = subTotal
                        group.serviceCharge = serviceCharge
                        group.gratuity = gratuity
                        group.discount = discount
                    }
                }
                group.total = group.subTotal + group.serviceCharge + group.gratuity - group.discount
            }
        }else{
            for group in arrGroups{
                var totalGroupPrice = 0.0
                group.arrProducts.forEach { (model) in
                    if !model.isDelete{
                        model.subTotal = (model.price ?? 0) * (Double(model.quantity ?? 0))
                        
                        model.addonPrice = 0
                        
                        model.arrAddons.forEach({ (addon) in
                            model.addonPrice = (model.addonPrice ?? 0) + ((addon.price ?? 0) * Double(addon.quantity)) * (Double(model.quantity ?? 0))
                        })
                        
                        model.ingredientsPrice = 0
                        
                        model.arrIngriedent.forEach({ (ingrident) in
                            model.ingredientsPrice = (model.ingredientsPrice ?? 0) + ((ingrident.price ?? 0) * Double(ingrident.quantity ?? 0)) * (Double(model.quantity ?? 0))
                        })
                        
                        let instructionPrice = ((model.instructionPrice ?? 0) * Double(model.quantity ?? 0))
                        model.total = (model.subTotal ?? 0) + (model.addonPrice ?? 0) + (model.ingredientsPrice ?? 0) + instructionPrice
                        
                        totalGroupPrice += (model.total ?? 0)
                    }
                }
                group.subTotal = totalGroupPrice
                if shouldUpdateDiscount && self.discount > 0 && !group.autoDiscountRemove{
                    group.discount = self.discount * totalGroupPrice / (self.orderData?.subTotal ?? 0)
                }
                if shouldUpdateServiceCharge && self.serviceCharge > 0 && !group.autoServiceChargeRemove{
                    group.serviceCharge = self.serviceCharge * totalGroupPrice / (self.orderData?.subTotal ?? 0)
                }
                if shouldUpdateGratuity && self.gratuity > 0 && !group.autoGratuityRemove{
                    group.gratuity = self.gratuity * totalGroupPrice / (self.orderData?.subTotal ?? 0)
                }
                group.total = totalGroupPrice + group.serviceCharge + group.gratuity - group.discount
                totalNewPrice += totalGroupPrice
            }
        }
        arrNormalProducts.forEach { (model) in
            if !model.isDelete{
                model.subTotal = (model.price ?? 0) * (Double(model.quantity ?? 0))
                
                model.addonPrice = 0
                
                model.arrAddons.forEach({ (addon) in
                    model.addonPrice = (model.addonPrice ?? 0) + ((addon.price ?? 0) * Double(addon.quantity)) * (Double(model.quantity ?? 0))
                })
                
                model.ingredientsPrice = 0
                
                model.arrIngriedent.forEach({ (ingrident) in
                    model.ingredientsPrice = (model.ingredientsPrice ?? 0) + ((ingrident.price ?? 0) * Double(ingrident.quantity ?? 0)) * (Double(model.quantity ?? 0))
                })
                
                let instructionPrice = ((model.instructionPrice ?? 0) * Double(model.quantity ?? 0))
                model.total = (model.subTotal ?? 0) + (model.addonPrice ?? 0) + (model.ingredientsPrice ?? 0) + instructionPrice
                
                totalNewPrice += (model.total ?? 0)
            }
        }
        totalPrice = totalNewPrice + totalPrice
        checkForServiceCharge()
        
        orderData?.subTotal = totalPrice
        
        grandAmount = (totalPrice + gratuity + serviceCharge + deliveryCharge)
        
        checkForAutoDiscountType()
        
        grandAmount = grandAmount - discount
        
        orderData?.total = grandAmount.getRoundFigure()
        
        if orderComment != ""{
            lblOrderComment.text = "Instruction: \(orderComment)"
            viewForComment.isHidden = false
        }else{
            viewForComment.isHidden = true
        }
        self.lblGrandTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign, orderData?.total ?? 0)
        
        self.lblSubTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign,orderData?.subTotal ?? 0)
        self.lblDiscount.superview?.superview?.isHidden = true
        self.lblServiceCharge.superview?.superview?.isHidden = true
        self.lblGratuity.superview?.superview?.isHidden = true
        self.lblDeliveryCharge.superview?.isHidden = true
        self.lblSubTotal.superview?.isHidden = true
        if isPriceBreakupShow{
            if discount != 0{
                self.lblDiscount.text = String.init(format: "-%@%.2f", AppConstants.currencySign, discount)
                self.lblDiscount.superview?.superview?.isHidden = false
            }
            if serviceCharge != 0{
                self.lblServiceCharge.text = String.init(format: "%@%.2f", AppConstants.currencySign, serviceCharge)
                self.lblServiceCharge.superview?.superview?.isHidden = false
            }
            if gratuity != 0{
                self.lblGratuity.text = String.init(format: "%@%.2f", AppConstants.currencySign, gratuity)
                self.lblGratuity.superview?.superview?.isHidden = false
            }
            if deliveryCharge != 0{
                self.lblDeliveryCharge.text = String.init(format: "%@%.2f", AppConstants.currencySign, deliveryCharge)
                self.lblDeliveryCharge.superview?.isHidden = false
            }
            self.lblSubTotal.superview?.isHidden = false
        }
        btnHome.setTitle(" Home ", for: .normal)
        btnOrderType.setTitle(" \(self.orderType.type ?? "") ", for: .normal)
        self.tblProducts.reloadData()
        self.collectionProduct.reloadData()
        self.setOrderButtons()
    }
    
    func checkOrderValidation()->Bool{
        if arrNormalProducts.count == 0 && arrGroups.count == 0{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.kAddProduct, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }
        
        return true
    }
    
    func getProductFromDataBase(){
        var categoryId = selectedMainCategory?.id ?? 0
        if selectedSubCategory != nil{
            categoryId = selectedSubCategory?.id ?? 0
        }
        self.arrProducts = CoreDataHelper.shared.fetchProductData(categoryId: categoryId, oderTypeId: orderType.id ?? 0, isBanquet: isBanquetOrder)
        self.collectionProduct.reloadData()
    }
    
    func showOrderModifiedToast(isFromAdd:Bool = false) -> Bool{
        if orderData?.orderStatusId ?? 0 == 10{
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_CANCELLED)
            return false
        }
        if orderData?.orderStatusId ?? 0 == 5{
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_COMPLETED)
            return false
        }
        if orderData?.orderStatusId ?? 0 == 6{
            if orderType.id ?? 0 == 3{
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_OTW)
            }else{
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_RTC)
            }
            return false
        }
        if orderData?.splitCount ?? 0 > 0{
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_SPLITED)
            return false
        }
        if !isFromAdd{
            if orderData?.totalPaid ?? 0 > 0{
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_PAYMENT)
                return false
            }
        }
        if orderData?.totalPaid ?? 0 >= orderData?.total ?? 0 && orderData?.total ?? 0 > 0{
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_PAYMENT)
            return false
        }
        return true
    }
    
    func createOrderPoructModel(model:ProductModel)->OrderProductModel?{
        let dictProduct = NSMutableDictionary()
        dictProduct["id"] = Date().millisecondsSince1970
        dictProduct["product_id"] = "\(model.id ?? 0)"
        dictProduct["product_name"] = model.name ?? ""
        dictProduct["quantity"] = "\(model.quantity)"
        dictProduct["special_instruction"] = ""
        dictProduct["instruction_price"] = 0
        dictProduct["updater_id"] = AppConstants.userData?.id ?? 0
        dictProduct["item_unique_id"] = Date().millisecondsSince1970
        
        if isBanquetOrder{
            dictProduct["preparation_location_id"] = model.banquetPreparationLocationId ?? 0
            dictProduct["price"] = "\(model.waitingPrice ?? 0)"
            dictProduct["sub_total"] = "\(Double(model.quantity) * (model.waitingPrice ?? 0))"
        }else{
            if orderType.id ?? 0 == 2 || orderType.id ?? 0 == 5{
                dictProduct["preparation_location_id"] = model.takeawayPreparationLocationId ?? 0
                dictProduct["price"] = "\(model.takeawayPrice ?? 0)"
                dictProduct["sub_total"] = "\(Double(model.quantity) * (model.takeawayPrice ?? 0))"
            }else if orderType.id ?? 0 == 3{
                dictProduct["preparation_location_id"] = model.deliveryPreparationLocationId ?? 0
                dictProduct["price"] = "\(model.deliveryPrice ?? 0)"
                dictProduct["sub_total"] = "\(Double(model.quantity) * (model.deliveryPrice ?? 0))"
            }else{
                dictProduct["preparation_location_id"] = model.preparationLocationId ?? 0
                dictProduct["price"] = "\(model.price ?? 0)"
                dictProduct["sub_total"] = "\(Double(model.quantity) * (model.price ?? 0))"
            }
        }
        
        if model.arrSelectedAddOn?.count ?? 0 > 0{
            var arrAddon = [NSMutableDictionary]()
            for addon in model.arrSelectedAddOn!{
                let dictAddon = NSMutableDictionary()
                dictAddon["id"] = addon.addOnId ?? Date().millisecondsSince1970
                dictAddon["addon_id"] = "\(addon.id ?? 0)"
                dictAddon["addon_name"] = addon.name ?? ""
                dictAddon["updater_id"] = AppConstants.userData?.id ?? 0
                if isBanquetOrder{
                    dictAddon["total"] = "\(addon.waitingPrice ?? 0)"
                    dictAddon["price"] = "\(addon.waitingPrice ?? 0)"
                }else{
                    if orderType.id ?? 0 == 3{
                        dictAddon["total"] = "\(addon.deliveryPrice ?? 0)"
                        dictAddon["price"] = "\(addon.deliveryPrice ?? 0)"
                    }else if orderType.id ?? 0 == 2 || orderType.id ?? 0 == 5{
                        dictAddon["total"] = "\(addon.takeawayPrice ?? 0)"
                        dictAddon["price"] = "\(addon.takeawayPrice ?? 0)"
                    }else{
                        dictAddon["total"] = "\(addon.price ?? 0)"
                        dictAddon["price"] = "\(addon.price ?? 0)"
                    }
                }
                dictAddon["quantity"] = "1"
                arrAddon.append(dictAddon)
            }
            dictProduct["order_item_addons"] = arrAddon
        }
        let jsonDecoder = JSONDecoder()
        if let data = AppCommonMethods.convertToJson(object: dictProduct), let aData = try? jsonDecoder.decode(OrderProductModel.self, from: data){
            aData.product = model
            aData.isItemUpdated = 1
            return aData
        }
        return nil
    }
    
    func printBillAction(){
        var payBillAction = "pay_bill_action"
        if self.orderType.id ?? 0 == 2{
            payBillAction = "pickup_pay_bill_action"
        }else if self.orderType.id ?? 0 == 5{
            payBillAction = "waiting_pay_bill_action"
        }else if self.orderType.id ?? 0 == 3{
            payBillAction = "delivery_pay_bill_action"
        }
        if AppCommonMethods.fetchSiteSettingValue(key: payBillAction) ?? "" == "prep_ticket"{
            if AppCommonMethods.fetchSiteSettingValue(key: "kitchen_copy_type") ?? "" == "manual"{
                AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_KITCHEN_COPY, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                    if index == 1{
                        PrintManager.shared.isPrintingBill = false
                        PrintManager.shared.connectToPrinterWithPrintOrder(order: self.orderData!, controller: self)
                    }else{
                        AppCommonMethods.stopProgressBar()
                        if self.orderData?.orderStatusId ?? 0 <= 2{
                            self.CallCreateOrderAPI(orderStatusId: 2, action: 3, shouldPrint: true)
                        }else{
                            self.CallCreateOrderAPI(action: 3, shouldPrint: true)
                        }
                    }
                }
            }else{
                PrintManager.shared.isPrintingBill = false
                PrintManager.shared.connectToPrinterWithPrintOrder(order: orderData!, controller: self)
            }
        }else if AppCommonMethods.fetchSiteSettingValue(key: payBillAction) ?? "" == "both"{
            printAllAction()
        }else if AppCommonMethods.fetchSiteSettingValue(key: payBillAction) ?? "" == "bill"{
            if AppCommonMethods.fetchSiteSettingValue(key: "pay_bill_action_type") ?? "" == "manual"{
                AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_ORDER_BILL, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                    if index == 1{
                        PrintManager.shared.isSplitBillCopy = false
                        PrintManager.shared.isPrintingBill = true
                        PrintManager.shared.connectToPrinterWithPrint(model: self.orderData!, controller: self)
                    }else{
                        AppCommonMethods.stopProgressBar()
                        if self.orderData?.orderStatusId ?? 0 <= 2{
                            self.CallCreateOrderAPI(orderStatusId: 2, action: 3, shouldPrint: true)
                        }else{
                            self.CallCreateOrderAPI(action: 3, shouldPrint: true)
                        }
                    }
                }
            }else{
                PrintManager.shared.isSplitBillCopy = false
                PrintManager.shared.isPrintingBill = true
                PrintManager.shared.connectToPrinterWithPrint(model: orderData!, controller: self)
            }
        }else{
            AppCommonMethods.stopProgressBar()
            if self.orderData?.orderStatusId ?? 0 <= 2{
                CallCreateOrderAPI(orderStatusId: 2, action: 3, shouldPrint: true)
            }else{
                self.CallCreateOrderAPI(action: 3, shouldPrint: true)
            }
        }
    }
    
    func printKitchCopyAction(){
        if AppCommonMethods.fetchSiteSettingValue(key: "send_order_action") ?? "" == "prep_ticket"{
            if AppCommonMethods.fetchSiteSettingValue(key: "kitchen_copy_type") ?? "" == "manual"{
                AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_KITCHEN_COPY, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                    if index == 1{
                        PrintManager.shared.isPrintingBill = false
                        PrintManager.shared.connectToPrinterWithPrintOrder(order: self.orderData!, controller: self)
                    }else{
                        AppCommonMethods.stopProgressBar()
                        if self.orderData?.orderStatusId ?? 0 <= 2{
                            self.CallCreateOrderAPI(orderStatusId: 2, action: 3, shouldPrint: true)
                        }else{
                            self.CallCreateOrderAPI(action: 3, shouldPrint: true)
                        }
                    }
                }
            }else{
                PrintManager.shared.isPrintingBill = false
                PrintManager.shared.connectToPrinterWithPrintOrder(order: orderData!, controller: self)
            }
        }else{
            AppCommonMethods.stopProgressBar()
            if self.orderData?.orderStatusId ?? 0 <= 2{
                self.CallCreateOrderAPI(orderStatusId: 2, action: 3, shouldPrint: true)
            }else{
                self.CallCreateOrderAPI(action: 3, shouldPrint: true)
            }
        }
    }
    
    func printAllAction(){
        PrintManager.shared.connectToPrinterWithPrintOrder(order: self.orderData!, controller: self, isPrintAll: true)
    }
    
    //MARK:  Button Actions
    @IBAction func btnDeleteProductAction(_ sender:UIButton){
        self.view.endEditing(true)
        if showOrderModifiedToast(){
            let section = Int(sender.accessibilityIdentifier ?? "") ?? 0
            var product:OrderProductModel!
            if section == 0{
                product = arrNormalProducts[sender.tag]
            }else{
                product = arrGroups[section-1].arrProducts[sender.tag]
            }
            product.updatedAt = Date().getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
            product.isDelete = true
            SQLiteManage.deleteOrderItem(productId: product.id ?? 0, orderId: self.orderData?.id ?? 0)
            setOrderView()
            if orderData?.orderStatusId ?? 0 <= 2{
                CallCreateOrderAPI(orderStatusId: 1)
            }else{
                CallCreateOrderAPI()
            }
        }
    }
    
    @IBAction func btnDiscountAction(_ sender:UIButton){
        passwordType = 2
        if AppCommonMethods.fetchSiteSettingValue(key: "discount_password_enable") ?? "" == "true"{
            var setting = AlertSetting()
            setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
            setting.alertMessage = "Please enter your password to apply discount"
            setting.textPlcaeholder = "password"
            setting.type = .kEnterUserPassword
            setting.textType = .default
            if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
                VC.delegate = self
            }
            return
        }
        constActionTrailingSpace.constant = -295
        UIView.animate(withDuration: 0.25) {
            self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
            self.view.layoutIfNeeded()
        }
        btnHome.setTitle(" \(orderType.type ?? "") ", for: .normal)
        btnOrderType.setTitle(" Discount ", for: .normal)
        if let VC = AddGratuityVC.showPopup(parentVC: self, amount: discount, totalAmount: totalPrice, type: .kDiscount){
            VC.delegate = self
        }
    }
    
    @IBAction func btnChangeOrderAction(_ sender:UIButton){
        constActionTrailingSpace.constant = -295
        UIView.animate(withDuration: 0.25) {
            self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
            self.view.layoutIfNeeded()
        }
        if let VC = ConvertOrderVC.showPopup(parentVC: self, type: self.orderType,table: self.selectedTable){
            VC.delegate = self
        }
    }
    
    @IBAction func btnCancelOrderAction(_ sender:UIButton){
        self.view.endEditing(true)
        passwordType = 1
        if AppCommonMethods.fetchSiteSettingValue(key: "cancel_order_password_enable") ?? "" == "true"{
            var setting = AlertSetting()
            setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_CANCELORDER
            setting.textPlcaeholder = "password"
            setting.type = .kEnterUserPassword
            setting.textType = .default
            if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
                VC.delegate = self
            }
            return
        }
        var setting = AlertSetting()
        setting.alertMessage = AppConstants.GlobalAlert.ALERT_CANCEL_ORDER
        setting.alertTitle = AppConstants.GlobalAlert.ALERT_CANCEL_ORDER_TITLE
        if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
            VC.delegate = self
        }
    }
    
    @IBAction func btnDeleteOrderAction(_ sender:UIButton){
        self.view.endEditing(true)
        passwordType = 0
        if orderData?.totalPaid ?? 0 > 0{
            var setting = AlertSetting()
            setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_DELETEORDER
            setting.textPlcaeholder = "password"
            setting.type = .kEnterUserPassword
            setting.textType = .default
            if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
                VC.delegate = self
            }
            return
        }
        var setting = AlertSetting()
        setting.alertMessage = AppConstants.GlobalAlert.ALERT_DELETE_ORDER
        setting.alertTitle = AppConstants.GlobalAlert.ALERT_DELETE_ORDER_TITLE
        if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
            VC.delegate = self
        }
    }
    
    @IBAction func btnCompleteOrderAction(_ sender:UIButton){
        constActionTrailingSpace.constant = -295
        UIView.animate(withDuration: 0.25) {
            self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
            self.view.layoutIfNeeded()
        }
        if selectedTable != nil{
            if let status = CoreDataHelper.shared.fetchTableStatusData(name: "Served and paid").first{
                AppCommonMethods.SaveTable(table: selectedTable!, statusId: status.id)
                selectedTable?.tableStatus = status
                selectedTable?.tableStatusId = status.id ?? 0
                orderData?.table = selectedTable
                SQLiteManage.updateTableStatus(tableId: selectedTable?.id ?? 0, statusId: status.id)
            }else{
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
            }
        }
        
        CallCreateOrderAPI(orderStatusId: 5, action: 3)
    }
    
    @IBAction func btnOrderTransitAction(_ sender:UIButton){
        constActionTrailingSpace.constant = -295
        UIView.animate(withDuration: 0.25) {
            self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
            self.view.layoutIfNeeded()
        }
        CallCreateOrderAPI(orderStatusId: 6, action: 3)
    }
    
    @IBAction func btnSwapTableAction(_ sender:UIButton){
        constActionTrailingSpace.constant = -295
        UIView.animate(withDuration: 0.25) {
            self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
            self.view.layoutIfNeeded()
        }
        var isOfflineOrder = true
        if orderData?.isNewOrder == nil && orderId == nil{
            
        }else{
            if orderData?.isNewOrder ?? 0 == 0{
                isOfflineOrder = false
            }
        }
        if let VC = SwapTableVC.showPopup(parentVC: self, table: self.selectedTable!, orderId: self.orderId ?? 0, isOfflineOrder: isOfflineOrder, orderTotal: self.orderData?.total, orderTime: self.orderData?.deliveryDate, orderPaid:self.orderData?.totalPaid ?? 0){
            VC.delegate = self
        }
    }
    
    @IBAction func btnSplitAction(_ sender:UIButton){
        if checkOrderSplite(){
            AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: "Are you sure want to unsplit the order?", withActionsTitle: ["No", "Yes"]) { index in
                if index == 1{
                    _ = SQLiteManage.ExecuteQuery("DELETE FROM OrderGroup WHERE order_id = \(self.orderId ?? 0)")
                    _ = SQLiteManage.ExecuteQuery("UPDATE OrderProducts SET order_split_id = NULL, group_unique_id = '' WHERE order_id = \(self.orderId ?? 0)")
                    _ = SQLiteManage.ExecuteQuery("UPDATE Orders SET split_count = 0 WHERE id = \(self.orderId ?? 0)")
                    self.fetchOrderFromDB()
                }
            }
        }else{
            constActionTrailingSpace.constant = -295
            UIView.animate(withDuration: 0.25) {
                self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
                self.view.layoutIfNeeded()
            }
            if checkOrderValidation(){
                if Reachabilities.shared.isConnectedToNetwork(){
                    CallCreateOrderAPI(action: 2)
                }else{
                    if let VC = SplitOrderVC.instance(){
                        VC.orderType = self.orderType
                        VC.selectedTable = selectedTable
                        VC.orderData = AppCommonMethods.Copy(of: orderData!) ?? orderData!
                        self.navigationController?.pushViewController(VC, animated: true)
                    }
                }
            }
        }
    }
    
    @IBAction func btnExpandAction(_ sender:UIButton){
        self.view.endEditing(true)
        if constActionTrailingSpace.constant == 0{
            constActionTrailingSpace.constant = -295
        }else{
            constActionTrailingSpace.constant = 0
        }
        
        UIView.animate(withDuration: 0.25) {
            if self.constActionTrailingSpace.constant == 0{
                self.btnExpand.transform = CGAffineTransform(rotationAngle: .pi)
            }else{
                self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
            }
            self.view.layoutIfNeeded()
        }
    }
    
    @IBAction func btnAddGratuityAction(_ sender:UIButton){
        constActionTrailingSpace.constant = -295
        UIView.animate(withDuration: 0.25) {
            self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
            self.view.layoutIfNeeded()
        }
        btnHome.setTitle(" \(orderType.type ?? "") ", for: .normal)
        btnOrderType.setTitle(" Gratuity ", for: .normal)
        if checkOrderValidation(){
            if let VC = AddGratuityVC.showPopup(parentVC: self, amount: gratuity, totalAmount: totalPrice){
                VC.delegate = self
            }
        }
    }
    
    @IBAction func btnABackAction(_ sender:UIButton){
        if AppCommonMethods.fetchSiteSettingValue(key: "auto_delivery_time_slot") ?? "" == "true"{
            if self.orderData?.isDeliveryCollectionAsk ?? false{
                if self.orderData?.orderStatusId ?? 0 <= 2{
                    CallCreateOrderAPI(orderStatusId: 2, action: 3)
                }else{
                    CallCreateOrderAPI(action: 3)
                }
            }else{
                if let VC = SelectTimeSlotVC.showPopup(parentVC: self){
                    VC.delegate = self
                }
            }
        }else{
            if self.orderData?.orderStatusId ?? 0 <= 2{
                CallCreateOrderAPI(orderStatusId: 2, action: 3)
            }else{
                CallCreateOrderAPI(action: 3)
            }
        }
    }
    
    @IBAction func btnMiscAction(_ sender:UIButton){
        if showOrderModifiedToast(){
            constActionTrailingSpace.constant = -295
            btnHome.setTitle(" \(orderType.type ?? "") ", for: .normal)
            btnOrderType.setTitle(" Miscellaneous ", for: .normal)
            UIView.animate(withDuration: 0.25) {
                self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
                self.view.layoutIfNeeded()
            }
            if showOrderModifiedToast(isFromAdd: true){
                if let VC = MiscellaneousVC.showPopup(parentVC: self){
                    VC.delegate = self
                }
            }
        }
    }
    
    @IBAction func btnCommentAction(_ sender:UIButton){
        constActionTrailingSpace.constant = -295
        btnHome.setTitle(" \(orderType.type ?? "") ", for: .normal)
        btnOrderType.setTitle(" Instructions ", for: .normal)
        UIView.animate(withDuration: 0.25) {
            self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
            self.view.layoutIfNeeded()
        }
        if let VC = AddCommentVC.addContainer(parentVC: self, comment: orderComment){
            VC.delegate = self
        }
    }
    
    @IBAction func btnVoucherAction(_ sender:UIButton){
        constActionTrailingSpace.constant = -295
        btnHome.setTitle(" \(orderType.type ?? "") ", for: .normal)
        btnOrderType.setTitle(" Voucher ", for: .normal)
        UIView.animate(withDuration: 0.25) {
            self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
            self.view.layoutIfNeeded()
        }
        if checkOrderValidation(){
            if Reachabilities.shared.isConnectedToNetwork(){
                CallCreateOrderAPI(action: 4)
            }else{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.kNoInternetMsg, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
    
    @IBAction func btnServiceChargeAction(_ sender:UIButton){
        constActionTrailingSpace.constant = -295
        btnHome.setTitle(" \(orderType.type ?? "") ", for: .normal)
        btnOrderType.setTitle(" Service Charge ", for: .normal)
        UIView.animate(withDuration: 0.25) {
            self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
            self.view.layoutIfNeeded()
        }
        if checkOrderValidation(){
            if let VC = AddGratuityVC.showPopup(parentVC: self, amount: serviceCharge, totalAmount: totalPrice, type: .kServiceCharge){
                VC.delegate = self
            }
        }
    }
    
    @IBAction func btnDeliveryChargeAction(_ sender:UIButton){
        constActionTrailingSpace.constant = -295
        btnHome.setTitle(" \(orderType.type ?? "") ", for: .normal)
        btnOrderType.setTitle(" Delivery ", for: .normal)
        UIView.animate(withDuration: 0.25) {
            self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
            self.view.layoutIfNeeded()
        }
        if checkOrderValidation(){
            if let VC = AddGratuityVC.showPopup(parentVC: self, amount: deliveryCharge, totalAmount: totalPrice, type: .kDeliveryCharge){
                VC.delegate = self
            }
        }
    }
    
    @IBAction func btnCardPayAction(_ sender:UIButton){
        self.view.endEditing(true)
        if checkOrderValidation(){
            CallCreateOrderAPI(action: 7)
        }
    }
    
    @IBAction func btnCashPayAction(_ sender:UIButton){
        self.view.endEditing(true)
        if checkOrderValidation(){
            if AppCommonMethods.fetchSiteSettingValue(key: "partial_payment_mode") ?? "" == "no" && arrGroups.count == 0{
                passwordType = 3
                let remainingAmount = (self.orderData?.total ?? 0) - (self.orderData?.totalPaid ?? 0)
                self.orderData?.totalPaid = self.orderData?.total ?? 0
                self.setOrderView()
                SQLiteManage.updateOrderTotalPaid(id: self.orderData?.uniqueId ?? "", amount: remainingAmount)
                let paymentModel = PaymentOrderModel()
                paymentModel.id = Date().millisecondsSince1970
                paymentModel.amount = remainingAmount
                paymentModel.updaterId = AppConstants.userData?.id ?? 0
                paymentModel.txnId = Int(Date().timeIntervalSinceReferenceDate).description
                paymentModel.paymentMethodId = 1
                paymentModel.paymentMethodName = "Cash"
                SQLiteManage.insertOrderPayments(orderId: self.orderId ?? 0, arrPayments: [paymentModel], database: nil, offline: 1)
                self.orderData?.arrOrderPayments.append(paymentModel)
                var setting = AlertSetting()
                setting.confirmTitle = ""
                setting.alertAnimation = "payment_successful"
                setting.cancelTitle = ""
                if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
                    VC.delegate = self
                }
                
                DispatchQueue.main.asyncAfter(deadline: .now()+0.25) {
                    if AppCommonMethods.fetchSiteSettingValue(key: "order_complete_mode") ?? "" == "auto"{
                        if self.selectedTable != nil{
                            if let status = CoreDataHelper.shared.fetchTableStatusData(name: "vacant").first{
                                self.orderData?.table?.tableStatusId = status.id
                                AppCommonMethods.SaveTable(table: self.selectedTable!, statusId: status.id)
                                self.selectedTable?.tableStatusId = status.id
                                SQLiteManage.updateTableStatus(tableId: self.selectedTable?.id ?? 0, statusId: status.id, lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", offline: 1)
                                if let table = SQLiteManage.fetchTableDataFromMergeId(id: self.selectedTable?.id ?? 0){
                                    table.mergeTableId = 0
                                    table.locked = false
                                    table.tableStatusId = status.id ?? 0
                                    if let dictTable = encodeFromModel(table) as? [String:Any]{
                                        SocketService.shared?.sendTableToSocket(data: dictTable, id: table.id ?? 0)
                                    }
                                }
                            }else{
                                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                            }
                        }
                        self.orderData?.orderStatusId = 5
                    }else{
                        if self.selectedTable != nil{
                            if let status = CoreDataHelper.shared.fetchTableStatusData(name: "Served and paid").first{
                                AppCommonMethods.SaveTable(table: self.selectedTable!, statusId: status.id)
                                self.selectedTable?.tableStatus = status
                                self.selectedTable?.tableStatusId = status.id ?? 0
                                self.orderData?.table = self.selectedTable
                                SQLiteManage.updateTableStatus(tableId: self.selectedTable?.id ?? 0, statusId: status.id)
                            }else{
                                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                            }
                        }
                        self.orderData?.orderStatusId = 4
                    }
                    self.CallCreateOrderAPI(action: 3)
                }
            }else{
                CallCreateOrderAPI(action: 6)
            }
        }
    }
    
    @IBAction func btnViewOrderDetailAction(_ sender:UIButton){
        self.view.endEditing(true)
        if checkOrderValidation(){
            CallCreateOrderAPI(action: 1)
        }
    }
    
    @IBAction func btnEditQuantityAction(_ sender:UIButton){
        self.view.endEditing(true)
        if showOrderModifiedToast(){
            isEditOrder = !isEditOrder
            tblProducts.reloadData()
            if isEditOrder{
                viewForEdit.isHidden = false
            }else{
                viewForEdit.isHidden = true
            }
        }
    }
    
    @IBAction func btnPlusProductAction(_ sender:UIButton){
        self.view.endEditing(true)
        if showOrderModifiedToast(){
            let section = Int(sender.accessibilityIdentifier ?? "") ?? 0
            var model:OrderProductModel!
            if section == 0{
                model = arrNormalProducts[sender.tag]
            }else{
                model = arrGroups[section - 1].arrProducts[sender.tag]
            }
            model.updatedAt = Date().getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
            model.quantity  = (model.quantity ?? 0) + 1
            if model.sentToKitchen{
                model.sentToKitchenQuantity += 1
            }else{
                model.sentToKitchenQuantity = model.quantity ?? 0
            }
            self.setOrderView()
            if orderData?.orderStatusId ?? 0 <= 2{
                CallCreateOrderAPI(orderStatusId: 1)
            }else{
                CallCreateOrderAPI()
            }
        }
        
    }
    
    @IBAction func btnMinusProductAction(_ sender:UIButton){
        self.view.endEditing(true)
        if showOrderModifiedToast(){
            let section = Int(sender.accessibilityIdentifier ?? "") ?? 0
            var model:OrderProductModel!
            if section == 0{
                model = arrNormalProducts[sender.tag]
            }else{
                model = arrGroups[section-1].arrProducts[sender.tag]
            }
            model.updatedAt = Date().getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
            if model.quantity ?? 0 <= 1{
                SQLiteManage.deleteOrderItem(productId: model.id ?? 0, orderId: self.orderData?.id ?? 0)
                model.isDelete = true
            }else{
                model.quantity = (model.quantity ?? 0) - 1
                if model.sentToKitchen{
                    if model.sentToKitchenQuantity > 0{
                        model.sentToKitchenQuantity -= 1
                    }
                }else{
                    model.sentToKitchenQuantity = model.quantity ?? 0
                }
            }
            self.setOrderView()
            if orderData?.orderStatusId ?? 0 <= 2{
                CallCreateOrderAPI(orderStatusId: 1)
            }else{
                CallCreateOrderAPI()
            }
        }
    }
    
    @IBAction func btnProductViewAction(_ sender: UIButton) {
        self.view.endEditing(true)
        if isEditOrder{
            return
        }
        let section = Int(sender.accessibilityIdentifier ?? "") ?? 0
        var model:OrderProductModel!
        if section == 0{
            model = arrNormalProducts[sender.tag]
        }else{
            model = arrGroups[section-1].arrProducts[sender.tag]
        }
        if model.isDelete{
            return
        }
        if showOrderModifiedToast(isFromAdd: true){
            if AppConstants.userData?.permissions?.modify?.actions?.list ?? 0 == 1{
                if AppCommonMethods.fetchSiteSettingValue(key: "addon_theme") ?? "" == "theme2"{
                    if let VC = AddOnTheme2VC.addToChildView(parentVC: self, index: sender.tag, orderType: self.orderType, isBanquetOrder: self.isBanquetOrder, orderProduct: AppCommonMethods.Copy(of: model) ?? model){
                        self.constContainerLeadingSpace.constant = 25
                        UIView.animate(withDuration: 0.25) {
                            self.view.layoutIfNeeded()
                            self.viewForBG.alpha = 1
                        }
                        VC.delegate = self
                    }
                }else{
                    if let VC = AddOnsVC.addToChildView(parentVC: self, index: sender.tag, orderType: self.orderType, isBanquetOrder: self.isBanquetOrder, orderProduct: AppCommonMethods.Copy(of: model) ?? model){
                        self.constContainerLeadingSpace.constant = (AppConstants.ScreenSize.SCREEN_WIDTH/2.25)
                        UIView.animate(withDuration: 0.25) {
                            self.view.layoutIfNeeded()
                            self.viewForBG.alpha = 1
                        }
                        VC.delegate = self
                    }
                }
            }
        }
    }
    
    @IBAction func btnChangeUserAction(_ sender: UIButton) {
        self.view.endEditing(true)
        constActionTrailingSpace.constant = -295
        UIView.animate(withDuration: 0.25) {
            self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
            self.view.layoutIfNeeded()
        }
        if orderType.id ?? 0 == 1{
            if let VC = NewDineInOrderVC.showPopup(parentVC: self, table: self.selectedTable!, customer: self.selectedCustomer, viewType: .changeCustomer, noOfDiner: noOfGuest ?? 1, orderData:orderData){
                VC.delegate = self
            }
        }else{
            if let VC = NewOrderVC.showPopup(parentVC: self, orderType: orderType, viewType: .changeCustomer, customer: self.selectedCustomer, orderData:orderData){
                VC.delegate = self
            }
        }
    }
    
    @IBAction func txtSearchChanged(_ sender:UITextField){
        if txtSearch.text ?? "" == ""{
            isSearchEnabled = false
        }else{
            isSearchEnabled = true
            arrSearchProducts = CoreDataHelper.shared.fetchSearchProductData(seachTerm: (txtSearch.text ?? "").lowercased(), oderTypeId: orderType.id ?? 0)
        }
        collectionProduct.reloadData()
    }
    
    @IBAction func btnRemovePriceAction(_ sender:UIButton){
        self.view.endEditing(true)
        if sender.tag == 0{
            gratuity = 0
            self.arrGroups.forEach {
                $0.gratuity = 0
                $0.autoGratuityRemove = false
                $0.total = $0.subTotal + $0.serviceCharge - $0.discount
            }
        }else if sender.tag == 1{
            serviceCharge = 0
            orderData?.isAutoServiceChargeRemove = true
            self.arrGroups.forEach {
                $0.serviceCharge = 0
                $0.autoServiceChargeRemove = false
                $0.total = $0.subTotal + $0.gratuity - $0.discount
            }
        }else if sender.tag == 2{
            discount = 0
            self.arrGroups.forEach {
                $0.discount = 0
                $0.autoDiscountRemove = false
                $0.total = $0.subTotal + $0.serviceCharge + $0.gratuity
            }
        }
        setOrderView()
        if orderData?.orderStatusId ?? 0 <= 2{
            CallCreateOrderAPI(orderStatusId: 1)
        }else{
            CallCreateOrderAPI()
        }
    }
    
    @IBAction func btnRemoveCommentAction(_ sender:UIButton){
        self.view.endEditing(true)
        orderComment = ""
        viewForComment.isHidden = true
        CallCreateOrderAPI()
        var settings = BottomAlertSettings()
        settings.bgColor = AppConstants.Colors.kAppThemeRedColor
        settings.strMessage = AppConstants.GlobalAlert.instructionRemoved
        AppValidation().showBottomAlertView(settings: settings)
    }
    
    @IBAction func btnViewMoreProductAction(_ sender:UIButton){
        self.view.endEditing(true)
        let section = Int(sender.accessibilityIdentifier ?? "") ?? 0
        var model:OrderProductModel!
        if section == 0{
            model = arrNormalProducts[sender.tag]
        }else{
            model = arrGroups[section-1].arrProducts[sender.tag]
        }
        if let _ = OrderProductDetailVC.showPopup(parentVC: self, product: model){
            
        }
    }
    
    @IBAction func btnGroupHeaderAction(_ sender:UIButton){
        self.view.endEditing(true)
        if sender.tag == selectedGroupIndex{
            selectedGroupIndex = nil
        }else{
            selectedGroupIndex = sender.tag
        }
        self.tblProducts.reloadData()
    }
    
    @IBAction func btnPriceBreakupShowAction(_ sender:UIButton){
        self.view.endEditing(true)
        isPriceBreakupShow = true
        btnPriceBreakupShow.superview?.isHidden = true
        btnPriceBreakupHide.superview?.isHidden = false
        viewForPriceBreakupSperator.isHidden = false
        setOrderView()
    }
    
    @IBAction func btnPriceBreakupHideAction(_ sender:UIButton){
        self.view.endEditing(true)
        isPriceBreakupShow = false
        btnPriceBreakupShow.superview?.isHidden = false
        btnPriceBreakupHide.superview?.isHidden = true
        viewForPriceBreakupSperator.isHidden = true
        setOrderView()
    }
    
    @IBAction func btnSendOrderAction(_ sender:UIButton){
        if let VC = SendOrderPopup.showPopup(parentVC: self, isSendOrder: true){
            VC.delegate = self
        }
    }
    
    @IBAction func btnPrintOrderAction(_ sender:UIButton){
        if AppCommonMethods.fetchSiteSettingValue(key: "is_printbill") ?? "" == "true" && AppConstants.userData?.permissions?.printBill?.actions?.list ?? 0 == 1 && (AppCommonMethods.fetchSiteSettingValue(key: "is_printall") ?? "" != "true" || AppConstants.userData?.permissions?.printAll?.actions?.list ?? 0 == 0){
            CallCreateOrderAPI(orderStatusId: 12, orderActionId: 5, action: 5)
            return
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_printall") ?? "" == "true" && AppConstants.userData?.permissions?.printAll?.actions?.list ?? 0 == 1 && (AppCommonMethods.fetchSiteSettingValue(key: "is_printbill") ?? "" != "true" || AppConstants.userData?.permissions?.printBill?.actions?.list ?? 0 == 0){
            CallCreateOrderAPI(orderStatusId: 12,orderActionId: 6, action: 5)
            return
        }
        if let VC = SendOrderPopup.showPopup(parentVC: self, isSendOrder: false){
            VC.delegate = self
        }
    }
    
    @IBAction func btnRefreshAction(_ sender:UIButton){
        fetchOrderFromDB()
        tblProducts.reloadData()
    }
    
    @IBAction func btnEstimatedTimeAction(_ sender:UIButton){
        if let VC = SelectTimeSlotVC.showPopup(parentVC: self){
            VC.delegate = self
        }
    }
    
    @IBAction func btnMergeTableAction(_ sender:UIButton){
        constActionTrailingSpace.constant = -295
        UIView.animate(withDuration: 0.25) {
            self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
            self.view.layoutIfNeeded()
        }
        var isOfflineOrder = true
        if orderData?.isNewOrder == nil && orderId == nil{
            
        }else{
            if orderData?.isNewOrder ?? 0 == 0{
                isOfflineOrder = false
            }
        }
        if let VC = SwapTableVC.showPopup(parentVC: self, table: self.selectedTable!, orderId: self.orderId ?? 0, isOfflineOrder: isOfflineOrder, orderTotal: self.orderData?.total, orderTime: self.orderData?.deliveryDate, orderPaid:self.orderData?.totalPaid ?? 0, isMergeTable: true){
            VC.delegate = self
        }
    }
    
    //MARK: Database Methods
    func FetchCategoryList(){
        self.arrCategory = CoreDataHelper.shared.fetchCategoryData(orderTypeId: self.orderType.id ?? 0, isBanquet: isBanquetOrder)
        self.collectionMainCategory.reloadData()
        self.selectedMainCategory = self.arrCategory.first
        self.arrSubCategory = CoreDataHelper.shared.fetchChildCategoryData(parentId: self.selectedMainCategory?.id ?? 0, orderTypeId: self.orderType.id ?? 0, isBanquet: isBanquetOrder)
        if arrSubCategory.count == 0{
            constSubCategoryHeight.constant = 0
        }else{
            if CoreDataHelper.shared.fetchProductCount(categoryId: selectedMainCategory?.id ?? 0, oderTypeId: self.orderType.id ?? 0) == 0{
                selectedSubCategory = self.arrSubCategory.first
            }
            if arrSubCategory.count == 1{
                constSubCategoryHeight.constant = 74
            }else{
                constSubCategoryHeight.constant = 148
            }
        }
        self.collectionSubCategory.reloadData()
    }
    
    func CallCreateOrderAPI(orderStatusId:Int? = nil, orderActionId:Int? = nil, action:Int = 0, oldTable:TableModel? = nil, newTable:TableModel? = nil, shouldPrint:Bool = false){
        if orderData == nil{
            var dictOrder = [String:Any]()
            dictOrder["customer_id"] = "\(selectedCustomer?.id ?? 0)"
            
            self.orderId = Int(Date().timeIntervalSinceReferenceDate)
            dictOrder["id"] = self.orderId
            dictOrder["unique_id"] = Int("\(Int(Date().timeIntervalSinceReferenceDate))\(AppConstants.businessData?.id ?? 0)\(AppConstants.DeviceId)")!
            dictOrder["created_at"] = Date().getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss")
            if selectedTable != nil{
                SQLiteManage.updateTableStatus(tableId: self.selectedTable?.id ?? 0, lastOrderId: self.orderId, lastOrderTime: self.orderData?.deliveryDate, offline: 1)
                dictOrder["table_id"] = "\(selectedTable?.id ?? 0)"
                dictOrder["no_guest"] = "\(noOfGuest ?? 0)"
            }else{
                dictOrder["table_id"] = ""
                dictOrder["no_guest"] = ""
            }
            
            dictOrder["order_type_id"] = "\(orderType.id ?? 0)"
            dictOrder["order_type"] = orderType.type ?? ""
            
            dictOrder["updater_id"] = AppConstants.userData?.id ?? 0
            
            dictOrder["delivery_charge"] = "\(deliveryCharge)"
            dictOrder["distance"] = "\(distance)"
            dictOrder["order_status_id"] = "1"
            
            let arr = AppConstants.arrOrderStatuses.filter { model in
                return model.id ?? 0 == 1
            }
            
            dictOrder["service_charge"] = serviceCharge
            
            dictOrder["order_status"] = arr.first?.status ?? ""
            
            dictOrder["delivery_date"] = Date().getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
            
            
            let jsonDecoder = JSONDecoder()
            if let data = AppCommonMethods.convertToJson(object: dictOrder), let aData = try? jsonDecoder.decode(OrderModel.self, from: data){
                orderData = aData
                orderData?.customer = self.selectedCustomer
            }
            self.selectedTable?.locked = true
            if let status = CoreDataHelper.shared.fetchTableStatusData(name: "taking order").first{
                self.selectedTable?.tableStatusId = status.id
            }
            self.selectedTable?.lastOrderId = orderData?.id ?? 0
            orderData?.table = self.selectedTable
            orderData?.isNewOrder = 1
        }else{
            if action != 8{
                orderData?.arrProducts.removeAll()
                if arrGroups.count == 0{
                    orderData?.arrProducts = arrNormalProducts
                }else{
                    orderData?.arrOrderSplit = arrGroups
                    for group in arrGroups{
                        orderData?.arrProducts.append(contentsOf: group.arrProducts)
                    }
                    SQLiteManage.updateOrderGroupTotal(arrGroups: arrGroups)
                    orderData?.arrProducts.append(contentsOf: arrNormalProducts)
                }
                orderData?.gratuity = gratuity
                orderData?.serviceCharge = serviceCharge
                orderData?.discount = discount
                orderData?.customer = self.selectedCustomer
                orderData?.customer?.offline = self.selectedCustomer?.offline ?? 1
                orderData?.customerId = self.selectedCustomer?.id
                
                if orderActionId != nil{
                    orderData?.orderActionId = orderActionId
                }
                orderData?.orderTypeId = self.orderType.id
                orderData?.orderType = self.orderType.type
                orderData?.subTotal = totalPrice
                orderData?.deliveryCharge = deliveryCharge
                orderData?.distance = distance
                orderData?.total = grandAmount.getRoundFigure()
                orderData?.comment = orderComment
                
                var statusId = 1
                if orderStatusId != nil{
                    statusId = orderStatusId!
                    orderData?.orderStatusId = orderStatusId
                }else if orderData?.orderStatusId ?? 0 != 0{
                    statusId = orderData?.orderStatusId ?? 0
                }
                
                let arr = AppConstants.arrOrderStatuses.filter { model in
                    return model.id ?? 0 == statusId
                }
                orderData?.orderStatus = arr.first
                if newTable != nil{
                    newTable?.lastOrderId = self.orderData?.id ?? 0
                    newTable?.lastOrderTotal = self.orderData?.total ?? 0
                    newTable?.lastOrderTime = self.orderData?.createdDate?.getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'") ?? ""
                    if self.orderData?.orderStatusId ?? 0 <= 2{
                        if let status = CoreDataHelper.shared.fetchTableStatusData(name: "taking order").first{
                            newTable?.tableStatusId = status.id ?? 0
                            newTable?.tableStatus = status
                        }
                    }else if self.orderData?.orderStatusId ?? 0 == 4{
                        if let status = CoreDataHelper.shared.fetchTableStatusData(name: "served and paid").first{
                            newTable?.tableStatusId = status.id ?? 0
                            newTable?.tableStatus = status
                        }
                    }else{
                        if let status = CoreDataHelper.shared.fetchTableStatusData(name: "order taken").first{
                            newTable?.tableStatusId = status.id ?? 0
                            newTable?.tableStatus = status
                        }
                    }
                    if self.selectedTable != nil{
                        SQLiteManage.updateTableStatus(tableId: self.selectedTable!.id ?? 0, status: "vacant", lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", locked: 0)
                        AppCommonMethods.SaveTable(table: self.selectedTable!, status: "vacant", locked: 0)
                    }
                    SQLiteManage.updateTableStatus(tableId: newTable!.id ?? 0, statusId: newTable?.tableStatusId, lastOrderId: self.orderData?.id, lastOrderTotal: self.orderData?.total ?? 0, lastOrderTime: newTable?.lastOrderTime, locked: 1)
                    newTable?.locked = true
                    if let oldTable = self.selectedTable, let table = SQLiteManage.fetchTableDataFromMergeId(id: oldTable.id ?? 0){
                        SQLiteManage.updateTableStatus(tableId: table.id ?? 0, mergeTableId: newTable!.id ?? 0)
                        table.mergeTableId = newTable!.id ?? 0
                        if let dictTable = encodeFromModel(table) as? [String:Any]{
                            SocketService.shared?.sendTableToSocket(data: dictTable, id: table.id ?? 0)
                        }
                    }
                    AppCommonMethods.SaveTable(table: newTable!, statusId: newTable?.tableStatusId, locked: 1, lastOrderId: self.orderData?.id)
                    self.selectedTable = newTable
                }
                if orderData?.orderTypeId ?? 0 == 1{
                    self.btnTableNo.superview?.isHidden = false
                    self.btnTableNo.setTitle(self.selectedTable?.number ?? "", for: .normal)
                }else{
                    self.btnTableNo.superview?.isHidden = true
                }
                if self.selectedTable?.id ?? 0 != 0{
                    orderData?.tableId = selectedTable?.id
                    orderData?.noGuest = noOfGuest
                    orderData?.table = self.selectedTable
                    if orderData?.orderStatusId ?? 0 == 10 || orderData?.orderStatusId ?? 0 == 5{
                        SQLiteManage.updateTableStatus(tableId: self.selectedTable?.id ?? 0, status: "vacant", lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", locked: 0)
                        AppCommonMethods.SaveTable(table: self.selectedTable!, status: "vacant", locked: 0)
                    }else{
                        if action == 5 && (orderData?.table?.tableStatus?.status ?? "").lowercased() == "taking order"{
                            if let status = CoreDataHelper.shared.fetchTableStatusData(name: "order taken").first{
                                AppCommonMethods.SaveTable(table: self.selectedTable!, statusId: status.id)
                                self.selectedTable?.tableStatusId = status.id
                                self.selectedTable?.tableStatus = status
                                SQLiteManage.updateTableStatus(tableId: self.selectedTable?.id ?? 0,statusId: status.id, lastOrderId: self.orderId, lastOrderTotal: self.orderData?.total, lastOrderTime: self.orderData?.deliveryDate, offline: 1)
                            }else{
                                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                            }
                        }else{
                            SQLiteManage.updateTableStatus(tableId: self.selectedTable?.id ?? 0, lastOrderId: self.orderId, lastOrderTotal:orderData?.total, lastOrderTime: self.orderData?.deliveryDate, offline: 1)
                        }
                    }
                }
                if oldTable != nil{
                    if newTable == nil{
                        _ = SQLiteManage.ExecuteQuery("UPDATE Orders SET table_id = 0 WHERE unique_id = \(self.orderData?.uniqueId ?? "")")
                        self.orderData?.table = nil
                        self.orderData?.tableId = nil
                        self.selectedTable = nil
                    }
                    SQLiteManage.updateTableStatus(tableId: oldTable!.id ?? 0, status: "vacant", lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", locked: 0)
                    AppCommonMethods.SaveTable(table: oldTable!, status: "vacant", locked: 0)
                }
            }else{
                if self.selectedTable?.id ?? 0 != 0{
                    SQLiteManage.updateTableStatus(tableId: self.selectedTable?.id ?? 0, status: "vacant", lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", locked: 0)
                    AppCommonMethods.SaveTable(table: self.selectedTable!, status: "vacant", locked: 0)
                }
                orderData?.isDeleted = 1
            }
        }
        
        if Reachabilities.shared.isConnectedToNetwork() && (action == 3 || action == 8 || action == 9) && AppConstants.DataSyncMode == "Auto"{
            if action != 9{
                if self.orderData!.table != nil{
                    self.orderData!.table?.locked = false
                }
                self.navigationController?.popViewController(animated: true)
            }
            BGAPIExecution.shared.orderSaved = { orderId,message in
                print("Order \(orderId) Saved To Server")
                DispatchQueue.main.async {
                    if message == nil{
                        if action == 9{
                            self.orderId = orderId
                            if let order = SQLiteManage.fetchOrderDataById(orderId: self.orderId!){
                                self.selectedCustomer = order.customer
                                self.orderData = order
                            }
                        }else{
                            NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: ["order_id":orderId,"old_id":self.orderId])
                        }
                    }else{
                        AppCommonMethods.showToastAlert(message: message!)
                        if action == 8{
                            if self.orderData!.isNewOrder == 1{
                                SQLiteManage.deleteOrder(orderId: self.orderData!.id ?? 0, isFromAPI: true)
                            }else{
                                SQLiteManage.SaveOrderIntoDatabase(order: self.orderData!, updated: 1, isDeleted: 1)
                            }
                        }
                    }
                }
            }
            BGAPIExecution.shared.AddOrderToQueue(order: self.orderData!, shouldPrint: shouldPrint)
        }else{
            if action == 8{
                if self.orderData!.isNewOrder == 1{
                    SQLiteManage.deleteOrder(orderId: self.orderData!.id ?? 0, isFromAPI: true)
                }else{
                    //RealmManager().saveOrdersIntoData([self.orderData!])
                    SQLiteManage.SaveOrderIntoDatabase(order: self.orderData!, updated: 1, isDeleted: 1)
                }
                self.navigationController?.popViewController(animated: true)
            }else{
                //RealmManager().saveOrdersIntoData([self.orderData!])
                SQLiteManage.SaveOrderIntoDatabase(order: self.orderData!, updated: 1)
                self.performOrderSaveAction(action:action)
            }
        }
    }
    
    func performOrderSaveAction(action:Int){
        self.setOrderButtons()
        if action == 1 || action == 6 || action == 7{
            if arrNormalProducts.count > 0 && arrGroups.count > 0{
                if let VC = SplitOrderVC.instance(){
                    VC.orderType = self.orderType
                    if action == 6{
                        VC.selectedPayment = .kCash
                    }else if action == 7{
                        VC.selectedPayment = .kCreditCard
                    }
                    VC.selectedTable = selectedTable
                    VC.orderData = AppCommonMethods.Copy(of: orderData!) ?? orderData!
                    self.navigationController?.pushViewController(VC, animated: true)
                }
            }else{
                if let VC = OrderReviewVC.instance(){
                    VC.orderType = self.orderType
                    if action == 6{
                        VC.selectedPayment = .kCash
                    }else if action == 7{
                        VC.selectedPayment = .kCreditCard
                    }
                    VC.orderData = AppCommonMethods.Copy(of: self.orderData!) ?? self.orderData!
                    VC.selectedTable = self.selectedTable
                    self.navigationController?.pushViewController(VC, animated: true)
                }
            }
        }else if action == 2{
            if let VC = SplitOrderVC.instance(){
                VC.orderType = self.orderType
                VC.selectedTable = self.selectedTable
                VC.orderData = AppCommonMethods.Copy(of: self.orderData!) ?? self.orderData!
                self.navigationController?.pushViewController(VC, animated: true)
            }
        }else if action == 3{
            self.navigationController?.popViewController(animated: true)
        }else if action == 4{
            if Reachabilities.shared.isConnectedToNetwork(){
                if let VC = ApplyVoucherVC.showPopup(parentVC: self){
                    VC.delegate = self
                }
            }else{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.kNoInternetMsg, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }else if action == 5{
            if self.orderData?.orderActionId ?? 0 == 5{
                self.printBillAction()
            }else if self.orderData?.orderActionId ?? 0 == 6{
                self.printAllAction()
            }else{
                self.printKitchCopyAction()
            }
        }
    }
    
    func fetchOrderFromDB(notificationId:Int? = nil){
        if let id = notificationId, id != orderId ?? 0{
            return
        }
        if let id = orderId, id != 0, let order = SQLiteManage.fetchOrderDataById(orderId: id){
            self.selectedCustomer = order.customer
            self.orderData = order
            self.discount = order.discount ?? 0
            self.deliveryCharge = order.deliveryCharge ?? 0
            self.noOfGuest = order.noGuest ?? 0
            self.selectedTable = order.table
            self.gratuity = order.gratuity ?? 0
            self.serviceCharge = order.serviceCharge ?? 0
            self.distance = order.distance ?? 0
            self.orderComment = order.comment ?? ""
            self.arrNormalProducts = order.arrProducts.filter({ product in
                return product.orderSplitId ?? 0 == 0
            })
            if order.splitCount ?? 0 == 0{
                self.arrGroups = order.arrOrderSplit
                for group in arrGroups {
                    group.arrProducts = order.arrProducts.filter({ product in
                        return product.groupUniqueId == group.uniqueId
                    })
                }
            }
            self.setOrderView()
            self.collectionProduct.reloadData()
        }else{
            setOrderView()
        }
    }
    
    func CallPaymentAPI(voucher:VoucherModel){
        if SQLiteManage.fetchCountOfTable(whereString: "WHERE voucher_code = '\(voucher.voucherCode ?? "")'", tableName: "OrderPayment") > 0{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "Voucher already redeemed", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return
        }
        let remainingAmount = (self.orderData?.total ?? 0) - (self.orderData?.totalPaid ?? 0)
        let paid = (self.orderData?.totalPaid ?? 0) + (voucher.voucherAmount ?? 0)
        self.orderData?.totalPaid = paid
        self.setOrderView()
        let paymentModel = PaymentOrderModel()
        paymentModel.id = Date().millisecondsSince1970
        if voucher.voucherAmount ?? 0 < remainingAmount{
            paymentModel.amount = voucher.voucherAmount ?? 0
        }else{
            paymentModel.amount = remainingAmount
        }
        paymentModel.updaterId = AppConstants.userData?.id ?? 0
        paymentModel.txnId = Int(Date().timeIntervalSinceReferenceDate).description
        paymentModel.voucherId = voucher.id ?? 0
        paymentModel.paymentMethodId = 5
        paymentModel.paymentMethodName = "Voucher"
        self.orderData!.arrOrderPayments.append(paymentModel)
        SQLiteManage.insertOrderPayments(orderId: self.orderId ?? 0, arrPayments: [paymentModel], database: nil, voucherCode: voucher.voucherCode ?? "", offline: 1)
        AppCommonMethods.showToastAlert(message: "Voucher applied successfully")
        CallCreateOrderAPI()
    }
    
    //MARK: WebService Methods
    func ApplyVoucherCode(code:String){
        if let voucher = SQLiteManage.FetchVouchers("Select * from Vouchers WHERE voucher_code == '\(code)'").first{
            if let orderTypes = voucher.orderTypeId{
                if orderTypes.contains("\(self.orderType.id ?? 0)"){
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "Voucher is not valid for \((self.orderType.type ?? "").capitalized) order", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                    return
                }
            }
            if let value = voucher.minimumOrderValue, self.orderData?.total ?? 0 < value{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: String.init(format: "Minimum order value for selected voucher is %@%.2f", AppConstants.currencySign, voucher.minimumOrderValue ?? 0), withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return
            }
            if voucher.applied ?? 0 == 1{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "Voucher already redeemed", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return
            }
            _ = SQLiteManage.ExecuteQuery("UPDATE Vouchers SET applied = 1 WHERE id = \(voucher.id!)")
            self.CallPaymentAPI(voucher: voucher)
        }else{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "Invalid voucher vode.", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
        }
    }
}

//MARK: UITableViewDataSource
extension CreateOrderVC:UITableViewDataSource,UITableViewDelegate{
    func numberOfSections(in tableView: UITableView) -> Int {
        return arrGroups.count+1
        
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section == 0{
            return arrNormalProducts.count
        }
        if arrGroups.count != 0{
            if let selectedGroupIndex{
                if section == selectedGroupIndex{
                    return arrGroups[section-1].arrProducts.count
                }
            }
            return 0
        }
        return arrNormalProducts.count
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let cell = tableView.dequeueReusableCell(withIdentifier: "GroupHeaderCell") as! GroupHeaderCell
        if section == 0{
            cell.btnGroup.setTitle("Not splited" , for: .normal)
        }else{
            let group = arrGroups[section-1]
            cell.btnGroup.setTitle(String.init(format: "%@ (%@%.2f/%@%.2f)", group.groupName ?? "", AppConstants.currencySign, group.paidAmount ?? 0, AppConstants.currencySign, group.total ?? 0), for: .normal)
        }
        cell.btnGroup.setTitleColor(AppConstants.Colors.kAppThemeAquaColor, for: .normal)
        cell.btnGroup.backgroundColor = .white
        if let selectedGroupIndex{
            if section == selectedGroupIndex{
                cell.btnGroup.setTitleColor(.white, for: .normal)
                cell.btnGroup.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            }
        }
        cell.btnGroup.tag = section
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        if section == 0{
            return 0
        }
        if arrGroups.count != 0{
            return 68
        }
        return 0
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        var product:OrderProductModel!
        if indexPath.section == 0{
            product = arrNormalProducts[indexPath.row]
        }else{
            product = arrGroups[indexPath.section-1].arrProducts[indexPath.row]
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "delete_item_visible") ?? "" == "false" && product.isDelete{
            return 0
        }
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "ProductsListCell", for: indexPath) as! ProductsListCell
        var model:OrderProductModel!
        if indexPath.section == 0{
            model = arrNormalProducts[indexPath.row]
        }else{
            model = arrGroups[indexPath.section-1].arrProducts[indexPath.row]
        }
        if model.isDelete{
//            print("1 name: \(model.productName ?? ""), deleted: \(model.isDelete)")
            cell.lblName.attributedText = (model.productName ?? "").strikeThoughText
            cell.lblPrice.attributedText = String.init(format: "%@%.2f", AppConstants.currencySign,model.price ?? 0).strikeThoughText
            cell.scrollView.isScrollEnabled = false
            cell.btnPlus.superview?.isHidden = true
            cell.btnMinus.superview?.isHidden = true
            cell.txtQuantity.superview?.isHidden = true
        }else{
//            print("2 name: \(model.productName ?? ""), deleted: \(model.isDelete)")
            cell.scrollView.isScrollEnabled = true
            cell.btnPlus.superview?.isHidden = false
            cell.btnMinus.superview?.isHidden = false
            cell.txtQuantity.superview?.isHidden = false
            cell.lblName.attributedText = nil
            cell.lblPrice.attributedText = nil
            cell.lblName.text = model.productName ?? ""
            cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign,model.price ?? 0)
        }
        cell.txtQuantity.superview?.accessibilityIdentifier = "1067"
        cell.txtQuantity.tag = indexPath.row
        cell.txtQuantity.accessibilityIdentifier = indexPath.section.description
        cell.txtQuantity.text = "\(model.quantity ?? 0)"
        cell.lblDescription.isHidden = true
        cell.btnViewMore.isHidden = true
        cell.btnViewMore.tag = indexPath.row
        cell.btnTopViewMore.isHidden = true
        cell.btnTopViewMore.tag = indexPath.row
        cell.btnView.tag = indexPath.row
        cell.btnView.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnViewMore.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnTopViewMore.accessibilityIdentifier = "\(indexPath.section)"
        var height:CGFloat = 0
        if model.arrAddons.count > 0 || model.arrIngriedent.count > 0 || model.specialInstruction ?? "" != ""{
            cell.lblDescription.isHidden = false
            var strDesc = ""
            model.arrIngriedent.forEach({ (ingrident) in
                var strIngrident = ""
                if ingrident.with ?? 0 == 1{
                    if ingrident.price ?? 0 == 0{
                        strIngrident = String.init(format: "(%dx %@ - Free)", ingrident.quantity ?? 0, ingrident.name ?? "")
                    }else{
                        strIngrident = String.init(format: "(%dx %@ - %@%.2f)", ingrident.quantity ?? 0, ingrident.name ?? "", AppConstants.currencySign, ingrident.price ?? 0)
                    }
                }else{
                    if ingrident.price ?? 0 == 0{
                        strIngrident = String.init(format: "(No %@ - Free)", ingrident.name ?? "")
                    }else{
                        strIngrident = String.init(format: "(No %@ - %@%.2f)", ingrident.name ?? "", AppConstants.currencySign, ingrident.price ?? 0)
                    }
                }
                if strDesc == ""{
                    strDesc = strIngrident
                }else{
                    strDesc = "\(strDesc)\n\(strIngrident)"
                }
            })
            model.arrAddons.forEach({ (addon) in
                let strAddon = String.init(format: "(%dx %@)", addon.quantity ,addon.name ?? "")
                if strDesc == ""{
                    strDesc = strAddon
                }else{
                    strDesc = "\(strDesc)\n\(strAddon)"
                }
            })
            if model.specialInstruction ?? "" != ""{
                if strDesc == ""{
                    strDesc = "Special Instruction: \(model.specialInstruction ?? "")"
                }else{
                    strDesc = "\(strDesc)\nSpecial Instruction: \(model.specialInstruction ?? "")"
                }
                if model.instructionPrice ?? 0 != 0{
                    strDesc.append(String.init(format: " - %.2f", model.instructionPrice ?? 0))
                }
            }
            if model.isDelete{
                cell.lblDescription.text = ""
                cell.lblDescription.attributedText = strDesc.strikeThoughText
            }else{
                cell.lblDescription.attributedText = nil
                cell.lblDescription.text = strDesc
            }
            height = strDesc.getHeightFromString(font: AppConstants.GlobalFontConstants.kBoldFont(size: 14), width: cell.lblDescription.frame.width)
            if height > 60{
                cell.btnViewMore.isHidden = false
                cell.btnTopViewMore.isHidden = false
            }
        }
        cell.btnPlus.tag = indexPath.row
        cell.btnDelete.tag = indexPath.row
        cell.btnMinus.tag = indexPath.row
        cell.btnMinus.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnPlus.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnDelete.accessibilityIdentifier = "\(indexPath.section)"
        if model.quantity ?? 0 > 1{
            cell.imgDelete.isHidden = true
            cell.lblMinus.isHidden = false
        }else{
            cell.imgDelete.isHidden = false
            cell.lblMinus.isHidden = true
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        self.view.endEditing(true)
        if isEditOrder{
            return
        }
        var model:OrderProductModel!
        if indexPath.section == 0{
            model = arrNormalProducts[indexPath.row]
        }else{
            model = arrGroups[indexPath.section-1].arrProducts[indexPath.row]
        }
        if model.isDelete{
            return
        }
        if AppConstants.userData?.permissions?.modify?.actions?.list ?? 0 == 1{
            if showOrderModifiedToast(){
                if AppCommonMethods.fetchSiteSettingValue(key: "addon_theme") ?? "" == "theme2"{
                    if let VC = AddOnTheme2VC.addToChildView(parentVC: self, index: indexPath.row, orderType: self.orderType, isBanquetOrder: self.isBanquetOrder, orderProduct: AppCommonMethods.Copy(of: model) ?? model){
                        self.constContainerLeadingSpace.constant = 25
                        UIView.animate(withDuration: 0.25) {
                            self.view.layoutIfNeeded()
                            self.viewForBG.alpha = 1
                        }
                        VC.delegate = self
                    }
                }else{
                    if let VC = AddOnsVC.addToChildView(parentVC: self, index: indexPath.row, orderType: self.orderType, isBanquetOrder: self.isBanquetOrder, orderProduct: AppCommonMethods.Copy(of: model) ?? model){
                        self.constContainerLeadingSpace.constant = (AppConstants.ScreenSize.SCREEN_WIDTH/2.25)
                        UIView.animate(withDuration: 0.25) {
                            self.view.layoutIfNeeded()
                            self.viewForBG.alpha = 1
                        }
                        VC.delegate = self
                    }
                }
            }
        }
    }
    
    
}

//MARK:  UICollectionViewDataSource
extension CreateOrderVC: UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout{
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if collectionView == collectionMainCategory{
            return arrCategory.count
        }
        if collectionView == collectionSubCategory{
            return arrSubCategory.count
        }
        return isSearchEnabled ? arrSearchProducts.count : arrProducts.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        if collectionView == collectionProduct{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "ProductsCollectionCell", for: indexPath) as! ProductsCollectionCell
            let model = isSearchEnabled ? arrSearchProducts[indexPath.row] : arrProducts[indexPath.row]
            cell.lblName.text = model.name ?? ""
            if isBanquetOrder{
                cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, model.waitingPrice ?? 0)
            }else{
                if self.orderType.id ?? 0 == 3{
                    cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, model.deliveryPrice ?? 0)
                }else if self.orderType.id ?? 0 == 2 || self.orderType.id ?? 0 == 5{
                    cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, model.takeawayPrice ?? 0)
                }else{
                    cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, model.price ?? 0)
                }
            }
            if model.description ?? "" != ""{
                cell.lblDescription.isHidden = false
                cell.lblDescription.text = model.description ?? ""
            }else{
                cell.lblDescription.isHidden = true
            }
            
            cell.imgProduct.isHidden = true
            if model.imageUrl ?? "" != "" && shouldDisplayImage{
                if let _ = URL.init(string: model.imageUrl ?? ""){
                    cell.imgProduct.isHidden = false
                    cell.imgProduct.SetImageFromURL(strURL: model.imageUrl ?? "")
                }
            }
            var quantity = 0
            arrNormalProducts.forEach { product in
                if AppCommonMethods.fetchSiteSettingValue(key: "clear_item_count_send_order") ?? "" == "true"{
                    if product.prodcutId ?? 0 == model.id ?? 0 && !product.isDelete{
                        quantity += product.sentToKitchenQuantity
                    }
                }else{
                    if product.prodcutId ?? 0 == model.id ?? 0 && !product.isDelete{
                        quantity += (product.quantity ?? 0)
                    }
                }
            }
            for group in arrGroups{
                group.arrProducts.forEach { product in
                    if product.prodcutId ?? 0 == model.id ?? 0 && !product.isDelete{
                        quantity += (product.quantity ?? 0)
                    }
                }
            }
            if quantity != 0{
                cell.lblQuantity.isHidden = false
                cell.lblQuantity.text = "\(quantity)"
            }else{
                cell.lblQuantity.isHidden = true
            }
            if AppCommonMethods.fetchSiteSettingValue(key: "product_background_type") ?? "" == "full"{
                cell.viewForBG.firstColor = UIColor.hexStr(hexStr: model.topColor ?? "", alpha: 1.0)
                cell.viewForBG.secondColor = UIColor.hexStr(hexStr: model.topColor ?? "", alpha: 1.0)
                cell.lblName.textColor = UIColor.hexStr(hexStr: model.fontColor ?? "", alpha: 1.0)
                cell.lblPrice.textColor = UIColor.hexStr(hexStr: model.fontColor ?? "", alpha: 1.0)
                cell.lblDescription.textColor = UIColor.hexStr(hexStr: model.fontColor ?? "", alpha: 1.0)
            }else{
                cell.viewForBG.firstColor = .white
                cell.viewForBG.secondColor = .white
                cell.lblName.textColor = .black
                cell.lblPrice.textColor = AppConstants.Colors.kAppDarkGreenColor
                cell.lblDescription.textColor = .black
            }
            return cell
        }else{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "ProductsCategoryCell", for: indexPath) as! ProductsCategoryCell
            let model = (collectionView == collectionMainCategory ? arrCategory : arrSubCategory)[indexPath.row]
            cell.viewForBG.firstColor = UIColor.hexStr(hexStr: model.topColor ?? "", alpha: 1.0)
            cell.viewForBG.secondColor = UIColor.hexStr(hexStr: model.bottomColor ?? "", alpha: 1.0)
            var fontColor = UIColor.white
            if model.fontColor ?? "" != ""{
                fontColor = UIColor.hexStr(hexStr: model.fontColor ?? "", alpha: 1.0)
            }
            cell.lblName.attributedText = (model.name ?? "").normal(color: fontColor, font: AppConstants.GlobalFontConstants.kMediumFont(size: 18))
            cell.NameTopSpace.constant = 2
            cell.NameLeadingSpace.constant = 2
            cell.viewForBG.cornerRadius = 8
            if (collectionView == collectionMainCategory ? selectedMainCategory : selectedSubCategory)?.id ?? 0 == model.id ?? 0{
                cell.lblName.attributedText = (model.name ?? "").underline(color: .white, font: AppConstants.GlobalFontConstants.kBoldFont(size: 19))
                cell.NameTopSpace.constant = 5
                cell.NameLeadingSpace.constant = 5
                cell.viewForBG.cornerRadius = 15
                cell.viewForBG.firstColor = AppConstants.Colors.kAppThemeDarkAquaColor
                cell.viewForBG.secondColor = AppConstants.Colors.kAppThemeDarkAquaColor
            }
            return cell
        }
    }
    
    func nearestEqualWidth()->CGFloat{
        let width = AppConstants.ScreenSize.SCREEN_WIDTH-550
        let cellWidth = width/ceil(width/200)
        return floor(cellWidth)
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        if collectionView == collectionProduct{
            var cellHeight:CGFloat = 95
            let model = isSearchEnabled ? arrSearchProducts[indexPath.row] : arrProducts[indexPath.row]
            if model.description ?? "" != ""{
                cellHeight += 36
            }
            if model.imageUrl ?? "" != "" && shouldDisplayImage{
                if let _ = URL.init(string: model.imageUrl ?? ""){
                    cellHeight += 93
                }
            }
            return CGSize.init(width: nearestEqualWidth(), height: cellHeight)
        }else if collectionView == collectionSubCategory{
            let width = AppConstants.ScreenSize.SCREEN_WIDTH-550
            let row = round(width/150)
            if arrSubCategory.count > Int(row){
                return CGSize.init(width: width/row, height: 74)
            }
            return CGSize.init(width: (AppConstants.ScreenSize.SCREEN_WIDTH-550)/(ceil(CGFloat(arrSubCategory.count)/2)), height: 74)
        }
        return CGSize.init(width: 119, height: 80)
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        self.view.endEditing(true)
        if collectionView == collectionSubCategory{
            isSearchEnabled = false
            txtSearch.text = ""
            if selectedSubCategory != nil{
                if selectedSubCategory?.id ?? 0 == arrSubCategory[indexPath.row].id ?? 0{
                    selectedSubCategory = nil
                }else{
                    selectedSubCategory = arrSubCategory[indexPath.row]
                }
            }else{
                selectedSubCategory = arrSubCategory[indexPath.row]
            }
            getProductFromDataBase()
            collectionSubCategory.reloadDataWithoutScroll()
        }else if collectionView == collectionMainCategory{
            isSearchEnabled = false
            txtSearch.text = ""
            selectedMainCategory = arrCategory[indexPath.row]
            selectedSubCategory = nil
            if self.selectedMainCategory?.arrChildCategory != nil{
                self.arrSubCategory = self.selectedMainCategory!.arrChildCategory!.filter({ model in
                    return model.disabled ?? 0 == 0
                })
            }else{
                self.arrSubCategory = CoreDataHelper.shared.fetchChildCategoryData(parentId: self.selectedMainCategory?.id ?? 0, orderTypeId: self.orderType.id ?? 0, isBanquet: isBanquetOrder)
                self.selectedMainCategory?.arrChildCategory = self.arrSubCategory
            }
            if arrSubCategory.count == 0{
                constSubCategoryHeight.constant = 0
            }else{
                if CoreDataHelper.shared.fetchProductCount(categoryId: selectedMainCategory?.id ?? 0, oderTypeId: self.orderType.id ?? 0) == 0{
                    selectedSubCategory = self.arrSubCategory.first
                }
                if arrSubCategory.count == 1{
                    constSubCategoryHeight.constant = 74
                }else{
                    constSubCategoryHeight.constant = 148
                }
            }
            getProductFromDataBase()
            collectionSubCategory.reloadDataWithoutScroll()
            collectionMainCategory.reloadDataWithoutScroll()
        }else{
            if isEditOrder{
                return
            }
            if showOrderModifiedToast(isFromAdd: true){
                let model = isSearchEnabled ? arrSearchProducts[indexPath.row] : arrProducts[indexPath.row]
                let predicate = NSPredicate.init(format: "product_id == %ld AND disabled == 0", model.id ?? 0)
                let countI = CoreDataHelper.shared.numberOfRowOfEntity(name: "Ingredients", predict: predicate) ?? 0
                if (model.totalAddOn ?? 0 > 0 && AppConstants.userData?.permissions?.addons?.actions?.list ?? 0 == 1 && model.autoAddon ?? 0 == 1) || (model.autoModify ?? 0 == 1 && AppConstants.userData?.permissions?.modify?.actions?.list ?? 0 == 1 && countI > 0){
                    if AppCommonMethods.fetchSiteSettingValue(key: "addon_theme") ?? "" == "theme2"{
                        if let VC = AddOnTheme2VC.addToChildView(parentVC: self, orderType: self.orderType, product: model, isBanquetOrder: self.isBanquetOrder){
                            self.constContainerLeadingSpace.constant = 25
                            UIView.animate(withDuration: 0.25) {
                                self.view.layoutIfNeeded()
                                self.viewForBG.alpha = 1
                            }
                            VC.delegate = self
                        }
                    }else{
                        if let VC = AddOnsVC.addToChildView(parentVC: self, orderType: self.orderType, product: model, isBanquetOrder: self.isBanquetOrder){
                            self.constContainerLeadingSpace.constant = (AppConstants.ScreenSize.SCREEN_WIDTH/2.25)
                            UIView.animate(withDuration: 0.25) {
                                self.view.layoutIfNeeded()
                                self.viewForBG.alpha = 1
                            }
                            VC.delegate = self
                        }
                    }
                }else{
                    if let selectedGroupIndex, selectedGroupIndex-1 < arrGroups.count{
                        let index = arrGroups[selectedGroupIndex-1].arrProducts.firstIndex { (product) -> Bool in
                            return product.arrIngriedent.count == 0 && product.prodcutId ?? 0 == model.id ?? 0 && !product.isDelete
                        }
                        if index != nil{
                            arrGroups[selectedGroupIndex-1].arrProducts[index!].quantity = (arrGroups[selectedGroupIndex-1].arrProducts[index!].quantity ?? 0) + 1
                            if arrGroups[selectedGroupIndex-1].arrProducts[index!].sentToKitchen{
                                arrGroups[selectedGroupIndex-1].arrProducts[index!].sentToKitchenQuantity += 1
                            }else{
                                arrGroups[selectedGroupIndex-1].arrProducts[index!].sentToKitchenQuantity = arrGroups[selectedGroupIndex-1].arrProducts[index!].quantity ?? 0
                            }
                        }else{
                            model.quantity = 1
                            if let item = createOrderPoructModel(model: model){
                                item.sentToKitchenQuantity = 1
                                item.orderSplitId = arrGroups[selectedGroupIndex-1].id ?? 0
                                item.groupOffline = arrGroups[selectedGroupIndex-1].offline
                                item.groupUniqueId = arrGroups[selectedGroupIndex-1].uniqueId
                                self.arrGroups[selectedGroupIndex-1].arrProducts.insert(item, at: 0)
                            }
                        }
                    }else{
                        let index = arrNormalProducts.firstIndex { (product) -> Bool in
                            return product.arrIngriedent.count == 0 && product.prodcutId ?? 0 == model.id ?? 0 && !product.isDelete
                        }
                        if index != nil{
                            arrNormalProducts[index!].updatedAt = Date().getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
                            arrNormalProducts[index!].quantity = (arrNormalProducts[index!].quantity ?? 0) + 1
                            if arrNormalProducts[index!].sentToKitchen{
                                arrNormalProducts[index!].sentToKitchenQuantity += 1
                            }else{
                                arrNormalProducts[index!].sentToKitchenQuantity = arrNormalProducts[index!].quantity ?? 0
                            }
                        }else{
                            model.quantity = 1
                            if let item = createOrderPoructModel(model: model){
                                item.sentToKitchenQuantity = 1
                                item.updatedAt = Date().getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
                                self.arrNormalProducts.insert(item, at: 0)
                            }
                        }
                    }
                    
                    collectionView.reloadData()
                    self.setOrderView()
                    if orderData?.orderStatusId ?? 0 <= 2{
                        CallCreateOrderAPI(orderStatusId: 1)
                    }else{
                        CallCreateOrderAPI()
                    }
                }
            }
            
        }
    }
}

//MARK:  ProductDelegate
extension CreateOrderVC:ProductDelegate{
    func deleteProduct() {
        
    }
    
    func assignToProduct(isAddon: Bool, product: ProductModel?) {
        
    }
    
    func productModified(product: OrderProductModel, index: Int?) {
        var arrN = [OrderProductModel]()
        if let selectedGroupIndex{
            arrN = arrGroups[selectedGroupIndex-1].arrProducts
            product.orderSplitId = arrGroups[selectedGroupIndex-1].id ?? 0
            product.groupOffline = arrGroups[selectedGroupIndex-1].offline
            product.groupUniqueId = arrGroups[selectedGroupIndex-1].uniqueId
        }else{
            arrN = arrNormalProducts
        }
        if index == nil{
            let prodcutIndex = arrN.firstIndex { (model) -> Bool in
                if model.arrIngriedent.count != 0 || model.prodcutId ?? 0 != product.prodcutId ?? 0{
                    return false
                }
                var isContain = true
                if model.specialInstruction ?? "" != product.specialInstruction ?? ""{
                    isContain = false
                }
                if model.instructionPrice ?? 0 != product.instructionPrice ?? 0{
                    isContain = false
                }
                if model.arrAddons.count > 0 && product.arrAddons.count == 0{
                    isContain = false
                }else if model.arrAddons.count == 0 && product.arrAddons.count > 0{
                    isContain = false
                }else{
                    for addon in model.arrAddons{
                        let addonContain = product.arrAddons.contains { (addon2) -> Bool in
                            return addon.AddonId ?? 0 == addon2.AddonId ?? 0
                        }
                        if !addonContain{
                            isContain = false
                            break
                        }
                    }
                }
                if model.arrIngriedent.count > 0 && product.arrIngriedent.count == 0{
                    isContain = false
                }else if model.arrIngriedent.count == 0 && product.arrIngriedent.count > 0{
                    isContain = false
                }else{
                    for ingrident in product.arrIngriedent{
                        let arr = model.arrIngriedent.filter { ingrident2 in
                            return (ingrident.productIngredientId ?? 0 == ingrident2.productIngredientId ?? 0)
                        }
                        if arr.count > 0{
                            if arr[0].quantity ?? 0 != ingrident.quantity ?? 0{
                                isContain = false
                                break
                            }
                        }else{
                            isContain = false
                            break
                        }
                    }
                }
                return isContain
            }
            if prodcutIndex != nil{
                arrN[prodcutIndex!].updatedAt = Date().getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
                arrN[prodcutIndex!].quantity = (arrN[prodcutIndex!].quantity ?? 0) + (product.quantity ?? 0)
                arrN[prodcutIndex!].isItemUpdated = 1
                if arrN[prodcutIndex!].sentToKitchen{
                    arrN[prodcutIndex!].sentToKitchenQuantity += (product.quantity ?? 0)
                }else{
                    arrN[prodcutIndex!].sentToKitchenQuantity = arrN[prodcutIndex!].quantity ?? 0
                }
            }else{
                product.sentToKitchenQuantity = product.quantity ?? 0
                product.updatedAt = Date().getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
                product.uniqueId = Date().millisecondsInString
                product.id = Date().millisecondsSince1970
                product.isItemUpdated = 1
                for j in 0..<product.arrIngriedent.count{
                    let addon = product.arrIngriedent[j]
                    addon.id = Int("\(Date().millisecondsSince1970)\(j)") ?? 0
                    addon.isNewOrder = 1
                }
                for j in 0..<product.arrAddons.count{
                    let addon = product.arrAddons[j]
                    addon.id = Int("\(Date().millisecondsSince1970)\(j)") ?? 0
                    addon.isNewOrder = 1
                }
                arrN.insert(product, at: 0)
            }
            
        }else{
            if product.itemModified < product.quantity ?? 0{
                let model = arrN[index!]
                var isContain = true
                if model.specialInstruction ?? "" != product.specialInstruction ?? ""{
                    isContain = false
                }
                if model.instructionPrice ?? 0 != product.instructionPrice ?? 0{
                    isContain = false
                }
                if model.arrIngriedent.count > 0 && product.arrIngriedent.count == 0{
                    isContain = false
                }else if model.arrIngriedent.count == 0 && product.arrIngriedent.count > 0{
                    isContain = false
                }else{
                    for ingrident in product.arrIngriedent{
                        let arr = model.arrIngriedent.filter { ingrident2 in
                            return (ingrident.productIngredientId ?? 0 == ingrident2.productIngredientId ?? 0)
                        }
                        if arr.count > 0{
                            if arr[0].quantity ?? 0 != ingrident.quantity ?? 0{
                                isContain = false
                                break
                            }
                        }else{
                            isContain = false
                            break
                        }
                    }
                }
                if model.arrAddons.count > 0 && product.arrAddons.count == 0{
                    isContain = false
                }else if model.arrAddons.count == 0 && product.arrAddons.count > 0{
                    isContain = false
                }else{
                    for addon in product.arrAddons{
                        let arr = model.arrAddons.filter { addon2 in
                            return (addon2.AddonId ?? 0 == addon.AddonId ?? 0)
                        }
                        if arr.count == 0{
                            isContain = false
                            break
                        }
                    }
                }
                product.isItemUpdated = 1
                product.updatedAt = Date().getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
                if isContain{
                    if product.sentToKitchenQuantity > product.quantity ?? 0{
                        product.sentToKitchenQuantity = product.quantity ?? 0
                    }
                    arrN[index!] = product
                }else{
                    let qty = product.quantity ?? 0
                    arrN[index!].quantity = qty-product.itemModified
                    product.quantity = product.itemModified
                    product.uniqueId = Date().millisecondsInString
                    product.id = Date().millisecondsSince1970
                    product.sentToKitchenQuantity = qty
                    product.sentToKitchen = false
                    for j in 0..<product.arrIngriedent.count{
                        let addon = product.arrIngriedent[j]
                        addon.id = Int("\(Date().millisecondsSince1970)\(j)") ?? 0
                        addon.isNewOrder = 1
                    }
                    for j in 0..<product.arrAddons.count{
                        let addon = product.arrAddons[j]
                        addon.id = Int("\(Date().millisecondsSince1970)\(j)") ?? 0
                        addon.isNewOrder = 1
                    }
                    arrN.append(product)
                }
            }else{
                arrN[index!] = product
            }
        }
        if let selectedGroupIndex{
            arrGroups[selectedGroupIndex-1].arrProducts = arrN
        }else{
            arrN.forEach { model in
                model.groupUniqueId = ""
                model.orderSplitId = nil
            }
            arrNormalProducts = arrN
        }
        setOrderView()
        if orderData?.orderStatusId ?? 0 <= 2{
            CallCreateOrderAPI(orderStatusId: 1)
        }else{
            CallCreateOrderAPI()
        }
        
        self.tblProducts.layoutIfNeeded()
    }
}

//MARK:  AddGratuityDelegate
extension CreateOrderVC:AddGratuityDelegate{
    func amountAdded(amount: Double, type:GratityViewType) {
        if type == .kGratuity{
            self.gratuity = amount.getRoundFigure()
            if self.orderData?.splitCount ?? 0 != 0{
                self.orderData!.arrOrderSplit.forEach {
                    let gratuity = self.gratuity * $0.subTotal / (self.orderData?.subTotal ?? 0)
                    $0.gratuity = gratuity
                    $0.total = $0.subTotal + $0.gratuity + $0.serviceCharge - $0.discount
                }
            }
        }else if type == .kDiscount{
            self.discount = amount.getRoundFigure()
            if AppCommonMethods.fetchSiteSettingValue(key: "display_discount_setting") ?? "" == "yes"{
                isPriceBreakupShow = true
                btnPriceBreakupShow.superview?.isHidden = true
                btnPriceBreakupHide.superview?.isHidden = false
                viewForPriceBreakupSperator.isHidden = false
            }
        }else if type == .kDeliveryCharge{
            self.deliveryCharge = amount.getRoundFigure()
        }else{
            self.serviceCharge = amount.getRoundFigure()
        }
        setOrderView()
        CallCreateOrderAPI()
    }
    
    func cancelCliked(){
        btnOrderType.setTitle(" \(orderType.type ?? "") ", for: .normal)
        btnHome.setTitle(" Home ", for: .normal)
    }
}

//MARK:  PrepLocationDelegate
extension CreateOrderVC:PrepLocationDelegate{
    func prepLocationSelected(product: OrderProductModel?) {
        btnOrderType.setTitle(" \(orderType.type ?? "") ", for: .normal)
        btnHome.setTitle(" Home ", for: .normal)
        if product != nil{
            product!.misc = 1
            product!.updatedAt = Date().getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
            if let selectedGroupIndex{
                product!.groupUniqueId = arrGroups[selectedGroupIndex-1].uniqueId
                product!.orderSplitId = arrGroups[selectedGroupIndex-1].id ?? 0
                product!.groupOffline = arrGroups[selectedGroupIndex-1].offline
                arrGroups[selectedGroupIndex-1].arrProducts.insert(product!, at: 0)
            }else{
                self.arrNormalProducts.insert(product!, at: 0)
            }
            setOrderView()
            if orderData?.orderStatusId ?? 0 <= 2{
                CallCreateOrderAPI(orderStatusId: 1)
            }else{
                CallCreateOrderAPI()
            }
            self.tblProducts.reloadData()
        }
    }
}

//MARK:  CommentDelegate
extension CreateOrderVC:CommentDelegate{
    func commentAdded(comment: String) {
        orderComment = comment
        var settings = BottomAlertSettings()
        if comment == ""{
            viewForComment.isHidden = true
            settings.bgColor = AppConstants.Colors.kAppThemeRedColor
            settings.strMessage = AppConstants.GlobalAlert.instructionRemoved
        }else{
            lblOrderComment.text = "Instruction: \(comment)"
            viewForComment.isHidden = false
            settings.bgColor = AppConstants.Colors.kAppMediumGreenColor
            settings.strMessage = AppConstants.GlobalAlert.instructionAdded
        }
        AppValidation().showBottomAlertView(settings: settings)
        CallCreateOrderAPI()
    }
    
    func cancelClicked() {
        btnOrderType.setTitle(" \(orderType.type ?? "") ", for: .normal)
        btnHome.setTitle(" Home ", for: .normal)
    }
}

//MARK:  SwapTableDelegate
extension CreateOrderVC:SwapTableDelegate{
    func tableSelected(table: TableModel, orderType:OrderTypesModel?, isMergedTable:Bool) {
        if orderType != nil{
            if let VC = NewDineInOrderVC.showPopup(parentVC: self, table: table, customer: self.selectedCustomer, viewType: .convertOrder, orderType: orderType){
                VC.delegate = self
            }
        }else{
            if isMergedTable{
                SQLiteManage.updateTableStatus(tableId: table.id ?? 0, status: "Merged", mergeTableId: self.orderData?.tableId)
                AppCommonMethods.SaveTable(table: table, status: "Merged", mergeTableId: self.orderData?.tableId)
            }else{
                if self.selectedTable?.id ?? 0 != table.id ?? 0{
                    self.CallCreateOrderAPI(oldTable: self.selectedTable, newTable: table)
                }
            }
        }
    }
}

//MARK:  NewOrderDelegate
extension CreateOrderVC:NewOrderDelegate{
    func orderTypeSelected(orderType:OrderTypesModel?){
        
    }
    
    func requestForNewOrder(customer: CustomerModel, orderType: OrderTypesModel?, delivery: DeliveryChargeModel?, table: TableModel?, noOfGuest:Int?) {
        self.selectedCustomer = customer
        self.deliveryCharge = delivery?.charge ?? 0
        self.noOfGuest = noOfGuest
        if orderType != nil{
            self.orderType = orderType
            getProductFromDataBase()
            self.arrNormalProducts.forEach { model in
                if orderType?.id ?? 0 == 2 || orderType?.id ?? 0 == 5{
                    model.prepLocationId = model.product?.takeawayPreparationLocationId ?? 0
                    model.price = model.product?.takeawayPrice ?? 0
                }else if orderType?.id ?? 0 == 3{
                    model.prepLocationId = model.product?.deliveryPreparationLocationId ?? 0
                    model.price = model.product?.deliveryPrice ?? 0
                }else{
                    model.prepLocationId = model.product?.preparationLocationId ?? 0
                    model.price = model.product?.price ?? 0
                }
            }
            for group in arrGroups{
                group.arrProducts.forEach { model in
                    if orderType?.id ?? 0 == 2 || orderType?.id ?? 0 == 5{
                        model.prepLocationId = model.product?.takeawayPreparationLocationId ?? 0
                        model.price = model.product?.takeawayPrice ?? 0
                    }else if orderType?.id ?? 0 == 3{
                        model.prepLocationId = model.product?.deliveryPreparationLocationId ?? 0
                        model.price = model.product?.deliveryPrice ?? 0
                    }else{
                        model.prepLocationId = model.product?.preparationLocationId ?? 0
                        model.price = model.product?.price ?? 0
                    }
                }
            }
            self.setOrderView()
            self.CallCreateOrderAPI(newTable: table)
        }else{
            self.CallCreateOrderAPI()
        }
    }
}

//MARK:  OrderTypeDelegate
extension CreateOrderVC:OrderTypeDelegate{
    func orderTypeChange(orderType: OrderTypesModel, oldTable:TableModel?) {
        if orderType.id ?? 0 == 1{
            if let VC = SwapTableVC.showPopup(parentVC: self, orderId: orderId ?? 0, orderType: orderType, orderTotal: self.orderData?.total, orderTime: self.orderData?.deliveryDate, orderPaid:self.orderData?.totalPaid ?? 0){
                VC.delegate = self
            }
        }else if orderType.id ?? 0 == 3{
            if let VC = NewOrderVC.showPopup(parentVC: self, orderType: orderType, viewType: .changeCustomer, customer: self.selectedCustomer, table: oldTable){
                VC.delegate = self
            }
        }else{
            self.deliveryCharge = 0
            self.orderType = orderType
            getProductFromDataBase()
            self.arrNormalProducts.forEach { model in
                if orderType.id ?? 0 == 2 || orderType.id ?? 0 == 5{
                    model.prepLocationId = model.product?.takeawayPreparationLocationId ?? 0
                    model.price = model.product?.takeawayPrice ?? 0
                }else if orderType.id ?? 0 == 3{
                    model.prepLocationId = model.product?.deliveryPreparationLocationId ?? 0
                    model.price = model.product?.deliveryPrice ?? 0
                }else{
                    model.prepLocationId = model.product?.preparationLocationId ?? 0
                    model.price = model.product?.price ?? 0
                }
            }
            for group in arrGroups{
                group.arrProducts.forEach { model in
                    if orderType.id ?? 0 == 2 || orderType.id ?? 0 == 5{
                        model.prepLocationId = model.product?.takeawayPreparationLocationId ?? 0
                        model.price = model.product?.takeawayPrice ?? 0
                    }else if orderType.id ?? 0 == 3{
                        model.prepLocationId = model.product?.deliveryPreparationLocationId ?? 0
                        model.price = model.product?.deliveryPrice ?? 0
                    }else{
                        model.prepLocationId = model.product?.preparationLocationId ?? 0
                        model.price = model.product?.price ?? 0
                    }
                }
            }
            self.setOrderView()
            self.CallCreateOrderAPI(oldTable: self.selectedTable)
        }
    }
}

//MARK:  AlertControllerDelegate
extension CreateOrderVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data:alertViewData,type:AlertType) {
        if index == 1{
            if type == .kApplyVoucher{
                ApplyVoucherCode(code: data.value)
            }else{
                if passwordType == 0{
                    self.CallCreateOrderAPI(action: 8)
                }else if passwordType == 1{
                    self.CallCreateOrderAPI(orderStatusId: 10, action: 3)
                }else if passwordType == 2{
                    constActionTrailingSpace.constant = -295
                    UIView.animate(withDuration: 0.25) {
                        self.btnExpand.transform = CGAffineTransform(rotationAngle: 0)
                        self.view.layoutIfNeeded()
                    }
                    btnHome.setTitle(" \(orderType.type ?? "") ", for: .normal)
                    btnOrderType.setTitle(" Discount ", for: .normal)
                    if let VC = AddGratuityVC.showPopup(parentVC: self, amount: discount, totalAmount: totalPrice, type: .kDiscount){
                        VC.delegate = self
                    }
                }else{
                    
                }
            }
        }else{
            btnOrderType.setTitle(" \(orderType.type ?? "") ", for: .normal)
            btnHome.setTitle(" Home ", for: .normal)
        }
    }
}

//MARK: SendOrderDelegate
extension CreateOrderVC:SendOrderDelegate{
    func sendOrder(index: Int) {
        CallCreateOrderAPI(orderStatusId: 12,orderActionId: index, action: 5, shouldPrint: true)
    }
}

//MARK:  UITextFieldDelegate
extension CreateOrderVC:UITextFieldDelegate{
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        return textField.resignFirstResponder()
    }
    
    func textFieldDidEndEditing(_ textField: UITextField) {
        if textField.superview?.accessibilityIdentifier ?? "" == "1067"{
            let section = Int(textField.accessibilityIdentifier ?? "") ?? 0
            var model:OrderProductModel!
            if section == 0{
                model = arrNormalProducts[textField.tag]
            }else{
                model = arrGroups[section-1].arrProducts[textField.tag]
            }
            model.updatedAt = Date().getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
            if showOrderModifiedToast(){
                let qty = Int(textField.text ?? "") ?? 0
                if qty == 0{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: "Quantity can not be zero.", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        textField.becomeFirstResponder()
                    }
                }else{
                    model.quantity  = qty
                    self.setOrderView()
                    if orderData?.orderStatusId ?? 0 <= 2{
                        CallCreateOrderAPI(orderStatusId: 1)
                    }else{
                        CallCreateOrderAPI()
                    }
                }
            }else{
                textField.text = model.quantity?.description ?? "0"
            }
        }
    }
}

extension CreateOrderVC:OrderActionDelegate{
    func reminderDateSet() {
        
    }
    
    func timeSlotSelected(strTimeslot: String?, isDelayTime: Bool) {
        self.orderData?.isDeliveryCollectionAsk = true
        self.orderData?.deliveryCollectionTimeSlot = strTimeslot ?? ""
        CallCreateOrderAPI()
    }
}
