//
//  MultiOrderTableVC.swift
//  EPOS
//
//  Created by Tushar Premal on 15/04/25.
//

import UIKit

class MultiOrderTableVC: UIViewController {

    @IBOutlet weak var stackOrderView:UIStackView!
    var arrOrders = [OrderModel]()
    var selectedTable = TableModel()
    
    //MARK:  ViewController Instance
    static var instance:MultiOrderTableVC?{
        return UIStoryboard.init(name: "SideMenu", bundle: nil).instantiateViewController(withIdentifier: "MultiOrderTableVC") as? MultiOrderTableVC
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        for i in 0..<arrOrders.count {
            let model = arrOrders[i]
            if let VC = OrderTableView.instance {
                VC.translatesAutoresizingMaskIntoConstraints = false
                VC.btnOrder.tag = i
                VC.btnOrder.addTarget(self, action: #selector(btnViewOrderAction(_:)), for: .touchUpInside)

                stackOrderView.addArrangedSubview(VC) // Add to stack view first

                VC.setViewData(order: model)
                
            }
        }
    }
    
    override func viewWillAppear(_ animated: Bool) {
        let orders = SQLiteManage.FetchOrdersForTable(table: selectedTable)
        if orders.count <= 1{
            self.navigationController?.popViewController(animated: true)
        }
    }
    
    @IBAction func btnViewOrderAction(_ sender:UIButton){
        if let VC = CreateOrderVC.instance(){
            VC.selectedTable = selectedTable
            if let type = AppConstants.arrOrderTypes.filter({ model in
                return model.id ?? 0 == 1
            }).first{
                VC.orderType = type
            }
            VC.orderId = arrOrders[sender.tag].id ?? 0
            self.navigationController?.pushViewController(VC, animated: true)
        }
    }
    
    @IBAction func btnMergeAction(){
        var items = [OrderProductModel]()
        var payments = [PaymentOrderModel]()
        var groups = [OrderGroupModel]()
        var totalPaid = 0.0
        var subTotal = 0.0
        var total = 0.0
        var discount = 0.0
        var serviceCharge = 0.0
        var gratuity = 0.0
        var customer:CustomerModel?
        var comment:String?
        var noOfGuest = 0
        var splitCount = 0
        for i in 0..<arrOrders.count{
            let order = arrOrders[i]
            items.append(contentsOf: order.arrProducts)
            payments.append(contentsOf: order.arrOrderPayments)
            groups.append(contentsOf: order.arrOrderSplit)
            totalPaid += (order.totalPaid ?? 0)
            total += (order.total ?? 0)
            subTotal += (order.subTotal ?? 0)
            discount += (order.discount ?? 0)
            serviceCharge += (order.serviceCharge ?? 0)
            gratuity += (order.gratuity ?? 0)
            noOfGuest = max(noOfGuest, order.noGuest ?? 0)
            splitCount = max(splitCount, order.splitCount ?? 0)
            if !(order.customer?.name ?? "").isEmpty{
                customer = order.customer
            }
            if !(order.comment ?? "").isEmpty{
                comment = order.comment
            }
            if i != 0{
                order.arrProducts.removeAll()
                order.arrOrderPayments.removeAll()
                order.arrOrderSplit.removeAll()
                order.total = 0
                order.totalPaid = 0
                order.subTotal = 0
                order.discount = 0
                order.serviceCharge = 0
                order.gratuity = 0
                order.splitCount = 0
                order.orderStatusId = 10
                SQLiteManage.SaveOrderIntoDatabase(order: order, updated: 1)
                arrOrders[i] = order
            }
        }
        arrOrders[0].total = total
        arrOrders[0].totalPaid = totalPaid
        arrOrders[0].subTotal = subTotal
        arrOrders[0].discount = discount
        arrOrders[0].serviceCharge = serviceCharge
        arrOrders[0].gratuity = gratuity
        arrOrders[0].splitCount = splitCount
        arrOrders[0].arrProducts = items
        arrOrders[0].arrOrderPayments = payments
        arrOrders[0].arrOrderSplit = groups
        if let customer{
            arrOrders[0].customer = customer
        }
        if let comment{
            arrOrders[0].comment = comment
        }
        arrOrders[0].arrProducts.forEach { model in
            model.orderId = arrOrders[0].id ?? 0
        }
        SQLiteManage.SaveOrderIntoDatabase(order: arrOrders[0], updated: 1)
        BGAPIExecution.shared.AddOrdersToQueue(arr: arrOrders)
        self.navigationController?.popViewController(animated: true)
        DispatchQueue.main.asyncAfter(deadline: .now()+1) {
            self.selectedTable.lastOrderId =  self.arrOrders[0].id ?? 0
            self.selectedTable.lastOrderTime =  self.arrOrders[0].createdDate?.getDateInString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'") ?? ""
            self.selectedTable.lastOrderTotal =  self.arrOrders[0].total ?? 0
            if self.arrOrders[0].orderStatusId ?? 0 == 4{
                if let status = CoreDataHelper.shared.fetchTableStatusData(name: "Served and paid").first{
                    self.selectedTable.tableStatus = status
                    self.selectedTable.tableStatusId = status.id
                }
            }else if self.arrOrders[0].orderStatusId ?? 0 == 12{
                if let status = CoreDataHelper.shared.fetchTableStatusData(name: "Order Taken").first{
                    self.selectedTable.tableStatus = status
                    self.selectedTable.tableStatusId = status.id
                }
            }else{
                if let status = CoreDataHelper.shared.fetchTableStatusData(name: "Taking Order").first{
                    self.selectedTable.tableStatus = status
                    self.selectedTable.tableStatusId = status.id
                }
            }
            SQLiteManage.updateTableSocket(model:  self.selectedTable)
            NotificationCenter.default.post(name: AppConstants.notifications.kTableUpdated, object: nil)
        }
    }
    
    @IBAction func btnBackAction(){
        self.navigationController?.popViewController(animated: true)
    }
}
