//
//  OrderListVC.swift
//  EPOS
//
//  Created by Tushar Premal on 23/04/21.
//

import UIKit

class OnlineOrdersVC: UIViewController {
    
    //IBOutlets
    @IBOutlet weak var collectionOnlineOrders:UICollectionView!
    @IBOutlet weak var btnOrderHistory:UIButton!
    
    //MARK:  Variable
    var arrNewOrder = [WebOrderModel]()
    var arrCompletedOrder = [WebOrderModel]()
    var arrCurrentOrder = [WebOrderModel]()
    var selectedOrderRow:Int?
    var selectedOrderSection:Int?
    var parentVC:SideMenuVC!
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        if AppConstants.userData?.permissions?.onlineOrderHistory?.actions?.list ?? 0 == 1{
            btnOrderHistory.isHidden = false
        }else{
            btnOrderHistory.isHidden = true
        }
        
        reloadPageData()
    }
    override func viewDidLayoutSubviews() {
        print("viewDidLayoutSubviews")
        self.collectionOnlineOrders.reloadData()
    }
    
    //MARK:  ViewController Instance
    static func instance()->OnlineOrdersVC?{
        return UIStoryboard.init(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "OnlineOrdersVC") as? OnlineOrdersVC
    }
    
    //MARK:  ViewController Instance
    static func addToParentView(parentVC:SideMenuVC)->OnlineOrdersVC?{
        guard let VC = UIStoryboard.init(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "OnlineOrdersVC") as? OnlineOrdersVC else {
            return nil
        }
        VC.parentVC = parentVC
        
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    @objc func reloadPageData(){
        GetOnlineOrders()
    }
    
    func sortOrderList(){
        self.arrCompletedOrder = self.arrCompletedOrder.sorted(by: { (model1, model2) -> Bool in
            var cDate1 = ""
            var cDate2 = ""
            if (model1.orderType ?? "").lowercased() == "dine in"{
                cDate1 = ((model1.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate1 = (model1.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate1 = "\(cDate1) \(model1.deliveryTime ?? "")"
            }
            if (model2.orderType ?? "").lowercased() == "dine in"{
                cDate2 = ((model2.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate2 = (model2.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate2 = "\(cDate2) \(model2.deliveryTime ?? "")"
            }
            if let date1 = cDate1.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil), let date2 = cDate2.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil){
                return date1 > date2
            }
            return true
        })
        self.arrCurrentOrder = self.arrCurrentOrder.sorted(by: { (model1, model2) -> Bool in
            var cDate1 = ""
            var cDate2 = ""
            if (model1.orderType ?? "").lowercased() == "dine in"{
                cDate1 = ((model1.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate1 = (model1.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate1 = "\(cDate1) \(model1.deliveryTime ?? "")"
            }
            if (model2.orderType ?? "").lowercased() == "dine in"{
                cDate2 = ((model2.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate2 = (model2.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate2 = "\(cDate2) \(model2.deliveryTime ?? "")"
            }
            if let date1 = cDate1.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil), let date2 = cDate2.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil){
                return date1 > date2
            }
            return true
        })
        self.arrNewOrder = self.arrNewOrder.sorted(by: { (model1, model2) -> Bool in
            var cDate1 = ""
            var cDate2 = ""
            if (model1.orderType ?? "").lowercased() == "dine in"{
                cDate1 = ((model1.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate1 = (model1.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate1 = "\(cDate1) \(model1.deliveryTime ?? "")"
            }
            if (model2.orderType ?? "").lowercased() == "dine in"{
                cDate2 = ((model2.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate2 = (model2.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate2 = "\(cDate2) \(model2.deliveryTime ?? "")"
            }
            if let date1 = cDate1.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil), let date2 = cDate2.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil){
                return date1 > date2
            }
            return true
        })
    }
    
    @IBAction func btnRefreshAction(_ sender:UIButton){
        self.view.endEditing(true)
        reloadPageData()
    }
    
    @IBAction func btnBackAction(_ sender:UIButton){
        self.parentVC.AddContainerView(data: parentVC.arrSideMenu.first!)
    }
    
    @IBAction func btnViewOrderAction(_ sender:UIButton){
        self.view.endEditing(true)
        var model:WebOrderModel!
        if sender.accessibilityIdentifier ?? "" == "0"{
            model = arrNewOrder[sender.tag]
        }else if sender.accessibilityIdentifier ?? "" == "1"{
            model = arrCurrentOrder[sender.tag]
        }else{
            model = arrCompletedOrder[sender.tag]
        }
        selectedOrderSection = Int(sender.accessibilityIdentifier ?? "") ?? 0
        selectedOrderRow = sender.tag
        if sender.accessibilityIdentifier ?? "" == "0"{
            if let _ = OrderDetailVC.addToParentView(parentVC: self.parentVC, orderId: model.id ?? 0, orderType: model.orderType ?? ""){
            }
        }else{
            let model = arrCurrentOrder[selectedOrderRow!]
            var settings = AlertSetting()
            if (model.orderType ?? "").lowercased() == "delivery"{
                settings.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_DELIVERED
                settings.alertTitle =  AppConstants.GlobalAlert.ALERT_DELIVERED_TITLE
            }else if (model.orderType ?? "").lowercased() == "pickup"{
                settings.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_COLLECTED
                settings.alertTitle =  AppConstants.GlobalAlert.ALERT_COLLECTED_TITLE
            }else{
                settings.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_RTS
                settings.alertTitle =  AppConstants.GlobalAlert.ALERT_RTS_TITLE
            }
            settings.type = .kDeliverOrder
            if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: settings){
                VC.delegate = self
            }
        }
    }
    
    @IBAction func btnOrderHistoryAction(_ sender:UIButton){
        self.view.endEditing(true)
        if let _ = OrderHistoryVC.addToParentView(parentVC: self.parentVC, isWebOrder: true, isFromOrders: true){
        }
    }
    
    //MARK:  API Calling
    @objc func GetOnlineOrders(isFromInterval:Bool = false){
        AppCommonMethods.startProgressBar()
        var dictParam = [String:String]()
        if let id = AppConstants.webResId{
            dictParam["restaurant_id"] = id
        }
        WebServiceManager().requestAPI(params: dictParam,  urlString: "\(AppConstants.APIURL.kOnlineOrder)home", method: "GET",isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let response = result as? NSDictionary{
                    self.arrNewOrder.removeAll()
                    self.arrCurrentOrder.removeAll()
                    if let arrO = response["pending_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        self.arrNewOrder = aData
                    }
                    if let arrO = response["pending_dinein_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        aData.forEach { model in
                            model.orderType = "dine in"
                        }
                        self.arrNewOrder.append(contentsOf: aData)
                    }
                    if let arrO = response["accepted_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        self.arrCurrentOrder = aData
                    }
                    if let arrO = response["accepted_dinein_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        aData.forEach { model in
                            model.orderType = "dine in"
                        }
                        self.arrCurrentOrder.append(contentsOf: aData)
                    }
                    if let arrO = response["completed_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        self.arrCompletedOrder = aData
                    }
                    if let arrO = response["completed_dinein_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        aData.forEach { model in
                            model.orderType = "dine in"
                        }
                        self.arrCompletedOrder.append(contentsOf: aData)
                    }
                    self.sortOrderList()
                    self.collectionOnlineOrders.reloadData()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
                self.collectionOnlineOrders.reloadData()
            }
        }
    }
    
    func CallSetOrderStatusAPI(status:String){
        var dictParam = [String:Any]()
        let orderType = arrCurrentOrder[selectedOrderRow!].orderType ?? ""
        let orderId = arrCurrentOrder[selectedOrderRow!].id ?? 0
        var strURL = "\(AppConstants.APIURL.kOnlineOrder)\(orderId)/change-status"
        if orderType.lowercased() == "dine in"{
            strURL = "\(AppConstants.APIURL.kOnlineDineinOrder)\(orderId)/change-status"
        }
        dictParam["status"] = status
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam,  urlString: strURL, method: "POST",isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let arrO = result as? NSDictionary, let data = AppCommonMethods.convertToJson(object: arrO), let model = try? jsonDecoder.decode(WebOrderModel.self, from: data){
                    var setting = BottomAlertSettings()
                    setting.strMessage = AppConstants.GlobalAlert.ORDER_COMPLETED
                    setting.isClickable = true
                    setting.id = orderId
                    setting.orderType = orderType
                    setting.type = .kOrder
                    if status == "Delivered"{
                        setting.bgColor = AppConstants.Colors.kAppDarkGreenColor
                        setting.strMessage = AppConstants.GlobalAlert.ORDER_COMPLETED
                    }
                    AppValidation().showBottomAlertView(settings: setting)
                    if self.selectedOrderSection! == 0{
                        self.arrNewOrder.remove(at: self.selectedOrderRow!)
                    }else{
                        self.arrCurrentOrder.remove(at: self.selectedOrderRow!)
                    }
                    if orderType.lowercased() == "dine in"{
                        model.orderType = "dine in"
                        let createDate = (model.created ?? "").components(separatedBy: "T").first ?? ""
                        if let date = createDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                            if let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil){
                                if date == currentDate{
                                    if (model.status ?? "").lowercased() == "accepted"{
                                        self.arrCurrentOrder.append(model)
                                    }else if (model.status ?? "").lowercased() == "delivered"{
                                        self.arrCompletedOrder.append(model)
                                    }
                                }
                            }
                        }
                    }else{
                        let cDate = (model.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                        if let date = cDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                            let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil)!
                            if date >= currentDate{
                                if (model.status ?? "").lowercased() == "accepted"{
                                    self.arrCurrentOrder.append(model)
                                }else if (model.status ?? "").lowercased() == "delivered"{
                                    self.arrCompletedOrder.append(model)
                                }
                            }
                        }
                    }
                    self.sortOrderList()
                    self.collectionOnlineOrders.reloadData()
                    BadgeManager.shared?.stopLastAPICall()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
}

//MARK:  CollectionView Methods
extension OnlineOrdersVC: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout{
    func numberOfSections(in collectionView: UICollectionView) -> Int {
        return 3
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        switch section {
        case 0:
            return (self.arrNewOrder.count == 0) ? 0 : self.arrNewOrder.count+1
        case 1:
            return (self.arrCurrentOrder.count == 0) ? 0 : self.arrCurrentOrder.count+1
        case 2:
            return (self.arrCompletedOrder.count == 0) ? 0 : self.arrCompletedOrder.count+1
        default:
            return 0
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        if indexPath.row == 0{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "ProductHeaderCollectionCell", for: indexPath) as! ProductHeaderCollectionCell
            switch indexPath.section {
            case 0:
                cell.lblTitle.text = "New order (\(self.arrNewOrder.count))"
            case 1:
                cell.lblTitle.text = "Order in progress (\(self.arrCurrentOrder.count))"
            case 2:
                cell.lblTitle.text = "Completed orders (\(self.arrCompletedOrder.count))"
            default:
                break
            }
            return cell
        }
        var isDelayed = false
        var model:WebOrderModel!
        if indexPath.section == 0{
            model = self.arrNewOrder[indexPath.row-1]
        }else if indexPath.section == 1{
            model = self.arrCurrentOrder[indexPath.row-1]
            var cDate = ""
            if (model.orderType ?? "").lowercased() == "dine in"{
                cDate = ((model.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd") ?? ""
            }else{
                cDate = (model.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
            }
            if let time = model.preparation, let preparation = "\(cDate) \(time)".getDateFromString(format: "yyyy-MM-dd hh:mm a"){
                if preparation <= Date(){
                    isDelayed = true
                }
            }
        }else{
            model = self.arrCompletedOrder[indexPath.row-1]
        }
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: isDelayed ? "DelayedOrderViewCell" : "OrderViewCell", for: indexPath) as! OrderViewCell
        cell.btnView.tag = indexPath.row-1
        cell.btnView.accessibilityIdentifier = "\(indexPath.section)"
        
        cell.lblUserName.text = model.customerName ?? ""
        if model.paymentStatus ?? "" == "P"{
            cell.lblPaid.text = "Paid"
            cell.lblPaid.textColor = AppConstants.Colors.kAppMediumGreenColor
        }else{
            cell.lblPaid.text = "Unpaid"
            cell.lblPaid.textColor = AppConstants.Colors.kAppThemeRedColor
        }
        cell.lblPaid.transform = CGAffineTransform(rotationAngle: CGFloat.pi / 2)
        cell.lblMainStatus.text = model.displayOrderType
        var strStatus = "Tap to view"
        cell.btnView.isHidden = false
        if !isDelayed{
            cell.lblStatus.superview?.isHidden = true
            cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            cell.lblMainStatus.textColor = AppConstants.Colors.kAppThemeTextColor
            cell.lblUserName.textColor = AppConstants.Colors.kAppThemeTextColor
        }
        if indexPath.section == 0{
            if (model.orderType ?? "").lowercased() == "delivery"{
                cell.viewForBG.backgroundColor = AppConstants.Colors.kAppDarkGreenColor
            }else if (model.orderType ?? "").lowercased() == "pickup"{
                cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBlueColor
            }else{
                cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeYellowColor
            }
            var cDate = ""
            if (model.orderType ?? "").lowercased() == "dine in"{
                cDate = ((model.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd") ?? ""
            }else{
                cDate = (model.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
            }
            if let date = cDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil)!
                if date > currentDate{
                    cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeMediumRedColor
                    cell.lblMainStatus.text = "Preorder - \(model.displayOrderType)"
                }
            }
            cell.lblMainStatus.textColor = .white
            cell.lblUserName.textColor = .white
        }else if indexPath.section == 1{
            if isDelayed{
                cell.lblUserName.textColor = .white
                cell.lblMainStatus.textColor = .white
            }
            if (model.orderType ?? "").lowercased() == "delivery"{
                strStatus = "Mark as delivered"
            }else if (model.orderType ?? "").lowercased() == "pickup"{
                strStatus = "Mark as collected"
            }else if (model.orderType ?? "").lowercased() == "dine in"{
                strStatus = "Ready to serve"
            }
        }else{
            cell.lblStatus.superview?.isHidden = false
            cell.imgStatus.image  = UIImage.init(named: (model.status ?? "" == "Delivered") ? "ic_selected_green" : "ic_close_red")
            cell.lblStatus.textColor = (model.status ?? "" == "Delivered") ? AppConstants.Colors.kAppDarkGreenColor : AppConstants.Colors.kAppThemeRedColor
            cell.imgStatus.imageColor = (model.status ?? "" == "Delivered") ? AppConstants.Colors.kAppDarkGreenColor : AppConstants.Colors.kAppThemeRedColor
            if (model.orderType ?? "").lowercased() == "delivery"{
                cell.lblStatus.text = (model.status ?? "" == "Delivered") ? "Delivered" : "Rejected"
            }else if (model.orderType ?? "").lowercased() == "pickup"{
                cell.lblStatus.text = (model.status ?? "" == "Delivered") ? "Collected" : "Rejected"
            }else if (model.orderType ?? "").lowercased() == "dine in"{
                cell.lblStatus.text = (model.status ?? "" == "Delivered") ? "Served" : "Rejected"
            }else{
                cell.lblStatus.text = ""
            }
            cell.btnView.isHidden = true
        }
        cell.btnView.setTitle(strStatus, for: .normal)
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        if indexPath.row == 0{
            return CGSize.init(width: self.view.frame.width-28, height: 50)
        }
        return CGSize.init(width: equalCellWidth(), height: 145)
    }
    
    func equalCellWidth()->CGFloat{
        let width = self.view.frame.width-28
        let cellWidth = width/round(width/250)
        return floor(cellWidth)
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if indexPath.row == 0{
            return
        }
        var model:WebOrderModel!
        if indexPath.section == 0{
            model = self.arrNewOrder[indexPath.row-1]
        }else if indexPath.section == 1{
            model = self.arrCurrentOrder[indexPath.row-1]
        }else{
            model = self.arrCompletedOrder[indexPath.row-1]
        }
        if let VC = OrderDetailVC.addToParentView(parentVC: self.parentVC, orderId: model.id ?? 0, orderType: model.orderType ?? ""){
            VC.delegate = self
        }
    }
}

extension OnlineOrdersVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data:alertViewData,type:AlertType) {
        if index == 1{
            CallSetOrderStatusAPI(status: "Delivered")
        }
    }
}

extension OnlineOrdersVC:pageRefreshDelegate{
    func pageNeedToRefresh() {
        self.GetOnlineOrders()
    }
}
