//
//  OrderListVC.swift
//  EPOS
//
//  Created by Apple on 23/04/21.
//

import UIKit

class OrderListVC: UIViewController {
    
    //IBOutlets
    @IBOutlet weak var collectionAllOrders:UICollectionView!
    @IBOutlet weak var collectionWaitingOrders:UICollectionView!
    @IBOutlet weak var collectionCollectionOrders:UICollectionView!
    @IBOutlet weak var collectionDeliveryOrders:UICollectionView!
    @IBOutlet weak var collectionOnlineOrders:UICollectionView!
    @IBOutlet weak var scrollOrders:UIScrollView!
    @IBOutlet weak var txtSearch:UITextField!
    @IBOutlet weak var lblOrderTitle:UILabel!
    @IBOutlet weak var lblSelectedOrders:UILabel!
    @IBOutlet weak var viewForArchieved:UIView!
    @IBOutlet weak var btnBack:UIButton!
    @IBOutlet weak var btnSelect:UIButton!
    @IBOutlet weak var btnArchieveOrders:UIButton!
    @IBOutlet weak var btnOrderHistory:UIButton!
    @IBOutlet weak var viewForOrderSelection:UIView!
    @IBOutlet weak var viewForHeader:UIView!
    @IBOutlet weak var lblShowAll:UILabel!
    @IBOutlet weak var lblAllActiveOrder:UILabel!
    @IBOutlet weak var lblWaiting:UILabel!
    @IBOutlet weak var lblWaitingActiveOrder:UILabel!
    @IBOutlet weak var lblCollection:UILabel!
    @IBOutlet weak var lblCollectionActiveOrder:UILabel!
    @IBOutlet weak var lblDelivery:UILabel!
    @IBOutlet weak var lblDeliveryActiveOrder:UILabel!
    @IBOutlet weak var lblOnlineOrders:UILabel!
    @IBOutlet weak var lblOnlineActiveOrder:UILabel!
    @IBOutlet weak var lblDeliveryLine:UILabel!
    @IBOutlet weak var lblCollectionLine:UILabel!
    @IBOutlet weak var lblWaitingLine:UILabel!
    @IBOutlet weak var lblShowAllLine:UILabel!
    @IBOutlet weak var lblOnlineLine:UILabel!
    
    //MARK:  Variable
    var totalPage = 1
    var pageLimit = 0
    var arrOngoingDeliveryOrders = [OrderModel]()
    var arrCompletedDeliveryOrders = [OrderModel]()
    var arrOngoingCollectionOrders = [OrderModel]()
    var arrCompletedCollectionOrders = [OrderModel]()
    var arrOngoingWaitingOrders = [OrderModel]()
    var arrCompletedWaitingOrders = [OrderModel]()
    var arrSearchCompletedDeliveryOrders = [OrderModel]()
    var arrSearchOngoingDeliveryOrders = [OrderModel]()
    var arrSearchCompletedCollectionOrders = [OrderModel]()
    var arrSearchOngoingCollectionOrders = [OrderModel]()
    var arrSearchCompletedWaitingOrders = [OrderModel]()
    var arrSearchOngoingWaitingOrders = [OrderModel]()
    var selectedOrderType:OrderTypesModel?
    var strTitle = ""
    var isSearchEnabled = false
    var arrNewOrder = [WebOrderModel]()
    var arrCompletedOrder = [WebOrderModel]()
    var arrCurrentOrder = [WebOrderModel]()
    var selectedOrderRow:Int?
    var selectedOrderSection:Int?
    var dictOrders = NSMutableDictionary()
    var arrOrderSection = [String]()
    var dictSearchOrders = NSMutableDictionary()
    var arrSelectedOrders = [OrderModel]()
    var isArchievedSelected = false
    var parentVC:SideMenuVC!
    var arrOrderTypeIds = [Int]()
    var selectedOrder:OrderModel!
    var collectionCount = 0
    var waitingCount = 0
    var deliveryCount = 0
    var selectedOrderTypeIndex:Int?
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        if AppConstants.userData?.permissions?.archiveOrder?.actions?.list ?? 0 == 1{
            btnSelect.isHidden = false
            btnArchieveOrders.isHidden = false
        }else{
            btnSelect.isHidden = true
            btnArchieveOrders.isHidden = true
        }
        if AppConstants.userData?.permissions?.orderHistory?.actions?.list ?? 0 == 1{
            btnOrderHistory.isHidden = false
        }else{
            btnOrderHistory.isHidden = true
        }
        txtSearch.superview?.isHidden = false
        setOrderTypeView()
        reloadPageData()
        DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
            self.setContentOffset()
        }
        lblOrderTitle.text = ""
    }
    
    override func viewWillAppear(_ animated: Bool) {
        NotificationCenter.default.addObserver(self, selector: #selector(checkForOrderType), name: AppConstants.notifications.kDatabasePulled, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(reloadPageData), name: AppConstants.notifications.kDatabasePushed, object: nil)
        viewForArchieved.isHidden = true
        isSearchEnabled = false
        txtSearch.text = ""
        reloadPageData()
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        NotificationCenter.default.removeObserver(self, name: AppConstants.notifications.kDatabasePushed, object: nil)
        NotificationCenter.default.removeObserver(self, name: AppConstants.notifications.kDatabasePulled, object: nil)
    }
    
    override func viewDidLayoutSubviews() {
        print("viewDidLayoutSubviews")
        let width = self.view.frame.width-28
        if self.selectedOrderTypeIndex != nil{
            self.scrollOrders.contentOffset = CGPoint.init(x: width*CGFloat(self.selectedOrderTypeIndex!), y: 0)
        }
        if self.selectedOrderType != nil{
            if self.selectedOrderType?.id ?? 0 == 5{
                self.collectionWaitingOrders.reloadData()
            }else if self.selectedOrderType?.id ?? 0 == 2{
                self.collectionCollectionOrders.reloadData()
            }else if self.selectedOrderType?.id ?? 0 == 6{
                self.collectionDeliveryOrders.reloadData()
            }else{
                self.collectionAllOrders.reloadData()
            }
        }else{
            self.collectionAllOrders.reloadData()
        }
    }
    
    //MARK:  ViewController Instance
    static func instance()->OrderListVC?{
        return UIStoryboard.init(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "OrderListVC") as? OrderListVC
    }
    
    //MARK:  ViewController Instance
    static func addToParentView(parentVC:SideMenuVC, title:String, orderTypeId:Int = 0)->OrderListVC?{
        guard let VC = UIStoryboard.init(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "OrderListVC") as? OrderListVC else {
            return nil
        }
        VC.parentVC = parentVC
        VC.strTitle = title
        VC.selectedOrderType = AppConstants.arrOrderTypes.filter({ (model) -> Bool in
            return model.id ?? 0 == orderTypeId
        }).first
        
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    @objc func reloadPageData(){
//        if AppConstants.DataSyncMode == "Auto" && Reachabilities.shared.isConnectedToNetwork(){
//            self.FetchOrdersList()
//        }else{
            self.checkForOrderType()
//        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1{
            GetOnlineOrders()
        }
    }
    
    @objc func checkForOrderType(){
        self.arrOrderTypeIds = [0]
        if AppCommonMethods.fetchSiteSettingValue(key: "is_waiting") ?? "" == "true" && AppConstants.userData?.permissions?.waiting?.actions?.list ?? 0 == 1{
            self.arrOrderTypeIds.append(5)
            self.collectionWaitingOrders.isHidden = false
            self.lblWaiting.superview?.isHidden = false
        }else{
            self.collectionWaitingOrders.isHidden = true
            self.lblWaiting.superview?.isHidden = true
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_collection") ?? "" == "true" && AppConstants.userData?.permissions?.collection?.actions?.list ?? 0 == 1{
            self.arrOrderTypeIds.append(2)
            self.collectionCollectionOrders.isHidden = false
            self.lblCollection.superview?.isHidden = false
        }else{
            self.collectionCollectionOrders.isHidden = true
            self.lblCollection.superview?.isHidden = true
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_delivery") ?? "" == "true" && AppConstants.userData?.permissions?.delivery?.actions?.list ?? 0 == 1{
            self.arrOrderTypeIds.append(3)
            self.collectionDeliveryOrders.isHidden = false
            self.lblDelivery.superview?.isHidden = false
        }else{
            self.collectionDeliveryOrders.isHidden = true
            self.lblDelivery.superview?.isHidden = true
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1{
            self.arrOrderTypeIds.append(6)
            self.lblOnlineOrders.superview?.isHidden = false
            self.collectionOnlineOrders.isHidden = false
        }else{
            self.lblOnlineOrders.superview?.isHidden = true
            self.collectionOnlineOrders.isHidden = true
        }
        var totalCount = 0
        self.arrOrderSection.removeAll()
        if AppCommonMethods.fetchSiteSettingValue(key: "is_waiting") ?? "" == "true" && AppConstants.userData?.permissions?.waiting?.actions?.list ?? 0 == 1{
            if AppCommonMethods.fetchSiteSettingValue(key: "show_completed_orders") ?? "" == "true"{
                self.arrCompletedWaitingOrders = SQLiteManage.fetchAllOrdersData(orderType: 5)
            }else{
                self.arrOngoingWaitingOrders = SQLiteManage.fetchOngoingOrdersData(orderType: 5)
            }
            var arr = self.arrCompletedWaitingOrders
            arr.append(contentsOf: self.arrOngoingWaitingOrders)
            arr.sort { model1, model2 in
                return model1.id ?? 0 > model2.id ?? 0
            }
            self.waitingCount = arr.count
            self.dictOrders["Waiting"] = arr
            if self.waitingCount > 0{
                self.arrOrderSection.append("Waiting")
            }
            totalCount = self.waitingCount
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_collection") ?? "" == "true" && AppConstants.userData?.permissions?.collection?.actions?.list ?? 0 == 1{
            if AppCommonMethods.fetchSiteSettingValue(key: "show_completed_orders") ?? "" == "true"{
                self.arrCompletedCollectionOrders = SQLiteManage.fetchAllOrdersData(orderType: 2)
            }else{
                self.arrOngoingCollectionOrders = SQLiteManage.fetchOngoingOrdersData(orderType: 2)
            }
            var arr = self.arrCompletedCollectionOrders
            arr.append(contentsOf: self.arrOngoingCollectionOrders)
            arr.sort { model1, model2 in
                return model1.id ?? 0 > model2.id ?? 0
            }
            self.collectionCount = arr.count
            self.dictOrders["Collection"] = arr
            if self.collectionCount > 0{
                self.arrOrderSection.append("Collection")
            }
            totalCount += self.collectionCount
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_delivery") ?? "" == "true" && AppConstants.userData?.permissions?.delivery?.actions?.list ?? 0 == 1{
            if AppCommonMethods.fetchSiteSettingValue(key: "show_completed_orders") ?? "" == "true"{
                self.arrCompletedDeliveryOrders = SQLiteManage.fetchAllOrdersData(orderType: 3)
            }else{
                self.arrOngoingDeliveryOrders = SQLiteManage.fetchOngoingOrdersData(orderType: 3)
            }
            var arr = self.arrCompletedDeliveryOrders
            arr.append(contentsOf: self.arrOngoingDeliveryOrders)
            arr.sort { model1, model2 in
                return model1.id ?? 0 > model2.id ?? 0
            }
            self.deliveryCount = arr.count
            self.dictOrders["Delivery"] = arr
            if self.deliveryCount > 0{
                self.arrOrderSection.append("Delivery")
            }
            totalCount += self.deliveryCount
        }
        if self.waitingCount > 0{
            self.lblWaitingActiveOrder.text = "\(self.waitingCount) Active Orders"
        }else{
            self.lblWaitingActiveOrder.text = "No Active Orders"
        }
        if self.collectionCount > 0{
            self.lblCollectionActiveOrder.text = "\(self.collectionCount) Active Orders"
        }else{
            self.lblCollectionActiveOrder.text = "No Active Orders"
        }
        if self.deliveryCount > 0{
            self.lblDeliveryActiveOrder.text = "\(self.deliveryCount) Active Orders"
        }else{
            self.lblDeliveryActiveOrder.text = "No Active Orders"
        }
        if totalCount > 0{
            self.lblAllActiveOrder.text = "\(totalCount) Active Orders"
        }else{
            self.lblAllActiveOrder.text = "No Active Orders"
        }
        self.collectionAllOrders.reloadData()
        self.collectionDeliveryOrders.reloadData()
        self.collectionCollectionOrders.reloadData()
        self.collectionWaitingOrders.reloadData()
    }
    
    func sortOrderList(){
        self.arrCompletedOrder = self.arrCompletedOrder.sorted(by: { (model1, model2) -> Bool in
            var cDate1 = ""
            var cDate2 = ""
            if (model1.orderType ?? "").lowercased() == "dine in"{
                cDate1 = ((model1.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate1 = (model1.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate1 = "\(cDate1) \(model1.deliveryTime ?? "")"
            }
            if (model2.orderType ?? "").lowercased() == "dine in"{
                cDate2 = ((model2.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate2 = (model2.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate2 = "\(cDate2) \(model2.deliveryTime ?? "")"
            }
            if let date1 = cDate1.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil), let date2 = cDate2.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil){
                return date1 > date2
            }
            return true
        })
        self.arrCurrentOrder = self.arrCurrentOrder.sorted(by: { (model1, model2) -> Bool in
            var cDate1 = ""
            var cDate2 = ""
            if (model1.orderType ?? "").lowercased() == "dine in"{
                cDate1 = ((model1.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate1 = (model1.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate1 = "\(cDate1) \(model1.deliveryTime ?? "")"
            }
            if (model2.orderType ?? "").lowercased() == "dine in"{
                cDate2 = ((model2.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate2 = (model2.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate2 = "\(cDate2) \(model2.deliveryTime ?? "")"
            }
            if let date1 = cDate1.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil), let date2 = cDate2.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil){
                return date1 > date2
            }
            return true
        })
        self.arrNewOrder = self.arrNewOrder.sorted(by: { (model1, model2) -> Bool in
            var cDate1 = ""
            var cDate2 = ""
            if (model1.orderType ?? "").lowercased() == "dine in"{
                cDate1 = ((model1.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate1 = (model1.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate1 = "\(cDate1) \(model1.deliveryTime ?? "")"
            }
            if (model2.orderType ?? "").lowercased() == "dine in"{
                cDate2 = ((model2.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate2 = (model2.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                cDate2 = "\(cDate2) \(model2.deliveryTime ?? "")"
            }
            if let date1 = cDate1.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil), let date2 = cDate2.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil){
                return date1 > date2
            }
            return true
        })
    }
    
    func checkOrderSplite(orderData:OrderModel)->Bool{
        var isSplited = false
        for model in orderData.arrProducts{
            if model.orderSplitId ?? 0 != 0{
                isSplited = true
                break
            }
        }
        return isSplited
    }
    
    func setContentOffset(){
        if self.selectedOrderType?.id ?? 0 != 0{
            let width = self.view.frame.width - 28
            let index = arrOrderTypeIds.firstIndex(of: selectedOrderType?.id ?? 0)
            if index != nil{
                scrollOrders.contentOffset = CGPoint.init(x: width*CGFloat(index!), y: 0)
            }else{
                scrollOrders.contentOffset = CGPoint.init(x: 0, y: 0)
            }
        }
    }
    
    func setOrderTypeView(){
        lblShowAllLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblShowAll.textColor = AppConstants.Colors.kAppLightGrayColor
        lblAllActiveOrder.textColor = AppConstants.Colors.kAppLightGrayColor
        
        lblCollectionLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblCollection.textColor = AppConstants.Colors.kAppLightGrayColor
        lblCollectionActiveOrder.textColor = AppConstants.Colors.kAppLightGrayColor
        
        lblDeliveryLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblDelivery.textColor = AppConstants.Colors.kAppLightGrayColor
        lblDeliveryActiveOrder.textColor = AppConstants.Colors.kAppLightGrayColor
        
        lblWaitingLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblWaiting.textColor = AppConstants.Colors.kAppLightGrayColor
        lblWaitingActiveOrder.textColor = AppConstants.Colors.kAppLightGrayColor
        
        lblOnlineLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblOnlineOrders.textColor = AppConstants.Colors.kAppLightGrayColor
        lblOnlineActiveOrder.textColor = AppConstants.Colors.kAppLightGrayColor
        
        if AppConstants.userData?.permissions?.archiveOrder?.actions?.list ?? 0 == 1{
            btnSelect.isHidden = false
            btnArchieveOrders.isHidden = false
        }else{
            btnSelect.isHidden = true
            btnArchieveOrders.isHidden = true
        }
        txtSearch.superview?.isHidden = false
        if self.selectedOrderType?.id ?? 0 == 0{
            lblShowAllLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            lblShowAll.textColor = AppConstants.Colors.kAppThemeTextColor
            lblAllActiveOrder.textColor = AppConstants.Colors.kAppThemeTextColor
        }else{
            if selectedOrderType?.id ?? 0 == 2{
                lblCollectionLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                lblCollection.textColor = AppConstants.Colors.kAppThemeTextColor
                lblCollectionActiveOrder.textColor = AppConstants.Colors.kAppThemeTextColor
            }else if selectedOrderType?.id ?? 0 == 3{
                lblDeliveryLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                lblDelivery.textColor = AppConstants.Colors.kAppThemeTextColor
                lblDeliveryActiveOrder.textColor = AppConstants.Colors.kAppThemeTextColor
            }else if selectedOrderType?.id ?? 0 == 5{
                lblWaitingLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                lblWaiting.textColor = AppConstants.Colors.kAppThemeTextColor
                lblWaitingActiveOrder.textColor = AppConstants.Colors.kAppThemeTextColor
            }else if selectedOrderType?.id ?? 0 == 6{
                btnSelect.isHidden = true
                btnArchieveOrders.isHidden = true
                txtSearch.superview?.isHidden = true
                lblOnlineLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                lblOnlineOrders.textColor = AppConstants.Colors.kAppThemeTextColor
                lblOnlineActiveOrder.textColor = AppConstants.Colors.kAppThemeTextColor
                
            }
        }
    }
    
    //MARK:  Button Actions
    @IBAction func txtSearchChanged(_ sender:UITextField){
        if txtSearch.text ?? "" == ""{
            isSearchEnabled = false
        }else{
            isSearchEnabled = true
            if self.selectedOrderType?.id ?? 0 == 0{
                dictOrders.forEach { (key, value) in
                    let arr = (value as! [OrderModel]).filter({ (model) -> Bool in
                        return (model.customer?.name ?? "").lowercased().contains((txtSearch.text ?? "").lowercased()) || "\(model.id ?? 0)".contains((txtSearch.text ?? ""))
                    })
                    dictSearchOrders[key as! String] = arr
                }
            }else{
                if selectedOrderType?.id ?? 0 == 2{
                    arrSearchOngoingCollectionOrders = arrOngoingCollectionOrders.filter({ (model) -> Bool in
                        return (model.customer?.name ?? "").lowercased().contains((txtSearch.text ?? "").lowercased()) || "\(model.id ?? 0)".contains((txtSearch.text ?? ""))
                    })
                    arrSearchCompletedCollectionOrders = arrCompletedCollectionOrders.filter({ (model) -> Bool in
                        return (model.customer?.name ?? "").lowercased().contains((txtSearch.text ?? "").lowercased()) || "\(model.id ?? 0)".contains((txtSearch.text ?? ""))
                    })
                }else if selectedOrderType?.id ?? 0 == 3{
                    arrSearchOngoingDeliveryOrders = arrOngoingDeliveryOrders.filter({ (model) -> Bool in
                        return (model.customer?.name ?? "").lowercased().contains((txtSearch.text ?? "").lowercased()) || "\(model.id ?? 0)".contains((txtSearch.text ?? ""))
                    })
                    arrSearchCompletedDeliveryOrders = arrCompletedDeliveryOrders.filter({ (model) -> Bool in
                        return (model.customer?.name ?? "").lowercased().contains((txtSearch.text ?? "").lowercased()) || "\(model.id ?? 0)".contains((txtSearch.text ?? ""))
                    })
                }else if selectedOrderType?.id ?? 0 == 5{
                    arrSearchOngoingWaitingOrders = arrOngoingWaitingOrders.filter({ (model) -> Bool in
                        return (model.customer?.name ?? "").lowercased().contains((txtSearch.text ?? "").lowercased()) || "\(model.id ?? 0)".contains((txtSearch.text ?? ""))
                    })
                    arrSearchCompletedWaitingOrders = arrCompletedWaitingOrders.filter({ (model) -> Bool in
                        return (model.customer?.name ?? "").lowercased().contains((txtSearch.text ?? "").lowercased()) || "\(model.id ?? 0)".contains((txtSearch.text ?? ""))
                    })
                }
                
            }
        }
        collectionDeliveryOrders.reloadData()
        collectionAllOrders.reloadData()
        collectionWaitingOrders.reloadData()
        collectionCollectionOrders.reloadData()
    }
    
    @IBAction func btnRefreshAction(_ sender:UIButton){
        self.view.endEditing(true)
        reloadPageData()
    }
    
    @IBAction func btnSelectAction(_ sender:UIButton){
        isArchievedSelected = true
        viewForArchieved.isHidden = false
        collectionDeliveryOrders.reloadData()
        collectionAllOrders.reloadData()
        collectionWaitingOrders.reloadData()
        collectionCollectionOrders.reloadData()
    }
    
    @IBAction func btnBackAction(_ sender:UIButton){
        self.parentVC.AddContainerView(data: parentVC.arrSideMenu.first!)
    }
    
    @IBAction func btnArchieveAction(_ sender:UIButton){
        if arrSelectedOrders.count == 0{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.kSelectOneOrder, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
        }else{
            var settings = AlertSetting()
            settings.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_ARCHIVEORDER
            settings.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
            settings.type = .kEnterUserPassword
            settings.textPlcaeholder = "password"
            settings.titleColor = AppConstants.Colors.kAppLightGrayColor
            if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: settings){
                VC.delegate = self
            }
        }
    }
    
    @IBAction func btnCancelArchieveAction(_ sender:UIButton){
        isArchievedSelected = false
        arrSelectedOrders.removeAll()
        lblSelectedOrders.text = "0 orders selected"
        viewForArchieved.isHidden = true
        collectionDeliveryOrders.reloadData()
        collectionAllOrders.reloadData()
        collectionWaitingOrders.reloadData()
        collectionCollectionOrders.reloadData()
    }
    
    @IBAction func btnOrderTypeSelectionAction(_ sender:UIButton){
        isSearchEnabled = false
        txtSearch.text = ""
        let width = self.view.frame.width - 28
        selectedOrderTypeIndex = arrOrderTypeIds.firstIndex(of: sender.tag)
        if selectedOrderTypeIndex != nil{
            scrollOrders.contentOffset = CGPoint.init(x: width*CGFloat(selectedOrderTypeIndex!), y: 0)
        }else{
            scrollOrders.contentOffset = CGPoint.init(x: 0, y: 0)
        }
    }
    
    @IBAction func btnViewOrderAction(_ sender:UIButton){
        self.view.endEditing(true)
        if selectedOrderType?.id ?? 0 == 6{
            var model:WebOrderModel!
            if sender.accessibilityIdentifier ?? "" == "0"{
                model = arrNewOrder[sender.tag]
            }else if sender.accessibilityIdentifier ?? "" == "1"{
                model = arrCurrentOrder[sender.tag]
            }else{
                model = arrCompletedOrder[sender.tag]
            }
            selectedOrderSection = Int(sender.accessibilityIdentifier ?? "") ?? 0
            selectedOrderRow = sender.tag
            if sender.accessibilityIdentifier ?? "" == "0"{
                if let _ = OrderDetailVC.addToParentView(parentVC: self.parentVC, orderId: model.id ?? 0, orderType: model.orderType ?? ""){
                }
            }else{
                let model = arrCurrentOrder[selectedOrderRow!]
                var settings = AlertSetting()
                if (model.orderType ?? "").lowercased() == "delivery"{
                    settings.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_DELIVERED
                    settings.alertTitle =  AppConstants.GlobalAlert.ALERT_DELIVERED_TITLE
                }else if (model.orderType ?? "").lowercased() == "pickup"{
                    settings.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_COLLECTED
                    settings.alertTitle =  AppConstants.GlobalAlert.ALERT_COLLECTED_TITLE
                }else{
                    settings.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_RTS
                    settings.alertTitle =  AppConstants.GlobalAlert.ALERT_RTS_TITLE
                }
                settings.type = .kDeliverOrder
                if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: settings){
                    VC.delegate = self
                }
            }
        }else{
            if self.selectedOrderType?.id ?? 0 == 0{
                selectedOrder = isSearchEnabled ? (dictSearchOrders[arrOrderSection[Int(sender.accessibilityIdentifier ?? "") ?? 0]] as! [OrderModel])[sender.tag] : (dictOrders[arrOrderSection[Int(sender.accessibilityIdentifier ?? "") ?? 0]] as! [OrderModel])[sender.tag]
            }else{
                if self.selectedOrderType?.id ?? 0 == 3{
                    selectedOrder = isSearchEnabled ? arrSearchOngoingDeliveryOrders[sender.tag] : arrOngoingDeliveryOrders[sender.tag]
                }else if self.selectedOrderType?.id ?? 0 == 2{
                    selectedOrder = isSearchEnabled ? arrSearchOngoingCollectionOrders[sender.tag] : arrOngoingCollectionOrders[sender.tag]
                }else if self.selectedOrderType?.id ?? 0 == 5{
                    selectedOrder = isSearchEnabled ? arrSearchOngoingWaitingOrders[sender.tag] : arrOngoingWaitingOrders[sender.tag]
                }
            }
            if selectedOrder.totalPaid ?? 0 >= (selectedOrder.total ?? 0) && selectedOrder.total ?? 0 > 0{
                var setting = AlertSetting()
                if selectedOrder.orderTypeId ?? 0 == 5{
                    setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_RTS
                }else{
                    if selectedOrder.orderTypeId ?? 0 == 2{
                        if selectedOrder.orderStatusId ?? 0 != 6 && AppCommonMethods.fetchSiteSettingValue(key: "is_ready_to_collect") ?? "" == "true"{
                            setting.type = .kReadyToCollect
                            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_RTC
                        }else{
                            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_COLLECTED
                        }
                    }else{
                        if selectedOrder.orderStatusId ?? 0 != 6 && AppCommonMethods.fetchSiteSettingValue(key: "is_on_the_way") ?? "" == "true"{
                            setting.type = .kReadyToCollect
                            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_OTW
                        }else{
                            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_DELIVERED
                        }
                    }
                    if selectedOrder.orderStatusId ?? 0 != 6 && AppCommonMethods.fetchSiteSettingValue(key: "is_ready_to_collect") ?? "" == "true"{
                        setting.type = .kReadyToCollect
                        if selectedOrder.orderTypeId ?? 0 == 2{
                            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_RTC
                        }else{
                            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_OTW
                        }
                    }else{
                        if selectedOrder.orderTypeId ?? 0 == 2{
                            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_COLLECTED
                        }else{
                            setting.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_DELIVERED
                        }
                    }
                }
                if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
                    VC.delegate = self
                }
            }else{
                if let VC = CreateOrderVC.instance(){
                    VC.orderId = selectedOrder.id ?? 0
                    let orderType = OrderTypesModel.init()
                    orderType.id = selectedOrder.orderTypeId
                    orderType.type = selectedOrder.orderType
                    VC.orderData = AppCommonMethods.Copy(of: selectedOrder) ?? selectedOrder
                    VC.orderType = orderType
                    if selectedOrder.splitCount ?? 0 > 0 || self.checkOrderSplite(orderData: selectedOrder){
                        if let VC = SplitOrderVC.instance(){
                            VC.orderType = orderType
                            VC.orderData = AppCommonMethods.Copy(of: selectedOrder) ?? selectedOrder
                            self.navigationController?.pushViewController(VC, animated: true)
                        }
                    }else{
                        if let VC = OrderReviewVC.instance(){
                            VC.orderType = orderType
                            VC.orderData = AppCommonMethods.Copy(of: selectedOrder) ?? selectedOrder
                            self.navigationController?.pushViewController(VC, animated: true)
                        }
                    }
                    self.navigationController?.viewControllers.insert(VC, at: self.navigationController!.viewControllers.count - 1)
                }
            }
        }
    }
    
    @IBAction func btnOrderHistoryAction(_ sender:UIButton){
        self.view.endEditing(true)
        if let _ = OrderHistoryVC.addToParentView(parentVC: self.parentVC, isWebOrder: (selectedOrderType?.id ?? 0 == 6), isFromOrders: true){
        }
    }
    
    @IBAction func btnShowArchievedOrderAction(_ sender:UIButton){
        self.view.endEditing(true)
        if let _ = OrderHistoryVC.addToParentView(parentVC: self.parentVC, isArchived: 1, isFromOrders: true){
        }
    }
    
    //MARK:  API Calling
    
    func addNewOnlineOrder(order:WebOrderModel, isNewOrder:Bool){
        if isNewOrder{
            self.arrNewOrder.append(order)
        }else{
            self.arrCurrentOrder.append(order)
        }
        self.sortOrderList()
        self.collectionAllOrders.reloadData()
    }
    
    @objc func GetOnlineOrders(isFromInterval:Bool = false){
        AppCommonMethods.startProgressBar()
        var dictParam = [String:String]()
        if let id = AppConstants.webResId{
            dictParam["restaurant_id"] = id
        }
        WebServiceManager().requestAPI(params: dictParam,  urlString: "\(AppConstants.APIURL.kOnlineOrder)home", method: "GET",isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let response = result as? NSDictionary{
                    self.arrNewOrder.removeAll()
                    self.arrCurrentOrder.removeAll()
                    if let arrO = response["pending_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        self.arrNewOrder = aData
                    }
                    if let arrO = response["pending_dinein_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        aData.forEach { model in
                            model.orderType = "dine in"
                        }
                        self.arrNewOrder.append(contentsOf: aData)
                    }
                    if let arrO = response["accepted_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        self.arrCurrentOrder = aData
                    }
                    if let arrO = response["accepted_dinein_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        aData.forEach { model in
                            model.orderType = "dine in"
                        }
                        self.arrCurrentOrder.append(contentsOf: aData)
                    }
                    if let arrO = response["completed_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        self.arrCompletedOrder = aData
                    }
                    if let arrO = response["completed_dinein_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        aData.forEach { model in
                            model.orderType = "dine in"
                        }
                        self.arrCompletedOrder.append(contentsOf: aData)
                    }
                    self.sortOrderList()
                    self.collectionAllOrders.reloadData()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
                if self.arrNewOrder.count > 0{
                    self.lblOnlineActiveOrder.text = "\(self.arrNewOrder.count) Active Orders"
                }else{
                    self.lblOnlineActiveOrder.text = "No Active Orders"
                }
                self.collectionOnlineOrders.reloadData()
            }
        }
    }
    
    func CallSetOrderStatusAPI(status:String){
        var dictParam = [String:Any]()
        let orderType = arrCurrentOrder[selectedOrderRow!].orderType ?? ""
        let orderId = arrCurrentOrder[selectedOrderRow!].id ?? 0
        var strURL = "\(AppConstants.APIURL.kOnlineOrder)\(orderId)/change-status"
        if orderType.lowercased() == "dine in"{
            strURL = "\(AppConstants.APIURL.kOnlineDineinOrder)\(orderId)/change-status"
        }
        dictParam["status"] = status
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam,  urlString: strURL, method: "POST",isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let arrO = result as? NSDictionary, let data = AppCommonMethods.convertToJson(object: arrO), let model = try? jsonDecoder.decode(WebOrderModel.self, from: data){
                    var setting = BottomAlertSettings()
                    setting.strMessage = AppConstants.GlobalAlert.ORDER_COMPLETED
                    setting.isClickable = true
                    setting.id = orderId
                    setting.orderType = orderType
                    setting.type = .kOrder
                    if status == "Delivered"{
                        setting.bgColor = AppConstants.Colors.kAppDarkGreenColor
                        setting.strMessage = AppConstants.GlobalAlert.ORDER_COMPLETED
                    }
                    AppValidation().showBottomAlertView(settings: setting)
                    if self.selectedOrderSection! == 0{
                        self.arrNewOrder.remove(at: self.selectedOrderRow!)
                    }else{
                        self.arrCurrentOrder.remove(at: self.selectedOrderRow!)
                    }
                    if orderType.lowercased() == "dine in"{
                        model.orderType = "dine in"
                        let createDate = (model.created ?? "").components(separatedBy: "T").first ?? ""
                        if let date = createDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                            if let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil){
                                if date == currentDate{
                                    if (model.status ?? "").lowercased() == "accepted"{
                                        self.arrCurrentOrder.append(model)
                                    }else if (model.status ?? "").lowercased() == "delivered"{
                                        self.arrCompletedOrder.append(model)
                                    }
                                }
                            }
                        }
                    }else{
                        let cDate = (model.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                        if let date = cDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                            let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil)!
                            if date >= currentDate{
                                if (model.status ?? "").lowercased() == "accepted"{
                                    self.arrCurrentOrder.append(model)
                                }else if (model.status ?? "").lowercased() == "delivered"{
                                    self.arrCompletedOrder.append(model)
                                }
                            }
                        }
                    }
                    self.sortOrderList()
                    self.collectionAllOrders.reloadData()
                    BadgeManager.shared?.stopLastAPICall()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func ArchieveOrders()  {
        AppCommonMethods.startProgressBar()
        var dictParam = [String:String]()
        var arrIds = [String]()
        var arrOfflineOrder = [OrderModel]()
        for model in arrSelectedOrders{
            if model.isNewOrder == 1{
                model.isArchived = true
                arrOfflineOrder.append(model)
            }else{
                arrIds.append("\(model.id ?? 0)")
            }
        }
        if arrIds.count > 0{
            dictParam["ids"] = AppCommonMethods.convertJsontoString(json: arrIds)
            WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kArchiveOrders, method: "POST") { (message, result) in
                DispatchQueue.main.async {
                    if let response = result as? [NSDictionary]{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let _ = try? jsonDecoder.decode([OrderModel].self, from: data){
                            for id in arrIds{
                                _ = SQLiteManage.ExecuteQuery("UPDATE Orders SET is_update = 0 WHERE id = \(id)")
                            }
                        }
                    }
                    if arrOfflineOrder.count > 0{
                        BGAPIExecution.shared.allDataPushed = {
                            DispatchQueue.main.async {
                                AppCommonMethods.stopProgressBar()
                                self.checkForOrderType()
                                self.isArchievedSelected = false
                                self.arrSelectedOrders.removeAll()
                                self.viewForArchieved.isHidden = true
                            }
                        }
                        BGAPIExecution.shared.AddOrdersToQueue(arr: arrOfflineOrder)
                    }else{
                        AppCommonMethods.stopProgressBar()
                        self.checkForOrderType()
                        self.isArchievedSelected = false
                        self.arrSelectedOrders.removeAll()
                        self.viewForArchieved.isHidden = true
                    }
                }
            }
        }
    }
}

//MARK:  CollectionView Methods
extension OrderListVC: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout{
    func numberOfSections(in collectionView: UICollectionView) -> Int {
        if collectionView == collectionAllOrders{
            return self.arrOrderSection.count
        }
        if collectionView == collectionOnlineOrders{
            return 3
        }
        return 2
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if collectionView == collectionAllOrders{
            if let arr = (self.isSearchEnabled ? self.dictSearchOrders[self.arrOrderSection[section]] : self.dictOrders[self.arrOrderSection[section]]) as? [OrderModel]{
                return arr.count+1
            }
            return 0
        }
        if collectionView == collectionOnlineOrders{
            switch section {
            case 0:
                return (self.arrNewOrder.count == 0) ? 0 : self.arrNewOrder.count+1
            case 1:
                return (self.arrCurrentOrder.count == 0) ? 0 : self.arrCurrentOrder.count+1
            case 2:
                return (self.arrCompletedOrder.count == 0) ? 0 : self.arrCompletedOrder.count+1
            default:
                return 0
            }
        }
        var count = 0
        if self.isSearchEnabled{
            if collectionView == collectionDeliveryOrders{
                count = (section == 0) ? self.arrSearchOngoingDeliveryOrders.count : self.arrSearchCompletedDeliveryOrders.count
            }else if collectionView == collectionCollectionOrders{
                count = (section == 0) ? self.arrSearchOngoingCollectionOrders.count : self.arrSearchCompletedCollectionOrders.count
            }else if collectionView == collectionWaitingOrders{
                count = (section == 0) ? self.arrSearchOngoingWaitingOrders.count : self.arrSearchCompletedWaitingOrders.count
            }
        }else{
            if collectionView == collectionDeliveryOrders{
                count = (section == 0) ? self.arrOngoingDeliveryOrders.count : self.arrCompletedDeliveryOrders.count
            }else if collectionView == collectionCollectionOrders{
                count = (section == 0) ? self.arrOngoingCollectionOrders.count : self.arrCompletedCollectionOrders.count
            }else if collectionView == collectionWaitingOrders{
                count = (section == 0) ? self.arrOngoingWaitingOrders.count : self.arrCompletedWaitingOrders.count
            }
        }
        return (count == 0) ? 0 : count+1
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        if indexPath.row == 0{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "ProductHeaderCollectionCell", for: indexPath) as! ProductHeaderCollectionCell
            if collectionView == collectionAllOrders{
                cell.lblTitle.text = "\(self.arrOrderSection[indexPath.section]) Orders (\(((self.isSearchEnabled ? self.dictSearchOrders[self.arrOrderSection[indexPath.section]] : self.dictOrders[self.arrOrderSection[indexPath.section]]) as! [OrderModel]).count))"
            }else if collectionView == collectionOnlineOrders{
                switch indexPath.section {
                case 0:
                    cell.lblTitle.text = "New order (\(self.arrNewOrder.count))"
                case 1:
                    cell.lblTitle.text = "Order in progress (\(self.arrCurrentOrder.count))"
                case 2:
                    cell.lblTitle.text = "Completed orders (\(self.arrCompletedOrder.count))"
                default:
                    break
                }
            }else{
                switch indexPath.section {
                case 0:
                    var count = 0
                    if collectionView == collectionDeliveryOrders{
                        count = isSearchEnabled ? self.arrSearchOngoingDeliveryOrders.count : self.arrOngoingDeliveryOrders.count
                    }else if collectionView == collectionCollectionOrders{
                        count = isSearchEnabled ? self.arrSearchOngoingCollectionOrders.count : self.arrOngoingCollectionOrders.count
                    }else if collectionView == collectionWaitingOrders{
                        count = isSearchEnabled ? self.arrSearchOngoingWaitingOrders.count : self.arrOngoingWaitingOrders.count
                    }
                    cell.lblTitle.text = "Orders in progress (\(count))"
                case 1:
                    var count = 0
                    if collectionView == collectionDeliveryOrders{
                        count = isSearchEnabled ? self.arrSearchCompletedDeliveryOrders.count : self.arrCompletedDeliveryOrders.count
                    }else if collectionView == collectionCollectionOrders{
                        count = isSearchEnabled ? self.arrSearchCompletedCollectionOrders.count : self.arrCompletedCollectionOrders.count
                    }else if collectionView == collectionWaitingOrders{
                        count = isSearchEnabled ? self.arrSearchCompletedWaitingOrders.count : self.arrCompletedWaitingOrders.count
                    }
                    cell.lblTitle.text = "Recently completed (\(count))"
                default:
                    break
                }
            }
            return cell
        }
        if collectionView == collectionOnlineOrders{
            var isDelayed = false
            var model:WebOrderModel!
            if indexPath.section == 0{
                model = self.arrNewOrder[indexPath.row-1]
            }else if indexPath.section == 1{
                model = self.arrCurrentOrder[indexPath.row-1]
                var cDate = ""
                if (model.orderType ?? "").lowercased() == "dine in"{
                    cDate = ((model.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd") ?? ""
                }else{
                    cDate = (model.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                }
                if let time = model.preparation, let preparation = "\(cDate) \(time)".getDateFromString(format: "yyyy-MM-dd hh:mm a"){
                    if preparation <= Date(){
                        isDelayed = true
                    }
                }
            }else{
                model = self.arrCompletedOrder[indexPath.row-1]
            }
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: isDelayed ? "DelayedOrderViewCell" : "OrderViewCell", for: indexPath) as! OrderViewCell
            cell.btnView.tag = indexPath.row-1
            cell.btnView.accessibilityIdentifier = "\(indexPath.section)"
            
            cell.lblUserName.text = model.customerName ?? ""
            if model.paymentStatus ?? "" == "P"{
                cell.lblPaid.text = "Paid"
                cell.lblPaid.textColor = AppConstants.Colors.kAppMediumGreenColor
            }else{
                cell.lblPaid.text = "Unpaid"
                cell.lblPaid.textColor = AppConstants.Colors.kAppThemeRedColor
            }
            cell.lblPaid.transform = CGAffineTransform(rotationAngle: CGFloat.pi / 2)
            cell.lblMainStatus.text = model.displayOrderType
            var strStatus = "Tap to view"
            cell.btnView.isHidden = false
            if !isDelayed{
                cell.lblStatus.superview?.isHidden = true
                cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                cell.lblMainStatus.textColor = AppConstants.Colors.kAppThemeTextColor
                cell.lblUserName.textColor = AppConstants.Colors.kAppThemeTextColor
            }
            if indexPath.section == 0{
                if (model.orderType ?? "").lowercased() == "delivery"{
                    cell.viewForBG.backgroundColor = AppConstants.Colors.kAppDarkGreenColor
                }else if (model.orderType ?? "").lowercased() == "pickup"{
                    cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBlueColor
                }else{
                    cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeYellowColor
                }
                var cDate = ""
                if (model.orderType ?? "").lowercased() == "dine in"{
                    cDate = ((model.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd") ?? ""
                }else{
                    cDate = (model.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                }
                if let date = cDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                    let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil)!
                    if date > currentDate{
                        cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeMediumRedColor
                        cell.lblMainStatus.text = "Preorder - \(model.displayOrderType)"
                    }
                }
                cell.lblMainStatus.textColor = .white
                cell.lblUserName.textColor = .white
            }else if indexPath.section == 1{
                if isDelayed{
                    cell.lblUserName.textColor = .white
                    cell.lblMainStatus.textColor = .white
                }
                if (model.orderType ?? "").lowercased() == "delivery"{
                    strStatus = "Mark as delivered"
                }else if (model.orderType ?? "").lowercased() == "pickup"{
                    strStatus = "Mark as collected"
                }else if (model.orderType ?? "").lowercased() == "dine in"{
                    strStatus = "Ready to serve"
                }
            }else{
                cell.lblStatus.superview?.isHidden = false
                cell.imgStatus.image  = UIImage.init(named: (model.status ?? "" == "Delivered") ? "ic_selected_green" : "ic_close_red")
                cell.lblStatus.textColor = (model.status ?? "" == "Delivered") ? AppConstants.Colors.kAppDarkGreenColor : AppConstants.Colors.kAppThemeRedColor
                cell.imgStatus.imageColor = (model.status ?? "" == "Delivered") ? AppConstants.Colors.kAppDarkGreenColor : AppConstants.Colors.kAppThemeRedColor
                if (model.orderType ?? "").lowercased() == "delivery"{
                    cell.lblStatus.text = (model.status ?? "" == "Delivered") ? "Delivered" : "Rejected"
                }else if (model.orderType ?? "").lowercased() == "pickup"{
                    cell.lblStatus.text = (model.status ?? "" == "Delivered") ? "Collected" : "Rejected"
                }else if (model.orderType ?? "").lowercased() == "dine in"{
                    cell.lblStatus.text = (model.status ?? "" == "Delivered") ? "Served" : "Rejected"
                }else{
                    cell.lblStatus.text = ""
                }
                cell.btnView.isHidden = true
            }
            cell.btnView.setTitle(strStatus, for: .normal)
            return cell
        }
        var model:OrderModel!
        if collectionView == collectionAllOrders{
            model = ((self.isSearchEnabled ? self.dictSearchOrders[self.arrOrderSection[indexPath.section]] : self.dictOrders[self.arrOrderSection[indexPath.section]]) as! [OrderModel])[indexPath.row-1]
        }else{
            switch indexPath.section {
            case 0:
                if collectionView == collectionDeliveryOrders{
                    model = isSearchEnabled ? self.arrSearchOngoingDeliveryOrders[indexPath.row-1] : self.arrOngoingDeliveryOrders[indexPath.row-1]
                }else if collectionView == collectionCollectionOrders{
                    model = isSearchEnabled ? self.arrSearchOngoingCollectionOrders[indexPath.row-1] : self.arrOngoingCollectionOrders[indexPath.row-1]
                }else if collectionView == collectionWaitingOrders{
                    model = isSearchEnabled ? self.arrSearchOngoingWaitingOrders[indexPath.row-1] : self.arrOngoingWaitingOrders[indexPath.row-1]
                }
            case 1:
                if collectionView == collectionDeliveryOrders{
                    model = isSearchEnabled ? self.arrSearchCompletedDeliveryOrders[indexPath.row-1] : self.arrCompletedDeliveryOrders[indexPath.row-1]
                }else if collectionView == collectionCollectionOrders{
                    model = isSearchEnabled ? self.arrSearchCompletedCollectionOrders[indexPath.row-1] : self.arrCompletedCollectionOrders[indexPath.row-1]
                }else if collectionView == collectionWaitingOrders{
                    model = isSearchEnabled ? self.arrSearchCompletedWaitingOrders[indexPath.row-1] : self.arrCompletedWaitingOrders[indexPath.row-1]
                }
            default:
                break
            }
        }
        let isContain = self.arrSelectedOrders.contains { (order) -> Bool in
            return model.id ?? 0 == order.id ?? 0
        }
        if model.orderStatusId ?? 0 == 1 || model.orderStatusId ?? 0 == 2 || model.orderStatusId ?? 0 == 4 || model.orderStatusId ?? 0 == 12 || model.orderStatusId ?? 0 == 13 || model.orderStatusId ?? 0 == 14 || model.orderStatusId ?? 0 == 7 || model.orderStatusId ?? 0 == 6{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "OrderViewCell", for: indexPath) as! OrderViewCell
            cell.btnSelect.isHidden = true
            cell.constOrderTopSpace.constant = 10
            if self.isArchievedSelected{
                cell.constOrderTopSpace.constant = 40
                cell.btnSelect.isHidden = false
            }
            if isContain{
                cell.btnSelect.isSelected = true
            }else{
                cell.btnSelect.isSelected = false
            }
            if model.customer?.name ?? "" == ""{
                cell.lblUserName.isHidden = true
            }else{
                cell.lblUserName.isHidden = false
                cell.lblUserName.text = model.customer?.name ?? ""
            }
            cell.lblMainStatus.text = "#\(model.displayOrderId)\n\(model.orderType ?? "")"
            var strAction = "Pay order"
            if model.totalPaid ?? 0 >= model.total ?? 0 && model.total ?? 0 > 0{
                if model.orderTypeId ?? 0 == 3{
                    if model.orderStatusId ?? 0 != 6 && AppCommonMethods.fetchSiteSettingValue(key: "is_on_the_way") ?? "" == "true"{
                        strAction = "On the way"
                    }else{
                        strAction = "Mark as delivered"
                    }
                }else if model.orderTypeId ?? 0 == 2{
                    if model.orderStatusId ?? 0 != 6 && AppCommonMethods.fetchSiteSettingValue(key: "is_ready_to_collect") ?? "" == "true"{
                        strAction = "Ready to collect"
                    }else{
                        strAction = "Mark as collected"
                    }
                }else{
                    strAction = "Mark as served"
                }
                cell.lblPaid.text = "Paid"
                cell.lblPaid.textColor = AppConstants.Colors.kAppMediumGreenColor
            }else if model.totalPaid ?? 0 > 0{
                cell.lblPaid.text = "Partial Paid"
                cell.lblPaid.textColor = AppConstants.Colors.kAppThemeRedColor
            }else{
                cell.lblPaid.text = "Unpaid"
                cell.lblPaid.textColor = AppConstants.Colors.kAppThemeRedColor
            }
            if let status = model.orderStatus{
                cell.viewForBG.backgroundColor = UIColor.hexStr(hexStr: status.topColor ?? "", alpha: 1.0)
            }else{
                cell.viewForBG.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
            }
            cell.lblMainStatus.textColor = .white
            cell.lblUserName.textColor = .white
            cell.btnView.accessibilityIdentifier = "\(indexPath.section)"
            cell.btnView.tag = indexPath.row-1
            cell.lblStatus.superview?.isHidden = true
            cell.btnView.setTitle(strAction, for: .normal)
            cell.lblPaid.transform = CGAffineTransform(rotationAngle: CGFloat.pi / 2)
            return cell
        }else{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "CompletedOrderViewCell", for: indexPath) as! OrderViewCell
            if self.isArchievedSelected{
                cell.constOrderTopSpace.constant = 40
                cell.btnSelect.isHidden = false
                if isContain{
                    cell.btnSelect.isSelected = true
                }else{
                    cell.btnSelect.isSelected = false
                }
            }else{
                cell.btnSelect.isHidden = true
                cell.constOrderTopSpace.constant = 10
            }
            if model.customer?.name ?? "" == ""{
                cell.lblUserName.isHidden = true
            }else{
                cell.lblUserName.isHidden = false
                cell.lblUserName.text = model.customer?.name ?? ""
            }
            
            cell.lblMainStatus.text = "#\(model.displayOrderId)\n\(model.orderType ?? "")"
            cell.imgStatus.image  = UIImage.init(named: "ic_selected_green")
            cell.lblStatus.textColor = AppConstants.Colors.kAppDarkGreenColor
            cell.imgStatus.imageColor = AppConstants.Colors.kAppDarkGreenColor
            if model.orderTypeId ?? 0 == 3{
                cell.lblStatus.text = "Delivered"
            }else if model.orderTypeId ?? 0 == 2{
                cell.lblStatus.text = "Collected"
            }else{
                cell.lblStatus.text = "Served"
            }
            if model.orderStatusId ?? 0 == 10{
                cell.lblStatus.text = "Cancelled"
                cell.imgStatus.image  = UIImage.init(named: "ic_close_red")
                cell.lblStatus.textColor = AppConstants.Colors.kAppThemeRedColor
                cell.imgStatus.imageColor = AppConstants.Colors.kAppThemeRedColor
            }
            if let status = model.orderStatus{
                cell.viewForBG.backgroundColor = UIColor.hexStr(hexStr: status.topColor ?? "", alpha: 1.0)
                cell.imgStatus.imageColor = .white
                cell.lblStatus.textColor = .white
                cell.imgStatus.imageColor = .white
                cell.lblMainStatus.textColor = .white
                cell.lblUserName.textColor = .white
            }else{
                cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            }
            return cell
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        if indexPath.row == 0{
            return CGSize.init(width: self.view.frame.width-28, height: 50)
        }
        if self.isArchievedSelected{
            return CGSize.init(width: equalCellWidth(), height: collectionView == collectionOnlineOrders ? 175 : 205)
        }else{
            return CGSize.init(width: equalCellWidth(), height: collectionView == collectionOnlineOrders ? 145 : 175)
        }
    }
    
    func equalCellWidth()->CGFloat{
        let width = self.view.frame.width-28
        let cellWidth = width/round(width/250)
        return floor(cellWidth)
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if indexPath.row == 0{
            return
        }
        var aData:OrderModel!
        if collectionView == collectionAllOrders{
            aData = ((self.isSearchEnabled ? self.dictSearchOrders[self.arrOrderSection[indexPath.section]] : self.dictOrders[self.arrOrderSection[indexPath.section]]) as! [OrderModel])[indexPath.row-1]
            if aData.orderStatusId ?? 0 == 3 || aData.orderStatusId ?? 0 == 5 || aData.orderStatusId ?? 0 == 9 || aData.orderStatusId ?? 0 == 10 || aData.orderStatusId ?? 0 == 19 || aData.orderStatusId ?? 0 == 20{
                if let _ = OrderDetailVC.addToParentView(parentVC: self.parentVC, orderId: aData.id ?? 0, orderType: aData.orderType ?? "", orderData: aData){
                }
                return
            }
        }else if collectionView == collectionOnlineOrders{
            var model:WebOrderModel!
            if indexPath.section == 0{
                model = self.arrNewOrder[indexPath.row-1]
            }else if indexPath.section == 1{
                model = self.arrCurrentOrder[indexPath.row-1]
            }else{
                model = self.arrCompletedOrder[indexPath.row-1]
            }
            if let VC = OrderDetailVC.addToParentView(parentVC: self.parentVC, orderId: model.id ?? 0, orderType: model.orderType ?? ""){
                VC.delegate = self
            }
            return
        }else{
            if indexPath.section == 0{
                if collectionView == collectionDeliveryOrders{
                    aData = self.isSearchEnabled ? self.arrSearchOngoingDeliveryOrders[indexPath.row-1] : self.arrOngoingDeliveryOrders[indexPath.row-1]
                }else if collectionView == collectionCollectionOrders{
                    aData = self.isSearchEnabled ? self.arrSearchOngoingCollectionOrders[indexPath.row-1] : self.arrOngoingCollectionOrders[indexPath.row-1]
                }else if collectionView == collectionWaitingOrders{
                    aData = self.isSearchEnabled ? self.arrSearchOngoingWaitingOrders[indexPath.row-1] : self.arrOngoingWaitingOrders[indexPath.row-1]
                }
            }else{
                if collectionView == collectionDeliveryOrders{
                    aData = self.isSearchEnabled ? self.arrSearchCompletedDeliveryOrders[indexPath.row-1] : self.arrCompletedDeliveryOrders[indexPath.row-1]
                }else if collectionView == collectionCollectionOrders{
                    aData = self.isSearchEnabled ? self.arrSearchCompletedCollectionOrders[indexPath.row-1] : self.arrCompletedCollectionOrders[indexPath.row-1]
                }else if collectionView == collectionWaitingOrders{
                    aData = self.isSearchEnabled ? self.arrSearchCompletedWaitingOrders[indexPath.row-1] : self.arrCompletedWaitingOrders[indexPath.row-1]
                }
                if let _ = OrderDetailVC.addToParentView(parentVC: self.parentVC, orderId: aData.id ?? 0, orderType: aData.orderType ?? "", orderData: aData){
                }
                return
            }
        }
        if self.isArchievedSelected{
            let index = self.arrSelectedOrders.firstIndex(where: { (model) -> Bool in
                return model.id ?? 0 == aData.id ?? 0
            })
            if index != nil{
                self.arrSelectedOrders.remove(at: index!)
            }else{
                self.arrSelectedOrders.append(aData)
            }
            collectionDeliveryOrders.reloadData()
            collectionAllOrders.reloadData()
            collectionWaitingOrders.reloadData()
            collectionCollectionOrders.reloadData()
            self.lblSelectedOrders.text = "\(self.arrSelectedOrders.count) orders selected"
        }else{
            if let VC = CreateOrderVC.instance(){
                VC.orderId = aData.id ?? 0
                let orderType = OrderTypesModel.init()
                orderType.id = aData.orderTypeId
                orderType.type = aData.orderType
                VC.orderData = aData
                VC.orderType = orderType
                parentVC.navigationController?.pushViewController(VC, animated: true)
            }
        }
    }
    
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        if scrollView == scrollOrders{
            NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(setOrderSelectionView), object: nil)
            self.perform(#selector(setOrderSelectionView), with: nil, afterDelay: 0.1)
        }
    }
    
    @objc func setOrderSelectionView(){
        self.selectedOrderTypeIndex = self.scrollOrders.currentPage-1
        if self.scrollOrders.currentPage-1 == 0{
            selectedOrderType = nil
        }else{
            selectedOrderType = AppConstants.arrOrderTypes.filter({ (model) -> Bool in
                return model.id ?? 0 == arrOrderTypeIds[self.scrollOrders.currentPage-1]
            }).first
        }
        setOrderTypeView()
        isSearchEnabled = false
        txtSearch.text = ""
    }
}

extension OrderListVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data:alertViewData,type:AlertType) {
        if index == 1{
            if type == .kEnterUserPassword{
                for model in arrSelectedOrders{
                    _ = SQLiteManage.ExecuteQuery("UPDATE Orders SET is_archived = 1, is_update = 1 WHERE id = \(model.id ?? 0)")
                }
                if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                    ArchieveOrders()
                }else{
                    isArchievedSelected = false
                    arrSelectedOrders.removeAll()
                    viewForArchieved.isHidden = true
                    checkForOrderType()
                }
            }else{
                if selectedOrderType?.id ?? 0 == 6{
                    CallSetOrderStatusAPI(status: "Delivered")
                }else{
                    if type == .kReadyToCollect{
                        selectedOrder.orderStatusId = 6
                    }else{
                        selectedOrder.orderStatusId = 5
                    }
                    if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                        AppCommonMethods.startProgressBar()
                        BGAPIExecution.shared.orderSaved = { orderId, message in
                            DispatchQueue.main.async {
                                AppCommonMethods.stopProgressBar()
                                print("Order \(orderId) Saved To Server")
                                self.checkForOrderType()
                            }
                        }
                        BGAPIExecution.shared.AddOrderToQueue(order: selectedOrder)
                    }else{
                        SQLiteManage.SaveOrderIntoDatabase(order: selectedOrder, updated: 1)
                        checkForOrderType()
                    }
                }
            }
        }
    }
}

extension OrderListVC:UITextFieldDelegate{
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        //btnSearchAction(UIButton())
        return textField.resignFirstResponder()
    }
}


extension OrderListVC:pageRefreshDelegate{
    func pageNeedToRefresh() {
        self.GetOnlineOrders()
    }
}
