//
//  OrderReviewVC.swift
//  EPOS
//
//  Created by Apple on 16/07/21.
//

import UIKit
import FormTextField
import Stripe
import StripeTerminal

class OrderReviewVC: UIViewController {
    
    //MARK: IBOutlets
    @IBOutlet weak var btnOrderType:UIButton!
    @IBOutlet weak var btnSendOrder:UIButton!
    @IBOutlet weak var btnPrintOrder:UIButton!
    @IBOutlet weak var btnEditOrder:UIButton!
    @IBOutlet weak var lblOrderNo:UILabel!
    @IBOutlet weak var btnSelectPayment:UIButton!
    @IBOutlet weak var lblBalanceRemaining:UILabel!
    @IBOutlet weak var collectionOrders:UICollectionView!
    @IBOutlet weak var collectionGroups:UICollectionView!
    @IBOutlet weak var lblCash:UILabel!
    @IBOutlet weak var lblCard:UILabel!
    @IBOutlet weak var lblCheque:UILabel!
    @IBOutlet weak var lblGroupPaid:UILabel!
    @IBOutlet weak var imgCash:UIImageViewX!
    @IBOutlet weak var imgCard:UIImageViewX!
    @IBOutlet weak var imgCheque:UIImageViewX!
    @IBOutlet weak var lblSubTotal:UILabel!
    @IBOutlet weak var lblDeliveryCharge:UILabel!
    @IBOutlet weak var lblGratuity:UILabel!
    @IBOutlet weak var lblServiceCharge:UILabel!
    @IBOutlet weak var lblDiscount:UILabel!
    @IBOutlet weak var txtAmount:UITextField!
    @IBOutlet var btnPayments:[UIButton]!
    @IBOutlet weak var lblGrandTotal:UILabel!
    @IBOutlet weak var lblPayAmount:UILabel!
    @IBOutlet weak var lblPayTitle:UILabel!
    @IBOutlet weak var lblCardReader:UILabel!
    @IBOutlet weak var lblMoto:UILabel!
    @IBOutlet weak var lblManual:UILabel!
    @IBOutlet weak var lblPaymentLink:UILabel!
    @IBOutlet weak var viewForCardMode:UIView!
    @IBOutlet weak var viewForDoneEdit:UIView!
    @IBOutlet weak var btnEdit:UIButton!
    @IBOutlet weak var viewForPayments:UIView!
    @IBOutlet weak var viewForAmount:UIView!
    @IBOutlet weak var viewForAmountBG:UIView!
    @IBOutlet weak var constAmountTrailingSpace:NSLayoutConstraint!
    @IBOutlet weak var constPaymentModeHeight:NSLayoutConstraint!
    @IBOutlet weak var txtCardNumber:FormTextField!
    @IBOutlet weak var txtExpDate:FormTextField!
    @IBOutlet weak var txtCVV:FormTextField!
    @IBOutlet weak var txtChequeNumbert:UITextField!
    @IBOutlet weak var txtCardHolderName:UITextField!
    @IBOutlet weak var txtPhoneNumber:UITextField!
    @IBOutlet weak var lblCustomerName:UILabel!
    @IBOutlet weak var lblCustomerAddress:UILabel!
    @IBOutlet weak var lblCustomerMobile:UILabel!
    @IBOutlet weak var lblCustomerDetail:UILabel!
    @IBOutlet weak var btnBackPayment:UIButton!
    @IBOutlet weak var btnRemoveDiscount:UIButton!
    @IBOutlet weak var btnRemoveServiceCharge:UIButton!
    @IBOutlet weak var btnRemoveGratuity:UIButton!
    @IBOutlet weak var viewForCustomerDetails:UIView!
    @IBOutlet weak var viewForOrderPayment:UIView!
    @IBOutlet weak var viewForRemoveServiceCharge:UIView!
    @IBOutlet weak var viewForRemoveDiscount:UIView!
    @IBOutlet weak var viewForRemoveGratuity:UIView!
    @IBOutlet weak var viewForGroupServiceCharge:UIView!
    @IBOutlet weak var viewForGroupDiscount:UIView!
    @IBOutlet weak var viewForGroupGratuity:UIView!
    @IBOutlet weak var lblGroupGratuity:UILabel!
    @IBOutlet weak var lblGroupServiceCharge:UILabel!
    @IBOutlet weak var lblGroupDiscount:UILabel!
    
    //MARK: Instances
    var isEditOrder = false
    var arrProducts = [OrderProductModel]()
    var selectedTable:TableModel?
    var orderData:OrderModel!
    var orderGroup:OrderGroupModel?
    var orderType:OrderTypesModel!
    var selectedPayment:PaymentViewType?
    var selectedReader:CardReaderModel?
    var totalPaid = 0.0
    var totalAmount = 0.0
    var dictPaymentParamter = [String:Any]()
    var selectedAmount = 0.0
    var shouldGoBack = false
    var isAutoDiscount = false
    var isAutoServiceCharge = false
    var arrGroups = [OrderGroupModel]()
    var discoverCancelable: Cancelable?
    var popupVC:SelectCardReaderVC?
    var failedType = PaymentFailedType.kCardReader
    var arrStripeCard = [Reader]()
    var isReaderProcessStart = false
    var amountType = GratityViewType.kGratuity
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        if let data = SQLiteManage.fetchOrderDataByUniqueId(orderId: orderData.uniqueId){
            orderData = data
        }
        checkForAvailbleMethod()
        setCardNumberField()
        setCVVField()
        setExpDateField()
        self.arrGroups = SQLiteManage.fetchOrderGroupData(orderId: self.orderData?.id ?? 0)
        self.arrGroups.forEach { group in
            group.arrProducts = orderData.arrProducts.filter({ (model) -> Bool in
                return model.groupUniqueId == group.uniqueId
            })
//            if orderData.splitCount ?? 0 > 0{
//                group.subTotal = (orderData.subTotal ?? 0)/Double(orderData.splitCount ?? 0)
//            }else{
//                group.subTotal = group.arrProducts.reduce(0) { $0 + ($1.isDelete ? 0 : ($1.subTotal ?? 0)) }
//            }
        }
        if self.arrGroups.count > 0 && orderGroup == nil{
            orderGroup = self.arrGroups.first
        }else if orderGroup != nil{
            orderGroup = self.arrGroups.filter{ $0.uniqueId == orderGroup!.uniqueId }.first
        }
        if orderGroup == nil{
            arrProducts = orderData.arrProducts
        }
        setOrderView()
        PrintManager.shared.printingStoped = { [weak self] in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
            }
            if self?.shouldGoBack ?? false{
                if self?.orderData?.orderStatusId ?? 0 <= 2{
                    self?.CallCreateOrderAPI(orderStatusId: 2, action: 2, shouldPrint: true)
                }else{
                    self?.CallCreateOrderAPI(action: 2, shouldPrint: true)
                }
                PrintManager.shared.printingStoped = nil
            }
        }
        if orderGroup != nil{
            btnEdit.isHidden = true
        }
        self.setCustomerData()
        DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
            self.constPaymentModeHeight.constant = AppConstants.ScreenSize.SCREEN_HEIGHT - (165 + self.viewForCustomerDetails.frame.height + self.viewForOrderPayment.frame.height)
        }
        
        if selectedPayment != nil{
            setPaymentView(isFromLoad: true)
            btnSelectPayment.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
            btnSelectPayment.isEnabled = true
            viewForPayments.alpha = 0
            viewForAmount.alpha = 1
            viewForCardMode.alpha = 0
            if AppCommonMethods.fetchSiteSettingValue(key: "partial_payment_mode") ?? "" == "no" && arrGroups.count == 0{
                self.btnAmountSelectionAction(UIButton())
            }
        }
        Terminal.shared.delegate = self
    }
    
    //MARK: Create ViewController Instance
    static func instance()->OrderReviewVC?{
        return UIStoryboard.init(name: "Orders", bundle: nil).instantiateViewController(withIdentifier: "OrderReviewVC") as? OrderReviewVC
    }
    
    //MARK: FormTextField Method
    func setCardNumberField(){
        var validation = Validation()
        validation.maximumLength = "1234 5678 1234 5678".count
        validation.minimumLength = "1234 5678 1234".count
        let characterSet = NSMutableCharacterSet.decimalDigit()
        characterSet.addCharacters(in: " ")
        validation.characterSet = characterSet as CharacterSet
        let inputValidator = InputValidator(validation: validation)
        txtCardNumber.inputValidator = inputValidator
        txtCardNumber.inputType = .integer
        txtCardNumber.formatter = CardNumberFormatter()
    }
    
    func setCVVField(){
        var validation = Validation()
        validation.maximumLength = "CVC2".count
        validation.minimumLength = "CVC".count
        validation.characterSet = NSCharacterSet.decimalDigits
        let inputValidator = InputValidator(validation: validation)
        txtCVV.inputValidator = inputValidator
        txtCVV.inputType = .integer
    }
    
    func setExpDateField(){
        var validation = Validation()
        validation.maximumLength = "02/20".count
        validation.minimumLength = "02/20".count
        let inputValidator = InputValidator(validation: validation)
        txtExpDate.inputValidator = inputValidator
        txtExpDate.formatter = CardExpirationDateFormatter()
        txtExpDate.inputType = .integer
    }
    
    //MARK: General Method
    func fetchOrderFromDB(notificationId:Int){
        if notificationId != orderData.id ?? 0{
            return
        }
        if let order = SQLiteManage.fetchOrderDataById(orderId: notificationId){
            self.orderData = order
            selectedTable = order.table
            self.arrGroups = SQLiteManage.fetchOrderGroupData(orderId: notificationId)
            self.arrGroups.forEach { group in
                group.arrProducts = orderData.arrProducts.filter({ (model) -> Bool in
                    return model.groupUniqueId == group.uniqueId
                })
//                if orderData.splitCount ?? 0 > 0{
//                    group.subTotal = (orderData.subTotal ?? 0)/Double(orderData.splitCount ?? 0)
//                }else{
//                    group.subTotal = group.arrProducts.reduce(0) { $0 + ($1.isDelete ? 0 : ($1.subTotal ?? 0)) }
//                }
            }
            if self.orderGroup != nil{
                self.orderGroup = self.arrGroups.filter{ $0.uniqueId == self.orderGroup!.uniqueId }.first
            }else{
                self.orderGroup = self.arrGroups.first
            }
            if orderGroup == nil{
                arrProducts = orderData.arrProducts
            }
            setOrderView()
            self.setCustomerData()
            self.collectionGroups.reloadData()
            self.collectionOrders.reloadData()
        }
    }
    
    func setOrderButton(){
        if AppConstants.userData?.permissions?.sendOrder?.actions?.list ?? 0 == 1{
            btnSendOrder.superview?.isHidden = false
        }else{
            btnSendOrder.superview?.isHidden = true
        }
        self.btnRemoveDiscount.isHidden = true
        self.btnRemoveGratuity.isHidden = true
        self.btnRemoveServiceCharge.isHidden = true
        if (AppCommonMethods.fetchSiteSettingValue(key: "is_printbill") ?? "" == "true" && AppConstants.userData?.permissions?.printBill?.actions?.list ?? 0 == 1) || (AppCommonMethods.fetchSiteSettingValue(key: "is_printall") ?? "" == "true" && AppConstants.userData?.permissions?.printAll?.actions?.list ?? 0 == 1){
            btnPrintOrder.superview?.isHidden = false
        }else{
            btnPrintOrder.superview?.isHidden = true
        }
        if (orderData.totalPaid ?? 0).getRoundFigure() >= (orderData.total ?? 0).getRoundFigure(), orderData.total ?? 0 > 0{
            btnSelectPayment.isHidden = true
            btnEdit.isHidden = true
            btnEditOrder.superview?.isHidden = true
            btnSendOrder.superview?.isHidden = true
            btnPrintOrder.superview?.isHidden = true
        }
        if orderData?.orderStatusId ?? 0 == 10 || orderData?.orderStatusId ?? 0 == 5 || orderData?.orderStatusId ?? 0 == 4 || self.selectedTable?.id ?? 0 == 4{
            btnSendOrder.superview?.isHidden = true
            btnPrintOrder.superview?.isHidden = true
        }
        if orderData?.orderStatusId ?? 0 == 5{
            btnSendOrder.superview?.isHidden = true
            btnPrintOrder.superview?.isHidden = true
        }
    }
    
    func setOrderView(){
        btnOrderType.setTitle(" \(orderType.type ?? "") ", for: .normal)
        if orderGroup != nil{
            lblOrderNo.text = orderGroup?.groupName ?? ""
        }else{
            lblOrderNo.text = "ORD\(orderData.id ?? 0)"
        }
        checkForServiceCharge()
        checkForAutoDiscountType()
        self.lblSubTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign,orderData.subTotal ?? 0)
        var amount = (orderData.subTotal ?? 0) + (orderData.serviceCharge ?? 0)
        amount += ((orderData.gratuity ?? 0) - (orderData.discount ?? 0))
        self.orderData.total = amount
        self.lblGrandTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign, amount)
        if orderGroup != nil{
            if self.orderData.splitCount ?? 0 > 0{
                arrProducts = orderData.arrProducts
            }else{
                arrProducts = orderData.arrProducts.filter({ (model) -> Bool in
                    return model.groupUniqueId == orderGroup?.uniqueId ?? ""
                })
            }
            collectionGroups.isHidden = false
            if orderGroup?.serviceCharge ?? 0 > 0{
                viewForRemoveServiceCharge.isHidden = false
                lblGroupServiceCharge.text = String.init(format: "%@%.2f", AppConstants.currencySign, orderGroup?.serviceCharge ?? 0)
            }else{
                viewForRemoveServiceCharge.isHidden = true
            }
            if orderGroup?.discount ?? 0 > 0{
                viewForRemoveDiscount.isHidden = false
                lblGroupDiscount.text = String.init(format: "%@%.2f", AppConstants.currencySign, orderGroup?.discount ?? 0)
            }else{
                viewForRemoveDiscount.isHidden = true
            }
            if orderGroup?.gratuity ?? 0 > 0{
                viewForRemoveGratuity.isHidden = false
                lblGroupGratuity.text = String.init(format: "%@%.2f", AppConstants.currencySign, orderGroup?.gratuity ?? 0)
            }else{
                viewForRemoveGratuity.isHidden = true
            }
            orderGroup!.total = orderGroup!.subTotal + orderGroup!.serviceCharge + orderGroup!.gratuity - orderGroup!.discount
            totalAmount = (orderGroup!.total ?? 0).getRoundFigure()
            totalPaid = (orderGroup!.paidAmount ?? 0).getRoundFigure()
            if orderGroup?.paidAmount ?? 0 >= orderGroup?.total ?? 0{
                lblGroupPaid.isHidden = false
            }else{
                lblGroupPaid.isHidden = true
            }
            SQLiteManage.updateOrderGroupTotal(group: orderGroup!)
        }else{
            totalAmount = (amount + (orderData.deliveryCharge ?? 0) - (orderData.discount ?? 0)).getRoundFigure()
            totalPaid = (orderData.totalPaid ?? 0).getRoundFigure()
        }
        if orderData.discount ?? 0 != 0{
            self.lblDiscount.text = String.init(format: "-%@%.2f", AppConstants.currencySign, orderData.discount ?? 0)
            self.lblDiscount.superview?.superview?.isHidden = false
        }else{
            self.lblDiscount.superview?.superview?.isHidden = true
        }
        if orderData.serviceCharge ?? 0 != 0{
            self.lblServiceCharge.text = String.init(format: "%@%.2f", AppConstants.currencySign, orderData.serviceCharge ?? 0)
            self.lblServiceCharge.superview?.superview?.isHidden = false
        }else{
            self.lblServiceCharge.superview?.superview?.isHidden = true
        }
        if orderData.gratuity ?? 0 != 0{
            self.lblGratuity.text = String.init(format: "%@%.2f", AppConstants.currencySign, orderData.gratuity ?? 0)
            self.lblGratuity.superview?.superview?.isHidden = false
        }else{
            self.lblGratuity.superview?.superview?.isHidden = true
        }
        if orderData.deliveryCharge ?? 0 != 0{
            self.lblDeliveryCharge.text = String.init(format: "%@%.2f", AppConstants.currencySign, orderData.deliveryCharge ?? 0)
            self.lblDeliveryCharge.superview?.isHidden = false
        }else{
            self.lblDeliveryCharge.superview?.isHidden = true
        }
        self.viewForGroupServiceCharge.isHidden = true
        self.viewForGroupDiscount.isHidden = true
        self.viewForGroupGratuity.isHidden = true
        if self.arrGroups.count > 0{
            let serviceCharge = self.arrGroups.reduce(0) { $0 + $1.serviceCharge }
            let discount = self.arrGroups.reduce(0) { $0 + $1.discount }
            let gratuity = self.arrGroups.reduce(0) { $0 + $1.gratuity }
            if serviceCharge < self.orderData.serviceCharge ?? 0{
                self.viewForGroupServiceCharge.isHidden = false
            }
            if discount < self.orderData.discount ?? 0{
                self.viewForGroupDiscount.isHidden = false
            }
            if gratuity < self.orderData.gratuity ?? 0{
                self.viewForGroupGratuity.isHidden = false
            }
        }
        if viewForPayments.alpha == 1{
            selectedAmount = max(0,(totalAmount - totalPaid))
            self.txtAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedAmount)
        }
        setAmountView()
        collectionOrders.reloadData()
        setOrderButton()
        self.lblBalanceRemaining.text = String.init(format: "Balance Remaining: %@%.2f", AppConstants.currencySign, max(0, totalAmount - totalPaid))
    }
    
    func setCustomerData(){
        lblCustomerAddress.isHidden = true
        lblCustomerMobile.isHidden = true
        lblCustomerName.isHidden = true
        lblCustomerDetail.isHidden = true
        lblCustomerMobile.isHidden = true
        if orderData.customer?.mobile ?? "" != ""{
            lblCustomerName.isHidden = false
            lblCustomerDetail.isHidden = false
            lblCustomerName.text = orderData.customer?.name ?? ""
        }
        if orderType.id ?? 0 == 5{
            if orderData.customer?.email ?? "" != ""{
                lblCustomerMobile.isHidden = false
                lblCustomerDetail.isHidden = false
                lblCustomerMobile.text = orderData.customer?.email ?? ""
            }
        }else{
            if orderData.customer?.mobile ?? "" != ""{
                lblCustomerMobile.isHidden = false
                lblCustomerDetail.isHidden = false
                lblCustomerMobile.text = orderData.customer?.mobile ?? ""
            }
            if orderType.id ?? 0 == 3{
                var strCustomerInfo = orderData.customer?.houseNo ?? ""
                if strCustomerInfo == ""{
                    strCustomerInfo = orderData.customer?.street ?? ""
                }else{
                    strCustomerInfo = "\(strCustomerInfo), \(orderData.customer?.street ?? "")"
                }
                if strCustomerInfo == ""{
                    strCustomerInfo = orderData.customer?.postcode ?? ""
                }else{
                    strCustomerInfo = "\(strCustomerInfo), \(orderData.customer?.postcode ?? "")"
                }
                if strCustomerInfo == ""{
                    strCustomerInfo = orderData.customer?.city ?? ""
                }else{
                    strCustomerInfo = "\(strCustomerInfo), \(orderData.customer?.city ?? "")"
                }
                if strCustomerInfo != ""{
                    lblCustomerDetail.isHidden = false
                    lblCustomerAddress.isHidden = false
                    lblCustomerAddress.text = strCustomerInfo
                }
            }
        }
    }
    
    func checkForAvailbleMethod(){
        let isCreditCardAvaiable = AppConstants.arrPaymentMethods.contains { (model) -> Bool in
            return model.id ?? 0 == 2 || model.id ?? 0 == 10 || model.id ?? 0 == 9
        }
        if isCreditCardAvaiable{
            lblCard.superview?.isHidden = false
        }else{
            lblCard.superview?.isHidden = true
        }
        
        let isCashAvaiable = AppConstants.arrPaymentMethods.contains { (model) -> Bool in
            return model.id ?? 0 == 1
        }
        if isCashAvaiable{
            lblCash.superview?.isHidden = false
        }else{
            lblCash.superview?.isHidden = true
        }
        
        let isChequeAvaiable = AppConstants.arrPaymentMethods.contains { (model) -> Bool in
            return model.id ?? 0 == 3
        }
        if isChequeAvaiable{
            lblCheque.superview?.isHidden = false
        }else{
            lblCheque.superview?.isHidden = true
        }
        
        let isManualAvaiable = AppConstants.arrPaymentMethods.contains { (model) -> Bool in
            return model.id ?? 0 == 2
        }
        if isManualAvaiable{
            lblManual.superview?.isHidden = false
        }else{
            lblManual.superview?.isHidden = true
        }
        let isMotoAvailable = AppConstants.arrPaymentMethods.contains { (model) -> Bool in
            return model.id ?? 0 == 10
        }
        if isMotoAvailable{
            lblMoto.superview?.isHidden = false
        }else{
            lblMoto.superview?.isHidden = true
        }
        let isTTAvailable = AppConstants.arrPaymentMethods.contains { (model) -> Bool in
            return model.id ?? 0 == 9
        }
        if isTTAvailable{
            lblCardReader.superview?.isHidden = false
        }else{
            lblCardReader.superview?.isHidden = true
        }
        
    }
    
    func setPaymentView(isFromLoad:Bool = false){
        lblPayAmount.text = "Amount: \(txtAmount.text ?? "")"
        if selectedPayment! == .kCheque{
            lblPayTitle.text = "Cheque"
            self.constAmountTrailingSpace.constant = 0
            UIView.animate(withDuration: 0.25) {
                self.viewForAmountBG.alpha = 1
                self.view.layoutIfNeeded()
            }
            txtCardNumber.superview?.superview?.isHidden = true
            txtCardHolderName.superview?.superview?.isHidden = true
            txtExpDate.superview?.superview?.superview?.isHidden = true
            txtChequeNumbert.superview?.superview?.isHidden = false
        }else if selectedPayment! == .kCash && !isFromLoad{
            let remaingAmount = max(0, totalAmount - totalPaid)
            if selectedAmount <= remaingAmount{
                CallPaymentAPI(amount: selectedAmount, methodId:1)
            }else{
                CallPaymentAPI(amount: remaingAmount, methodId:1)
            }
        }else{
            lblPayTitle.text = "Moto Payment"
            txtChequeNumbert.superview?.superview?.isHidden = true
            txtCardNumber.superview?.superview?.isHidden = false
            txtCardHolderName.superview?.superview?.isHidden = false
            txtExpDate.superview?.superview?.superview?.isHidden = false
            viewForAmount.alpha = 0
            viewForCardMode.alpha = 1
            btnSelectPayment.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            btnSelectPayment.isEnabled = false
        }
    }
    
    func setAmountView(){
        for btn in btnPayments{
            if btn.tag == 0{
                if selectedAmount == (totalAmount - totalPaid){
                    btn.setTitleColor(.white, for: .normal)
                    btn.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                }else{
                    btn.setTitleColor(AppConstants.Colors.kAppDarkGrayColor, for: .normal)
                    btn.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                }
            }else{
                if Double(btn.tag) == selectedAmount{
                    btn.setTitleColor(.white, for: .normal)
                    btn.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                }else{
                    btn.setTitleColor(AppConstants.Colors.kAppDarkGrayColor, for: .normal)
                    btn.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                }
            }
        }
        
    }
    
    func checkMotoValidation()->Bool{
        if txtCardNumber.superview!.superview!.isHidden{
            if (txtPhoneNumber.text ?? "").trimmingCharacters(in: .whitespacesAndNewlines).isEmpty{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_ENTER_MOBILENO, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtPhoneNumber.becomeFirstResponder()
                }
                return false
            }else if (txtPhoneNumber.text ?? "").trimmingCharacters(in: .whitespaces).count < 10 || (txtPhoneNumber.text ?? "").trimmingCharacters(in: .whitespaces).count > 11{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_MOBILE_10_DIGIT, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtPhoneNumber.becomeFirstResponder()
                }
                return false
            }
        }else{
            if !txtCardNumber.validate(){
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_VALID_CARDNO, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtCardNumber.becomeFirstResponder()
                }
                return false
            }else if (txtExpDate.text?.trimmingCharacters(in: .whitespaces).isEmpty ?? false){
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_EMPTY_EXPIRYDATE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtExpDate.becomeFirstResponder()
                }
                return false
            }else if !txtExpDate.validate(){
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_VALID_EXPIRYDATE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtExpDate.becomeFirstResponder()
                }
                return false
            }else if (txtCVV.text?.trimmingCharacters(in: .whitespaces).isEmpty ?? false){
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_EMPTY_CVV, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtCVV.becomeFirstResponder()
                }
                return false
            }else if !txtCVV.validate(){
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_VALID_CVV, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtCVV.becomeFirstResponder()
                }
                return false
            }
        }
        return true
    }
    
    func showOrderModifiedToast(isFromAdd:Bool = false) -> Bool{
        if orderData?.orderStatusId ?? 0 == 10{
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_CANCELLED)
            return false
        }
        if orderData?.orderStatusId ?? 0 == 5{
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_COMPLETED)
            return false
        }
        if orderData?.orderStatusId ?? 0 == 6{
            if orderType.id ?? 0 == 3{
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_OTW)
            }else{
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_RTC)
            }
            return false
        }
        if orderData?.splitCount ?? 0 > 0{
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_SPLITED)
            return false
        }
        if !isFromAdd{
            if totalPaid > 0{
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_PAYMENT)
                return false
            }
        }
        if totalPaid > totalAmount && totalAmount > 0{
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_ORDER_MODIFIED_AFTER_PAYMENT)
            return false
        }
        return true
    }
    
    func checkForAutoDiscountType(){
        if isAutoDiscount{
            isAutoDiscount = false
            orderData?.discount = 0
        }
        if let arrD = AppConstants.autoDiscount{
            for discount in arrD{
                let discountDay = discount.weekDay ?? ""
                let discountOrderType = discount.orderTypeId ?? ""
                let startDate = discount.startDate ?? ""
                let endDate = discount.endDate ?? ""
                let discountType = discount.discountType ?? ""
                let discountAmount = discount.discount ?? 0
                let orderType = "\(self.orderType.id ?? 0)"
                let today = Date().getDateInString(format: "EEEE").lowercased()
                
                if let minOrder = discount.minimumValue{
                    if let sDate = startDate.getDateFromString(format: "yyyy-MM-dd HH:mm:ss"), let eDate = endDate.getDateFromString(format: "yyyy-MM-dd HH:mm:ss"){
                        let currentDate = Date().startOfDate() ?? Date()
                        if totalAmount >= minOrder && (sDate ... eDate).contains(currentDate) && discountOrderType.contains(orderType) && discountDay.contains(today){
                            if discountType == "flat"{
                                self.orderData?.discount = discountAmount
                            }else{
                                self.orderData?.discount = totalAmount*discountAmount/100
                            }
                            isAutoDiscount = true
                            break
                        }
                    }
                }else{
                    if let sDate = startDate.getDateFromString(format: "yyyy-MM-dd HH:mm:ss"), let eDate = endDate.getDateFromString(format: "yyyy-MM-dd HH:mm:ss"){
                        if (sDate ... eDate).contains(Date()) && discountOrderType.contains(orderType) && discountDay.contains(today){
                            if discountType == "flat"{
                                self.orderData?.discount = discountAmount
                            }else{
                                self.orderData?.discount = totalAmount*discountAmount/100
                            }
                            isAutoDiscount = true
                            break
                        }
                    }
                }
            }
        }
    }
    
    func checkForServiceCharge(){
        if let order = self.orderData, order.isAutoServiceChargeRemove{
            
        }else{
            if AppCommonMethods.fetchSiteSettingValue(key: "is_service_charge") ?? "" == "true" && (AppCommonMethods.fetchSiteSettingValue(key: "service_charge_order_type") ?? "").contains((self.orderData?.orderType ?? "").lowercased()){
                if AppCommonMethods.fetchSiteSettingValue(key: "service_charge_type_option") ?? "" == "auto"{
                    let serviceC = Double(AppCommonMethods.fetchSiteSettingValue(key: "service_charge") ?? "") ?? 0
                    if AppCommonMethods.fetchSiteSettingValue(key: "service_charge_type") ?? "" == "flat"{
                        orderData?.serviceCharge = serviceC.getRoundFigure()
                    }else{
                        orderData?.serviceCharge = (serviceC*totalAmount/100).getRoundFigure()
                    }
                    isAutoServiceCharge = true
                }else{
                    if isAutoServiceCharge{
                        orderData?.serviceCharge = 0
                    }
                    isAutoServiceCharge = false
                }
            }
        }
    }
    
    func printBillAction(){
        var payBillAction = "pay_bill_action"
        if self.orderType.id ?? 0 == 2{
            payBillAction = "pickup_pay_bill_action"
        }else if self.orderType.id ?? 0 == 5{
            payBillAction = "waiting_pay_bill_action"
        }else if self.orderType.id ?? 0 == 3{
            payBillAction = "delivery_pay_bill_action"
        }
        if AppCommonMethods.fetchSiteSettingValue(key: payBillAction) ?? "" == "prep_ticket"{
            if AppCommonMethods.fetchSiteSettingValue(key: "kitchen_copy_type") ?? "" == "manual"{
                AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_KITCHEN_COPY, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                    if index == 1{
                        PrintManager.shared.connectToPrinterWithPrintOrder(order: self.orderData!, controller: self)
                    }else{
                        if self.shouldGoBack{
                            AppCommonMethods.stopProgressBar()
                            if self.orderData?.orderStatusId ?? 0 <= 2{
                                self.CallCreateOrderAPI(orderStatusId: 2, action: 2, shouldPrint: true)
                            }else{
                                self.CallCreateOrderAPI(action: 2, shouldPrint: true)
                            }
                        }
                    }
                }
            }else{
                PrintManager.shared.connectToPrinterWithPrintOrder(order: orderData!, controller: self)
            }
        }else if AppCommonMethods.fetchSiteSettingValue(key: payBillAction) ?? "" == "both"{
            printAllAction()
        }else if AppCommonMethods.fetchSiteSettingValue(key: payBillAction) ?? "" == "bill"{
            if AppCommonMethods.fetchSiteSettingValue(key: "pay_bill_action_type") ?? "" == "manual"{
                AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_ORDER_BILL, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                    if index == 1{
                        PrintManager.shared.isSplitBillCopy = false
                        PrintManager.shared.isPrintingBill = true
                        PrintManager.shared.connectToPrinterWithPrint(model: self.orderData!, controller: self)
                    }else{
                        if self.shouldGoBack{
                            AppCommonMethods.stopProgressBar()
                            if self.orderData?.orderStatusId ?? 0 <= 2{
                                self.CallCreateOrderAPI(orderStatusId: 2, action: 2, shouldPrint: true)
                            }else{
                                self.CallCreateOrderAPI(action: 2, shouldPrint: true)
                            }
                        }
                    }
                }
            }else{
                PrintManager.shared.isSplitBillCopy = false
                PrintManager.shared.isPrintingBill = true
                PrintManager.shared.connectToPrinterWithPrint(model: orderData!, controller: self)
            }
        }else{
            if shouldGoBack{
                AppCommonMethods.stopProgressBar()
                if self.orderData?.orderStatusId ?? 0 <= 2{
                    CallCreateOrderAPI(orderStatusId: 2, action: 2, shouldPrint: true)
                }else{
                    self.CallCreateOrderAPI(action: 2, shouldPrint: true)
                }
            }
        }
    }
    
    func printKitchCopyAction(){
        if AppCommonMethods.fetchSiteSettingValue(key: "send_order_action") ?? "" == "prep_ticket"{
            if AppCommonMethods.fetchSiteSettingValue(key: "kitchen_copy_type") ?? "" == "manual"{
                AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_KITCHEN_COPY, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                    if index == 1{
                        PrintManager.shared.connectToPrinterWithPrintOrder(order: self.orderData!, controller: self)
                    }else{
                        AppCommonMethods.stopProgressBar()
                        if self.orderData?.orderStatusId ?? 0 <= 2{
                            self.CallCreateOrderAPI(orderStatusId: 2, action: 2, shouldPrint: true)
                        }else{
                            self.CallCreateOrderAPI(action: 2, shouldPrint: true)
                        }
                    }
                }
            }else{
                PrintManager.shared.connectToPrinterWithPrintOrder(order: orderData!, controller: self)
            }
        }else{
            AppCommonMethods.stopProgressBar()
            if self.orderData?.orderStatusId ?? 0 <= 2{
                self.CallCreateOrderAPI(orderStatusId: 2, action: 2, shouldPrint: true)
            }else{
                self.CallCreateOrderAPI(action: 2, shouldPrint: true)
            }
        }
    }
    
    func printAllAction(){
        PrintManager.shared.connectToPrinterWithPrintOrder(order: self.orderData!, controller: self, isPrintAll: true)
    }
    
    func DisplayFailedAlert(){
        var setting = AlertSetting()
        setting.confirmTitle = "Retry"
        setting.alertAnimation = "payment_failed"
        setting.type = .kRetryPayment
        if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
            VC.delegate = self
        }
    }
    
    //MARK:Button Action
    @IBAction func btnBackPaymentAction(_ sender:UIButton){
        self.view.endEditing(true)
        if viewForCardMode.alpha == 1{
            viewForAmount.alpha = 1
            viewForCardMode.alpha = 0
            btnSelectPayment.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
            btnSelectPayment.isEnabled = true
        }else{
            btnBackPayment.isHidden = true
            viewForPayments.alpha = 1
            viewForAmount.alpha = 0
            btnSelectPayment.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            btnSelectPayment.isEnabled = false
        }
    }
    
    @IBAction func btnBackAction(_ sender:UIButton){
        self.navigationController?.popViewController(animated: true)
    }
    
    @IBAction func btnEditQuantityAction(_ sender:UIButton){
        self.view.endEditing(true)
        if showOrderModifiedToast(){
            isEditOrder = !isEditOrder
            collectionOrders.reloadData()
            if isEditOrder{
                viewForDoneEdit.isHidden = false
            }else{
                viewForDoneEdit.isHidden = true
            }
        }
    }
    
    @IBAction func btnPlusQuantityAction(_ sender:UIButton){
        self.view.endEditing(true)
        let model = arrProducts[sender.tag]
        model.quantity  = (model.quantity ?? 0) + 1
        if model.sentToKitchen{
            model.sentToKitchenQuantity += 1
        }else{
            model.sentToKitchenQuantity = model.quantity ?? 0
        }
        collectionOrders.reloadData()
        setOrderView()
        CallCreateOrderAPI(orderStatusId: 1)
    }
    
    @IBAction func btnMinusQuantityAction(_ sender:UIButton){
        self.view.endEditing(true)
        let model = arrProducts[sender.tag]
        if model.quantity ?? 0 <= 1{
            SQLiteManage.deleteOrderItem(productId: model.id ?? 0, orderId: self.orderData?.id ?? 0)
            arrProducts.remove(at: sender.tag)
        }else{
            model.quantity  = (model.quantity ?? 0) - 1
            if model.sentToKitchen{
                if model.sentToKitchenQuantity > 0{
                    model.sentToKitchenQuantity -= 1
                }
            }else{
                model.sentToKitchenQuantity = model.quantity ?? 0
            }
        }
        collectionOrders.reloadData()
        setOrderView()
        CallCreateOrderAPI(orderStatusId: 1)
    }
    
    @IBAction func btnSendOrderAction(_ sender:UIButton){
        self.view.endEditing(true)
        if orderGroup == nil{
            shouldGoBack = true
        }else{
            shouldGoBack = false
        }
        if let VC = SendOrderPopup.showPopup(parentVC: self, isSendOrder: true){
            VC.delegate = self
        }
    }
    
    @IBAction func btnPrintOrderAction(_ sender:UIButton){
        self.view.endEditing(true)
        if orderGroup == nil{
            shouldGoBack = true
        }else{
            shouldGoBack = false
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_printbill") ?? "" == "true" && AppConstants.userData?.permissions?.printBill?.actions?.list ?? 0 == 1 && (AppCommonMethods.fetchSiteSettingValue(key: "is_printall") ?? "" != "true" || AppConstants.userData?.permissions?.printAll?.actions?.list ?? 0 == 0){
            CallCreateOrderAPI(orderStatusId: 12, orderActionId: 5, action: 1)
            return
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_printall") ?? "" == "true" && AppConstants.userData?.permissions?.printAll?.actions?.list ?? 0 == 1 && (AppCommonMethods.fetchSiteSettingValue(key: "is_printbill") ?? "" != "true" || AppConstants.userData?.permissions?.printBill?.actions?.list ?? 0 == 0){
            CallCreateOrderAPI(orderStatusId: 12,orderActionId: 6, action: 1)
            return
        }
        if let VC = SendOrderPopup.showPopup(parentVC: self, isSendOrder: false){
            VC.delegate = self
        }
    }
    
    @IBAction func btnSelectPaymentAction(_ sender:UIButton){
        self.view.endEditing(true)
        if orderData.totalPaid ?? 0 >= orderData.total ?? 0 && orderData.total ?? 0 > 0{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ORDER_PAID, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return
        }
        if selectedAmount == 0{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ZERO_CARD, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return
        }
        if selectedPayment! != .kCash{
            if totalAmount - selectedAmount < 0{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_AMOUNT_LESS_ORDER, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return
            }
        }
        if sender.tag == 0 && selectedPayment == .kCreditCard && orderGroup == nil{
            txtPhoneNumber.text = orderData.customer?.mobile ?? ""
            lblPaymentLink.superview?.isHidden = false
        }
        setPaymentView()
    }
    
    @IBAction func btnPaymentSelectionAction(_ sender:UIButton){
        if totalPaid >= totalAmount, totalAmount > 0{
            AppCommonMethods.showToastAlert(message: "Order is paid")
            return
        }
        if self.orderData?.orderStatusId ?? 0 == 10{
            AppCommonMethods.showToastAlert(message: "Order is cancelled")
            return
        }
        switch sender.tag {
        case 0:
            selectedPayment = .kCreditCard
        case 1:
            selectedPayment = .kCash
        case 2:
            selectedPayment = .kCheque
        default:
            break
        }
        btnBackPayment.isHidden = false
        btnSelectPayment.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
        btnSelectPayment.isEnabled = true
        viewForPayments.alpha = 0
        viewForAmount.alpha = 1
        viewForCardMode.alpha = 0
    }
    
    @IBAction func btnAmountSelectionAction(_ sender:UIButton){
        self.view.endEditing(true)
        btnBackPayment.isHidden = false
        if sender.tag == 0{
            selectedAmount = max(0, totalAmount - totalPaid)
            txtAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedAmount)
            self.btnSelectPaymentAction(UIButton())
        }else{
            lblPaymentLink.superview?.isHidden = true
            selectedAmount = Double(sender.tag)
            btnSelectPayment.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
            btnSelectPayment.isEnabled = true
        }
        txtAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedAmount)
        setAmountView()
    }
    
    @IBAction func btnCancelPaymentAction(_ sender:UIButton){
        self.view.endEditing(true)
        self.constAmountTrailingSpace.constant = -380
        UIView.animate(withDuration: 0.25) {
            self.viewForAmountBG.alpha = 0
            self.view.layoutIfNeeded()
        }
    }
    
    @IBAction func btnPayOrderAction(_ sender:UIButton){
        self.view.endEditing(true)
        if selectedPayment! == .kCheque{
            if (txtChequeNumbert.text ?? "").trimmingCharacters(in: .whitespacesAndNewlines).isEmpty{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_CHEQUENUMBER, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }else{
                self.txtChequeNumbert.text = ""
                self.constAmountTrailingSpace.constant = -380
                UIView.animate(withDuration: 0.25) {
                    self.viewForAmountBG.alpha = 0
                    self.view.layoutIfNeeded()
                }
                CallPaymentAPI(methodId:3)
            }
        }else{
            if checkMotoValidation(){
                if txtCardNumber.superview!.superview!.isHidden{
                    sendPaymentLinkList()
                }else{
                    CreateStripePaymentMethod()
                }
            }
        }
    }
    
    @IBAction func btnViewProductDetailAction(_ sender:UIButton){
        self.view.endEditing(true)
        let model = arrProducts[sender.tag]
        if let _ = OrderProductDetailVC.showPopup(parentVC: self, product: model){
            
        }
    }
    
    @IBAction func btnCardPaymentModeAction(_ sender:UIButton){
        self.view.endEditing(true)
        if sender.tag == 0{
            if AppConstants.selectedStripeReader != nil{
                self.CreateStripePaymentIntent(terminalId: AppConstants.selectedStripeReader!.stripeId ?? "")
            }else{
                if AppConstants.businessData?.cardReaders?.count ?? 0 == 0{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_NO_CARDREADER, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }else if AppConstants.businessData?.cardReaders?.count ?? 0 == 1{
                    selectedReader = AppConstants.businessData?.cardReaders?.first
                    self.connectToCardReader()
                }else{
                    selectedReader = AppConstants.businessData?.cardReaders?.first
                    if let VC = SelectCardReaderVC.showPopup(parentVC: self, selectedReader: selectedReader){
                        VC.delegate = self
                    }
                }
            }
        }else if sender.tag == 1{
            lblPayTitle.text = "Moto Payment"
            txtCardNumber.superview?.superview?.isHidden = false
            txtPhoneNumber.superview?.superview?.isHidden = true
            txtCardHolderName.superview?.superview?.isHidden = false
            txtExpDate.superview?.superview?.superview?.isHidden = false
            self.constAmountTrailingSpace.constant = 0
            UIView.animate(withDuration: 0.25) {
                self.viewForAmountBG.alpha = 1
                self.view.layoutIfNeeded()
            }
        }else if sender.tag == 2{
            CallPaymentAPI(methodId: 2)
        }else{
            lblPayTitle.text = "Send Payment Link"
            txtCardNumber.superview?.superview?.isHidden = true
            txtPhoneNumber.superview?.superview?.isHidden = false
            txtCardHolderName.superview?.superview?.isHidden = true
            txtExpDate.superview?.superview?.superview?.isHidden = true
            self.constAmountTrailingSpace.constant = 0
            UIView.animate(withDuration: 0.25) {
                self.viewForAmountBG.alpha = 1
                self.view.layoutIfNeeded()
            }
        }
    }
    
    @IBAction func btnRemovePriceAction(_ sender:UIButton){
        self.view.endEditing(true)
        if sender.tag == 0{
            orderData.gratuity = 0
            arrGroups.forEach { $0.gratuity = 0 }
        }else if sender.tag == 1{
            orderData.serviceCharge = 0
            arrGroups.forEach { $0.serviceCharge = 0 }
        }else if sender.tag == 2{
            orderData.discount = 0
            arrGroups.forEach { $0.discount = 0 }
        }
        setOrderView()
        CallCreateOrderAPI(orderStatusId: 1)
    }
    
    @IBAction func btnGroupAction(_ sender:UIButton){
        self.view.endEditing(true)
        if orderGroup?.id ?? 0 != arrGroups[sender.tag].id ?? 0{
            orderGroup = arrGroups[sender.tag]
            btnBackPayment.isHidden = true
            viewForPayments.alpha = 1
            viewForCardMode.alpha = 0
            viewForAmount.alpha = 0
            btnSelectPayment.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            btnSelectPayment.isEnabled = false
            setOrderView()
            collectionGroups.reloadData()
        }
    }
    
    @IBAction func btnDiscountAction(_ sender:UIButton){
        var settings = AlertSetting()
        settings.alertTitle = "Add Discount"
        settings.type = .kEnterAmount
        settings.textPlcaeholder = "discount"
        amountType = GratityViewType.kDiscount
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        let discount = self.arrGroups.reduce(0) { $0 + $1.discount }
        settings.maxAmount = (self.orderData.discount ?? 0) - discount
        settings.textTitle = String.init(format: "%@%.2f", AppConstants.currencySign, settings.maxAmount!)
        if let VC = AlertViewController.showPopup(parentVC: self, setting: settings){
            VC.delegate = self
        }
    }
    
    @IBAction func btnServiceChargeAction(_ sender:UIButton){
        var settings = AlertSetting()
        settings.alertTitle = "Add Service Charge"
        settings.type = .kEnterAmount
        settings.textPlcaeholder = "service charge"
        amountType = GratityViewType.kServiceCharge
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        let serviceCharge = self.arrGroups.reduce(0) { $0 + $1.serviceCharge }
        settings.maxAmount = (self.orderData.serviceCharge ?? 0) - serviceCharge
        settings.textTitle = String.init(format: "%@%.2f", AppConstants.currencySign, settings.maxAmount!)
        if let VC = AlertViewController.showPopup(parentVC: self, setting: settings){
            VC.delegate = self
        }
    }
    
    @IBAction func btnGratuityAction(_ sender:UIButton){
        var settings = AlertSetting()
        settings.alertTitle = "Add Gratuity"
        settings.type = .kEnterAmount
        settings.textPlcaeholder = "gratuity"
        amountType = GratityViewType.kGratuity
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        let gratuity = self.arrGroups.reduce(0) { $0 + $1.gratuity }
        settings.maxAmount = (self.orderData.gratuity ?? 0) - gratuity
        settings.textTitle = String.init(format: "%@%.2f", AppConstants.currencySign, settings.maxAmount!)
        if let VC = AlertViewController.showPopup(parentVC: self, setting: settings){
            VC.delegate = self
        }
    }
    
    @IBAction func btnRemoveGratuityAction(_ sender:UIButton){
        if let selectedGroup = orderGroup{
            selectedGroup.autoGratuityRemove = true
            selectedGroup.gratuity = 0
            self.setOrderView()
            self.CallCreateOrderAPI()
        }
    }
    
    @IBAction func btnRemoveDiscountAction(_ sender:UIButton){
        if let selectedGroup = orderGroup{
            selectedGroup.autoDiscountRemove = true
            selectedGroup.discount = 0
            self.setOrderView()
            self.CallCreateOrderAPI()
        }
    }
    
    @IBAction func btnRemoveServiceChargeAction(_ sender:UIButton){
        if let selectedGroup = orderGroup{
            selectedGroup.autoServiceChargeRemove = true
            selectedGroup.serviceCharge = 0
            self.setOrderView()
            self.CallCreateOrderAPI()
        }
    }
    
    //MARK: Database Method
    func CallCreateOrderAPI(orderStatusId:Int? = nil, orderActionId:Int? = nil, action:Int = 0, shouldPrint:Bool = false){
        if orderActionId != nil{
            orderData.orderActionId = orderActionId
        }
        if orderGroup != nil{
            let arr = orderData.arrProducts.filter { (model) -> Bool in
                return model.groupUniqueId != orderGroup!.uniqueId
            }
            orderData.arrProducts = arr
            orderData.arrProducts.append(contentsOf: arrProducts)
        }else{
            orderData.arrProducts = arrProducts
        }
        if orderStatusId != nil{
            orderData?.orderStatusId = orderStatusId
            let arr = AppConstants.arrOrderStatuses.filter { model in
                return model.id ?? 0 == orderData?.orderStatusId ?? 0
            }
            orderData.orderStatus = arr.first
        }
        if self.selectedTable?.id ?? 0 != 0{
            orderData?.tableId = selectedTable?.id
            var locked:Int?
            if action == 2{
                locked = 0
                self.selectedTable?.locked = false
                orderData?.table?.locked = false
            }
            if (action == 1 || action == 2 || action == 3) && (orderData?.table?.tableStatus?.status ?? "").lowercased() == "taking order"{
                if let status = CoreDataHelper.shared.fetchTableStatusData(name: "order taken").first{
                    AppCommonMethods.SaveTable(table: self.selectedTable!, statusId: status.id)
                    self.selectedTable?.tableStatusId = status.id
                    self.selectedTable?.tableStatus = status
                    orderData?.table = self.selectedTable
                    SQLiteManage.updateTableStatus(tableId: self.selectedTable?.id ?? 0,statusId: status.id, lastOrderId: self.orderData.id ?? 0, lastOrderTotal: self.orderData?.total, lastOrderTime: self.orderData?.deliveryDate, offline: 1, locked: locked)
                }else{
                    AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                }
            }else{
                SQLiteManage.updateTableStatus(tableId: self.selectedTable?.id ?? 0, lastOrderId: self.orderData.id ?? 0, lastOrderTotal: self.orderData?.total, lastOrderTime: self.orderData?.deliveryDate, offline: 1, locked: locked)
            }
        }
        
        if Reachabilities.shared.isConnectedToNetwork() && action == 2 && AppConstants.DataSyncMode == "Auto"{
            self.navigationController?.popToRootViewController(animated: true)
            BGAPIExecution.shared.orderSaved = { orderId,message in
                print("Order \(orderId) Saved To Server")
                DispatchQueue.main.async {
                    if message == nil{
                        NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: ["order_id":orderId,"old_id":self.orderData.id ?? 0])
                    }else{
                        AppCommonMethods.showToastAlert(message: message!)
                    }
                }
            }
            BGAPIExecution.shared.AddOrderToQueue(order: self.orderData!, shouldPrint: shouldPrint)
        }else{
            SQLiteManage.SaveOrderIntoDatabase(order: self.orderData!, updated: 1)
            self.performOrderSaveAction(action:action)
        }
    }
    
    func performOrderSaveAction(action:Int){
        if action == 1{
            SQLiteManage.SaveOrderIntoDatabase(order: orderData!, updated: 1)
            if let order = SQLiteManage.fetchOrderDataById(orderId: orderData.id ?? 0){
                self.orderData = order
                if self.orderData.orderActionId ?? 0 == 5{
                    self.printBillAction()
                }else if self.orderData.orderActionId ?? 0 == 6{
                    self.printAllAction()
                }else{
                    self.printKitchCopyAction()
                }
            }
        }else if action == 2{
            self.navigationController?.popToRootViewController(animated: true)
        }else if action == 3{
            self.navigationController?.popViewController(animated: true)
        }
    }
    
    func OrderPaidTask(){
        if orderGroup != nil{
            arrGroups = SQLiteManage.fetchOrderGroupData(orderId: self.orderData?.id ?? 0)
            self.arrGroups.forEach { group in
                group.arrProducts = orderData.arrProducts.filter({ (model) -> Bool in
                    return model.groupUniqueId == group.uniqueId
                })
            }
            orderGroup = arrGroups.filter({ model in
                return model.uniqueId == (orderGroup?.uniqueId ?? "")
            }).first
        }
        if (self.orderData.totalPaid ?? 0).getRoundFigure() >= (self.orderData?.total ?? 0).getRoundFigure() && self.orderData?.total ?? 0 > 0{
            shouldGoBack = true
            if AppCommonMethods.fetchSiteSettingValue(key: "order_complete_mode") ?? "" == "auto"{
                if self.selectedTable != nil{
                    if let status = CoreDataHelper.shared.fetchTableStatusData(name: "vacant").first{
                        self.orderData?.table?.tableStatusId = status.id
                        AppCommonMethods.SaveTable(table: self.selectedTable!, statusId: status.id)
                        self.selectedTable?.tableStatusId = status.id
                        SQLiteManage.updateTableStatus(tableId: self.selectedTable?.id ?? 0, statusId: status.id, lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", offline: 1)
                        if let table = SQLiteManage.fetchTableDataFromMergeId(id: self.selectedTable?.id ?? 0){
                            table.mergeTableId = 0
                            table.locked = false
                            table.tableStatusId = status.id ?? 0
                            if let dictTable = encodeFromModel(table) as? [String:Any]{
                                SocketService.shared?.sendTableToSocket(data: dictTable, id: table.id ?? 0)
                            }
                        }
                    }else{
                        AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                    }
                }
                orderData.orderStatusId = 5
            }else{
                if self.selectedTable != nil{
                    if let status = CoreDataHelper.shared.fetchTableStatusData(name: "Served and paid").first{
                        AppCommonMethods.SaveTable(table: selectedTable!, statusId: status.id)
                        selectedTable?.tableStatus = status
                        selectedTable?.tableStatusId = status.id ?? 0
                        orderData?.table = selectedTable
                        SQLiteManage.updateTableStatus(tableId: selectedTable?.id ?? 0, statusId: status.id)
                    }else{
                        AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                    }
                }
                orderData.orderStatusId = 4
            }
        }else{
            orderData.orderStatusId = 7
            if self.orderData?.orderStatusId ?? 0 <= 2{
                self.CallCreateOrderAPI(orderStatusId: 7, action: 3)
            }else{
                self.CallCreateOrderAPI(action: 3)
            }
        }
    }
    
    func CallPaymentAPI(amount:Double? = nil, methodId:Int = 1, cardNumber:String? = nil, txnId:String? = nil){
        let paymentId = Date().millisecondsSince1970
        if methodId != 1{
            PrintManager.shared.shouldOpenDrawer = false
            if !Reachabilities.shared.isConnectedToNetwork(){
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.kNoInternetMsg, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return
            }
            self.totalPaid = self.totalPaid + selectedAmount
            if orderGroup?.id ?? 0 != 0{
                SQLiteManage.updateOrderTotalPaid(id: self.orderData.uniqueId, amount: self.totalPaid, groupId: orderGroup?.uniqueId, orderTotal: (orderData.totalPaid ?? 0).getRoundFigure() + selectedAmount)
            }else{
                SQLiteManage.updateOrderTotalPaid(id: self.orderData.uniqueId, amount: self.totalPaid)
            }
            self.orderData.totalPaid = (self.orderData.totalPaid ?? 0).getRoundFigure() + selectedAmount
            if self.orderGroup != nil{
                self.orderGroup?.paidAmount = self.totalPaid
            }
            let paymentModel = PaymentOrderModel()
            paymentModel.id = paymentId
            paymentModel.amount = selectedAmount
            paymentModel.paymentMethodId = methodId
            paymentModel.updaterId = AppConstants.userData?.id ?? 0
            if orderGroup != nil{
                if orderGroup!.offline == 0{
                    paymentModel.orderSplitId = orderGroup?.id ?? 0
                }
                paymentModel.groupUniqueId = orderGroup?.uniqueId ?? ""
            }
            if methodId == 3{
                paymentModel.paymentMethodName = "Cheque"
                paymentModel.chequeNumber = txtChequeNumbert.text ?? ""
            }else if methodId == 2{
                paymentModel.paymentMethodName = "Credit Card Manual"
            }else if methodId == 10{
                paymentModel.paymentMethodName = "Credit Card Moto"
            }else if methodId == 9{
                paymentModel.paymentMethodName = "Credit Card TT"
            }
            if cardNumber != nil{
                paymentModel.ccNumber = cardNumber ?? ""
            }
            if txnId != nil{
                paymentModel.txnId = txnId ?? ""
            }else{
                paymentModel.txnId = Int(Date().timeIntervalSinceReferenceDate).description
            }
            SQLiteManage.insertOrderPayments(orderId: self.orderData.id ?? 0, arrPayments: [paymentModel], database: nil, offline: 1)
            
            var setting = AlertSetting()
            setting.confirmTitle = ""
            setting.alertAnimation = "payment_successful"
            setting.cancelTitle = ""
            if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
                VC.delegate = self
            }
        }else{
            PrintManager.shared.shouldOpenDrawer = true
            if selectedAmount - amount! > 0{
                let strChange = String.init(format: "Change due: %@%.2f", AppConstants.currencySign, selectedAmount - amount!)
                var setting = AlertSetting()
                setting.alertBoldMessage = strChange
                setting.alertBoldMessageColor = AppConstants.Colors.kAppThemeAquaColor
                setting.confirmTitle = "Done"
                setting.cancelTitle = ""
                if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
                    VC.delegate = self
                }
            }else{
                var setting = AlertSetting()
                setting.confirmTitle = ""
                setting.alertAnimation = "payment_successful"
                setting.cancelTitle = ""
                if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
                    VC.delegate = self
                }
            }
            self.totalPaid = self.totalPaid + amount!
            if orderGroup?.id ?? 0 != 0{
                SQLiteManage.updateOrderTotalPaid(id: self.orderData.uniqueId, amount: self.totalPaid, groupId: orderGroup?.uniqueId, orderTotal: (orderData.totalPaid ?? 0).getRoundFigure() + amount!)
            }else{
                SQLiteManage.updateOrderTotalPaid(id: self.orderData.uniqueId, amount: self.totalPaid)
            }
            self.orderData.totalPaid = (self.orderData.totalPaid ?? 0).getRoundFigure() + amount!
            if self.orderGroup != nil{
                self.orderGroup?.paidAmount = self.totalPaid
            }
            let paymentModel = PaymentOrderModel()
            paymentModel.id = paymentId
            paymentModel.txnId = Int(Date().timeIntervalSinceReferenceDate).description
            paymentModel.amount = amount!
            paymentModel.updaterId = AppConstants.userData?.id ?? 0
            paymentModel.paymentMethodId = 1
            if orderGroup != nil{
                if orderGroup!.offline == 0{
                    paymentModel.orderSplitId = orderGroup?.id ?? 0
                }
                paymentModel.groupUniqueId = orderGroup?.uniqueId ?? ""
            }
            paymentModel.paymentMethodName = "Cash"
            SQLiteManage.insertOrderPayments(orderId: self.orderData.id ?? 0, arrPayments: [paymentModel], database: nil, offline: 1)
        }
    }
    
    //MARK: CardReader Methods
    func connectToStripeReader(){
        if AppConstants.selectedStripeReader!.deviceType == .wisePad3{
            var locationId = ""
            if AppConstants.selectedReader?.sLocationId ?? "" != ""{
                locationId = AppConstants.selectedReader?.sLocationId ?? ""
            }else if AppConstants.selectedStripeReader?.locationId ?? "" != ""{
                locationId = AppConstants.selectedStripeReader?.locationId ?? ""
            }else{
                AppCommonMethods.showToastAlert(message: "Location not found")
                self.cancelTermintalProcess()
                return
            }
            do{
                let config = try BluetoothConnectionConfigurationBuilder.init(delegate: self, locationId: locationId).setAutoReconnectOnUnexpectedDisconnect(true).build()
                AppCommonMethods.startProgressBar()
                
                Terminal.shared.connectReader(AppConstants.selectedStripeReader!, connectionConfig: config) { reader, error in
                    DispatchQueue.main.async {
                        if let reader = reader {
                            AppCommonMethods.startProgressBar()
                            self.CreateStripePaymentIntent(terminalId: reader.stripeId ?? "")
                        } else if let error = error {
                            AppCommonMethods.stopProgressBar()
                            print("connectInternetReader failed: \(error)")
                            self.failedType = .kCardReader
                            self.DisplayFailedAlert()
                            self.cancelTermintalProcess()
                        }
                    }
                }
            }catch{
                print(error.localizedDescription)
            }
            
        }else{
            do{
                let config = try InternetConnectionConfigurationBuilder(delegate: self).build()
                AppCommonMethods.startProgressBar()
                Terminal.shared.connectReader(AppConstants.selectedStripeReader!, connectionConfig: config) { reader, error in
                    DispatchQueue.main.async {
                        if let reader = reader {
                            self.CreateStripePaymentIntent(terminalId: reader.stripeId ?? "")
                        } else if let error = error {
                            self.cancelTermintalProcess()
                            AppCommonMethods.stopProgressBar()
                            print("connectInternetReader failed: \(error)")
                            self.failedType = .kCardReader
                            self.DisplayFailedAlert()
                            self.cancelTermintalProcess()
                            self.cancelTermintalProcess()
                        }
                    }
                }
            }catch{
                print(error.localizedDescription)
            }
        }
    }
    
    func terminalPaymentProcessing(secret:String){
        Terminal.shared.retrievePaymentIntent(clientSecret: secret) { paymentIntet, error in
            DispatchQueue.main.async {
                guard let intent = paymentIntet else{
                    AppCommonMethods.stopProgressBar()
                    if let err = error{
                        print("retriveInent failed: \(err)")
                    }
                    self.failedType = .kCardReader
                    self.DisplayFailedAlert()
                    self.cancelTermintalProcess()
                    return
                }
                let _ = Terminal.shared.collectPaymentMethod(intent) { collectResult, collectError in
                    DispatchQueue.main.async {
                        guard let result = collectResult else{
                            AppCommonMethods.stopProgressBar()
                            if let err = collectError{
                                print("collectPaymentMethod failed: \(err)")
                            }
                            self.failedType = .kCardReader
                            self.DisplayFailedAlert()
                            self.cancelTermintalProcess()
                            return
                        }
                        Terminal.shared.confirmPaymentIntent(result) { processResult, processError in
                            DispatchQueue.main.async {
                                guard let pResult = processResult else{
                                    AppCommonMethods.stopProgressBar()
                                    if let err = processError{
                                        print("processPayment failed: \(err)")
                                    }
                                    self.failedType = .kCardReader
                                    self.DisplayFailedAlert()
                                    self.cancelTermintalProcess()
                                    return
                                }
                                self.CapturePaymentIntent(id: pResult.stripeId ?? "", cardNo: pResult.charges.first?.paymentMethodDetails?.cardPresent?.last4 ?? "")
                            }
                        }
                    }
                }
            }
        }
    }
    
    func cancelTermintalProcess(){
        if self.discoverCancelable != nil{
            self.discoverCancelable?.cancel({ error in
                if let err = error{
                    print(err.localizedDescription)
                }
                AppCommonMethods.showToastAlert(message: "Discover cancelled")
                self.discoverCancelable = nil
                if let _ = AppConstants.selectedStripeReader{
                }else{
                    self.isReaderProcessStart = false
                    NSObject.cancelPreviousPerformRequests(withTarget: self)
                }
            })
        }else{
            if let _ = AppConstants.selectedStripeReader{
            }else{
                self.isReaderProcessStart = false
                NSObject.cancelPreviousPerformRequests(withTarget: self)
            }
        }
    }
    
    //MARK: WebService Method
    func sendPaymentLinkList(){
        var dictParam = [String:Any]()
        
        dictParam["phone"] = txtPhoneNumber.text ?? ""
        dictParam["amount"] = "\(selectedAmount)"
        dictParam["name"] = AppConstants.businessData?.name ?? ""
        dictParam["device_id"] = AppConstants.FCMToken ?? ""
        dictParam["order_id"] = self.orderData.id ?? 0
        if AppConstants.businessData?.connectService ?? 0 == 1{
            dictParam["secretkey"] = AppConstants.businessData?.connectStripePrivateKey ?? ""
            dictParam["publishkey"] = AppConstants.businessData?.connectStripePublicKey ?? ""
        }else{
            if (AppConstants.businessData?.stripeMode ?? "").lowercased() == "live"{
                dictParam["secretkey"] = AppConstants.businessData?.stripePrivateKeyLive ?? ""
                dictParam["publishkey"] = AppConstants.businessData?.stripePublicKeyLive ?? ""
            }else{
                dictParam["secretkey"] = AppConstants.businessData?.stripePrivateKeyTest ?? ""
                dictParam["publishkey"] = AppConstants.businessData?.stripePublicKeyTest ?? ""
            }
        }
        dictParam["descriptor"] = AppConstants.businessData?.statementDescriptor ?? ""
        dictParam["description"] = AppConstants.businessData?.statementDescription ?? ""
        
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kPaymentMessage, method: "POST") { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let result = response as? NSDictionary, let data = AppCommonMethods.convertToJson(object: result), let _ = try? jsonDecoder.decode(PaymentLinkModel.self, from: data){
                    var setting = BottomAlertSettings()
                    setting.strMessage = AppConstants.GlobalAlert.ALERT_PAYMENTLINK_SEND
                    AppValidation().showBottomAlertView(settings: setting)
                    if self.orderData?.orderStatusId ?? 0 <= 2{
                        self.CallCreateOrderAPI(orderStatusId: 2, action: 2)
                    }else{
                        self.CallCreateOrderAPI(action: 2)
                    }
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func CreateStripePaymentMethod(){
        if AppConstants.businessData?.connectService ?? 0 == 1{
            let cardParam = STPPaymentMethodCardParams.init()
            cardParam.number = txtCardNumber.text ?? ""
            cardParam.expMonth = NSNumber.init(integerLiteral: Int((txtExpDate.text ?? "").components(separatedBy: "/").first ?? "") ?? 0)
            cardParam.expYear = NSNumber.init(integerLiteral: Int((txtExpDate.text ?? "").components(separatedBy: "/").last ?? "") ?? 0)
            cardParam.cvc = txtCVV.text ?? ""
            
            let paymentMethodParams = STPPaymentMethodParams(card: cardParam, billingDetails: nil, metadata: nil)
            
            STPAPIClient.shared.createPaymentMethod(with: paymentMethodParams) { (method, error) in
                if error != nil {
                    print(error!.localizedDescription)
                    AppCommonMethods.stopProgressBar()
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: error!.localizedDescription, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }else{
                    if let id = method?.stripeId{
                        self.CreateStripeIntent(method: id, appFee: Int(self.CalculateAppFee(stpCard: method?.card) * 100))
                    }else{
                        AppCommonMethods.stopProgressBar()
                        AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_PAYMENT_FAILED, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                            
                        }
                    }
                }
            }
        }else{
            let cardParam = STPCardParams()
            cardParam.number = txtCardNumber.text ?? ""
            cardParam.expMonth = UInt((txtExpDate.text ?? "").components(separatedBy: "/").first ?? "") ?? 0
            cardParam.expYear = UInt((txtExpDate.text ?? "").components(separatedBy: "/").last ?? "") ?? 0
            cardParam.cvc = txtCVV.text ?? ""
            
            STPAPIClient.shared.createToken(withCard: cardParam) { (token, error) in
                if error != nil {
                    print(error!.localizedDescription)
                    AppCommonMethods.stopProgressBar()
                }else{
                    self.CreateStripePayment(token: token?.tokenId ?? "")
                }
            }
        }
    }
    
    func CreateStripeIntent(method:String, appFee:Int){
        var dictParam = [String:Any]()
        
        dictParam["amount"] = Int((selectedAmount)*100)
        dictParam["currency"] = AppConstants.businessData?.country?.currencyCode ?? ""
        dictParam["capture_method"] = "automatic"
//        dictParam["confirmation_method"] = "automatic"
        
        dictParam["payment_method"] = method
        dictParam["description"] = AppConstants.businessData?.statementDescription ?? ""
        dictParam["statement_descriptor_suffix"] = AppConstants.businessData?.statementDescriptor ?? ""
        dictParam["transfer_data[destination]"] = AppConstants.businessData?.sAccountId ?? ""
        dictParam["application_fee_amount"] = appFee
        dictParam["automatic_payment_methods[enabled]"] = "true"
        dictParam["automatic_payment_methods[allow_redirects]"] = "never"
        
        WebServiceManager().postAPIForStripe(params: dictParam, urlString: AppConstants.APIURL.kConfirmIntentAPI) { (message, response) in
            DispatchQueue.main.async {
                if AppConstants.isInDevlopmentMode{
                    print("Intent Response:",response ?? "")
                }
                if let result = response as? NSDictionary{
                    if let id = result.getStringValue("id"), let method = result.getStringValue("payment_method"){
                        self.confirmPaymentIntent(intentId: id, methodId: method)
                        return
                    }
                }
                self.failedType = .kMoto
                self.DisplayFailedAlert()
            }
        }
    }
    
    func CreateStripePayment(token:String){
        var dictParam = [String:Any]()
        dictParam["amount"] = Int((selectedAmount)*100)
        dictParam["currency"] = AppConstants.businessData?.country?.currencyCode ?? ""
        dictParam["source"] = token
        dictParam["description"] = AppConstants.businessData?.statementDescription ?? ""
        dictParam["statement_descriptor"] = AppConstants.businessData?.statementDescriptor ?? ""
        
        WebServiceManager().postAPIForStripe(params: dictParam, urlString: AppConstants.APIURL.kStripeChargeAPI) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if AppConstants.isInDevlopmentMode{
                    print("Stripe Response:",response ?? "")
                }
                if let result = response as? NSDictionary{
                    if let id = result.getStringValue("id"){
                        self.txtCVV.reset()
                        self.txtExpDate.reset()
                        self.txtCardNumber.reset()
                        self.txtCardHolderName.text = ""
                        self.constAmountTrailingSpace.constant = -380
                        UIView.animate(withDuration: 0.25) {
                            self.viewForAmountBG.alpha = 0
                            self.view.layoutIfNeeded()
                        }
                        self.CallPaymentAPI(methodId: 10, cardNumber: result.getStringFromPath("source.last4") ?? "", txnId: id)
                        return
                    }
                }
                self.failedType = .kMoto
                self.DisplayFailedAlert()
            }
        }
    }
    
    func confirmPaymentIntent(intentId:String, methodId:String){
        var dictParam = [String:Any]()
        dictParam["payment_method"] = methodId
        WebServiceManager().postAPIForStripe(params: dictParam, urlString: "\(AppConstants.APIURL.kConfirmIntentAPI)/\(intentId)/confirm") { message, response in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let result = response as? NSDictionary{
                    if let id = result.getStringValue("id"), let status = result.getStringValue("status"), status == "succeeded"{
                        self.txtCVV.reset()
                        self.txtExpDate.reset()
                        self.txtCardNumber.reset()
                        self.txtCardHolderName.text = ""
                        self.constAmountTrailingSpace.constant = -380
                        UIView.animate(withDuration: 0.25) {
                            self.viewForAmountBG.alpha = 0
                            self.view.layoutIfNeeded()
                        }
                        self.CallPaymentAPI(methodId: 10, cardNumber: result.getStringFromPath("source.last4") ?? "", txnId: id)
                        return
                    }
                }
                self.failedType = .kMoto
                self.DisplayFailedAlert()
            }
        }
    }
    
    func CreateStripePaymentIntent(paymentMethodId:String? = nil,terminalId:String? = nil){
        var dictParam = [String:Any]()
        dictParam["amount"] = Int(selectedAmount*100)
        
        if paymentMethodId != nil{
            dictParam["transaction_type"] = ((AppConstants.businessData?.connectService ?? 0) == 1) ? "connect" : "merchant"
            dictParam["payment_method_id"] = paymentMethodId!
        }
        if terminalId != nil{
            dictParam["transaction_type"] = "merchant"
            dictParam["s_terminal_id"] = terminalId!
        }
        dictParam["business_id"] = AppConstants.businessData?.id ?? 0
        
        if AppConstants.isInDevlopmentMode{
            print("Internt Paramter:",dictParam)
        }
        
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kPaymentIntentAPI, method: "POST") { (message, result) in
            DispatchQueue.main.async {
                if AppConstants.isInDevlopmentMode{
                    print("Intent Response:",result ?? "")
                }
                if let response = result as? NSDictionary{
                    if let id = response.getStringValue("payment_intent_id"), let method = response.getStringFromPath("payment_intent.payment_method"), paymentMethodId != nil{
                        self.confirmPaymentIntent(intentId: id, methodId: method)
                    }
                    if let secret = response.getStringFromPath("payment_intent.client_secret"), terminalId != nil{
                        self.terminalPaymentProcessing(secret: secret)
                    }
                    return
                }
                AppCommonMethods.stopProgressBar()
                if paymentMethodId != nil{
                    self.failedType = .kMoto
                }else{
                    self.failedType = .kCardReader
                }
                self.DisplayFailedAlert()
            }
        }
    }
    
    func connectToCardReader(){
        if (AppConstants.selectedReader?.connectivity ?? "").lowercased() == "internet"{
            do{
                let config = try InternetDiscoveryConfigurationBuilder().setLocationId(AppConstants.selectedReader?.sLocationId ?? "").build()
                AppCommonMethods.startProgressBar()
                
                self.discoverCancelable = Terminal.shared.discoverReaders(config, delegate: self) { error in
                    DispatchQueue.main.async {
                        if let error = error {
                            AppCommonMethods.stopProgressBar()
                            print("discoverReaders failed: \(error)")
                            self.failedType = .kCardReader
                            self.DisplayFailedAlert()
                            self.cancelTermintalProcess()
                        } else {
                            print("discoverReaders succeeded")
                        }
                        self.discoverCancelable = nil
                    }
                }
            }catch{
                print(error.localizedDescription)
            }
        }else if (AppConstants.selectedReader?.connectivity ?? "").lowercased() == "taptopay"{
        }else{
            do{
                let config = try BluetoothScanDiscoveryConfigurationBuilder().build()
                AppCommonMethods.startProgressBar()
                self.discoverCancelable = Terminal.shared.discoverReaders(config, delegate: self) { error in
                    DispatchQueue.main.async {
                        if let error = error {
                            AppCommonMethods.stopProgressBar()
                            print("discoverReaders failed: \(error)")
                            self.failedType = .kCardReader
                            self.DisplayFailedAlert()
                            self.cancelTermintalProcess()
                        } else {
                            print("discoverReaders succeeded")
                        }
                        self.discoverCancelable = nil
                    }
                }
            }catch{
                print(error.localizedDescription)
            }
        }
    }
    
    func CapturePaymentIntent(id:String, cardNo:String){
        var dictParam = [String:Any]()
        dictParam["payment_intent_id"] = id
        dictParam["s_terminal_id"] = AppConstants.selectedStripeReader?.stripeId ?? ""
        dictParam["business_id"] = AppConstants.businessData?.id ?? 0
        
        if AppConstants.isInDevlopmentMode{
            print("Internt Paramter :",dictParam)
        }
        
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kCaptureIntentAPI, method: "POST") { (message, result) in
            DispatchQueue.main.async {
                if AppConstants.isInDevlopmentMode{
                    print("Intent Response:",result ?? "")
                }
                self.cancelTermintalProcess()
                AppCommonMethods.stopProgressBar()
                if let response = result as? NSDictionary, let id = response.getStringValue("id"){
                    self.CallPaymentAPI(methodId: 9, cardNumber: cardNo, txnId: id)
                    return
                }
                self.failedType = .kCardReader
                self.DisplayFailedAlert()
            }
        }
    }
    
    func CalculateAppFee(stpCard:STPPaymentMethodCard? = nil, isForMoto:Bool = false)->Double{
        var appFee = 0.0
        let amount = selectedAmount
        if isForMoto{
            var cardBrand:CardBrandModel?
            var cardBrandComission:CardBrandComissionModel?
            var countryComission:CountryComissionModel?
            if let card = stpCard{
                let brand = STPCardBrandUtilities.stringFrom(card.brand) ?? ""
                cardBrand = AppConstants.cardBrands?.filter({ model in
                    return (model.code ?? "").lowercased() == brand.lowercased()
                }).first
                countryComission = AppConstants.countryComissions?.filter({ model in
                    return (model.country?.iso ?? "").lowercased() == (card.country ?? "").lowercased()
                }).first
            }
            if cardBrand != nil{
                cardBrandComission = AppConstants.cardBrandComissions?.filter({ model in
                    return model.cardBrandId ?? 0 == cardBrand!.id ?? 0
                }).first
            }
            if cardBrandComission == nil{
                cardBrandComission = AppConstants.cardBrandComissions?.filter({ model in
                    return model.other ?? 0 == 1
                }).first
            }
            if cardBrandComission != nil{
                appFee = cardBrandComission!.stripeFixed ?? 0
                appFee += (amount * (cardBrandComission?.stripePercentage ?? 0)/100)
            }
            if countryComission == nil{
                countryComission = AppConstants.countryComissions?.filter({ model in
                    return model.other ?? 0 == 1
                }).first
            }
            if countryComission != nil{
                appFee += (countryComission!.stripeFixed ?? 0)
                appFee += (amount * (countryComission?.stripePercentage ?? 0)/100)
            }
        }
        let authFee = AppConstants.businessData?.businessCommissions?.connecCardAuthFee ?? 0
        if (AppConstants.businessData?.businessCommissions?.connectCardAuthFeeType ?? "").lowercased() == "flat"{
            appFee += authFee
        }else if (AppConstants.businessData?.businessCommissions?.connectCardAuthFeeType ?? "").lowercased() == "percentage"{
            appFee += (amount * authFee/100)
        }
        let procssingFee = AppConstants.businessData?.businessCommissions?.connecCardProcessingFee ?? 0
        if (AppConstants.businessData?.businessCommissions?.connectCardProcessingFeeType ?? "").lowercased() == "flat"{
            appFee += procssingFee
        }else if (AppConstants.businessData?.businessCommissions?.connectCardProcessingFeeType ?? "").lowercased() == "percentage"{
            appFee += (amount * procssingFee/100)
        }
        return appFee
    }
}

//MARK: UICollectionViewDataSource
extension OrderReviewVC:UICollectionViewDataSource,UICollectionViewDelegate, UICollectionViewDelegateFlowLayout{
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        if collectionView == collectionGroups{
            return CGSize(width: 131, height: 62)
        }
        let product = arrProducts[indexPath.row]
        if AppCommonMethods.fetchSiteSettingValue(key: "delete_item_visible") ?? "" == "false" && product.isDelete{
            return .zero
        }
        let width = (AppConstants.ScreenSize.SCREEN_WIDTH-415)/2
        return CGSize(width: width, height: 132)
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if collectionView == collectionGroups{
            return arrGroups.count
        }
        return arrProducts.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        if collectionView == collectionGroups{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "GroupsListCell", for: indexPath) as! GroupsListCell
            cell.btnGroup.tag = indexPath.row
            let model = arrGroups[indexPath.row]
            cell.btnGroup.setTitle(model.groupName ?? "", for: .normal)
            cell.btnGroup.backgroundColor  = AppConstants.Colors.kAppThemeBGColor
            cell.btnGroup.setTitleColor(AppConstants.Colors.kAppDarkGrayColor, for: .normal)
            if model.id ?? 0 == orderGroup?.id ?? 0{
                cell.btnGroup.backgroundColor  = AppConstants.Colors.kAppThemeAquaColor
                cell.btnGroup.setTitleColor(.white, for: .normal)
            }
            if model.paidAmount ?? 0 >= model.total ?? 0 && model.total ?? 0 > 0{
                cell.btnGroup.backgroundColor  = AppConstants.Colors.kAppMediumGreenColor
                cell.btnGroup.setTitleColor(.white, for: .normal)
            }
            return cell
        }
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: isEditOrder ? "OrderItemEditCell" : "OrderItemCollectionCell", for: indexPath) as! OrderItemCollectionCell
        let model = arrProducts[indexPath.row]
        cell.lblQuantity.text = "\(model.quantity ?? 0)x"
        if model.isDelete{
            cell.lblName.text = ""
            cell.lblName.attributedText = (model.productName ?? "").strikeThoughText
            cell.lblPrice.text = ""
            cell.lblPrice.attributedText = String.init(format: "%@%.2f", AppConstants.currencySign,model.price ?? 0).strikeThoughText
        }else{
            cell.lblName.attributedText = nil
            cell.lblName.text = model.productName ?? ""
            cell.lblPrice.attributedText = nil
            cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign,model.price ?? 0)
        }
        cell.lblDescription.isHidden = true
        cell.btnViewMore.isHidden = true
        cell.btnViewMore.tag = indexPath.row
        if model.arrAddons.count > 0 || model.arrIngriedent.count > 0 || model.specialInstruction ?? "" != ""{
            cell.lblDescription.isHidden = false
            var strDesc = ""
            model.arrIngriedent.forEach({ (ingrident) in
                var strIngrident = ""
                if ingrident.with ?? 0 == 1{
                    if ingrident.price ?? 0 == 0{
                        strIngrident = String.init(format: "(%dx %@ - Free)", ingrident.quantity ?? 0, ingrident.name ?? "")
                    }else{
                        strIngrident = String.init(format: "(%dx %@ - %@%.2f)", ingrident.quantity ?? 0, ingrident.name ?? "", AppConstants.currencySign, ingrident.price ?? 0)
                    }
                }else{
                    if ingrident.price ?? 0 == 0{
                        strIngrident = String.init(format: "(No %@ - Free)", ingrident.name ?? "")
                    }else{
                        strIngrident = String.init(format: "(No %@ - %@%.2f)", ingrident.name ?? "", AppConstants.currencySign, ingrident.price ?? 0)
                    }
                }
                if strDesc == ""{
                    strDesc = strIngrident
                }else{
                    strDesc = "\(strDesc)\n\(strIngrident)"
                }
            })
            model.arrAddons.forEach({ (addon) in
                let strAddon = String.init(format: "(%dx %@)", addon.quantity ,addon.name ?? "")
                if strDesc == ""{
                    strDesc = strAddon
                }else{
                    strDesc = "\(strDesc)\n\(strAddon)"
                }
            })
            if model.specialInstruction ?? "" != ""{
                if strDesc == ""{
                    strDesc = "Special Instruction: \(model.specialInstruction ?? "")"
                }else{
                    strDesc = "\(strDesc)\nSpecial Instruction: \(model.specialInstruction ?? "")"
                }
                if model.instructionPrice ?? 0 != 0{
                    strDesc.append(String.init(format: " - %.2f", model.instructionPrice ?? 0))
                }
            }
            if model.isDelete{
                cell.lblDescription.text = ""
                cell.lblDescription.attributedText = strDesc.strikeThoughText
            }else{
                cell.lblDescription.attributedText = nil
                cell.lblDescription.text = strDesc
            }
            
            let height = strDesc.getHeightFromString(font: AppConstants.GlobalFontConstants.kBoldFont(size: 14), width: cell.lblDescription.frame.width)
            if height > 60{
                cell.btnViewMore.isHidden = false
            }
        }
        if isEditOrder{
            cell.btnPlus.tag = indexPath.row
            cell.btnMinus.tag = indexPath.row
            if model.quantity ?? 0 > 1{
                cell.imgDelete.isHidden = true
                cell.lblMinus.isHidden = false
            }else{
                cell.imgDelete.isHidden = false
                cell.lblMinus.isHidden = true
            }
        }
        return cell
    }
}

//MARK: SendOrderDelegate
extension OrderReviewVC:SendOrderDelegate{
    func sendOrder(index: Int) {
        CallCreateOrderAPI(orderStatusId: 12,orderActionId: index, action: 1, shouldPrint:true)
    }
}

//MARK: UITextFieldDelegate
extension OrderReviewVC:UITextFieldDelegate{
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        return textField.resignFirstResponder()
    }
    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let allowedCharacters = CharacterSet(charactersIn:"0123456789")
        let characterSet = CharacterSet(charactersIn: string)
        if textField == txtPhoneNumber{
            return allowedCharacters.isSuperset(of: characterSet)
        }
        if textField == txtAmount{
            if textField.text ?? "" == ""{
                textField.text = "\(AppConstants.currencySign)0.00"
            }
            if allowedCharacters.isSuperset(of: characterSet){
                var strText = (textField.text!).replacingOccurrences(of: AppConstants.currencySign, with: "").replacingOccurrences(of: ".", with: "")
                if string == ""{
                    if strText != "000"{
                        if strText.count == 3{
                            strText.removeLast()
                            strText = "0\(strText)"
                        }else{
                            strText.removeLast()
                        }
                        strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                        textField.text = "\(AppConstants.currencySign)\(strText)"
                    }
                }else{
                    if strText.first! == "0"{
                        strText.removeFirst()
                        strText = "\(strText)\(string)"
                    }else{
                        strText = "\(strText)\(string)"
                    }
                    strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                    textField.text = "\(AppConstants.currencySign)\(strText)"
                }
            }
            selectedAmount = Double((textField.text ?? "").replacingOccurrences(of: AppConstants.currencySign, with: "")) ?? 0
            if selectedAmount != 0{
                btnSelectPayment.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
                btnSelectPayment.isEnabled = true
            }else{
                btnSelectPayment.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                btnSelectPayment.isEnabled = false
            }
            setAmountView()
            return false
        }
        return true
    }
}

//MARK: CardReaderDelegate
extension OrderReviewVC: CardReaderDelegate{
    func cardReaderSelected(reader: Any?) {
        popupVC = nil
        if let reader = reader as? Reader{
            AppConstants.selectedStripeReader = reader
            self.isReaderProcessStart = true
            self.connectToStripeReader()
        }else if let reader = reader as? CardReaderModel{
            selectedReader = reader
            self.connectToCardReader()
        }else{
            self.cancelTermintalProcess()
        }
    }
}

//MARK: AlertControllerDelegate
extension OrderReviewVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data:alertViewData,type:AlertType) {
        if type == .kEnterAmount{
            if let value = Double(data.value){
                if amountType == .kDiscount{
                    orderGroup?.autoDiscountRemove = true
                    self.orderGroup?.discount += value
                }else if amountType == .kServiceCharge{
                    orderGroup?.autoServiceChargeRemove = true
                    self.orderGroup?.serviceCharge += value
                }else if amountType == .kGratuity{
                    orderGroup?.autoGratuityRemove = true
                    self.orderGroup?.gratuity += value
                }
                self.setOrderView()
                self.CallCreateOrderAPI()
            }
        }else{
            if index == 1{
                if type == .kRetryPayment{
                    if failedType == .kCardReader{
                        connectToCardReader()
                    }else{
                        CreateStripePaymentMethod()
                    }
                }else{
                    OrderPaidTask()
                    SQLiteManage.SaveOrderIntoDatabase(order: orderData!, updated: 1)
                    if let order = SQLiteManage.fetchOrderDataById(orderId: orderData.id ?? 0){
                        self.orderData = order
                        if (self.orderData.totalPaid ?? 0).getRoundFigure() >= (self.orderData?.total ?? 0).getRoundFigure() && self.orderData?.total ?? 0 > 0{
                            printBillAction()
                        }else{
                            if AppCommonMethods.fetchSiteSettingValue(key: "partial_payment_print") ?? "" == "yes"{
                                printBillAction()
                            }
                        }
                    }
                }
            }
        }
    }
    
}

//MARK: DiscoveryDelegate
extension OrderReviewVC:DiscoveryDelegate{
    func terminal(_ terminal: Terminal, didUpdateDiscoveredReaders readers: [Reader]) {
        arrStripeCard = readers
        print("readers",readers.last?.serialNumber ?? "")
        self.perform(#selector(performReaderAction), with: nil, afterDelay: 4)
    }
    
    @objc func performReaderAction(){
        if self.isReaderProcessStart{
            return
        }
        if self.popupVC != nil{
            self.popupVC?.arrStripeCard = self.arrStripeCard
            self.popupVC?.tblCardReader.reloadData()
        }else{
            AppCommonMethods.stopProgressBar()
            if self.arrStripeCard.count == 0{
                self.cancelTermintalProcess()
            }else{
                if let reader = self.arrStripeCard.filter({ reader in
                    return (self.selectedReader?.serialNumber ?? "").contains(reader.serialNumber)
                }).first{
                    AppConstants.selectedStripeReader = reader
                    self.isReaderProcessStart = true
                    self.connectToStripeReader()
                }else{
                    if let VC = SelectCardReaderVC.showPopup(parentVC: self,selectedReader: self.arrStripeCard.first, readers: self.arrStripeCard){
                        self.popupVC = VC
                        VC.delegate = self
                    }
                }
            }
        }
    }
}

//MARK: BluetoothReaderDelegate
extension OrderReviewVC:MobileReaderDelegate, InternetReaderDelegate, TerminalDelegate{
    func terminal(_ terminal: Terminal, didReportUnexpectedReaderDisconnect reader: Reader) {
        AppConstants.selectedStripeReader = nil
    }
    
    func reader(_ reader: Reader, didReportAvailableUpdate update: ReaderSoftwareUpdate) {
    }
    
    func reader(_ reader: Reader, didStartInstallingUpdate update: ReaderSoftwareUpdate, cancelable: Cancelable?) {
        AppCommonMethods.stopProgressBar()
        AppCommonMethods.startProgressBar(view: self.view, strMessage: "Start installing update")
        AppCommonMethods.showToastAlert(message: "Reader starts updating")
    }
    
    func reader(_ reader: Reader, didReportReaderSoftwareUpdateProgress progress: Float) {
        let percent = Int(progress*100)
        AppCommonMethods.changeProgressMessage(msg: "Update progress:\n\(percent)%")
    }
    
    func reader(_ reader: Reader, didFinishInstallingUpdate update: ReaderSoftwareUpdate?, error: Error?) {
        if let error = error{
            print("didFinishInstallingUpdate Failed: \(error.localizedDescription)")
            AppCommonMethods.showToastAlert(message: error.localizedDescription)
        }
        AppCommonMethods.stopProgressBar(view: self.view)
    }
    
    func reader(_ reader: Reader, didRequestReaderInput inputOptions: ReaderInputOptions = []) {
        print("didRequestReaderInput: \(Terminal.stringFromReaderInputOptions(inputOptions))")
        AppCommonMethods.showToastAlert(message: Terminal.stringFromReaderInputOptions(inputOptions))
    }
    
    func reader(_ reader: Reader, didRequestReaderDisplayMessage displayMessage: ReaderDisplayMessage) {
        print("didRequestReaderDisplayMessage: \(Terminal.stringFromReaderDisplayMessage(displayMessage))")
        AppCommonMethods.showToastAlert(message: Terminal.stringFromReaderDisplayMessage(displayMessage))
    }
}
