//
//  FreeTableVC.swift
//  EPOS
//
//  Created by Apple on 21/06/21.
//

import UIKit
import CoreData

class FreeTableVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var collectionTable:UICollectionView!
    
    //MARK: Instances
    var arrTables = [TableModel]()
    var parentVC:SideMenuVC!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        fetchTablesFromDB()
//        if Reachabilities.shared.isConnectedToNetwork(){
//            FetchTableList()
//        }
    }
    
    override func viewDidLayoutSubviews() {
        DispatchQueue.main.async {
            self.collectionTable.reloadData()
        }
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:SideMenuVC)->FreeTableVC?{
        guard let VC = UIStoryboard.init(name: "Others", bundle: nil).instantiateViewController(withIdentifier: "FreeTableVC") as? FreeTableVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: Button Actions
    @IBAction func btnFreeTableAction(_ sneder:UIButton){
        let table = arrTables[sneder.tag]
        AppCommonMethods.SaveTable(table: table, locked: 0)
        table.locked = false
        SQLiteManage.updateTableStatus(tableId: table.id ?? 0, locked: 0)
        self.collectionTable.reloadData()
    }
    
    //MARK: General Methods
    func fetchTablesFromDB(){
        let arrFloor = CoreDataHelper.shared.fetchFloorData()
        arrTables.removeAll()
        for floor in arrFloor{
            let arrTable = SQLiteManage.fetchTableData(floorId: floor.id ?? 0)
            arrTable.forEach { (table) in
                table.floorName = floor.name ?? ""
                arrTables.append(table)
            }
        }
        arrTables.sort { (model1, model2) -> Bool in
            return model1.sequence ?? 0 < model2.sequence ?? 0
        }
        self.collectionTable.reloadData()
    }
    
    //MARK: WebService Methods
    func FetchTableList(){
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kTables, method: "GET") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let response = result as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([TableModel].self, from: data){
                        SQLiteManage.insertTable(arrData: aData)
                        self.fetchTablesFromDB()
                        return
                    }
                }
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
}

//MARK: UICollectionViewDataSource
extension FreeTableVC: UICollectionViewDelegate,UICollectionViewDataSource, UICollectionViewDelegateFlowLayout{
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return arrTables.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "TablesViewCell", for: indexPath) as! TablesViewCell
        cell.btnFreeTable.tag = indexPath.row
        let model = arrTables[indexPath.row]
        if model.locked{
            cell.btnFreeTable.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
            cell.btnFreeTable.isUserInteractionEnabled = true
        }else{
            cell.btnFreeTable.isUserInteractionEnabled = false
            cell.btnFreeTable.backgroundColor = AppConstants.Colors.kAppMediumGrayColor
        }
        cell.btnFreeTable.setTitle(model.tableStatus?.status ?? "", for: .normal)
        cell.lblTitle.text = "\(model.number ?? "")\n\(model.floorName ?? "")"
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        var itemWidth = (self.view.frame.width-28)/4
        if AppConstants.ScreenSize.SCREEN_HEIGHT >= 1024{
            itemWidth = (self.view.frame.width-28)/5
        }
        return CGSize(width: itemWidth, height: 160)
    }
}
