//
//  NewReservationVC.swift
//  EPOS
//
//  Created by Apple on 27/05/21.
//

import UIKit
import DropDown
import ActionSheetPicker_3_0

class NewReservationVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var tblReservation:UITableView!
    @IBOutlet weak var txtCustomerName:UITextField!
    @IBOutlet weak var txtContactNo:UITextField!
    @IBOutlet weak var txtEMailId:UITextField!
    @IBOutlet weak var txtReservationDate:UITextField!
    @IBOutlet weak var txtReservationTime:UITextField!
    @IBOutlet weak var txtDepositAmount:UITextField!
    @IBOutlet weak var txtSearchCustomer:UITextField!
    @IBOutlet weak var txtDeposit:UITextField!
    @IBOutlet weak var txtSpecialInsturction:UITextView!
    @IBOutlet weak var lblReservationDate:UILabel!
    @IBOutlet weak var lblNoOfDiner:UILabel!
    @IBOutlet weak var lblAssignTable:UILabel!
    @IBOutlet weak var lblViewTitle:UILabel!
    @IBOutlet weak var btnConfirm:UIButton!
    @IBOutlet weak var btnConfirmPrint:UIButton!
    @IBOutlet weak var btnCancel:UIButton!
    @IBOutlet weak var lblInsturctionPlaceholder:UILabel!
    
    //MARK: Instances
    var arrCustomer = [CustomerModel]()
    var selectedCutomer:CustomerModel?
    var selectedTable:TableModel?
    var selectedDeposit:DepositTypeModel?
    var selectedReservation:ReservationModel?
    var noOfDiner = 1
    var reservationDate:Date?
    var reservationTime:Date?
    var arrReservations = [ReservationModel]()
    var parentVC:SideMenuVC!
    weak var delegate:pageRefreshDelegate?
    let customerDropDown = DropDown()
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        txtDepositAmount.text = "\(AppConstants.currencySign)0.00"
        if selectedReservation != nil{
            btnCancel.isHidden = false
            lblViewTitle.text = "Update Reservation"
            btnConfirm.setTitle("SAVE", for: .normal)
            btnConfirmPrint.setTitle("SAVE & PRINT", for: .normal)
            if selectedReservation?.reservationStatusId ?? 0 == 2{
                btnConfirm.superview?.isHidden = true
            }
            setReservationData()
        }
        fetchReservation()
        
        customerDropDown.dismissMode = .automatic
        customerDropDown.anchorView = txtSearchCustomer
        customerDropDown.bottomOffset = CGPoint(x: 0, y: txtSearchCustomer.bounds.height)
        // Action triggered on selection
        customerDropDown.selectionAction = { [weak self] (index, item) in
            self?.view.endEditing(true)
            self?.selectedCutomer = self?.arrCustomer[index]
            self?.setCustomerData()
            self?.customerDropDown.hide()
        }
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:SideMenuVC, reservation:ReservationModel? = nil)->NewReservationVC?{
        guard let VC = UIStoryboard.init(name: "Others", bundle: nil).instantiateViewController(withIdentifier: "NewReservationVC") as? NewReservationVC else {
            return nil
        }
        VC.selectedReservation = reservation
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: General Methods
    func fetchReservation(){
        let date = reservationDate ?? Date()
        lblReservationDate.text = "on \(date.getDateInString(format: "dd/MM/yy"))"
        let today = date.startOfDate()
        let tomorrow = date.endOfDate()
        self.arrReservations = CoreDataHelper.shared.fetchReservationData(fromDate: today, toDate: tomorrow, onlyRunning: true)
        self.tblReservation.reloadData()
    }
    
    func setReservationData(){
        reservationDate = (selectedReservation?.reservationDateTime ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss")
        reservationTime = (selectedReservation?.reservationDateTime ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss")
        txtReservationDate.text = (selectedReservation?.reservationDateTime ?? "")
        self.txtReservationDate.text = reservationDate?.getDateInString(format: "yyyy-MM-dd") ?? ""
        self.txtReservationTime.text = reservationTime?.getDateInString(format: "HH:mm") ?? ""
        self.lblNoOfDiner.text = "\(selectedReservation?.diners ?? 1)"
        noOfDiner = selectedReservation?.diners ?? 1
        if selectedReservation?.tableId ?? 0 != 0{
            selectedTable = SQLiteManage.fetchTableDataFromId(id: selectedReservation!.tableId!)
        }
        
        if selectedTable != nil{
            lblAssignTable.text = "Table: \(selectedTable?.number ?? "")"
            lblAssignTable.textColor = AppConstants.Colors.kAppDarkGrayColor
        }
        if selectedReservation?.depositTypeId ?? 0 != 0{
            selectedDeposit = AppConstants.arrDepositType.filter({ model in
                return model.id ?? 0 == selectedReservation?.depositTypeId ?? 0
            }).first
            txtDeposit.text = selectedDeposit?.type ?? ""
        }
        txtDepositAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign,selectedReservation?.depositAmount ?? 0)
        txtSpecialInsturction.text = selectedReservation?.specialInstruction ?? ""
        if txtSpecialInsturction.text ?? "" != ""{
            lblInsturctionPlaceholder.isHidden = true
        }
        selectedCutomer = selectedReservation?.customer
        setCustomerData()
    }
    
    func setCustomerData(){
        txtCustomerName.text = selectedCutomer?.name ?? ""
        txtContactNo.text = selectedCutomer?.mobile ?? ""
        txtSearchCustomer.text = ""
        txtEMailId.text = selectedCutomer?.email ?? ""
    }
    
    func checkValidation()->Bool{
        if (txtCustomerName.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_NAME, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                _ = self.txtCustomerName.becomeFirstResponder()
            }
            return false
        }
        if !(txtEMailId.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
            if !AppValidation().isValidRegEx(txtEMailId.text ?? "", RegEx.email){
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_VALID_EMAIL, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtEMailId.becomeFirstResponder()
                }
                return false
            }
        }
        if (txtContactNo.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_MOBILENO, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                _ = self.txtContactNo.becomeFirstResponder()
            }
            return false
        }
        if (txtContactNo.text ?? "").trimmingCharacters(in: .whitespaces).count < 10 || (txtContactNo.text ?? "").trimmingCharacters(in: .whitespaces).count > 11{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_MOBILE_10_DIGIT, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                _ = self.txtContactNo.becomeFirstResponder()
            }
            return false
        }
        if reservationDate == nil{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.kSelectReservationDate, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
            }
            return false
        }
        if reservationTime == nil{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.kSelectReservationTime, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
            }
            return false
        }
        if let date = "\(reservationDate!.getDateInString(format: "dd/MM/yyyy")) \(reservationTime!.getDateInString(format: "HH:mm"))".getDateFromString(format: "dd/MM/yyyy HH:mm"){
            if date < Date(){
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.kReservationTimeGreaterToday, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                }
                return false
            }
        }
        let amount = Double((txtDepositAmount.text ?? "").replacingOccurrences(of: AppConstants.currencySign, with: "")) ?? 0
        if amount != 0{
            if selectedDeposit == nil{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.kSelectDepositType, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                }
                return false
            }
        }
        return true
    }
    
    @objc func fetchCustomerOffline(){
        arrCustomer = CoreDataHelper.shared.fetchCustomerData(name: txtSearchCustomer.text ?? "")
        var arrCustomerName = [String]()
        self.arrCustomer.forEach { (model) in
            if model.mobile ?? "" != ""{
                arrCustomerName.append("\(model.name ?? "") (\(model.mobile ?? ""))")
            }else{
                arrCustomerName.append(model.name ?? "")
            }
        }
        customerDropDown.dataSource = arrCustomerName
        customerDropDown.show()
    }
    
    //MARK: Button Actions
    @IBAction func btnBackAction(_ sender:UIButton){
        if self.delegate != nil{
            self.delegate?.pageNeedToRefresh()
        }
        self.view.removeFromSuperview()
        self.removeFromParent()
    }
    
    @IBAction func btnCancelAction(_ sender:UIButton){
        var setting = AlertSetting()
        setting.alertMessage = AppConstants.GlobalAlert.ALERT_CANCEL_RESERVATION
        setting.alertTitle = AppConstants.GlobalAlert.ALERT_CANCEL_RESERVATION_TITLE
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
            VC.delegate = self
        }
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        self.view.endEditing(true)
        if checkValidation(){
            SaveReservation()
        }
    }
    
    @IBAction func btnPrintAndSaveAction(_ sender:UIButton){
        self.view.endEditing(true)
        if checkValidation(){
            SaveReservation(shouldPrint: true)
        }
    }
    
    @IBAction func txtSearchCustomerAction(_ sender:UITextField){
        if sender.text?.count ?? 0 > 2{
            NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(fetchCustomerOffline), object: nil)
            self.perform(#selector(fetchCustomerOffline), with: nil, afterDelay: 0.1)
        }else{
            self.customerDropDown.hide()
        }
    }
    
    @IBAction func btnDinerModifiedAction(_ sender:UIButton){
        self.view.endEditing(true)
        if sender.tag == 0{
            if noOfDiner > 1{
                noOfDiner -= 1
            }
        }else{
            noOfDiner += 1
        }
        lblNoOfDiner.text = "\(noOfDiner)"
    }
    
    @IBAction func btnAssignTableAction(_ sender:UIButton){
        self.view.endEditing(true)
        if let VC = SwapTableVC.showPopup(parentVC: self.parentVC, table: selectedTable){
            VC.delegate = self
        }
    }
    
    //MARK: WebService Methods
    func SaveReservation(shouldPrint:Bool = false){
        var dictParam = [String:Any]()
        let dictCustomer = NSMutableDictionary()
        if selectedCutomer == nil{
            dictParam["customer_id"] = ""
            dictCustomer["id"] = ""
        }else{
            if selectedCutomer?.offline ?? 1 == 0{
                dictCustomer["id"] = selectedCutomer?.id ?? 0
                dictParam["customer_id"] = selectedCutomer?.id ?? 0
            }else{
                dictParam["customer_id"] = ""
                dictCustomer["id"] = ""
            }
        }
        dictCustomer["name"] = txtCustomerName.text ?? ""
        dictCustomer["mobile"] = txtContactNo.text ?? ""
        dictCustomer["email"] = txtEMailId.text ?? ""
        
        dictParam["customer"] = dictCustomer
        
        if selectedTable != nil{
            dictParam["table_id"] = selectedTable?.id ?? 0
        }
        
        dictParam["telephone"] = txtContactNo.text ?? ""
        dictParam["reservation_status_id"] = 1
        dictParam["updater_id"] = AppConstants.userData?.id ?? 0
        if selectedDeposit != nil{
            dictParam["deposit_type_id"] = selectedDeposit?.id ?? 0
            dictParam["deposit_amount"] = (txtDepositAmount.text ?? "").replacingOccurrences(of: AppConstants.currencySign, with: "")
        }
        
        dictParam["diners"] = noOfDiner
        dictParam["special_instruction"] = txtSpecialInsturction.text ?? ""
        dictParam["reservation_date_time"] = "\(txtReservationDate.text ?? "") \(txtReservationTime.text ?? "")"
        let uniueId = Int64(Date().timeIntervalSinceReferenceDate)
        dictParam["unique_id"] = uniueId.description
        let jsonDecoder = JSONDecoder()
        var oldId = Int(Date().timeIntervalSinceReferenceDate)
        
        var strURL = AppConstants.APIURL.kReservations
        if let data = AppCommonMethods.convertToJson(object: dictParam), let aData = try? jsonDecoder.decode(ReservationModel.self, from: data){
            aData.id = oldId
            if selectedCutomer == nil{
                aData.customer?.offline = 1
            }
            if self.selectedReservation != nil{
                if self.selectedReservation!.offline == 0{
                    strURL = "\(AppConstants.APIURL.kReservations)/\(self.selectedReservation?.id ?? 0)"
                    aData.id = self.selectedReservation?.id ?? 0
                    oldId = self.selectedReservation?.id ?? 0
                }
            }
            if selectedTable != nil{
                aData.tableNumber = selectedTable?.number ?? ""
            }
            if shouldPrint{
                PrintManager.shared.connectToPrinterWithPrint(model: aData, controller: self)
            }
            CoreDataHelper.shared.SaveReservationToDatabase(reservation: aData, update: 1)
        }
        if Reachabilities.shared.isConnectedToNetwork(){
            dictParam["customer"] = AppCommonMethods.convertJsontoString(json: dictCustomer)
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST") { (message, result) in
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    if let response = result as? NSDictionary{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(ReservationModel.self, from: data){
                            aData.offline = 0
                            CoreDataHelper.shared.SaveReservationToDatabase(reservation: aData, oldCustomerId: self.selectedCutomer?.id, update: 0, oldId: oldId)
                            self.btnBackAction(UIButton())
                            return
                        }
                    }
                }
            }
        }else{
            self.btnBackAction(UIButton())
        }
    }
    
    func CancelReservation(){
        if let reservation = self.selectedReservation{
            var dictParam = [String:Any]()
            let dictCustomer = NSMutableDictionary()
            if reservation.customer?.offline ?? 1 == 0{
                dictCustomer["id"] = reservation.customer?.id ?? 0
                dictParam["customer_id"] = reservation.customer?.id ?? 0
            }else{
                dictParam["customer_id"] = ""
                dictCustomer["id"] = ""
            }
            dictCustomer["name"] = reservation.customer?.name ?? ""
            dictCustomer["mobile"] = reservation.customer?.mobile ?? ""
            dictCustomer["email"] = reservation.customer?.email ?? ""

            dictParam["customer"] = AppCommonMethods.convertJsontoString(json: dictCustomer)

            if reservation.tableId ?? 0 != 0{
                dictParam["table_id"] = reservation.tableId ?? 0
            }

            dictParam["telephone"] = reservation.customer?.mobile ?? ""
            dictParam["reservation_status_id"] = 2
            dictParam["updater_id"] = AppConstants.userData?.id ?? 0
            if reservation.depositTypeId ?? 0 != 0{
                dictParam["deposit_type_id"] = reservation.depositTypeId ?? 0
            }
            if reservation.depositAmount ?? 0 != 0{
                dictParam["deposit_amount"] = reservation.depositAmount ?? 0
            }
            dictParam["updater_id"] = AppConstants.userData?.id ?? 0
            dictParam["diners"] = reservation.diners ?? 0
            dictParam["special_instruction"] = reservation.specialInstruction ?? ""
            dictParam["reservation_date_time"] = reservation.reservationDateTime ?? ""
            
            dictParam["unique_id"] = reservation.uniqueId
            var strURL = AppConstants.APIURL.kReservations
            if reservation.offline == 0{
                strURL = "\(AppConstants.APIURL.kReservations)/\(reservation.id ?? 0)"
            }
            let oldId = reservation.id ?? 0
            
            reservation.reservationStatusId = 2
            
            self.tblReservation.reloadData()
            CoreDataHelper.shared.SaveReservationToDatabase(reservation: reservation, update: 1, oldId: oldId)
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_CANCELLED_RESERVATION)
            if Reachabilities.shared.isConnectedToNetwork(){
                AppCommonMethods.startProgressBar()
                WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST") { (message, result) in
                    DispatchQueue.main.async {
                        AppCommonMethods.stopProgressBar()
                        if let response = result as? NSDictionary{
                            let jsonDecoder = JSONDecoder()
                            if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(ReservationModel.self, from: data){
                                aData.offline = 0
                                CoreDataHelper.shared.SaveReservationToDatabase(reservation: aData, oldCustomerId: reservation.customer?.id, update: 0, oldId: oldId)
                            }
                        }
                        self.btnBackAction(UIButton())
                    }
                }
            }else{
                self.btnBackAction(UIButton())
            }
        }
    }
}

//MARK: UITableViewDataSource
extension NewReservationVC:UITableViewDelegate,UITableViewDataSource{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrReservations.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "ReservationItemCell", for: indexPath) as! ReservationItemCell
        let model = arrReservations[indexPath.row]
        cell.lblName.text = model.customer?.name ?? ""
        cell.lblDate.text = (model.reservationDateTime ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: "HH:mm")
        cell.lblDiners.text = "\(model.diners ?? 0)"
        return cell
    }
}

//MARK: UITextFieldDelegate
extension NewReservationVC:UITextFieldDelegate{
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let allowedCharacters = CharacterSet(charactersIn:"0123456789")
        let characterSet = CharacterSet(charactersIn: string)
        if txtDepositAmount == textField{
            if allowedCharacters.isSuperset(of: characterSet){
                var strText = (textField.text!).replacingOccurrences(of: AppConstants.currencySign, with: "").replacingOccurrences(of: ".", with: "")
                if string == ""{
                    if strText != "000"{
                        if strText.count == 3{
                            strText.removeLast()
                            strText = "0\(strText)"
                        }else{
                            strText.removeLast()
                        }
                        strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                        textField.text = "\(AppConstants.currencySign)\(strText)"
                    }
                }else{
                    if strText.first! == "0"{
                        strText.removeFirst()
                        strText = "\(strText)\(string)"
                    }else{
                        strText = "\(strText)\(string)"
                    }
                    strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                    textField.text = "\(AppConstants.currencySign)\(strText)"
                }
            }
            return false
        }else if textField == txtContactNo{
            return allowedCharacters.isSuperset(of: characterSet)
        }
        return true
    }
    
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        if textField == txtSearchCustomer{
            if !(textField.text ?? "").trimmingCharacters(in: .whitespacesAndNewlines).isEmpty{
                fetchCustomerOffline()
            }
        }
        return textField.resignFirstResponder()
    }
    
    func textFieldShouldBeginEditing(_ textField: UITextField) -> Bool {
        if textField == txtReservationDate{
            self.view.endEditing(true)
            let date = reservationDate ?? Date()
            let datePicker = ActionSheetDatePicker(title: "Select date", datePickerMode: UIDatePicker.Mode.date, selectedDate: date, doneBlock: {
                picker, value, index in
                self.reservationDate = (value as! Date)
                self.fetchReservation()
                self.txtReservationDate.text = (value as! Date).getDateInString(format: "yyyy-MM-dd")
            }, cancel: { ActionStringCancelBlock in return }, origin: textField)
            datePicker?.minimumDate = Date()
            datePicker?.show()
            return false
        }else if textField == txtReservationTime{
            self.view.endEditing(true)
            if let VC = ReservationTimeVC.showPopup(parentVC: self.parentVC, selectedTime: self.reservationTime?.getDateInString(format: "HH:mm") ?? ""){
                VC.delegate = self
            }
            return false
        }else if textField == txtDeposit{
            self.view.endEditing(true)
            let typeDropDown = DropDown()
            typeDropDown.dismissMode = .automatic
            typeDropDown.anchorView = txtDeposit
            typeDropDown.bottomOffset = CGPoint(x: 0, y: txtDeposit.bounds.height)
            var arrType = [String]()
            AppConstants.arrDepositType.forEach { model in
                arrType.append(model.type ?? "")
            }
            // Action triggered on selection
            typeDropDown.selectionAction = { [weak self] (index, item) in
                self?.txtDeposit.text = item
                self?.view.endEditing(true)
                self?.selectedDeposit = AppConstants.arrDepositType[index]
            }
            typeDropDown.dataSource = arrType
            typeDropDown.show()
            return false
        }
        return true
    }
}

//MARK: UITextViewDelegate
extension NewReservationVC:UITextViewDelegate{
    func textViewDidChange(_ textView: UITextView) {
        if textView.text ?? "" == ""{
            lblInsturctionPlaceholder.isHidden = false
        }else{
            lblInsturctionPlaceholder.isHidden = true
        }
    }
}

//MARK: SwapTableDelegate
extension NewReservationVC:SwapTableDelegate{
    func tableSelected(table: TableModel, orderType: OrderTypesModel?, isMergedTable:Bool) {
        selectedTable = table
        lblAssignTable.text = "Table: \(table.number ?? "")"
        lblAssignTable.textColor = AppConstants.Colors.kAppDarkGrayColor
    }
}

//MARK: ReservationTimeDelegate
extension NewReservationVC:ReservationTimeDelegate{
    func timeSelected(selectedTime: String) {
        self.reservationTime = selectedTime.getDateFromString(format: "HH:mm")
        self.txtReservationTime.text = selectedTime
    }
}

extension NewReservationVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            self.CancelReservation()
        }
    }
}
