//
//  VouchersListVC.swift
//  EPOS
//
//  Created by Apple on 10/06/21.
//

import UIKit

class VouchersListVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var lblTotalVoucher:UILabel!
    @IBOutlet weak var tblVouchers:UITableView!
    @IBOutlet weak var lblToday:UILabel!
    @IBOutlet weak var lblTodayLine:UILabel!
    @IBOutlet weak var lblTomorrow:UILabel!
    @IBOutlet weak var lblTomorrowLine:UILabel!
    @IBOutlet weak var lblThisWeek:UILabel!
    @IBOutlet weak var lblThisWeekLine:UILabel!
    @IBOutlet weak var lblShowAll:UILabel!
    @IBOutlet weak var lblShowAllLine:UILabel!
    
    //MARK: Instances
    var dictVouchers = [String:[VoucherModel]]()
    var arrVoucherDate = [String]()
    var arrVouchers = [VoucherModel]()
    var parentVC:SideMenuVC!
    var refreshControl = UIRefreshControl()
    var selectedViewIndex = 0
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        refreshControl.addTarget(self, action: #selector(FetchVoucherList), for: .valueChanged)
        self.tblVouchers.addSubview(refreshControl)
    }

    override func viewWillAppear(_ animated: Bool) {
        FetchVoucherList()
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:SideMenuVC)->VouchersListVC?{
        guard let VC = UIStoryboard.init(name: "Others", bundle: nil).instantiateViewController(withIdentifier: "VouchersListVC") as? VouchersListVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: Button Actions
    @IBAction func btnBackAction(_ sender:UIButton){
//        self.view.removeFromSuperview()
//        self.removeFromParent()
        self.parentVC.AddContainerView(data: self.parentVC.arrSideMenu.first!)
    }
    
    @IBAction func btnNewVocucherAction(_ sender:UIButton){
        if let VC = CreateVoucherVC.addToParentView(parentVC: self.parentVC){
            VC.delegate = self
        }
    }
    
    @IBAction func btnVoucherTabChanged(_ sender:UIButton){
        selectedViewIndex = sender.tag
        SortVouchers()
    }
    
    @IBAction func btnViewVoucherAction(_ sender:UIButton){
        if let VC = CreateVoucherVC.addToParentView(parentVC: self.parentVC, voucher: dictVouchers[arrVoucherDate[Int(sender.accessibilityIdentifier ?? "") ?? 0]]![sender.tag]){
            VC.delegate = self
        }
    }
    
    @IBAction func btnPrintVoucherAction(_ sender:UIButton){
        PrintManager.shared.connectToPrinterWithPrint(model: dictVouchers[arrVoucherDate[Int(sender.accessibilityIdentifier ?? "") ?? 0]]![sender.tag], controller: self)
    }
    
    @IBAction func btnCopyVoucherAction(_ sender:UIButton){
        UIPasteboard.general.string = dictVouchers[arrVoucherDate[Int(sender.accessibilityIdentifier ?? "") ?? 0]]![sender.tag].voucherCode
        AppCommonMethods.showToastAlert(message: "Voucher code has been copied!")
    }
    
    @IBAction func btnDeleteVoucherAction(_ sender:UIButton){
        AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: "Do you wish to cancel voucher?", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
            if index == 1{
                self.CallDeleteVoucher(section: Int(sender.accessibilityIdentifier ?? "") ?? 0, row: sender.tag)
            }
        }
    }
    
    //MARK: General Methods
    func SortVouchers(){
        var startDate:Date?
        var endDate:Date?
        var strVoucher = "All Vouchers"
        self.dictVouchers.removeAll()
        self.arrVoucherDate.removeAll()
        lblToday.textColor = AppConstants.Colors.kAppLightGrayColor
        lblTodayLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblTomorrow.textColor = AppConstants.Colors.kAppLightGrayColor
        lblTomorrowLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblThisWeek.textColor = AppConstants.Colors.kAppLightGrayColor
        lblThisWeekLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblShowAll.textColor = AppConstants.Colors.kAppLightGrayColor
        lblShowAllLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        var totalCount = 0
        if selectedViewIndex == 0{
            lblToday.textColor = AppConstants.Colors.kAppThemeTextColor
            lblTodayLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            startDate = Date().startOfDate() ?? Date()
            endDate = Date().endOfDate() ?? Date()
            strVoucher = Date().getDateInString(format: "dd MMMM yyyy")
            let arr = self.arrVouchers.filter { (model) -> Bool in
                if let date = (model.startDate ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss"){
                    return date >= startDate! && date < endDate!
                }
                return false
            }
            self.dictVouchers[startDate!.getDateInString(format: "dd MMMM yyyy")] = arr
            self.arrVoucherDate.append(startDate!.getDateInString(format: "dd MMMM yyyy"))
        } else if selectedViewIndex == 1{
            lblTomorrow.textColor = AppConstants.Colors.kAppThemeTextColor
            lblTomorrowLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            startDate = Date().startOfWeek()
            endDate = Date().endOfWeek()
            strVoucher = "\(startDate?.getDateInString(format: "dd MMMM yyyy") ?? "") - \(endDate?.getDateInString(format: "dd MMMM yyyy") ?? "")"
            if startDate != nil && endDate != nil{
                let arrDate = Date.dates(from: startDate!, to: endDate!)
                arrDate.forEach { sDate in
                    let eDate = sDate.addingTimeInterval(24*60*59)
                    let arr = self.arrVouchers.filter { (model) -> Bool in
                        if let date = (model.startDate ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss"){
                            return date >= sDate && date < eDate
                        }
                        return false
                    }
                    if arr.count > 0{
                        totalCount += arr.count
                        self.dictVouchers[sDate.getDateInString(format: "dd MMMM yyyy")] = arr
                        self.arrVoucherDate.append(sDate.getDateInString(format: "dd MMMM yyyy"))
                    }
                }
            }
        }else if selectedViewIndex == 2{
            lblThisWeek.textColor = AppConstants.Colors.kAppThemeTextColor
            lblThisWeekLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            startDate = Date().startOfMonth()
            endDate = Date().endOfMonth()
            strVoucher = Date().getDateInString(format: "MMMM yyyy")
            if startDate != nil && endDate != nil{
                let arrDate = Date.datesAtInterVal(fromDate: startDate!, toDate: endDate!, duration: 7)
                arrDate.forEach { sDate in
                    var eDate = sDate.addingTimeInterval(604799)
                    if eDate > endDate!{
                        eDate = endDate!
                    }
                    let arr = self.arrVouchers.filter { (model) -> Bool in
                        if let date = (model.startDate ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss"){
                            return date >= sDate && date < eDate
                        }
                        return false
                    }
                    if arr.count > 0{
                        totalCount += arr.count
                        self.dictVouchers["\(sDate.getDateInString(format: "dd MMMM yyyy")) - \(eDate.getDateInString(format: "dd MMMM yyyy"))"] = arr
                        self.arrVoucherDate.append("\(sDate.getDateInString(format: "dd MMMM yyyy")) - \(eDate.getDateInString(format: "dd MMMM yyyy"))")
                    }
                }
            }
        }else{
            lblShowAll.textColor = AppConstants.Colors.kAppThemeTextColor
            lblShowAllLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            totalCount = self.arrVouchers.count
            self.arrVouchers.forEach { model in
                let date = (model.startDate ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: "MMMM yyyy") ?? ""
                if var arr = dictVouchers[date]{
                    arr.append(model)
                    dictVouchers[date] = arr
                }else{
                    dictVouchers[date] = [model]
                    arrVoucherDate.append(date)
                }
            }
            arrVoucherDate.sort { str1, str2 in
                let date1 = str1.getDateFromString(format: "MMMM yyyy") ?? Date()
                let date2 = str2.getDateFromString(format: "MMMM yyyy") ?? Date()
                return date1 > date2
            }
        }

        self.lblTotalVoucher.text = "\(strVoucher)\nTotal vouchers: \(totalCount)"
        self.tblVouchers.reloadData()
    }
    
    //MARK: WebService Methods
    func CallDeleteVoucher(section:Int,row:Int){
        let voucher = dictVouchers[arrVoucherDate[section]]![row]
        if voucher.offline == 0{
            let dictParam = [String:String]()
            let id = dictVouchers[arrVoucherDate[section]]![row].id ?? 0
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kVoucher)\(id)", method: "DELETE") { (message, result) in
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    if let response = result as? NSDictionary{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let voucher = try? jsonDecoder.decode(VoucherModel.self, from: data){
                            if voucher.id ?? 0 != 0{
                                let index = self.arrVouchers.firstIndex { (model) -> Bool in
                                    return model.id ?? 0 == id
                                }
                                if index != nil{
                                    self.arrVouchers.remove(at: index!)
                                }
                                _ = SQLiteManage.ExecuteQuery("DELETE FROM Vouchers WHERE id = \(voucher.id ?? 0)")
                                self.SortVouchers()
                                return
                            }
                        }
                    }
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }else{
            if voucher.id ?? 0 != 0{
                if let index = self.arrVouchers.firstIndex(where: { (model) -> Bool in
                    return model.id ?? 0 == voucher.id ?? 0
                }){
                    self.arrVouchers.remove(at: index)
                }
                _ = SQLiteManage.ExecuteQuery("DELETE FROM Vouchers WHERE id = \(voucher.id ?? 0)")
                self.SortVouchers()
            }
        }
    }
    
    @objc func FetchVoucherList(){
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kVoucher, method: "GET") { (message, result) in
            DispatchQueue.main.async {
                self.refreshControl.endRefreshing()
                AppCommonMethods.stopProgressBar()
                self.arrVouchers.removeAll()
                if let response = result as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([VoucherModel].self, from: data){
                        self.arrVouchers = aData
                        self.SortVouchers()
                        return
                    }
                }
                self.SortVouchers()
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
}

//MARK: UITableViewDataSource
extension VouchersListVC:UITableViewDelegate, UITableViewDataSource{
    func numberOfSections(in tableView: UITableView) -> Int {
        return arrVoucherDate.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "VoucherItemCell", for: indexPath) as! VoucherItemCell
        if let arr = dictVouchers[arrVoucherDate[indexPath.section]]{
            let model = arr[indexPath.row]
            if model.customer?.name ?? ""  == ""{
                cell.lblName.text = "-"
            }else{
                cell.lblName.text = model.customer?.name ?? ""
            }
            if model.voucherCode ?? ""  == ""{
                cell.lblEmail.text = "-"
            }else{
                cell.lblEmail.text = model.voucherCode ?? ""
            }
            if model.customer?.mobile ?? ""  == ""{
                cell.lblContactNo.text = "-"
            }else{
                cell.lblContactNo.text = model.customer?.mobile ?? ""
            }
            
            cell.lblStartDate.text = (model.startDate ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: "dd/MM/yyyy") ?? "-"
            
            if model.endDate ?? "" == "" || model.endDate ?? "" == "0000-00-00 00:00:00"{
                cell.lblEndDate.text = "No Expiry"
            }else{
                cell.lblEndDate.text = (model.endDate ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: "dd/MM/yyyy") ?? "-"
            }
            
            cell.lblType.text = "-"
            cell.lblAmount.text = String.init(format: "%.2f", model.voucherAmount ?? 0)
            cell.btnView.tag = indexPath.row
            cell.btnPrint.tag = indexPath.row
            cell.btnDelete.tag = indexPath.row
            cell.btnCopy.tag = indexPath.row
            cell.btnCopy.accessibilityIdentifier = "\(indexPath.section)"
            cell.btnView.accessibilityIdentifier = "\(indexPath.section)"
            cell.btnPrint.accessibilityIdentifier = "\(indexPath.section)"
            cell.btnDelete.accessibilityIdentifier = "\(indexPath.section)"
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        let count = dictVouchers[arrVoucherDate[section]]?.count ?? 0
        return (count == 0) ? 0 : 40
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return dictVouchers[arrVoucherDate[section]]?.count ?? 0
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let cell = tableView.dequeueReusableCell(withIdentifier: "ReservationHeaderCell") as! ReservationHeaderCell
        cell.lblTitle.text = arrVoucherDate[section]
        return cell
    }
}

extension VouchersListVC:pageRefreshDelegate{
    func pageNeedToRefresh() {
        self.FetchVoucherList()
    }
}
