//
//  WebViewVC.swift
//  EPOS
//
//  Created by Apple on 23/06/21.
//

import UIKit
import WebKit

class WebViewVC: UIViewController {
    
    //MARK: IBOutlet
    @IBOutlet weak var webView: WKWebView?
    
    //MARK: Instances
    var strURL = ""
    var viewForHeader:HeaderView!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        AppCommonMethods.startProgressBar(isInteractive: true)
        viewForHeader = HeaderView.addToViewHeader(VC: self)
        viewForHeader.setViewData()
        if webView != nil{
            webView!.navigationDelegate = self
            if let url = URL(string: strURL.addingPercentEncoding(withAllowedCharacters: CharacterSet.urlQueryAllowed) ?? "") {
                let request = URLRequest(url: url)
                webView!.load(request)
            }
        }
    }
    
    deinit {
        webView = nil
    }
    
    //MARK: Create Viewcontrlloer instance
    static func instance()->WebViewVC?{
        return UIStoryboard.init(name: "Others", bundle: nil).instantiateViewController(withIdentifier: "WebViewVC") as? WebViewVC
    }
    
}

//MARK: WKNavigationDelegate
extension WebViewVC:WKNavigationDelegate{
    func webView(_ webView: WKWebView, didFinish navigation: WKNavigation!) {
        AppCommonMethods.stopProgressBar()
    }
    
    func webView(_ webView: WKWebView, didFail navigation: WKNavigation!, withError error: Error) {
        print(error.localizedDescription)
        AppCommonMethods.stopProgressBar()
    }
}
