//
//  CardReaderVC.swift
//  EPOS
//
//  Created by Apple on 29/05/21.
//

import UIKit
import StripeTerminal

class CardReaderVC: UIViewController {
    
    //MARK: IBOutlet
    @IBOutlet weak var txtAmount:UITextField!
    @IBOutlet weak var lblCardReaderName:UILabel!
    @IBOutlet weak var txtTipAmount:UITextField!
    @IBOutlet weak var constTblReaderHeight:NSLayoutConstraint!
    
    //MARK: Instances
    var parentVC:PaymentMainVC!
    var discoverCancelable: Cancelable?
    var popupVC:SelectCardReaderVC?
    var arrStripeCard = [Reader]()
    var isReaderProcessStart = false
    var lastReader:CardReaderModel?
    var arrCardReader = [CardReaderModel]()
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        txtAmount.text = "\(AppConstants.currencySign)0.00"
        txtTipAmount.text = "\(AppConstants.currencySign)0.00"
        if AppConstants.businessData?.tip ?? 0 == 0{
            txtTipAmount.superview?.isHidden = true
        }
        arrCardReader = AppConstants.businessData?.cardReaders?.filter({ model in
            model.connectivity?.lowercased() ?? "" != "taptopay"
        }) ?? [CardReaderModel]()
        if AppConstants.selectedReader == nil{
            AppConstants.selectedReader = arrCardReader.first
        }
        lastReader = AppConstants.selectedReader
        constTblReaderHeight.constant = 70*CGFloat(arrCardReader.count)
        
    }
    
    override func viewWillAppear(_ animated: Bool) {
        checkCardConnected()
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:PaymentMainVC)->CardReaderVC?{
        guard let VC = UIStoryboard.init(name: "Payments", bundle: nil).instantiateViewController(withIdentifier: "CardReaderVC") as? CardReaderVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 10, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height-20)
        return VC
    }
    
    //MARK: Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.view.endEditing(true)
        self.txtAmount.text = "\(AppConstants.currencySign)0.00"
        self.txtTipAmount.text = "\(AppConstants.currencySign)0.00"
    }
    
    @IBAction func btnPayNowAction(_ sender: UIButton) {
        self.view.endEditing(true)
        let strAmount = (txtAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")
        if Double(strAmount) ?? 0 < 0.5{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "Amount can not be less than 0.5", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
        }else{
            Terminal.shared.delegate = self
            if let reader = lastReader, reader.id ?? 0 != AppConstants.selectedReader?.id ?? 0{
                Terminal.shared.disconnectReader { error in
                    if error != nil{
                        print("disconnectReader error:",error!.localizedDescription)
                    }
                    AppConstants.selectedStripeReader = nil
                    self.cancelTermintalProcess{
                        DispatchQueue.main.asyncAfter(deadline: .now()+0.5) {
                            self.connectToCardReader()
                        }
                    }
                }
            }else{
                if AppConstants.selectedStripeReader != nil{
                    AppCommonMethods.startProgressBar()
                    self.CreateStripePaymentIntent(terminalId: AppConstants.selectedStripeReader!.stripeId ?? "")
                }else{
                    self.connectToCardReader()
                }
            }
        }
    }
    
    //MARK: General Methods
    func checkCardConnected(){
        if AppConstants.selectedStripeReader != nil{
            self.lblCardReaderName.superview?.isHidden = false
            self.lblCardReaderName.text = String.init(format: "%@ - (%.0f)%@", AppConstants.selectedStripeReader!.serialNumber, (AppConstants.selectedStripeReader!.batteryLevel?.floatValue ?? 0) * 100, "%")
        }else{
            self.lblCardReaderName.superview?.isHidden = true
        }
    }
    
    func printDelineTransaction(){
        if AppConstants.selectedPrinter != nil{
            let amount = Double((txtAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
            let tipAmount = Double((txtTipAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
            PrintManager.shared.isCustomerCopy = false
            PrintManager.shared.amount = amount
            PrintManager.shared.tipAmount = tipAmount
            PrintManager.shared.status = "Declined"
            PrintManager.shared.entryMode = "Terminal"
            PrintManager.shared.isReprint = false
            PrintManager.shared.connectToPrinterWithPrint(model: AppConstants.businessData!, controller: self)
        }
        self.cancelTermintalProcess{}
        CustomAudioPlayer.shared.preparePlayer(soundName: "decline_sound")
    }
    
    func getPaymentCardBrand(card:Any?)->String{
        if let card = card as? CardBrand{
            switch card {
            case .unknown: return ""
            case .masterCard: return "Mastercard"
            case .amex: return "AMEX"
            case .visa: return "Visa"
            case .interac: return "Interac"
            case .dinersClub: return "Diners Club"
            case .discover: return "Discover"
            case .JCB: return "JCB"
            default: return ""
            }
        }
        return ""
    }
    
    //MARK: WebService Methods
    func CalculateAppFee()->Double{
        var appFee = 0.0
        let amount = (Double((txtAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0) + (Double((txtTipAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0)
        let authFee = AppConstants.businessData?.businessCommissions?.connecCardAuthFee ?? 0
        if (AppConstants.businessData?.businessCommissions?.connectCardAuthFeeType ?? "").lowercased() == "flat"{
            appFee += authFee
        }else if (AppConstants.businessData?.businessCommissions?.connectCardAuthFeeType ?? "").lowercased() == "percentage"{
            appFee += (amount * authFee/100)
        }
        let procssingFee = AppConstants.businessData?.businessCommissions?.connecCardProcessingFee ?? 0
        if (AppConstants.businessData?.businessCommissions?.connectCardProcessingFeeType ?? "").lowercased() == "flat"{
            appFee += procssingFee
        }else if (AppConstants.businessData?.businessCommissions?.connectCardProcessingFeeType ?? "").lowercased() == "percentage"{
            appFee += (amount * procssingFee/100)
        }
        return appFee
    }
    
    func CreateStripePaymentIntent(terminalId:String){
        var dictParam = [String:Any]()
        let amount = Double((txtAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
        let tipAmount = Double((txtTipAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
        
        dictParam["amount"] = Int((amount+tipAmount)*100)
        dictParam["transaction_type"] = "merchant"
        dictParam["s_terminal_id"] = terminalId
        dictParam["business_id"] = AppConstants.businessData?.id ?? 0
        
        if AppConstants.isInDevlopmentMode{
            print("Internt Paramter :",dictParam)
        }
        PrintManager.shared.cardBrand = ""
        PrintManager.shared.cardNumber = ""
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kPaymentIntentAPI, method: "POST") { (message, result) in
            DispatchQueue.main.async {
                if AppConstants.isInDevlopmentMode{
                    print("Intent Response:",result ?? "")
                }
                if let response = result as? NSDictionary, let secret = response.getStringFromPath("payment_intent.client_secret"){
                    self.terminalPaymentProcessing(secret: secret)
                    return
                }
                AppCommonMethods.stopProgressBar()
                self.printDelineTransaction()
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
    
    func CapturePaymentIntent(id:String){
        var dictParam = [String:Any]()
        dictParam["payment_intent_id"] = id
        dictParam["s_terminal_id"] = AppConstants.selectedStripeReader?.stripeId ?? ""
        dictParam["business_id"] = AppConstants.businessData?.id ?? 0
        
        if AppConstants.isInDevlopmentMode{
            print("Internt Paramter :",dictParam)
        }
        let amount = Double((txtAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
        let tipAmount = Double((txtTipAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
        
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kCaptureIntentAPI, method: "POST") { (message, result) in
            DispatchQueue.main.async {
                if AppConstants.isInDevlopmentMode{
                    print("Intent Response:",result ?? "")
                }
                self.cancelTermintalProcess{}
                AppCommonMethods.stopProgressBar()
                if let response = result as? NSDictionary, let id = response.getStringValue("id"){
                    AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_PAYMENT_SUCESS)
                    self.txtAmount.text = "\(AppConstants.currencySign)0.00"
                    self.txtTipAmount.text = "\(AppConstants.currencySign)0.00"
                    CustomAudioPlayer.shared.preparePlayer(soundName: "payment_approval_sound")
                    if AppConstants.selectedPrinter != nil{
                        PrintManager.shared.TID = id
                        PrintManager.shared.entryMode = "Terminal"
                        PrintManager.shared.isCustomerCopy = false
                        PrintManager.shared.amount = amount
                        PrintManager.shared.tipAmount = tipAmount
                        PrintManager.shared.status = "Approved"
                        PrintManager.shared.isReprint = false
                        PrintManager.shared.connectToPrinterWithPrint(model: AppConstants.businessData!, controller: self)
                    }
                    return
                }
                self.printDelineTransaction()
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
    
    //MARK: CardReader Methods
    func terminalPaymentProcessing(secret:String){
        Terminal.shared.retrievePaymentIntent(clientSecret: secret) { paymentIntet, error in
            DispatchQueue.main.async {
                guard let intent = paymentIntet else{
                    AppCommonMethods.stopProgressBar()
                    if let err = error{
                        print("retriveInent failed: \(err)")
                        AppCommonMethods.showToastAlert(message: err.localizedDescription)
                    }
                    self.printDelineTransaction()
                    return
                }
                let _ = Terminal.shared.collectPaymentMethod(intent) { collectResult, collectError in
                    DispatchQueue.main.async {
                        guard let result = collectResult else{
                            AppCommonMethods.stopProgressBar()
                            if let err = collectError{
                                print("collectPaymentMethod failed: \(err)")
                                AppCommonMethods.showToastAlert(message: err.localizedDescription)
                            }
                            self.printDelineTransaction()
                            return
                        }
                        Terminal.shared.confirmPaymentIntent(result) { processResult, processError in
                            DispatchQueue.main.async {
                                guard let pResult = processResult else{
                                    AppCommonMethods.stopProgressBar()
                                    if let err = processError{
                                        print("processPayment failed: \(err)")
                                        AppCommonMethods.showToastAlert(message: err.localizedDescription)
                                    }
                                    self.printDelineTransaction()
                                    return
                                }
                                PrintManager.shared.cardBrand = self.getPaymentCardBrand(card: pResult.charges.first?.paymentMethodDetails?.cardPresent?.brand)
                                PrintManager.shared.cardNumber = pResult.charges.first?.paymentMethodDetails?.cardPresent?.last4 ?? ""
                                self.CapturePaymentIntent(id: pResult.stripeId ?? "")
                            }
                        }
                    }
                }
            }
        }
    }
    
    func connectToCardReader(){
        if (AppConstants.selectedReader?.connectivity ?? "").lowercased() == "internet"{
            do{
                let config = try InternetDiscoveryConfigurationBuilder().setLocationId(AppConstants.selectedReader?.sLocationId ?? "").build()
                AppCommonMethods.startProgressBar()
                
                self.discoverCancelable = Terminal.shared.discoverReaders(config, delegate: self) { error in
                    DispatchQueue.main.async {
                        if let error = error {
                            AppCommonMethods.stopProgressBar()
                            print("discoverReaders failed: \(error)")
                            AppCommonMethods.showToastAlert(message: error.localizedDescription)
                        } else {
                            print("discoverReaders succeeded")
                        }
                        self.discoverCancelable = nil
                    }
                }
            }catch{
                print(error.localizedDescription)
            }
        }else if (AppConstants.selectedReader?.connectivity ?? "").lowercased() == "taptopay"{
        }else{
            do{
                let config = try BluetoothScanDiscoveryConfigurationBuilder().build()
                AppCommonMethods.startProgressBar()
                self.discoverCancelable = Terminal.shared.discoverReaders(config, delegate: self) { error in
                    DispatchQueue.main.async {
                        if let error = error {
                            AppCommonMethods.stopProgressBar()
                            print("discoverReaders failed: \(error)")
                            AppCommonMethods.showToastAlert(message: error.localizedDescription)
                        } else {
                            print("discoverReaders succeeded")
                        }
                        self.discoverCancelable = nil
                    }
                }
            }catch{
                print(error.localizedDescription)
            }
        }
    }
    
    func connectToStripeReader(){
        if AppConstants.selectedStripeReader!.deviceType == .wisePad3{
            var locationId = ""
            if AppConstants.selectedReader?.sLocationId ?? "" != ""{
                locationId = AppConstants.selectedReader?.sLocationId ?? ""
            }else if AppConstants.selectedStripeReader?.locationId ?? "" != ""{
                locationId = AppConstants.selectedStripeReader?.locationId ?? ""
            }else{
                AppCommonMethods.showToastAlert(message: "Location not found")
                self.cancelTermintalProcess{}
                return
            }
            do{
                let config = try BluetoothConnectionConfigurationBuilder.init(delegate: self, locationId: locationId).setAutoReconnectOnUnexpectedDisconnect(true).build()
                AppCommonMethods.startProgressBar()
                
                Terminal.shared.connectReader(AppConstants.selectedStripeReader!, connectionConfig: config) { reader, error in
                    DispatchQueue.main.async {
                        if let reader = reader {
                            self.CreateStripePaymentIntent(terminalId: reader.stripeId ?? "")
                        } else if let error = error {
                            AppCommonMethods.stopProgressBar()
                            print("connectInternetReader failed: \(error)")
                            AppCommonMethods.showToastAlert(message: error.localizedDescription)
                            self.cancelTermintalProcess{}
                            CustomAudioPlayer.shared.preparePlayer(soundName: "decline_sound")
                        }
                    }
                }
            }catch{
                print(error.localizedDescription)
            }
            
        }else{
            do{
                let config = try InternetConnectionConfigurationBuilder(delegate: self).build()
                AppCommonMethods.startProgressBar()
                
                Terminal.shared.connectReader(AppConstants.selectedStripeReader!, connectionConfig: config) { reader, error in
                    DispatchQueue.main.async {
                        if let reader = reader {
                            self.CreateStripePaymentIntent(terminalId: reader.stripeId ?? "")
                        } else if let error = error {
                            self.cancelTermintalProcess{}
                            AppCommonMethods.stopProgressBar()
                            print("connectInternetReader failed: \(error)")
                            AppCommonMethods.showToastAlert(message: error.localizedDescription)
                            CustomAudioPlayer.shared.preparePlayer(soundName: "decline_sound")
                        }
                    }
                }
            }catch{
                print(error.localizedDescription)
            }
        }
    }
    
    func cancelTermintalProcess(completed : @escaping () -> ()){
        if self.discoverCancelable != nil{
            self.discoverCancelable?.cancel({ error in
                if let err = error{
                    print(err.localizedDescription)
                }
                AppCommonMethods.showToastAlert(message: "Discover cancelled")
                self.discoverCancelable = nil
                if let _ = AppConstants.selectedStripeReader{
                }else{
                    self.isReaderProcessStart = false
                    NSObject.cancelPreviousPerformRequests(withTarget: self)
                }
                completed()
            })
        }else{
            if let _ = AppConstants.selectedStripeReader{
            }else{
                self.isReaderProcessStart = false
                NSObject.cancelPreviousPerformRequests(withTarget: self)
                completed()
            }
        }
    }
}

//MARK: UITextFieldDelegate
extension CardReaderVC: UITextFieldDelegate{
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let allowedCharacters = CharacterSet(charactersIn:"0123456789")
        let characterSet = CharacterSet(charactersIn: string)
        if allowedCharacters.isSuperset(of: characterSet){
            var strText = (textField.text!).replacingOccurrences(of: "\(AppConstants.currencySign)", with: "").replacingOccurrences(of: ".", with: "")
            if string == ""{
                if strText != "000"{
                    if strText.count == 3{
                        strText.removeLast()
                        strText = "0\(strText)"
                    }else{
                        strText.removeLast()
                    }
                    strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                    textField.text = "\(AppConstants.currencySign)\(strText)"
                }
            }else{
                if strText.first! == "0"{
                    strText.removeFirst()
                    strText = "\(strText)\(string)"
                }else{
                    strText = "\(strText)\(string)"
                }
                strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                textField.text = "\(AppConstants.currencySign)\(strText)"
            }
        }
        return false
    }
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        return textField.resignFirstResponder()
    }
}

//MARK: CardReaderDelegate
extension CardReaderVC: CardReaderDelegate{
    func cardReaderSelected(reader: Any?) {
        popupVC = nil
        if let reder = reader as? Reader{
            self.lastReader = AppConstants.selectedReader
            AppConstants.selectedStripeReader = reder
            self.isReaderProcessStart = true
            connectToStripeReader()
            self.checkCardConnected()
        }else if let reader = reader as? CardReaderModel{
            AppConstants.selectedReader = reader
            self.connectToCardReader()
        }else{
            self.cancelTermintalProcess{}
        }
    }
}

//MARK: DiscoveryDelegate
extension CardReaderVC:DiscoveryDelegate{
    func terminal(_ terminal: Terminal, didUpdateDiscoveredReaders readers: [Reader]) {
        arrStripeCard = readers
        print("readers",readers.last?.serialNumber ?? "")
        self.perform(#selector(performReaderAction), with: nil, afterDelay: 1)
    }
    
    @objc func performReaderAction(){
        if self.isReaderProcessStart{
            return
        }
        if self.popupVC != nil{
            self.popupVC?.arrStripeCard = self.arrStripeCard
            self.popupVC?.tblCardReader.reloadData()
        }else{
            AppCommonMethods.stopProgressBar()
            if self.arrStripeCard.count == 0{
                self.cancelTermintalProcess{}
            }else if self.arrStripeCard.count == 1{
                lastReader = AppConstants.selectedReader
                AppConstants.selectedStripeReader = self.arrStripeCard[0]
                self.connectToStripeReader()
            }else{
                if let reader = self.arrStripeCard.filter({ reader in
                    return (AppConstants.selectedReader?.serialNumber ?? "").contains(reader.serialNumber)
                }).first{
                    
                    AppConstants.selectedStripeReader = reader
                    self.isReaderProcessStart = true
                    self.connectToStripeReader()
                    self.checkCardConnected()
                }else{
                    if let VC = SelectCardReaderVC.showPopup(parentVC: self.parentVC.parentVC,selectedReader: self.arrStripeCard.first, readers: self.arrStripeCard){
                        self.popupVC = VC
                        VC.delegate = self
                    }
                }
            }
        }
    }
}

//MARK: BluetoothReaderDelegate
extension CardReaderVC:MobileReaderDelegate, InternetReaderDelegate, TerminalDelegate{
    func terminal(_ terminal: Terminal, didReportUnexpectedReaderDisconnect reader: Reader) {
        AppConstants.selectedStripeReader = nil
        self.checkCardConnected()
    }
    
    func reader(_ reader: Reader, didReportAvailableUpdate update: ReaderSoftwareUpdate) {
    }
    
    func reader(_ reader: Reader, didStartInstallingUpdate update: ReaderSoftwareUpdate, cancelable: Cancelable?) {
        AppCommonMethods.stopProgressBar()
        AppCommonMethods.startProgressBar(view: self.view, strMessage: "Start installing update")
        AppCommonMethods.showToastAlert(message: "Reader starts updating")
    }
    
    func reader(_ reader: Reader, didReportReaderSoftwareUpdateProgress progress: Float) {
        let percent = Int(progress*100)
        AppCommonMethods.changeProgressMessage(msg: "Update progress:\n\(percent)%")
    }
    
    func reader(_ reader: Reader, didFinishInstallingUpdate update: ReaderSoftwareUpdate?, error: Error?) {
        if let error = error{
            print("didFinishInstallingUpdate Failed: \(error.localizedDescription)")
            AppCommonMethods.showToastAlert(message: error.localizedDescription)
        }
        AppCommonMethods.stopProgressBar(view: self.view)
    }
    
    func reader(_ reader: Reader, didRequestReaderInput inputOptions: ReaderInputOptions = []) {
        print("didRequestReaderInput: \(Terminal.stringFromReaderInputOptions(inputOptions))")
        AppCommonMethods.showToastAlert(message: Terminal.stringFromReaderInputOptions(inputOptions))
    }
    
    func reader(_ reader: Reader, didRequestReaderDisplayMessage displayMessage: ReaderDisplayMessage) {
        print("didRequestReaderDisplayMessage: \(Terminal.stringFromReaderDisplayMessage(displayMessage))")
        AppCommonMethods.showToastAlert(message: Terminal.stringFromReaderDisplayMessage(displayMessage))
    }
}

//MARK: UITableViewDataSource
extension CardReaderVC:UITableViewDelegate,UITableViewDataSource{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrCardReader.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "CardReaderViewCell", for: indexPath) as! CardReaderViewCell
        let model = arrCardReader[indexPath.row]
        cell.lblName.text = model.name ?? ""
        cell.imgSelect.image = UIImage.init(named: "ic_radio_unselected")
        if let card = AppConstants.selectedReader{
            if card.id ?? 0 == model.id ?? 0{
                cell.imgSelect.image = UIImage.init(named: "ic_radio_selected")
            }
        }
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        AppConstants.selectedReader = arrCardReader[indexPath.row]
        tableView.reloadData()
    }
}
