//
//  FullReportVC.swift
//  EPOS
//
//  Created by Apple on 08/06/21.
//

import UIKit
import BetterSegmentedControl
import ActionSheetPicker_3_0

class FullReportVC: UIViewController {
    
    //MARK: IBOutlet
    @IBOutlet weak var viewForCustomDate:UIView!
    @IBOutlet weak var txtFromDate:UITextField!
    @IBOutlet weak var txtToDate:UITextField!
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var lblValue:UILabel!
    @IBOutlet weak var lblQuantity:UILabel!
    @IBOutlet weak var lblDateRange:UILabel!
    @IBOutlet weak var imgDropArrow:UIImageView!
    @IBOutlet weak var lblSlectedUser:UILabel!
    @IBOutlet weak var lblType:UILabel!
    @IBOutlet weak var segementTime:BetterSegmentedControl!
    @IBOutlet weak var tblReport:UITableView!
    @IBOutlet weak var tblUserList:UITableView!
    @IBOutlet weak var constTblHeight:NSLayoutConstraint!
    @IBOutlet weak var constSegmentTopSpace:NSLayoutConstraint!
    @IBOutlet weak var viewForUser:UIView!
    @IBOutlet weak var btnBack:UIButton!
    @IBOutlet weak var btnSendReprot:UIButton!
    
    //MARK: Instances
    var fromDate = Date()
    var toDate = Date()
    var selectedReport:RerportCellData!
    var arrReports = [ReportModel]()
    var arrUsers = [UserModel]()
    var selectedUser:UserModel!
    var reportData:FullReportModel?
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        
        viewForCustomDate.isHidden = true
        
        lblTitle.text = selectedReport.title
        lblValue.text = "Value"
        
        self.segementTime.segments = LabelSegment.segments(withTitles: ["Today","This week","This month","Custom"], normalBackgroundColor: .white, normalFont: AppConstants.GlobalFontConstants.kBoldFont(size: 14), normalTextColor: AppConstants.Colors.kAppDarkGrayColor, selectedBackgroundColor: AppConstants.Colors.kAppThemeAquaColor , selectedFont: AppConstants.GlobalFontConstants.kBoldFont(size: 14), selectedTextColor: .white)
        
        if selectedReport.type == RerportType.kFullReport || selectedReport.type == RerportType.kOnlineOrderReport || selectedReport.type == RerportType.kSelectedUserReport || selectedReport.type == RerportType.kFullArchivedReport{
            lblQuantity.isHidden = true
        }
        if selectedReport.type == RerportType.kSelectedUserReport{
            viewForUser.isHidden = false
            constSegmentTopSpace.constant = 68
            arrUsers = AppConstants.arrUserList ?? [UserModel]()
            selectedUser = AppConstants.userData!
            lblSlectedUser.text = selectedUser.username ?? ""
        }
        if selectedReport.type == RerportType.FullReportBeta{
            btnBack.isHidden = true
            btnSendReprot.isHidden = false
            lblQuantity.textAlignment = .right
        }
        self.lblDateRange.text = Date().getDateInString(format: "dd/MM/yyyy")
        FetchFullReport()
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:PaymentMainVC,selectedReport:RerportCellData)->FullReportVC?{
        guard let VC = UIStoryboard.init(name: "Payments", bundle: nil).instantiateViewController(withIdentifier: "FullReportVC") as? FullReportVC else {
            return nil
        }
        VC.selectedReport = selectedReport
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 10, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height-20)
        return VC
    }
    
    //MARK: Button Actions
    @IBAction func segmentValueChanged(_ sender:Any){
        viewForCustomDate.isHidden = true
        if segementTime.index == 0{
            fromDate = Date().startOfDate() ?? Date()
            toDate = Date().endOfDate() ?? Date()
            self.lblDateRange.text = Date().getDateInString(format: "dd/MM/yyyy")
        }else if segementTime.index == 1{
            fromDate = Date().startOfWeek() ?? Date()
            toDate = Date().endOfWeek() ?? Date()
            self.lblDateRange.text = "\(fromDate.getDateInString(format: "dd/MM/yyyy")) - \(toDate.getDateInString(format: "dd/MM/yyyy"))"
        }else if segementTime.index == 2{
            fromDate = Date().startOfMonth()
            toDate = Date().endOfMonth()
            self.lblDateRange.text = "\(fromDate.getDateInString(format: "dd/MM/yyyy")) - \(toDate.getDateInString(format: "dd/MM/yyyy"))"
        }else{
            viewForCustomDate.isHidden = false
            txtToDate.text = "To - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
            txtFromDate.text = "From - \(self.fromDate.getDateInString(format: "dd/MM/yyyy"))"
            self.lblDateRange.text = "\(self.fromDate.getDateInString(format: "dd/MM/yyyy")) - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
        }
        FetchFullReport()
    }
    
    @IBAction func btnBackAction(_ sender:UIButton){
        self.view.removeFromSuperview()
        self.removeFromParent()
    }
    
    @IBAction func btnPrintAction(_ sender:UIButton){
        var strHeaderDate = Date().gatDateFormatAndTime(isWithTime: true)
        if segementTime.index != 0{
            strHeaderDate = "\(fromDate.gatDateFormatAndTime()) to \(toDate.gatDateFormatAndTime())"
        }
        PrintManager.shared.strHeaderDate = strHeaderDate
        if self.selectedReport.type == RerportType.kSelectedUserReport{
            PrintManager.shared.selectedUserName = selectedUser?.username
        }
        if arrReports.count > 0{
            PrintManager.shared.reportType = selectedReport.type
            PrintManager.shared.connectToPrinterWithPrint(model: arrReports, controller: self)
        }
    }
    
    @IBAction func btnUserDropDownAction(_ sender:UIButton){
        if constTblHeight.constant == 0{
            let height = CGFloat(arrUsers.count) * 35
            constTblHeight.constant = min(height, 140)
        }else{
            constTblHeight.constant = 0
        }
        UIView.animate(withDuration: 0.25) {
            if self.constTblHeight.constant != 0{
                self.imgDropArrow.transform = CGAffineTransform(rotationAngle: .pi)
            }else{
                self.imgDropArrow.transform = CGAffineTransform(rotationAngle: 0)
            }
            self.view.layoutIfNeeded()
        }
    }
    
    @IBAction func btnSendReportAction(_ sender:UIButton){
        var setting = AlertSetting()
        setting.alertMessage = "Separate multiple email addresses with commas"
        setting.alertTitle = "Send report"
        setting.cancelBGColor = AppConstants.Colors.kAppMediumGrayColor
        setting.confirmBGColor = AppConstants.Colors.kAppDarkGrayColor
        setting.textPlcaeholder = "Deliver to"
        setting.textTitle = AppConstants.businessData?.autoMailEmail ?? ""
        setting.type = .kNormal
        setting.textType = .emailAddress
        if let VC = AlertViewController.showPopup(parentVC: self.parent!.parent!, setting: setting){
            VC.delegate = self
        }
    }
    
    //MARK: Database Methods
    func setReportData(dict:NSDictionary? = nil){
        if self.selectedReport.type == RerportType.kOnlineOrderReport{
            self.arrReports.append(ReportModel.init(status: "Orders", count: self.reportData?.onlineOrderCount, rowType: 1))
            self.arrReports.append(ReportModel.init(status: "iOS", total: self.reportData?.iOSOnlineOrder?.first?.total ?? 0, count: self.reportData?.iOSOnlineOrder?.first?.count ?? 0, showAll: true))
            self.arrReports.append(ReportModel.init(status: "Android", total: self.reportData?.androidOnlineOrder?.first?.total ?? 0, count: self.reportData?.androidOnlineOrder?.first?.count ?? 0, showAll: true))
            self.arrReports.append(ReportModel.init(status: "Web", total: self.reportData?.webOnlineOrder?.first?.total ?? 0, count: self.reportData?.webOnlineOrder?.first?.count ?? 0, showAll: true))
            self.arrReports.append(ReportModel.init(status: "Reservations", count: self.reportData?.onlineReservationCount, rowType: 1))
            self.arrReports.append(ReportModel.init(status: "Order Businesses", total: self.reportData?.onlineOrderTotalBusiness))
            self.arrReports.append(ReportModel.init(status: "Order Commission", total: self.reportData?.onlineOrderCalculatedCommission))
            if self.reportData?.onlineOrderType?.count ?? 0 > 0{
                self.arrReports.append(ReportModel.init(status: "Order Type", total:0, count: 0, rowType: 2))
                for model in self.reportData!.onlineOrderType!{
                    self.arrReports.append(ReportModel.init(status: "\(model.status ?? "")", total: model.total ?? 0, count: model.count ?? 0, showAll: true))
                }
            }
            if self.reportData?.onlineOrderPayment?.count ?? 0 > 0{
                self.arrReports.append(ReportModel.init(status: "Order Payment", total:0, count: 0, rowType: 2))
                for model in self.reportData!.onlineOrderPayment!{
                    self.arrReports.append(ReportModel.init(status: "\(model.status ?? "")", total: model.total ?? 0, count: model.count ?? 0, showAll: true))
                }
            }
            
        }else if self.selectedReport.type == RerportType.ZReport{
            self.arrReports.insert(ReportModel.init(status: "Total Orders", count: self.reportData?.orderCount, rowType: 1), at: 0)
            self.arrReports.append(ReportModel.init(status: "Product Sale", total: self.reportData?.ordersAmountProduct, count: self.reportData?.ordersTotalProduct, showAll: true))
            self.arrReports.append(ReportModel.init(status: "Total Discount", total: self.reportData?.totalDiscount))
            self.arrReports.append(ReportModel.init(status: "Total Vouchers", total: self.reportData?.allocatedVoucherValue, count: self.reportData?.allocatedVoucher, showAll: true))
            self.arrReports.append(ReportModel.init(status: "Total Dinners", count: self.reportData?.totalNoGuest, rowType: 1))
            self.arrReports.append(ReportModel.init(status: "Total Tables", count: self.reportData?.totalNoTable, rowType: 1))
            self.arrReports.append(ReportModel.init(status: "Total Gratuity", total: self.reportData?.totalGratuity))
            self.arrReports.append(ReportModel.init(status: "Total Service Charge", total: self.reportData?.totalServiceCharge))
            self.arrReports.append(ReportModel.init(status: "Total deleted items", total: self.reportData?.deletedOrderItemsAmount, count: self.reportData?.deletedOrderItems, showAll: true))
            if self.reportData?.orderTypeWise?.count ?? 0 > 0{
                self.arrReports.append(ReportModel.init(status: "Order Type", total:0, count: 0, rowType: 2))
                for model in self.reportData!.orderTypeWise!{
                    if model.total != nil{
                        self.arrReports.append(ReportModel.init(status: model.status ?? "", total: model.total, count: model.count, showAll: true))
                    }
                }
            }
            if self.reportData?.orderStatusWise?.count ?? 0 > 0{
                self.arrReports.append(ReportModel.init(status: "Order Status", total:0, count: 0, rowType: 2))
                for model in self.reportData!.orderStatusWise!{
                    if model.total != nil{
                        self.arrReports.append(ReportModel.init(status: model.status ?? "", total: model.total, count: model.count, showAll: true))
                    }
                }
            }
            if self.reportData?.orderPaymentWise?.count ?? 0 > 0{
                self.arrReports.append(ReportModel.init(status: "Payment Wise", total:0, count: 0, rowType: 2))
                for model in self.reportData!.orderPaymentWise!{
                    if model.total != nil{
                        self.arrReports.append(ReportModel.init(status: model.status ?? "", total: model.total, count: model.count, showAll: true))
                    }
                }
            }
            self.arrReports.append(ReportModel.init(status: "Grand total", total:0, count: 0, rowType: 2))
            let totalCash = self.reportData?.orderPaymentWise?.filter{ $0.status?.lowercased().contains("cash") ?? false }.first?.total ?? 0
            let totalCard = self.reportData?.orderPaymentWise?.filter{ $0.status?.lowercased().contains("card") ?? false }.first?.total ?? 0
            let totalCheque = self.reportData?.orderPaymentWise?.filter{ $0.status?.lowercased().contains("cheque") ?? false }.first?.total ?? 0
            self.arrReports.append(ReportModel.init(status: "Total Cash", total: totalCash, showAll: true))
            self.arrReports.append(ReportModel.init(status: "Total Card", total: totalCard, showAll: true))
            self.arrReports.append(ReportModel.init(status: "Total Cheque", total: totalCheque, showAll: true))
            self.arrReports.append(ReportModel.init(status: "Total", total: totalCash + totalCard + totalCheque, showAll: true))
        }else{
            self.arrReports.removeAll()
            let archieve = (self.selectedReport.type == RerportType.kFullArchivedReport) ? "AND Orders.is_archived = 1" : "AND Orders.is_archived = 0"
            let userConditionString = (self.selectedReport.type == RerportType.kSelectedUserReport) ? "AND Orders.updater_id = \(selectedUser.id ?? 0)" : ""
            let userConditionStringNoJoin = (self.selectedReport.type == RerportType.kSelectedUserReport) ? "AND updater_id = \(selectedUser.id ?? 0)" : ""
            
            let startDate = Int((fromDate.startOfDate() ?? fromDate).timeIntervalSince1970)
            let endDate = Int((toDate.endOfDate() ?? toDate).timeIntervalSince1970)
            
            if selectedReport.type == RerportType.kProductSaleReport{
                let produstSale = SQLiteManage.SelectQuery("SELECT SUM(OrderProducts.quantity) as count,sum(OrderProducts.sub_total) as total, OrderProducts.product_name as name FROM OrderProducts LEFT JOIN Orders ON OrderProducts.order_id = orders.id WHERE Orders.delivery_date >= \(startDate) AND Orders.isDelete == 0 AND OrderProducts.isDelete == 0 AND Orders.order_status_id != 10 AND Orders.delivery_date < \(endDate) \(archieve) GROUP BY OrderProducts.product_id")
                if produstSale.count > 0{
                    for type in produstSale{
                        if let value = type["total"], value != ""{
                            self.arrReports.append(ReportModel.init(status: (type["name"] ?? ""), total: Double(value) ?? 0, count: Int(type["count"] ?? "") ?? 0, showAll: true))
                        }
                    }
                }
            }else if selectedReport.type == RerportType.kProductCategoryReport{
                let categorySale = SQLiteManage.SelectQuery("SELECT SUM(OrderProducts.quantity) as count, sum(OrderProducts.sub_total) as total, OrderProducts.category_id as category_id FROM OrderProducts LEFT JOIN Orders ON OrderProducts.order_id = orders.id WHERE Orders.delivery_date >= \(startDate) AND Orders.isDelete == 0 AND OrderProducts.isDelete == 0 AND Orders.order_status_id != 10 AND Orders.delivery_date < \(endDate) \(archieve) GROUP BY OrderProducts.category_id")
                if categorySale.count > 0{
                    for type in categorySale{
                        if let value = type["total"], value != ""{
                            if let category = CoreDataHelper.shared.fetchCategoryById(id: Int(type["category_id"] ?? "") ?? 0), let name = category.name{
                                self.arrReports.append(ReportModel.init(status: name, total: Double(value) ?? 0, count: Int(type["count"] ?? "") ?? 0, showAll: true))
                            }
                        }
                    }
                }
            }else if selectedReport.type == RerportType.kFullReport{
                if let product = SQLiteManage.SelectQuery("SELECT SUM(OrderProducts.quantity) as total_product, SUM(OrderProducts.sub_total) as value_product from  OrderProducts LEFT JOIN Orders ON Orders.id = OrderProducts.order_id WHERE Orders.delivery_date >= \(startDate) AND Orders.isDelete == 0 AND OrderProducts.isDelete == 0 AND Orders.delivery_date < \(endDate) \(userConditionString) \(archieve)").first{
                    if (Double(product["value_product"] ?? "") ?? 0 > 0 && AppConstants.userData?.permissions?.ordersAmountProduct?.actions?.list ?? 0 == 1){
                        self.arrReports.append(ReportModel.init(status: "Product Sale", total: Double(product["value_product"] ?? ""), count: Int(product["total_product"] ?? ""), showAll: true))
                    }
                }
                if let order = SQLiteManage.SelectQuery("SELECT sum(no_guest) as no_diner,count(*) as no_order,sum(discount) as discount,sum(gratuity) as gratuity,sum(service_charge) as service_charge, (SELECT  count(*) FROM Orders WHERE table_id != 0 AND delivery_date >= \(startDate) AND delivery_date < \(endDate) \(userConditionStringNoJoin) \(archieve) AND Orders.isDelete == 0) as total_table FROM Orders WHERE delivery_date >= \(startDate) AND delivery_date < \(endDate) \(userConditionStringNoJoin) \(archieve) AND Orders.isDelete == 0").first{
                    if (Int(order["no_order"] ?? "") ?? 0 > 0 && AppConstants.userData?.permissions?.orderCount?.actions?.list ?? 0 == 1){
                        self.arrReports.insert(ReportModel.init(status: "Total Orders", count: Int(order["no_order"] ?? ""), rowType: 1), at: 0)
                    }
                    if (Double(order["discount"] ?? "") ?? 0 > 0 && AppConstants.userData?.permissions?.totalDiscount?.actions?.list ?? 0 == 1){
                        self.arrReports.append(ReportModel.init(status: "Total Discount", total: Double(order["discount"] ?? "")))
                    }
                    if let order = SQLiteManage.SelectQuery("SELECT COUNT(*) AS count, SUM(OrderPayment.amount) AS total, PaymentMethods.name AS name FROM PaymentMethods LEFT JOIN OrderPayment ON PaymentMethods.id = OrderPayment.payment_method_id LEFT JOIN Orders ON Orders.id = OrderPayment.order_id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) AND Orders.isDelete = 0 \(userConditionString) AND PaymentMethods.id == 5 \(archieve) GROUP BY OrderPayment.payment_method_id, PaymentMethods.name").first{
                        if (Double(order["total"] ?? "") ?? 0 > 0 && AppConstants.userData?.permissions?.vouchers?.actions?.list ?? 0 == 1){
                            self.arrReports.append(ReportModel.init(status: "Total Vouchers", total: Double(order["total"] ?? ""), count: Int(order["count"] ?? ""), showAll: true))
                        }
                    }
                    
                    
                    if (Int(order["no_diner"] ?? "") ?? 0 > 0 && AppConstants.userData?.permissions?.totalNoGuest?.actions?.list ?? 0 == 1){
                        self.arrReports.append(ReportModel.init(status: "Total Dinners", count: Int(order["no_diner"] ?? ""), rowType: 1))
                    }
                    if (Int(order["total_table"] ?? "") ?? 0 > 0 && AppConstants.userData?.permissions?.totalNoTable?.actions?.list ?? 0 == 1){
                        self.arrReports.append(ReportModel.init(status: "Total Tables", count: Int(order["total_table"] ?? ""), rowType: 1))
                    }
                    if Double(order["gratuity"] ?? "") ?? 0 > 0{
                        self.arrReports.append(ReportModel.init(status: "Total Gratuity", total: Double(order["gratuity"] ?? "")))
                    }
                    if Double(order["service_charge"] ?? "") ?? 0 > 0{
                        self.arrReports.append(ReportModel.init(status: "Total Service Charge", total: Double(order["service_charge"] ?? "")))
                    }
                }
                
                
                if let order = SQLiteManage.SelectQuery("SELECT SUM(OrderProducts.price) AS item_price, SUM(OrderProducts.quantity) AS item_quantity FROM OrderProducts JOIN Orders ON OrderProducts.order_id = Orders.id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) \(userConditionString) \(archieve) AND Orders.isDelete == 0 AND OrderProducts.isDelete == 1").first{
                    if Double(order["item_price"] ?? "") ?? 0 > 0{
                        self.arrReports.append(ReportModel.init(status: "Total deleted items", total: Double(order["item_price"] ?? ""), count: Int(order["item_quantity"] ?? ""), showAll: true))
                    }
                }
                
                
                if self.reportData != nil{
                    self.arrReports.append(ReportModel.init(status: "Online orders", total:0, count: 0, rowType: 2))
                    self.arrReports.append(ReportModel.init(status: "iOS", total: self.reportData?.iOSOnlineOrder?.first?.total ?? 0, count: self.reportData?.iOSOnlineOrder?.first?.count ?? 0, showAll: true))
                    self.arrReports.append(ReportModel.init(status: "Android", total: self.reportData?.androidOnlineOrder?.first?.total ?? 0, count: self.reportData?.androidOnlineOrder?.first?.count ?? 0, showAll: true))
                    self.arrReports.append(ReportModel.init(status: "Web", total: self.reportData?.webOnlineOrder?.first?.total ?? 0, count: self.reportData?.webOnlineOrder?.first?.count ?? 0, showAll: true))
                }
                
                if AppConstants.userData?.permissions?.orderTypeWise?.actions?.list ?? 0 == 1{
                    let orderType = SQLiteManage.SelectQuery("SELECT COUNT(*) as count,sum(total) as total, OrderTypes.type as type FROM OrderTypes LEFT JOIN Orders ON OrderTypes.id = Orders.order_type_id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) AND Orders.isDelete == 0 \(userConditionString) \(archieve) GROUP BY orders.order_type_id")
                    if orderType.count > 0{
                        self.arrReports.append(ReportModel.init(status: "Order Type", total:0, count: 0, rowType: 2))
                        for type in orderType{
                            if let value = type["total"], value != ""{
                                self.arrReports.append(ReportModel.init(status: "\(type["type"] ?? "")", total: Double(value) ?? 0, count: Int(type["count"] ?? ""), showAll: true))
                            }
                        }
                    }
                }
                
                if AppConstants.userData?.permissions?.orderStatusWise?.actions?.list ?? 0 == 1{
                    let orderStatus = SQLiteManage.SelectQuery("SELECT COUNT(*) as count,sum(total) as total, OrderStatus.status as status FROM OrderStatus LEFT JOIN Orders ON OrderStatus.id = orders.order_status_id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) AND Orders.isDelete == 0 \(userConditionString) \(archieve) GROUP BY orders.order_status_id")
                    if orderStatus.count > 0{
                        self.arrReports.append(ReportModel.init(status: "Order Status", total:0, count: 0, rowType: 2))
                        for type in orderStatus{
                            if let value = type["total"], value != ""{
                                self.arrReports.append(ReportModel.init(status: "\(type["status"] ?? "")", total: Double(value) ?? 0, count: Int(type["count"] ?? ""), showAll: true))
                            }
                        }
                    }
                }
                
                var totalCash = 0.0
                var totalCard = 0.0
                var totalCardManual = 0.0
                var totalCardMoto = 0.0
                var totalCheque = 0.0
                
                if AppConstants.userData?.permissions?.orderPaymentWise?.actions?.list ?? 0 == 1{
                    let orderPayment = SQLiteManage.SelectQuery("SELECT COUNT(*) AS count, SUM(OrderPayment.amount) AS total, PaymentMethods.name AS name FROM PaymentMethods LEFT JOIN OrderPayment ON PaymentMethods.id = OrderPayment.payment_method_id LEFT JOIN Orders ON Orders.id = OrderPayment.order_id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) AND Orders.isDelete = 0  AND Orders.order_status_id != 10 \(userConditionString) AND PaymentMethods.id != 5 \(archieve) GROUP BY OrderPayment.payment_method_id, PaymentMethods.name")
                    if orderPayment.count > 0{
                        self.arrReports.append(ReportModel.init(status: "Payment Wise", total:0, count: 0, rowType: 2))
                        for type in orderPayment{
                            if let value = type["total"], value != ""{
                                if type["name"] ?? "" == "Cash"{
                                    totalCash += (Double(value) ?? 0)
                                }else if type["name"] ?? "" == "Credit Card TT"{
                                    totalCard += (Double(value) ?? 0)
                                }else if type["name"] ?? "" == "Cheque"{
                                    totalCheque += (Double(value) ?? 0)
                                }else if type["name"] ?? "" == "Credit Card Moto"{
                                    totalCardMoto += (Double(value) ?? 0)
                                }else if type["name"] ?? "" == "Credit Card Manual"{
                                    totalCardManual += (Double(value) ?? 0)
                                }
                                self.arrReports.append(ReportModel.init(status: "\(type["name"] ?? "")", total: Double(type["total"] ?? ""), count: Int(type["count"] ?? "") ?? 0, rowType: 1, showAll: true))
                            }
                        }
                    }
                }
                
                if totalCash > 0 || totalCard > 0 || totalCheque > 0 || totalCardManual > 0 || totalCardMoto > 0{
                    self.arrReports.append(ReportModel.init(status: "Grand total", total:0, count: 0, rowType: 2))
                    if totalCard > 0{
                        self.arrReports.append(ReportModel.init(status: "Total Card", total: totalCard, showAll: true))
                    }
                    if totalCash > 0{
                        self.arrReports.append(ReportModel.init(status: "Total Cash", total: totalCash, showAll: true))
                    }
                    if totalCardMoto > 0{
                        self.arrReports.append(ReportModel.init(status: "Total Card Moto", total: totalCardMoto, showAll: true))
                    }
                    if totalCardManual > 0{
                        self.arrReports.append(ReportModel.init(status: "Total Card Manual", total: totalCardManual, showAll: true))
                    }
                    if totalCheque > 0{
                        self.arrReports.append(ReportModel.init(status: "Total Cheque", total: totalCheque, showAll: true))
                    }
                    self.arrReports.append(ReportModel.init(status: "Total", total: totalCash + totalCard + totalCheque + totalCardMoto + totalCardManual, showAll: true))
                }
            }else{
                self.arrReports.append(ReportModel.init(status: "Sales(All Order Types)", total:0, count: 0, rowType: 2))
                if let order = SQLiteManage.SelectQuery("SELECT count(*) as no_order, sum(discount) as discount, sum(gratuity) as gratuity,sum(service_charge) as service_charge, sum(total) as total FROM Orders WHERE delivery_date >= \(startDate) AND delivery_date < \(endDate) \(userConditionStringNoJoin) \(archieve) AND Orders.isDelete == 0").first{
                    self.arrReports.append(ReportModel.init(status: "Gross Sales", total: Double(order["total"] ?? ""), count: Int(order["no_order"] ?? "") ?? 0, showAll: true))
                    self.arrReports.append(ReportModel.init(status: "Discount", total: Double(order["discount"] ?? ""), count: 0, showAll: true))
                    self.arrReports.append(ReportModel.init(status: "Tips", total: Double(order["gratuity"] ?? ""), count: 0, showAll: true))
                    self.arrReports.append(ReportModel.init(status: "Service Charge", total: Double(order["service_charge"] ?? ""), count: 0, showAll: true))
                }
                if let order = SQLiteManage.SelectQuery("SELECT count(*) as count, sum(total) as total FROM Orders WHERE delivery_date >= \(startDate) AND delivery_date < \(endDate) \(userConditionStringNoJoin) \(archieve) AND Orders.isDelete == 0 AND Orders.order_status_id == 10").first{
                    self.arrReports.insert(ReportModel.init(status: "Cancelled Sales", total: Double(order["total"] ?? ""), count: Int(order["count"] ?? "") ?? 0, showAll: true), at: 2)
                    
                }
                if let order = SQLiteManage.SelectQuery("SELECT SUM(OrderProducts.price) AS total, SUM(OrderProducts.quantity) AS count FROM OrderProducts JOIN Orders ON OrderProducts.order_id = Orders.id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) \(userConditionString) \(archieve) AND Orders.isDelete == 0 AND Orders.order_status_id == 10").first{
                    self.arrReports.insert(ReportModel.init(status: "Cancelled Items", total: Double(order["total"] ?? ""), count: Int(order["count"] ?? "") ?? 0, showAll: true), at: 3)
                }
                if AppConstants.userData?.permissions?.orderPaymentWise?.actions?.list ?? 0 == 1, let orderPayment = SQLiteManage.SelectQuery("SELECT count(*) as count, SUM(OrderPayment.amount) AS total FROM PaymentMethods LEFT JOIN OrderPayment ON PaymentMethods.id = OrderPayment.payment_method_id LEFT JOIN Orders ON Orders.id = OrderPayment.order_id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) AND Orders.isDelete = 0 \(userConditionString) AND OrderPayment.is_refunded == 1 \(archieve) GROUP BY OrderPayment.payment_method_id").first{
                    self.arrReports.insert(ReportModel.init(status: "Refunds", total: Double(orderPayment["total"] ?? ""), count: Int(orderPayment["count"] ?? "") ?? 0, showAll: true), at: 4)
                }
                let arrOrderType = ["Dine in", "Waiting", "Collection", "Delivery"]
                let arrOrderTypeId = [1,5,2,3]
                for i in 0..<arrOrderType.count{
                    self.arrReports.append(ReportModel.init(status: arrOrderType[i], total:0, count: 0, rowType: 2))
                    if let order = SQLiteManage.SelectQuery("SELECT count(*) as count, sum(discount) as discount, sum(gratuity) as gratuity,sum(service_charge) as service_charge, sum(total) as total FROM Orders WHERE delivery_date >= \(startDate) AND delivery_date < \(endDate) \(userConditionStringNoJoin) \(archieve) AND Orders.isDelete == 0 AND Orders.order_type_id == \(arrOrderTypeId[i])").first{
                        self.arrReports.append(ReportModel.init(status: "Gross Sales", total: Double(order["total"] ?? ""), count: Int(order["count"] ?? "") ?? 0, showAll: true))
                        if let order = SQLiteManage.SelectQuery("SELECT count(*) as count, sum(total) as total FROM Orders WHERE delivery_date >= \(startDate) AND delivery_date < \(endDate) \(userConditionStringNoJoin) \(archieve) AND Orders.isDelete == 0 AND Orders.order_status_id == 10 AND Orders.order_type_id == \(arrOrderTypeId[i])").first{
                            self.arrReports.append(ReportModel.init(status: "Cancelled Sales", total: Double(order["total"] ?? ""), count: Int(order["count"] ?? "") ?? 0, showAll: true))
                            
                        }
                        if let order = SQLiteManage.SelectQuery("SELECT SUM(OrderProducts.price) AS total, SUM(OrderProducts.quantity) AS count FROM OrderProducts JOIN Orders ON OrderProducts.order_id = Orders.id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) \(userConditionString) \(archieve) AND Orders.isDelete == 0 AND Orders.order_status_id == 10 AND Orders.order_type_id == \(arrOrderTypeId[i])").first{
                            self.arrReports.append(ReportModel.init(status: "Cancelled Items", total: Double(order["total"] ?? ""), count: Int(order["count"] ?? "") ?? 0, showAll: true))
                        }
                        if AppConstants.userData?.permissions?.orderPaymentWise?.actions?.list ?? 0 == 1, let orderPayment = SQLiteManage.SelectQuery("SELECT count(*) as count, SUM(OrderPayment.amount) AS total FROM PaymentMethods LEFT JOIN OrderPayment ON PaymentMethods.id = OrderPayment.payment_method_id LEFT JOIN Orders ON Orders.id = OrderPayment.order_id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) AND Orders.isDelete = 0 \(userConditionString) AND OrderPayment.is_refunded == 1 AND Orders.order_type_id == \(arrOrderTypeId[i]) \(archieve) GROUP BY OrderPayment.payment_method_id").first{
                            self.arrReports.append(ReportModel.init(status: "Refunds", total: Double(orderPayment["total"] ?? ""), count: Int(orderPayment["count"] ?? "") ?? 0, showAll: true))
                        }
                        self.arrReports.append(ReportModel.init(status: "Discount", total: Double(order["discount"] ?? ""), count: 0, showAll: true))
                        self.arrReports.append(ReportModel.init(status: "Tips", total: Double(order["gratuity"] ?? ""), count: 0, showAll: true))
                        self.arrReports.append(ReportModel.init(status: "Service Charge", total: Double(order["service_charge"] ?? ""), count: 0, showAll: true))
                    }
                }
                if let dict{
                    if let order = dict["online_order"] as? NSDictionary{
                        self.arrReports.append(ReportModel.init(status: "Online Orders", total:0, count: 0, rowType: 2))
                        if let data = order["gross_sales"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Gross Sales", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                        }
                        if let data = order["completed_orders"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Completed Orders", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                        }
                        if let data = order["rejected_orders"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Rejected Orders", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                        }
                        if let data = order["ios_orders"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "iOS", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                        }
                        if let data = order["android_orders"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Android", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                        }
                        if let data = order["web_orders"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Web", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                        }
                        if let data = order["refunds"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Refunds", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                        }
                        if let data = order["tips"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Tip", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                        }
                        if let data = order["service_charges"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Service Charge", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                        }
                    }
                    if let order = dict["payment_type"] as? NSDictionary{
                        self.arrReports.append(ReportModel.init(status: "Payment Type", total:0, count: 0, rowType: 2))
                        var totalValue = 0.0
                        var total = 0
                        if let data = order["total_card"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Total Card", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                            total += (data.getIntValue("count") ?? 0)
                            totalValue += (data.getDoubleValue("value") ?? 0)
                        }
                        if let data = order["total_payment_link"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Total Payment Link", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                            total += (data.getIntValue("count") ?? 0)
                            totalValue += (data.getDoubleValue("value") ?? 0)
                        }
                        if let data = order["total_moto"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Total Moto", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                            total += (data.getIntValue("count") ?? 0)
                            totalValue += (data.getDoubleValue("value") ?? 0)
                        }
                        if let data = order["total_manual_card"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Total Manual Card", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                            total += (data.getIntValue("count") ?? 0)
                            totalValue += (data.getDoubleValue("value") ?? 0)
                        }
                        if let data = order["total_cash"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Total Cash", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                            total += (data.getIntValue("count") ?? 0)
                            totalValue += (data.getDoubleValue("value") ?? 0)
                        }
                        if let data = order["external_payments"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Total External Payment", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                            total += (data.getIntValue("count") ?? 0)
                            totalValue += (data.getDoubleValue("value") ?? 0)
                        }
                        if let data = order["total_refund"] as? NSDictionary{
                            self.arrReports.append(ReportModel.init(status: "Total Refunds", total: data.getDoubleValue("value"), count: data.getIntValue("count"), showAll: true))
                            total += (data.getIntValue("count") ?? 0)
                            totalValue += (data.getDoubleValue("value") ?? 0)
                        }
                        self.arrReports.append(ReportModel.init(status: "Total", total: totalValue, count: total, showAll: true))
                    }
                }
            }
        }
    }
    
    //MARK: WebService Methods
    func FetchFullReport()  {
        if selectedReport.type == RerportType.kProductSaleReport || selectedReport.type == RerportType.kProductCategoryReport{
            self.setReportData()
            self.tblReport.reloadData()
        }else{
            self.setReportData()
            self.tblReport.reloadData()
            var dictParam = [String:Any]()
            dictParam["from_date"] = fromDate.getDateInString(format: "yyyy-MM-dd")
            dictParam["to_date"] = toDate.getDateInString(format: "yyyy-MM-dd")
            if selectedUser != nil{
                dictParam["user_id"] = selectedUser.id ?? 0
            }
            dictParam["archived"] = "0"
            var strURL = AppConstants.APIURL.kFullReport
            if selectedReport.type == RerportType.ZReport{
                strURL = AppConstants.APIURL.kZReport
            }else if selectedReport.type == RerportType.FullReportBeta{
                strURL = AppConstants.APIURL.kFullReportBeta
            }else if selectedReport.type == RerportType.kOnlineOrderReport{
                strURL = AppConstants.APIURL.kOnlineOrderReport
            }else if selectedReport.type == RerportType.kFullArchivedReport{
                dictParam["archived"] = "1"
            }
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "GET") { (message, result) in
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    self.arrReports.removeAll()
                    let jsonDecoder = JSONDecoder()
                    var data:NSDictionary?
                    if let response = result as? NSDictionary{
                        if let data = AppCommonMethods.convertToJson(object: response){
                            if let aData = try? jsonDecoder.decode(FullReportModel.self, from: data){
                                self.reportData = aData
                            }
                        }
                        data = response
                    }
                    self.setReportData(dict: data)
                    self.tblReport.reloadData()
                }
            }
        }
        
    }
    
}

//MARK: UITableViewDataSource
extension FullReportVC:UITableViewDataSource,UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if tableView == tblUserList{
            return arrUsers.count
        }
        return arrReports.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if tableView == tblUserList{
            let cell = tableView.dequeueReusableCell(withIdentifier: "UserDropdownCell", for: indexPath) as! UserDropdownCell
            cell.lblUserName.text = arrUsers[indexPath.row].username ?? ""
            return cell
        }
        let cell = tableView.dequeueReusableCell(withIdentifier: "ReportDetailViewCell", for: indexPath) as! ReportDetailViewCell
        let model = arrReports[indexPath.row]
        cell.lblType.text = model.status ?? ""
        cell.lblQuantity.isHidden = true
        cell.lblValue.isHidden = true
        cell.lblType.isHidden = false
        cell.lblQuantity.font = AppConstants.GlobalFontConstants.kBoldFont(size: 14)
        if selectedReport.type == RerportType.kProductSaleReport || selectedReport.type == RerportType.kProductCategoryReport || selectedReport.type == RerportType.FullReportBeta{
            cell.lblQuantity.isHidden = false
            cell.lblValue.isHidden = false
            cell.lblValue.text = String.init(format: "%.2f", model.total ?? 0)
            cell.lblQuantity.text = String.init(format: "%d", model.count ?? 0)
        }else{
            if model.rowType == 2{
                cell.lblQuantity.isHidden = false
                cell.lblType.isHidden = true
                cell.lblQuantity.text = model.status ?? ""
                cell.lblQuantity.font = AppConstants.GlobalFontConstants.kBoldFont(size: 17)
            }else if model.rowType == 1{
                cell.lblValue.isHidden = false
                cell.lblValue.text = String.init(format: "%d", model.count ?? 0)
            }else{
                cell.lblValue.isHidden = false
                cell.lblValue.text = String.init(format: "%.2f", model.total ?? 0)
            }
        }
        cell.lblQuantity.textAlignment = .center
        if selectedReport.type == RerportType.FullReportBeta{
            if model.rowType == 2{
                cell.lblQuantity.isHidden = false
                cell.lblType.isHidden = true
                cell.lblValue.isHidden = true
                cell.lblQuantity.text = model.status ?? ""
                cell.lblQuantity.font = AppConstants.GlobalFontConstants.kBoldFont(size: 17)
            }else{
                cell.lblQuantity.textAlignment = .right
            }
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if tableView == tblUserList{
            selectedUser = arrUsers[indexPath.row]
            lblSlectedUser.text = selectedUser.username ?? ""
            constTblHeight.constant = 0
            self.FetchFullReport()
            UIView.animate(withDuration: 0.25) {
                self.view.layoutIfNeeded()
            }
        }
    }
}

//MARK: UITextFieldDelegate
extension FullReportVC:UITextFieldDelegate{
    func textFieldShouldBeginEditing(_ textField: UITextField) -> Bool {
        if textField == txtToDate{
            let datePicker = ActionSheetDatePicker(title: "Select Date", datePickerMode: UIDatePicker.Mode.date, selectedDate: toDate, doneBlock: {
                picker, value, index in
                self.toDate = (value as! Date)
                if self.fromDate > self.toDate{
                    self.fromDate = self.toDate
                }
                self.txtToDate.text = "To - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
                self.txtFromDate.text = "From - \(self.fromDate.getDateInString(format: "dd/MM/yyyy"))"
                self.FetchFullReport()
                self.lblDateRange.text = "\(self.fromDate.getDateInString(format: "dd/MM/yyyy")) - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
            }, cancel: { ActionStringCancelBlock in return }, origin: textField)
            datePicker?.minimumDate = self.fromDate
            datePicker?.show()
            return false
        }else{
            let datePicker = ActionSheetDatePicker(title: "Select Date", datePickerMode: UIDatePicker.Mode.date, selectedDate: fromDate, doneBlock: {
                picker, value, index in
                self.fromDate = (value as! Date)
                if self.toDate < self.fromDate{
                    self.toDate = self.fromDate
                }
                self.txtToDate.text = "To - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
                self.txtFromDate.text = "From - \(self.fromDate.getDateInString(format: "dd/MM/yyyy"))"
                self.FetchFullReport()
                self.lblDateRange.text = "\(self.fromDate.getDateInString(format: "dd/MM/yyyy")) - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
            }, cancel: { ActionStringCancelBlock in return }, origin: textField)
            datePicker?.maximumDate = self.toDate
            datePicker?.show()
            return false
        }
    }
}

extension FullReportVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            var dictParam = [String:Any]()
            dictParam["from_date"] = fromDate.getDateInString(format: "yyyy-MM-dd")
            dictParam["to_date"] = toDate.getDateInString(format: "yyyy-MM-dd")
            dictParam["email"] = data.value
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kSendReport)/\(AppConstants.businessData?.id ?? 0)", method: "POST") { (message, result) in
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    if let response = result as? NSDictionary, let message = response.getStringValue("message"){
                        var settings = BottomAlertSettings()
                        settings.strMessage = message
                        AppValidation().showBottomAlertView(settings: settings)
                    }
                }
            }
        }
    }
}
