//
//  MotoPaymentVC.swift
//  EPOS
//
//  Created by Apple on 29/05/21.
//

import UIKit
import FormTextField
import Stripe

class MotoPaymentVC: UIViewController {
    
    //MARK: IBOutlet
    @IBOutlet weak var txtCardNumber:FormTextField!
    @IBOutlet weak var txtExpDate:FormTextField!
    @IBOutlet weak var txtCVV:FormTextField!
    @IBOutlet weak var txtCardAmount:UITextField!
    @IBOutlet weak var txtTipAmount:UITextField!
    @IBOutlet weak var txtCardHolderName:UITextField!
    @IBOutlet weak var viewForTip:UIStackView!
    
    //MARK: Instances
    weak var parentVC:PaymentMainVC!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        txtCardAmount.text = "\(AppConstants.currencySign)0.00"
        txtTipAmount.text = "\(AppConstants.currencySign)0.00"
        setCardNumberField()
        setCVVField()
        setExpDateField()
        if AppConstants.businessData?.tip ?? 0 == 0{
            viewForTip.isHidden = true
        }
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:PaymentMainVC)->MotoPaymentVC?{
        guard let VC = UIStoryboard.init(name: "Payments", bundle: nil).instantiateViewController(withIdentifier: "MotoPaymentVC") as? MotoPaymentVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 10, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height-20)
        return VC
    }
    
    //MARK: General Methods
    func checkMotoValidation()->Bool{
        let strAmount = (txtCardAmount.text ?? "").replacingOccurrences(of: AppConstants.currencySign, with: "")
        if (txtCardNumber.text?.trimmingCharacters(in: .whitespaces).isEmpty ?? false){
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_EMPTY_CARDNO, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }else if !txtCardNumber.validate(){
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_VALID_CARDNO, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }else if (txtExpDate.text?.trimmingCharacters(in: .whitespaces).isEmpty ?? false){
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_EMPTY_EXPIRYDATE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }else if !txtExpDate.validate(){
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_VALID_EXPIRYDATE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }else if (txtCVV.text?.trimmingCharacters(in: .whitespaces).isEmpty ?? false){
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_EMPTY_CVV, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }else if !txtCVV.validate(){
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_VALID_CVV, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }else if Double(strAmount) ?? 0 < 0.5{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "Amount can not be less than 0.5", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }
        return true
    }
    
    func printDelineTransaction(){
        print("Printer IP:", AppConstants.selectedPrinter?.ip ?? "")
        if AppConstants.selectedPrinter != nil{
            let amount = Double((txtCardAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
            let tipAmount = Double((txtTipAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
            PrintManager.shared.isCustomerCopy = false
            PrintManager.shared.amount = amount
            PrintManager.shared.tipAmount = tipAmount
            PrintManager.shared.status = "Declined"
            PrintManager.shared.entryMode = "MOTO"
            PrintManager.shared.isReprint = false
            PrintManager.shared.connectToPrinterWithPrint(model: AppConstants.businessData!, controller: self)
        }
        playDeclineSound()
    }
    
    func playDeclineSound(){
        CustomAudioPlayer.shared.preparePlayer(soundName: "decline_sound")
        var settings = AlertSetting()
        settings.alertAnimation = "payment_failed"
        settings.confirmTitle = AppConstants.GlobalAlert.ALERT_BTN_OK
        settings.cancelTitle = ""
        if let _ = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: settings){
            
        }
    }
    
    //MARK:FormTextField Method
    func setCardNumberField(){
        var validation = Validation()
        validation.maximumLength = "1234 5678 1234 5678".count
        validation.minimumLength = "1234 5678 1234".count
        let characterSet = NSMutableCharacterSet.decimalDigit()
        characterSet.addCharacters(in: " ")
        validation.characterSet = characterSet as CharacterSet
        let inputValidator = InputValidator(validation: validation)
        txtCardNumber.inputValidator = inputValidator
        txtCardNumber.inputType = .integer
        txtCardNumber.formatter = CardNumberFormatter()
    }
    
    func setCVVField(){
        var validation = Validation()
        validation.maximumLength = "CVC2".count
        validation.minimumLength = "CVC".count
        validation.characterSet = NSCharacterSet.decimalDigits
        let inputValidator = InputValidator(validation: validation)
        txtCVV.inputValidator = inputValidator
        txtCVV.inputType = .integer
    }
    
    func setExpDateField(){
        var validation = Validation()
        validation.maximumLength = "02/20".count
        validation.minimumLength = "02/20".count
        let inputValidator = InputValidator(validation: validation)
        txtExpDate.inputValidator = inputValidator
        txtExpDate.formatter = CardExpirationDateFormatter()
        txtExpDate.inputType = .integer
    }
    
    func CalculateAppFee(stpCard:STPPaymentMethodCard?)->Double{
        var appFee = 0.0
        var cardBrand:CardBrandModel?
        var cardBrandComission:CardBrandComissionModel?
        var countryComission:CountryComissionModel?
        let amount = Double((txtCardAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
        if let card = stpCard{
            let brand = STPCardBrandUtilities.stringFrom(card.brand) ?? ""
            cardBrand = AppConstants.cardBrands?.filter({ model in
                return (model.code ?? "").lowercased() == brand.lowercased()
            }).first
            countryComission = AppConstants.countryComissions?.filter({ model in
                return (model.country?.iso ?? "").lowercased() == (card.country ?? "").lowercased()
            }).first
        }
        if cardBrand != nil{
            cardBrandComission = AppConstants.cardBrandComissions?.filter({ model in
                return model.cardBrandId ?? 0 == cardBrand!.id ?? 0
            }).first
        }
        if cardBrandComission == nil{
            cardBrandComission = AppConstants.cardBrandComissions?.filter({ model in
                return model.other ?? 0 == 1
            }).first
        }
        if cardBrandComission != nil{
            appFee = cardBrandComission!.stripeFixed ?? 0
            appFee += (amount * (cardBrandComission?.stripePercentage ?? 0)/100)
        }
        if countryComission == nil{
            countryComission = AppConstants.countryComissions?.filter({ model in
                return model.other ?? 0 == 1
            }).first
        }
        if countryComission != nil{
            appFee += (countryComission!.stripeFixed ?? 0)
            appFee += (amount * (countryComission?.stripePercentage ?? 0)/100)
        }
        let authFee = AppConstants.businessData?.businessCommissions?.connecCardAuthFee ?? 0
        if (AppConstants.businessData?.businessCommissions?.connectCardAuthFeeType ?? "").lowercased() == "flat"{
            appFee += authFee
        }else if (AppConstants.businessData?.businessCommissions?.connectCardAuthFeeType ?? "").lowercased() == "percentage"{
            appFee += (amount * authFee/100)
        }
        let procssingFee = AppConstants.businessData?.businessCommissions?.connecCardProcessingFee ?? 0
        if (AppConstants.businessData?.businessCommissions?.connectCardProcessingFeeType ?? "").lowercased() == "flat"{
            appFee += procssingFee
        }else if (AppConstants.businessData?.businessCommissions?.connectCardProcessingFeeType ?? "").lowercased() == "percentage"{
            appFee += (amount * procssingFee/100)
        }
        return appFee
    }
    
    //MARK: Button Actions
    @IBAction func btnPayNowAction(_ sender:UIButton){
        self.view.endEditing(true)
        if checkMotoValidation(){
            CreateStripePaymentMethod()
        }
    }
    
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.view.endEditing(true)
        self.txtCardAmount.text = "\(AppConstants.currencySign)0.00"
        self.txtTipAmount.text = "\(AppConstants.currencySign)0.00"
        self.txtCVV.reset()
        self.txtExpDate.reset()
        self.txtCardNumber.reset()
        self.txtCardHolderName.text = ""
    }
    
    //MARK: WebService Mathods
    func CreateStripePaymentMethod(){
        AppCommonMethods.startProgressBar()
        PrintManager.shared.cardBrand = ""
        PrintManager.shared.cardNumber = ""
        if AppConstants.businessData?.connectService ?? 0 == 1{
            let cardParam = STPPaymentMethodCardParams.init()
            cardParam.number = txtCardNumber.text ?? ""
            cardParam.expMonth = NSNumber.init(integerLiteral: Int((txtExpDate.text ?? "").components(separatedBy: "/").first ?? "") ?? 0)
            cardParam.expYear = NSNumber.init(integerLiteral: Int((txtExpDate.text ?? "").components(separatedBy: "/").last ?? "") ?? 0)
            cardParam.cvc = txtCVV.text ?? ""
            
            let paymentMethodParams = STPPaymentMethodParams(card: cardParam, billingDetails: nil, metadata: nil)
            
            STPAPIClient.shared.createPaymentMethod(with: paymentMethodParams) { (method, error) in
                if error != nil {
                    print(error!.localizedDescription)
                    self.playDeclineSound()
                    AppCommonMethods.stopProgressBar()
                }else{
                    if let id = method?.stripeId{
                        if let card = method?.card{
                            PrintManager.shared.cardBrand = STPCardBrandUtilities.stringFrom(card.brand) ?? ""
                            PrintManager.shared.cardNumber = card.last4 ?? ""
                        }
                        self.CreateStripeIntent(method: id, appFee: Int(self.CalculateAppFee(stpCard: method?.card) * 100))
                    }else{
                        self.playDeclineSound()
                        AppCommonMethods.stopProgressBar()
                    }
                }
            }
        }else{
            let cardParam = STPCardParams()
            cardParam.number = txtCardNumber.text ?? ""
            cardParam.expMonth = UInt((txtExpDate.text ?? "").components(separatedBy: "/").first ?? "") ?? 0
            cardParam.expYear = UInt((txtExpDate.text ?? "").components(separatedBy: "/").last ?? "") ?? 0
            cardParam.cvc = txtCVV.text ?? ""
            
            STPAPIClient.shared.createToken(withCard: cardParam) { (token, error) in
                if error != nil {
                    print(error!.localizedDescription)
                    self.playDeclineSound()
                    AppCommonMethods.stopProgressBar()
                }else{
                    if let card = token?.card{
                        PrintManager.shared.cardBrand = STPCardBrandUtilities.stringFrom(card.brand) ?? ""
                        PrintManager.shared.cardNumber = card.last4
                    }
                    self.CreateStripePayment(token: token?.tokenId ?? "")
                }
            }
        }
    }
    
    func CreateStripePayment(token:String){
        var dictParam = [String:Any]()
        let amount = Double((txtCardAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
        let tipAmount = Double((txtTipAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
        
        dictParam["amount"] = Int((amount+tipAmount)*100)
        dictParam["currency"] = AppConstants.businessData?.country?.currencyCode ?? ""
        dictParam["source"] = token
        dictParam["description"] = AppConstants.businessData?.statementDescription ?? ""
        dictParam["statement_descriptor_suffix"] = AppConstants.businessData?.statementDescriptor ?? ""
        
        WebServiceManager().postAPIForStripe(params: dictParam, urlString: AppConstants.APIURL.kStripeChargeAPI) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                var aMSG = message
                if AppConstants.isInDevlopmentMode{
                    print("Stripe Response:",response ?? "")
                }
                if let result = response as? NSDictionary{
                    if let error = result.getStringFromPath("error.message"){
                        aMSG = error
                    }
                    
                    if let id = result.getStringValue("id"){
                        let amount = Double((self.txtCardAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
                        let tipAmount = Double((self.txtTipAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
                        CustomAudioPlayer.shared.preparePlayer(soundName: "payment_approval_sound")
                        self.txtCardAmount.text = "\(AppConstants.currencySign)0.00"
                        self.txtTipAmount.text = "\(AppConstants.currencySign)0.00"
                        self.txtCVV.reset()
                        self.txtExpDate.reset()
                        self.txtCardNumber.reset()
                        self.txtCardHolderName.text = ""
                        var settings = AlertSetting()
                        settings.alertAnimation = "payment_successful"
                        settings.confirmTitle = AppConstants.GlobalAlert.ALERT_BTN_OK
                        settings.cancelTitle = ""
                        if let _ = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: settings){
                            
                        }
                        PrintManager.shared.isCustomerCopy = false
                        PrintManager.shared.TID = id
                        PrintManager.shared.amount = amount
                        PrintManager.shared.tipAmount = tipAmount
                        PrintManager.shared.status = "Approved"
                        PrintManager.shared.entryMode = "MOTO"
                        PrintManager.shared.isReprint = false
                        PrintManager.shared.connectToPrinterWithPrint(model: AppConstants.businessData!, controller: self)
                        return
                    }
                }
                self.printDelineTransaction()
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: aMSG, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
    
    func CreateStripeIntent(method:String, appFee:Int){
        var dictParam = [String:Any]()
        let amount = (Double((txtCardAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0) + (Double((txtTipAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0)
        
        dictParam["amount"] = Int(amount*100)
        dictParam["currency"] = AppConstants.businessData?.country?.currencyCode ?? ""
        dictParam["capture_method"] = "automatic"
//        dictParam["confirmation_method"] = "automatic"
        
        dictParam["payment_method"] = method
        dictParam["description"] = AppConstants.businessData?.statementDescription ?? ""
        dictParam["statement_descriptor_suffix"] = AppConstants.businessData?.statementDescriptor ?? ""
        dictParam["transfer_data[destination]"] = AppConstants.businessData?.sAccountId ?? ""
        dictParam["application_fee_amount"] = appFee
        dictParam["automatic_payment_methods[enabled]"] = "true"
        dictParam["automatic_payment_methods[allow_redirects]"] = "never"
        
        WebServiceManager().postAPIForStripe(params: dictParam, urlString: AppConstants.APIURL.kConfirmIntentAPI) { (message, response) in
            DispatchQueue.main.async {
                if AppConstants.isInDevlopmentMode{
                    print("Intent Response:",response ?? "")
                }
                if let result = response as? NSDictionary{
                    if let id = result.getStringValue("id"), let method = result.getStringValue("payment_method"){
                        self.confirmPaymentIntent(intentId: id, methodId: method)
                        return
                    }
                }
                self.printDelineTransaction()
            }
        }
    }
    
    func confirmPaymentIntent(intentId:String, methodId:String){
        var dictParam = [String:Any]()
        dictParam["payment_method"] = methodId
        WebServiceManager().postAPIForStripe(params: dictParam, urlString: "\(AppConstants.APIURL.kConfirmIntentAPI)/\(intentId)/confirm") { message, response in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let result = response as? NSDictionary{
                    if let id = result.getStringValue("id"), let status = result.getStringValue("status"), status == "succeeded"{
                        let amount = Double((self.txtCardAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
                        let tipAmount = Double((self.txtTipAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign)", with: "")) ?? 0
                        CustomAudioPlayer.shared.preparePlayer(soundName: "payment_approval_sound")
                        self.txtCardAmount.text = "\(AppConstants.currencySign)0.00"
                        self.txtTipAmount.text = "\(AppConstants.currencySign)0.00"
                        self.txtCVV.reset()
                        self.txtExpDate.reset()
                        self.txtCardNumber.reset()
                        self.txtCardHolderName.text = ""
                        var settings = AlertSetting()
                        settings.alertAnimation = "payment_successful"
                        settings.confirmTitle = AppConstants.GlobalAlert.ALERT_BTN_OK
                        settings.cancelTitle = ""
                        if let _ = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: settings){
                            
                        }
                        PrintManager.shared.isCustomerCopy = false
                        PrintManager.shared.TID = id
                        PrintManager.shared.amount = amount
                        PrintManager.shared.tipAmount = tipAmount
                        PrintManager.shared.status = "Approved"
                        PrintManager.shared.entryMode = "MOTO"
                        PrintManager.shared.isReprint = false
                        PrintManager.shared.connectToPrinterWithPrint(model: AppConstants.businessData!, controller: self)
                        return
                    }
                }
                self.printDelineTransaction()
            }
        }
    }
}

//MARK: UITextFieldDelegate
extension MotoPaymentVC:UITextFieldDelegate{
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let allowedCharacters = CharacterSet(charactersIn:"0123456789")
        let characterSet = CharacterSet(charactersIn: string)
        if txtTipAmount == textField || txtCardAmount == textField{
            if allowedCharacters.isSuperset(of: characterSet){
                var strText = (textField.text!).replacingOccurrences(of: AppConstants.currencySign, with: "").replacingOccurrences(of: ".", with: "")
                if string == ""{
                    if strText != "000"{
                        if strText.count == 3{
                            strText.removeLast()
                            strText = "0\(strText)"
                        }else{
                            strText.removeLast()
                        }
                        strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                        textField.text = "\(AppConstants.currencySign)\(strText)"
                    }
                }else{
                    if strText.first! == "0"{
                        strText.removeFirst()
                        strText = "\(strText)\(string)"
                    }else{
                        strText = "\(strText)\(string)"
                    }
                    strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                    textField.text = "\(AppConstants.currencySign)\(strText)"
                }
            }
            return false
        }
        return true
    }
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        return textField.resignFirstResponder()
    }
}
