//
//  AddGratuityVC.swift
//  EPOS
//
//  Created by Apple on 16/04/21.
//

import UIKit

class AddGratuityVC: UIViewController {

    //MARK: IBOutlets
    @IBOutlet weak var txtAmount:UITextField!
    @IBOutlet weak var btnPercetage:UIButton!
    @IBOutlet weak var btnFlatAmount:UIButton!
    @IBOutlet weak var btnApply:UIButton!
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var btnOrderType:UIButton!
    @IBOutlet weak var btnViewTitle:UIButton!
    
    //MARK: Instances
    var amount = 0.0
    var totalAmount = 0.0
    var viewType = GratityViewType.kGratuity
    weak var delegate:AddGratuityDelegate?
    var isPercentageSelected = true
    var parentVC:CreateOrderVC!
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        txtAmount.text = String.init(format: "%.2f", amount)
        if viewType == .kDiscount{
            lblTitle.text = "Discount"
            btnApply.setTitle("Apply Discount", for: .normal)
            btnViewTitle.setTitle(" Discount ", for: .normal)
        }else if viewType == .kServiceCharge{
            btnApply.setTitle("Apply Service Charge", for: .normal)
            lblTitle.text = "Service Charge"
            btnViewTitle.setTitle(" Service Charge ", for: .normal)
        }else if viewType == .kDeliveryCharge{
            btnApply.setTitle("Apply Delivery Charge", for: .normal)
            lblTitle.text = "Delivery Charge"
            btnViewTitle.setTitle(" Delivery Charge ", for: .normal)
        }
        if amount == 0{
            btnApply.isUserInteractionEnabled = false
            btnApply.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        }else{
            isPercentageSelected = false
            btnFlatAmount.setTitleColor(.white, for: .normal)
            btnFlatAmount.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            btnPercetage.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
            btnPercetage.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            btnApply.isUserInteractionEnabled = true
            btnApply.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
        }
        btnOrderType.setTitle(" \(parentVC.orderType?.type ?? "") ", for: .normal)
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:CreateOrderVC, amount:Double, totalAmount:Double, type: GratityViewType = .kGratuity)->AddGratuityVC?{
        for view in parentVC.viewForDiscountContainer.subviews{
            view.removeFromSuperview()
        }
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "AddGratuityVC") as? AddGratuityVC{
            container.amount = amount
            container.totalAmount = totalAmount
            container.parentVC = parentVC
            container.viewType = type
            parentVC.addChild(container)
            parentVC.viewForDiscountContainer.addSubview(container.view)
            
            container.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForDiscountContainer.frame.width, height: parentVC.viewForDiscountContainer.frame.height)
            parentVC.viewForDiscountContainer.alpha = 1.0
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        parentVC.viewForDiscountContainer.alpha = 0.0
        self.view.removeFromSuperview()
        self.removeFromParent()
    }
    
    func setAmountType(){
        if isPercentageSelected{
            btnPercetage.setTitleColor(.white, for: .normal)
            btnPercetage.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            btnFlatAmount.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
            btnFlatAmount.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        }else{
            btnFlatAmount.setTitleColor(.white, for: .normal)
            btnFlatAmount.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            btnPercetage.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
            btnPercetage.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        }
    }
    
    //MARK:  Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.closePopup()
        if delegate != nil{
            delegate?.cancelCliked()
        }
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        var amount = Double(txtAmount.text ?? "") ?? 0
        if isPercentageSelected{
            amount = amount*totalAmount/100
        }
        if amount > self.totalAmount{
            var aMSG = "The discount amount must be less than the total order amount."
            if viewType == .kServiceCharge{
                aMSG = "The service charge must be less than the total order amount."
            }else if viewType == .kDeliveryCharge{
                aMSG = "The delivery charge must be less than the total order amount."
            }else if viewType == .kGratuity{
                aMSG = "The gratuity must be less than the total order amount."
            }
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: aMSG, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
        }else{
            self.closePopup()
            delegate?.amountAdded(amount: amount, type: viewType)
        }
    }
    
    @IBAction func btnAmountTypeAction(_ sender:UIButton){
        isPercentageSelected = (sender.tag == 0)
        setAmountType()
    }
    
    @IBAction func btnNumberPadAction(_ sender:UIButton){
        if sender.tag == 10{
            txtAmount.text = String.init(format: "%.2f", 0)
            btnApply.isUserInteractionEnabled = false
            btnApply.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        }else{
            var strQuantity = txtAmount.text ?? ""
            var strText = (strQuantity).replacingOccurrences(of: ".", with: "")
            if sender.tag == 11{
                if strText != "000"{
                    if strText.count == 3{
                        strText.removeLast()
                        strText = "0\(strText)"
                    }else{
                        strText.removeLast()
                    }
                    strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                    strQuantity = "\(strText)"
                }
            }else{
                let string = "\(sender.tag)"
                if strText.first! == "0"{
                    strText.removeFirst()
                    strText = "\(strText)\(string)"
                }else{
                    strText = "\(strText)\(string)"
                }
                strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                strQuantity = "\(strText)"
            }
            txtAmount.text = strQuantity
            if Double(strQuantity) ?? 0 == 0{
                btnApply.isUserInteractionEnabled = false
                btnApply.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            }else{
                btnApply.isUserInteractionEnabled = true
                btnApply.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
            }
        }
    }
    
    @IBAction func btnPreDefinedNumberAction(_ sender:UIButton){
        let amount = Double(txtAmount.text ?? "") ?? 0
        txtAmount.text = String.init(format: "%.2f", amount + Double(sender.tag))
        btnApply.isUserInteractionEnabled = true
        btnApply.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
    }
}
