//
//  ApplyVoucherVC.swift
//  EPOS
//
//  Created by Apple on 06/08/21.
//

import UIKit

class ApplyVoucherVC: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var txtVoucherCode:UITextField!
    @IBOutlet weak var btnConfirm:UIButton!
    @IBOutlet weak var btnOrderType:UIButton!
    
    //MARK:  Instances
    weak var delegate:AlertControllerDelegate?
    var parentVC:CreateOrderVC!
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        btnOrderType.setTitle(" \(parentVC.orderType?.type ?? "") ", for: .normal)
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:CreateOrderVC)->ApplyVoucherVC?{
        for view in parentVC.viewForDiscountContainer.subviews{
            view.removeFromSuperview()
        }
        
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "ApplyVoucherVC") as? ApplyVoucherVC{
            container.parentVC = parentVC
            parentVC.addChild(container)
            parentVC.viewForDiscountContainer.addSubview(container.view)
            
            container.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForDiscountContainer.frame.width, height: parentVC.viewForDiscountContainer.frame.height)
            parentVC.viewForDiscountContainer.alpha = 1.0
            
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        parentVC.viewForDiscountContainer.alpha = 0.0
        self.view.removeFromSuperview()
        self.removeFromParent()
    }

    //MARK: Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.closePopup()
        if delegate != nil{
            delegate?.alertButtonAction(index:0, data: alertViewData.init(value: ""),type:.kApplyVoucher)
        }
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        self.closePopup()
        if delegate != nil{
            delegate?.alertButtonAction(index:1, data: alertViewData.init(value: txtVoucherCode.text ?? ""),type:.kApplyVoucher)
        }
    }
    
    @IBAction func txtVoucherCodeChanged(_ sender:UITextField){
        if sender.text ?? "" == ""{
            btnConfirm.isEnabled = false
            btnConfirm.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        }else{
            btnConfirm.isEnabled = true
            btnConfirm.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
        }
    }
}
