//
//  CancelReasonVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 03/11/20.
//

import UIKit

class CancelReasonVC: UIViewController {
    
    //MARK:  IBOutlets
    @IBOutlet weak var collectionReason:UICollectionView!
    @IBOutlet weak var constCollectionHeight:NSLayoutConstraint!
    @IBOutlet weak var txtOtherReason:UITextField!
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var lblDescription:UILabel!
    
    //MARK:  Instances
    var arrReasons = ["Item out of stock","Not taking orders","Customer error","Other"]
    var selectedReason = ""
    weak var delegate:AlertControllerDelegate?
    var orderId:Int?
    var orderType:String?
    var viewType = CancelViewType.kOrder
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        if viewType == .kReservation{
            lblTitle.text = "Cancel Reservation"
            lblDescription.text = "Please select reason for cancelling reservation"
            arrReasons = ["Customer cancelled","Fully booked","Customer error","Other"]
            constCollectionHeight.constant = 132
        }else if viewType == .kOrderSyncType{
            selectedReason = AppConstants.DataSyncMode
            lblTitle.text = "Order Sync Mode"
            lblDescription.text = "Please select order sync mode"
            arrReasons = ["Auto","Manual"]
            constCollectionHeight.constant = 80
        }else if viewType == .kRemoteDevice{
            selectedReason = AppConstants.remoteDevice
            lblTitle.text = "Remote Device Access"
            lblDescription.text = AppConstants.GlobalAlert.ALERT_REMOTE_DEVICE
            arrReasons = ["No","Yes"]
            constCollectionHeight.constant = 80
        }
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController,viewType:CancelViewType = .kOrder)->CancelReasonVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "CancelReasonVC") as? CancelReasonVC{
            container.viewType = viewType
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnConfirmAction(_ sender:UIButton){
        self.view.endEditing(true)
        if !txtOtherReason.isHidden{
            if (txtOtherReason.text?.trimmingCharacters(in: .whitespaces).isEmpty)!
            {
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_EMPTY_CANCELREASON, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return
            }
            selectedReason = txtOtherReason.text ?? ""
        }else{
            if selectedReason == ""{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_SELECT_CANCELREASON, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return
            }
        }
        if delegate != nil{
            delegate!.alertButtonAction(index: 1, data: alertViewData(value: selectedReason), type: .kRejectOrder)
        }
        self.closePopup()
    }
    
    @IBAction func btnCnacelAction(_ sender:UIButton){
        self.closePopup()
    }
    
}

//MARK:  UICollectionViewDataSource
extension CancelReasonVC:UICollectionViewDataSource,UICollectionViewDelegate, UICollectionViewDelegateFlowLayout{
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return arrReasons.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "CancelReasonCell", for: indexPath) as! CancelReasonCell
        cell.lblReason.text = arrReasons[indexPath.row]
        if selectedReason == arrReasons[indexPath.row]{
            cell.lblReason.textColor = .white
            cell.lblReason.superview?.backgroundColor = AppConstants.Colors.kAppDarkGrayColor
        }else{
            cell.lblReason.textColor = AppConstants.Colors.kAppDarkGrayColor
            cell.lblReason.superview?.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        }
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        return CGSize.init(width: 270, height: 66)
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        selectedReason = arrReasons[indexPath.row]
        collectionView.reloadData()
        if arrReasons[indexPath.row] == "Other"{
            txtOtherReason.isHidden = false
        }else{
            txtOtherReason.isHidden = true
        }
    }
}

//MARK:  UITextFieldDelegate
extension CancelReasonVC:UITextFieldDelegate{
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        return textField.resignFirstResponder()
    }
}
