//
//  ContactTiffinTomVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 04/12/20.
//

import UIKit
import MessageUI

class ContactTiffinTomVC: UIViewController {
    
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
    }
    
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController)->ContactTiffinTomVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "ContactTiffinTomVC") as? ContactTiffinTomVC{
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.closePopup()
    }
    
    @IBAction func btnEmailAction(_ sender:UIButton){
        if MFMailComposeViewController.canSendMail() && AppConstants.restaurantSiteSettings?.contactEmail ?? "" != ""{
            let composeVC = MFMailComposeViewController()
            composeVC.mailComposeDelegate = self
            composeVC.setToRecipients(["\(AppConstants.restaurantSiteSettings?.contactEmail ?? "")"])
            composeVC.setSubject("")
            composeVC.setMessageBody("", isHTML: false)
            
            // Present the view controller modally.
            self.present(composeVC, animated: true, completion: nil)
        }else{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.FailedEmail, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in

            }
        }
    }
    
    @IBAction func btnCallAction(_ sender:UIButton){
        if let url = URL(string: "tel://\(AppConstants.restaurantSiteSettings?.contactPhone ?? "")") {
            if UIApplication.shared.canOpenURL(url){
                UIApplication.shared.open(url, options: [:], completionHandler: nil)
            }else{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.FailedTiffinTomCall, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in

                }
            }
        }else{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.FailedTiffinTomCall, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in

            }
        }
    }
}

//MARK: MFMailComposeViewControllerDelegate
extension ContactTiffinTomVC:MFMailComposeViewControllerDelegate{
    func mailComposeController(_ controller: MFMailComposeViewController, didFinishWith result: MFMailComposeResult, error: Error?) {
        controller.dismiss(animated: true, completion: nil)
    }
}
