//
//  ConvertOrderVC.swift
//  EPOS
//
//  Created by Apple on 18/05/21.
//

import UIKit

class ConvertOrderVC: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var viewForDelivery:UIView!
    @IBOutlet weak var viewForCollection:UIView!
    @IBOutlet weak var viewForDineIn:UIView!
    @IBOutlet weak var viewForWaiting:UIView!
    @IBOutlet weak var lblDelivery:UILabel!
    @IBOutlet weak var lblCollection:UILabel!
    @IBOutlet weak var lblDineIn:UILabel!
    @IBOutlet weak var lblWaiting:UILabel!
    
    //MARK:  Instances
    var selectedType:OrderTypesModel!
    var oldOrderType:OrderTypesModel!
    weak var delegate:OrderTypeDelegate?
    var selectedTable:TableModel?
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        setOrderType()
        checkForOrderType()
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController, type:OrderTypesModel, table:TableModel? = nil)->ConvertOrderVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "ConvertOrderVC") as? ConvertOrderVC{
            container.selectedType = type
            container.selectedTable = table
            container.oldOrderType = type
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    func setOrderType(){
        viewForWaiting.backgroundColor = .white
        lblWaiting.textColor = AppConstants.Colors.kAppThemeTextColor
        viewForDineIn.backgroundColor = .white
        lblDineIn.textColor = AppConstants.Colors.kAppThemeTextColor
        viewForCollection.backgroundColor = .white
        lblCollection.textColor = AppConstants.Colors.kAppThemeTextColor
        viewForDelivery.backgroundColor = .white
        lblDelivery.textColor = AppConstants.Colors.kAppThemeTextColor
        
        switch selectedType.id ?? 0 {
        case 1:
            viewForDineIn.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            lblDineIn.textColor = .white
        case 2:
            viewForCollection.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            lblCollection.textColor = .white
        case 3:
            viewForDelivery.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            lblDelivery.textColor = .white
        case 5:
            viewForWaiting.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            lblWaiting.textColor = .white
        default:
            break
        }
    }
    
    func checkForOrderType(){
        if AppCommonMethods.fetchSiteSettingValue(key: "is_delivery") ?? "" == "true" && AppConstants.userData?.permissions?.delivery?.actions?.list ?? 0 == 1{
            viewForDelivery.isHidden = false
        }else{
            viewForDelivery.isHidden = true
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_collection") ?? "" == "true" && AppConstants.userData?.permissions?.collection?.actions?.list ?? 0 == 1{
            viewForCollection.isHidden = false
        }else{
            viewForCollection.isHidden = true
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_dinein") ?? "" == "true" && AppConstants.userData?.permissions?.dinein?.actions?.list ?? 0 == 1{
            viewForDineIn.isHidden = false
        }else{
            viewForDineIn.isHidden = true
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_waiting") ?? "" == "true" && AppConstants.userData?.permissions?.waiting?.actions?.list ?? 0 == 1{
            viewForWaiting.isHidden = false
        }else{
            viewForWaiting.isHidden = true
        }
    }
    
    //MARK:  Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.closePopup()
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        if oldOrderType.id ?? 0 == selectedType.id ?? 0{
            self.closePopup()
            return
        }
        if self.selectedTable != nil{
            if self.delegate != nil{
                self.delegate?.orderTypeChange(orderType: self.selectedType, oldTable: self.selectedTable)
            }
            self.closePopup()
        }else{
            if self.delegate != nil{
                self.delegate?.orderTypeChange(orderType: self.selectedType, oldTable: self.selectedTable)
            }
            self.closePopup()
        }
    }
    
    @IBAction func btnChangeTypeAction(_ sender:UIButton){
        let index = AppConstants.arrOrderTypes.firstIndex { (model) -> Bool in
            return model.id ?? 0 == sender.tag
        }
        if index != nil{
            selectedType = AppConstants.arrOrderTypes[index!]
        }
        setOrderType()
    }
}
