//
//  MiscellaneousVC.swift
//  EPOS
//
//  Created by Apple on 15/04/21.
//

import UIKit
import DropDown

class MiscellaneousVC: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var txtPrepLocation:UITextField!
    @IBOutlet weak var txtProductName:UITextField!
    @IBOutlet weak var txtPrice:UITextField!
    @IBOutlet weak var lblQuantity:UILabel!
    @IBOutlet weak var btnConfirm:UIButton!
    @IBOutlet weak var btnOrderType:UIButton!
    
    //MARK:  Instances
    var arrLocation = [PrepLocationModel]()
    var selectedLocation:PrepLocationModel?
    weak var delegate:PrepLocationDelegate?
    let prepLocationDropDown = DropDown()
    var productQty = 1
    var parentVC:CreateOrderVC!
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        arrLocation = CoreDataHelper.shared.fetchPrepLocationData()
        txtPrice.text = "0.00"
        prepLocationDropDown.dismissMode = .manual
        prepLocationDropDown.anchorView = txtPrepLocation
        prepLocationDropDown.bottomOffset = CGPoint(x: 0, y: txtPrepLocation.bounds.height)
        // Action triggered on selection
        prepLocationDropDown.selectionAction = { [weak self] (index, item) in
            self?.selectedLocation = self?.arrLocation[index]
            self?.txtPrepLocation.text = item
            self?.checkValidation()
            self?.view.endEditing(true)
        }
        btnOrderType.setTitle(" \(parentVC.orderType?.type ?? "") ", for: .normal)
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:CreateOrderVC)->MiscellaneousVC?{
        for view in parentVC.viewForDiscountContainer.subviews{
            view.removeFromSuperview()
        }
        
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "MiscellaneousVC") as? MiscellaneousVC{
            container.parentVC = parentVC
            parentVC.addChild(container)
            parentVC.viewForDiscountContainer.addSubview(container.view)
            
            container.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForDiscountContainer.frame.width, height: parentVC.viewForDiscountContainer.frame.height)
            parentVC.viewForDiscountContainer.alpha = 1.0
            
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        parentVC.viewForDiscountContainer.alpha = 0.0
        self.view.removeFromSuperview()
        self.removeFromParent()
    }
    
    //MARK:  Button Actions
    @IBAction func btnQuantityChangeAction(_ sender:UIButton){
        self.view.endEditing(true)
        if sender.tag == 0{
            if productQty > 1{
                productQty -= 1
            }
        }else{
            productQty += 1
        }
        lblQuantity.text = "\(productQty)"
    }
    
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.closePopup()
        if delegate != nil{
            delegate?.prepLocationSelected(product: nil)
        }
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        self.view.endEditing(true)
        self.closePopup()
        let product = OrderProductModel.init()
        product.productName = txtProductName.text ?? ""
        product.price = Double(txtPrice.text ?? "") ?? 0
        product.quantity = productQty
        product.prepLocationId = selectedLocation?.id ?? 0
        product.subTotal = (Double(txtPrice.text ?? "") ?? 0) * Double(productQty)
        product.id = Date().millisecondsSince1970
        if delegate != nil{
            delegate?.prepLocationSelected(product: product)
        }
    }
    
    func checkValidation(){
        var isValidMisc = true
        if selectedLocation == nil{
            isValidMisc = false
        }else if (txtProductName.text ?? "").trimmingCharacters(in: .whitespacesAndNewlines).isEmpty{
            isValidMisc = false
        }
        if isValidMisc{
            btnConfirm.isUserInteractionEnabled = true
            btnConfirm.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
        }else{
            btnConfirm.isUserInteractionEnabled = false
            btnConfirm.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        }
    }
}

//MARK:  UITextFieldDelegate
extension MiscellaneousVC:UITextFieldDelegate{
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        return textField.resignFirstResponder()
    }
    
    func textFieldDidBeginEditing(_ textField: UITextField) {
        if textField == txtPrepLocation{
            var arr = [String]()
            for model in arrLocation{
                arr.append(model.name ?? "")
            }
            self.prepLocationDropDown.dataSource = arr
            self.prepLocationDropDown.show()
        }
    }
    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        if textField == txtPrice{
            let allowedCharacters = CharacterSet(charactersIn:"0123456789")
            let characterSet = CharacterSet(charactersIn: string)
            if allowedCharacters.isSuperset(of: characterSet){
                var strText = (textField.text!).replacingOccurrences(of: ".", with: "")
                if string == ""{
                    if strText != "000"{
                        if strText.count == 3{
                            strText.removeLast()
                            strText = "0\(strText)"
                        }else{
                            strText.removeLast()
                        }
                        strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                        textField.text = "\(strText)"
                    }
                }else{
                    if strText.first! == "0"{
                        strText.removeFirst()
                        strText = "\(strText)\(string)"
                    }else{
                        strText = "\(strText)\(string)"
                    }
                    strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                    textField.text = "\(strText)"
                }
            }
            checkValidation()
            return false
        }
        checkValidation()
        return true
    }
    
    
}

//MARK:  UITableViewDataSource
extension MiscellaneousVC:UITableViewDataSource,UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrLocation.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "PrepLocationCell", for: indexPath) as! PrepLocationCell
        let model = arrLocation[indexPath.row]
        cell.lblName.text = model.name ?? ""
        if selectedLocation?.id ?? 0 == model.id ?? 0{
            cell.imgSelection.image = UIImage.init(named: "ic_radio_selected")
        }else{
            cell.imgSelection.image = UIImage.init(named: "ic_radio_unselected")
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        selectedLocation = arrLocation[indexPath.row]
        tableView.reloadData()
    }
}
