//
//  OrderProductDetailVC.swift
//  EPOS
//
//  Created by Apple on 03/08/21.
//

import UIKit

class OrderProductDetailVC: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var lblProductName:UILabel!
    @IBOutlet weak var txtProductDesc:UITextView!
    @IBOutlet weak var lblProductQty:UILabel!
    @IBOutlet weak var lblProductPrice:UILabel!
    @IBOutlet weak var constDescHeight:NSLayoutConstraint!
    
    //MARK:  Instances
    var orderProduct:OrderProductModel!
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        lblProductName.text = orderProduct.productName ?? ""
        var strDesc = ""
        lblProductQty.text = "\(orderProduct.quantity ?? 0)x"
        lblProductPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign,orderProduct.price ?? 0)
        orderProduct.arrIngriedent.forEach({ (ingrident) in
            var strIngrident = ""
            if ingrident.with ?? 0 == 1{
                if ingrident.price ?? 0 == 0{
                    strIngrident = String.init(format: "(%dx %@ - Free)", ingrident.quantity ?? 0, ingrident.name ?? "")
                }else{
                    strIngrident = String.init(format: "(%dx %@ - %@%.2f)", ingrident.quantity ?? 0, ingrident.name ?? "", AppConstants.currencySign, ingrident.price ?? 0)
                }
            }else{
                if ingrident.price ?? 0 == 0{
                    strIngrident = String.init(format: "(No %@ - Free)", ingrident.name ?? "")
                }else{
                    strIngrident = String.init(format: "(No %@ - %@%.2f)", ingrident.name ?? "", AppConstants.currencySign, ingrident.price ?? 0)
                }
            }
            if strDesc == ""{
                strDesc = strIngrident
            }else{
                strDesc = "\(strDesc)\n\(strIngrident)"
            }
        })
        orderProduct.arrAddons.forEach({ (addon) in
            let strAddon = String.init(format: "(%dx %@)", addon.quantity ,addon.name ?? "")
            if strDesc == ""{
                strDesc = strAddon
            }else{
                strDesc = "\(strDesc)\n\(strAddon)"
            }
        })
        if orderProduct.specialInstruction ?? "" != ""{
            if strDesc == ""{
                strDesc = "Special Instruction: \(orderProduct.specialInstruction ?? "")"
            }else{
                strDesc = "\(strDesc)\nSpecial Instruction: \(orderProduct.specialInstruction ?? "")"
            }
            if orderProduct.instructionPrice ?? 0 != 0{
                strDesc.append(String.init(format: " - %.2f", orderProduct.instructionPrice ?? 0))
            }
        }
        
        if orderProduct.isDelete{
            txtProductDesc.text = ""
            txtProductDesc.attributedText = strDesc.strikeThoughText
        }else{
            txtProductDesc.attributedText = nil
            txtProductDesc.text = strDesc
        }
        let height = strDesc.getHeightFromString(font: AppConstants.GlobalFontConstants.kBoldFont(size: 14), width: AppConstants.ScreenSize.SCREEN_WIDTH - 609) + 20
        let nameHeight = (orderProduct.productName ?? "").getHeightFromString(font: AppConstants.GlobalFontConstants.kBoldFont(size: 18), width: AppConstants.ScreenSize.SCREEN_WIDTH - 609)
        constDescHeight.constant = min(height, AppConstants.ScreenSize.SCREEN_HEIGHT - (AppConstants.ScreenSize.topPadding + AppConstants.ScreenSize.bottomPadding) - nameHeight - 140)
    }
    
    //MARK: Create ViewController Instance
    class func showPopup(parentVC:UIViewController, product:OrderProductModel)->OrderProductDetailVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "OrderProductDetailVC") as? OrderProductDetailVC{
            container.orderProduct = product
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  Button Action
    @IBAction func btnCloseAction(_ sender:UIButton){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
}
