//
//  OrderResetAlertVC.swift
//  EPOS
//
//  Created by Tushar Premal on 09/06/25.
//

import UIKit

class OrderResetAlertVC: UIViewController {

    var fromDate = Date().addingTimeInterval(-24*60*60)
    var toDate = Date()
    lazy var arrReports = [ReportModel]()
    var reportData:FullReportModel?
    var orderReset: (() -> Void)?
    
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
    }
    

    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController)->OrderResetAlertVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "OrderResetAlertVC") as? OrderResetAlertVC{
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func removePopView(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    @IBAction func btnPrintReportAction(_ sender:UIButton){
        FetchFullReport()
    }
    
    @IBAction func btnCnacelAction(_ sender:UIButton){
        self.removePopView()
    }

    @IBAction func btnConfirmAction(_ sender:UIButton){
        self.removePopView()
        self.orderReset?()
    }
    
    func FetchFullReport()  {
        var dictParam = [String:Any]()
        dictParam["from_date"] = fromDate.getDateInString(format: "yyyy-MM-dd")
        dictParam["to_date"] = toDate.getDateInString(format: "yyyy-MM-dd")
        dictParam["archived"] = "0"
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kFullReport, method: "GET") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                self.arrReports.removeAll()
                let jsonDecoder = JSONDecoder()
                var data:NSDictionary?
                if let response = result as? NSDictionary{
                    if let data = AppCommonMethods.convertToJson(object: response){
                        if let aData = try? jsonDecoder.decode(FullReportModel.self, from: data){
                            self.reportData = aData
                        }
                    }
                    data = response
                }
                self.setReportData(dict: data)
            }
        }
    }
    
    func setReportData(dict:NSDictionary? = nil){
        
        self.arrReports.removeAll()
        
        let startDate = Int((fromDate.startOfDate() ?? fromDate).timeIntervalSince1970)
        let endDate = Int((toDate.endOfDate() ?? toDate).timeIntervalSince1970)
        
        if let product = SQLiteManage.SelectQuery("SELECT SUM(OrderProducts.quantity) as total_product, SUM(OrderProducts.sub_total) as value_product from  OrderProducts LEFT JOIN Orders ON Orders.id = OrderProducts.order_id WHERE Orders.delivery_date >= \(startDate) AND Orders.isDelete == 0 AND OrderProducts.isDelete == 0 AND Orders.delivery_date < \(endDate) AND Orders.is_archived = 0").first{
            if (Double(product["value_product"] ?? "") ?? 0 > 0 && AppConstants.userData?.permissions?.ordersAmountProduct?.actions?.list ?? 0 == 1){
                self.arrReports.append(ReportModel.init(status: "Product Sale", total: Double(product["value_product"] ?? ""), count: Int(product["total_product"] ?? ""), showAll: true))
            }
        }
        if let order = SQLiteManage.SelectQuery("SELECT sum(no_guest) as no_diner,count(*) as no_order,sum(discount) as discount,sum(gratuity) as gratuity,sum(service_charge) as service_charge, (SELECT  count(*) FROM Orders WHERE table_id != 0 AND delivery_date >= \(startDate) AND delivery_date < \(endDate) AND Orders.is_archived = 0 AND Orders.isDelete == 0) as total_table FROM Orders WHERE delivery_date >= \(startDate) AND delivery_date < \(endDate) AND Orders.is_archived = 0 AND Orders.isDelete == 0").first{
            if (Int(order["no_order"] ?? "") ?? 0 > 0 && AppConstants.userData?.permissions?.orderCount?.actions?.list ?? 0 == 1){
                self.arrReports.insert(ReportModel.init(status: "Total Orders", count: Int(order["no_order"] ?? ""), rowType: 1), at: 0)
            }
            if (Double(order["discount"] ?? "") ?? 0 > 0 && AppConstants.userData?.permissions?.totalDiscount?.actions?.list ?? 0 == 1){
                self.arrReports.append(ReportModel.init(status: "Total Discount", total: Double(order["discount"] ?? "")))
            }
            if let order = SQLiteManage.SelectQuery("SELECT COUNT(*) AS count, SUM(OrderPayment.amount) AS total, PaymentMethods.name AS name FROM PaymentMethods LEFT JOIN OrderPayment ON PaymentMethods.id = OrderPayment.payment_method_id LEFT JOIN Orders ON Orders.id = OrderPayment.order_id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) AND Orders.isDelete = 0 AND PaymentMethods.id == 5 AND Orders.is_archived = 0 GROUP BY OrderPayment.payment_method_id, PaymentMethods.name").first{
                if (Double(order["total"] ?? "") ?? 0 > 0 && AppConstants.userData?.permissions?.vouchers?.actions?.list ?? 0 == 1){
                    self.arrReports.append(ReportModel.init(status: "Total Vouchers", total: Double(order["total"] ?? ""), count: Int(order["count"] ?? ""), showAll: true))
                }
            }
            
            
            if (Int(order["no_diner"] ?? "") ?? 0 > 0 && AppConstants.userData?.permissions?.totalNoGuest?.actions?.list ?? 0 == 1){
                self.arrReports.append(ReportModel.init(status: "Total Dinners", count: Int(order["no_diner"] ?? ""), rowType: 1))
            }
            if (Int(order["total_table"] ?? "") ?? 0 > 0 && AppConstants.userData?.permissions?.totalNoTable?.actions?.list ?? 0 == 1){
                self.arrReports.append(ReportModel.init(status: "Total Tables", count: Int(order["total_table"] ?? ""), rowType: 1))
            }
            if Double(order["gratuity"] ?? "") ?? 0 > 0{
                self.arrReports.append(ReportModel.init(status: "Total Gratuity", total: Double(order["gratuity"] ?? "")))
            }
            if Double(order["service_charge"] ?? "") ?? 0 > 0{
                self.arrReports.append(ReportModel.init(status: "Total Service Charge", total: Double(order["service_charge"] ?? "")))
            }
        }
        
        
        if let order = SQLiteManage.SelectQuery("SELECT SUM(OrderProducts.price) AS item_price, SUM(OrderProducts.quantity) AS item_quantity FROM OrderProducts JOIN Orders ON OrderProducts.order_id = Orders.id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) AND Orders.is_archived = 0 AND Orders.isDelete == 0 AND OrderProducts.isDelete == 1").first{
            if Double(order["item_price"] ?? "") ?? 0 > 0{
                self.arrReports.append(ReportModel.init(status: "Total deleted items", total: Double(order["item_price"] ?? ""), count: Int(order["item_quantity"] ?? ""), showAll: true))
            }
        }
        
        
        if self.reportData != nil{
            self.arrReports.append(ReportModel.init(status: "Online orders", total:0, count: 0, rowType: 2))
            self.arrReports.append(ReportModel.init(status: "iOS", total: self.reportData?.iOSOnlineOrder?.first?.total ?? 0, count: self.reportData?.iOSOnlineOrder?.first?.count ?? 0, showAll: true))
            self.arrReports.append(ReportModel.init(status: "Android", total: self.reportData?.androidOnlineOrder?.first?.total ?? 0, count: self.reportData?.androidOnlineOrder?.first?.count ?? 0, showAll: true))
            self.arrReports.append(ReportModel.init(status: "Web", total: self.reportData?.webOnlineOrder?.first?.total ?? 0, count: self.reportData?.webOnlineOrder?.first?.count ?? 0, showAll: true))
        }
        
        if AppConstants.userData?.permissions?.orderTypeWise?.actions?.list ?? 0 == 1{
            let orderType = SQLiteManage.SelectQuery("SELECT COUNT(*) as count,sum(total) as total, OrderTypes.type as type FROM OrderTypes LEFT JOIN Orders ON OrderTypes.id = Orders.order_type_id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) AND Orders.isDelete == 0 AND Orders.is_archived = 0 GROUP BY orders.order_type_id")
            if orderType.count > 0{
                self.arrReports.append(ReportModel.init(status: "Order Type", total:0, count: 0, rowType: 2))
                for type in orderType{
                    if let value = type["total"], value != ""{
                        self.arrReports.append(ReportModel.init(status: "\(type["type"] ?? "")", total: Double(value) ?? 0, count: Int(type["count"] ?? ""), showAll: true))
                    }
                }
            }
        }
        
        if AppConstants.userData?.permissions?.orderStatusWise?.actions?.list ?? 0 == 1{
            let orderStatus = SQLiteManage.SelectQuery("SELECT COUNT(*) as count,sum(total) as total, OrderStatus.status as status FROM OrderStatus LEFT JOIN Orders ON OrderStatus.id = orders.order_status_id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) AND Orders.isDelete == 0 AND Orders.is_archived = 0 GROUP BY orders.order_status_id")
            if orderStatus.count > 0{
                self.arrReports.append(ReportModel.init(status: "Order Status", total:0, count: 0, rowType: 2))
                for type in orderStatus{
                    if let value = type["total"], value != ""{
                        self.arrReports.append(ReportModel.init(status: "\(type["status"] ?? "")", total: Double(value) ?? 0, count: Int(type["count"] ?? ""), showAll: true))
                    }
                }
            }
        }
        
        var totalCash = 0.0
        var totalCard = 0.0
        var totalCardManual = 0.0
        var totalCardMoto = 0.0
        var totalCheque = 0.0
        
        if AppConstants.userData?.permissions?.orderPaymentWise?.actions?.list ?? 0 == 1{
            let orderPayment = SQLiteManage.SelectQuery("SELECT COUNT(*) AS count, SUM(OrderPayment.amount) AS total, PaymentMethods.name AS name FROM PaymentMethods LEFT JOIN OrderPayment ON PaymentMethods.id = OrderPayment.payment_method_id LEFT JOIN Orders ON Orders.id = OrderPayment.order_id WHERE Orders.delivery_date >= \(startDate) AND Orders.delivery_date < \(endDate) AND Orders.isDelete = 0  AND Orders.order_status_id != 10 AND PaymentMethods.id != 5 AND Orders.is_archived = 0 GROUP BY OrderPayment.payment_method_id, PaymentMethods.name")
            if orderPayment.count > 0{
                self.arrReports.append(ReportModel.init(status: "Payment Wise", total:0, count: 0, rowType: 2))
                for type in orderPayment{
                    if let value = type["total"], value != ""{
                        if type["name"] ?? "" == "Cash"{
                            totalCash += (Double(value) ?? 0)
                        }else if type["name"] ?? "" == "Credit Card TT"{
                            totalCard += (Double(value) ?? 0)
                        }else if type["name"] ?? "" == "Cheque"{
                            totalCheque += (Double(value) ?? 0)
                        }else if type["name"] ?? "" == "Credit Card Moto"{
                            totalCardMoto += (Double(value) ?? 0)
                        }else if type["name"] ?? "" == "Credit Card Manual"{
                            totalCardManual += (Double(value) ?? 0)
                        }
                        self.arrReports.append(ReportModel.init(status: "\(type["name"] ?? "")", total: Double(type["total"] ?? ""), count: Int(type["count"] ?? "") ?? 0, rowType: 1, showAll: true))
                    }
                }
            }
        }
        
        if totalCash > 0 || totalCard > 0 || totalCheque > 0 || totalCardManual > 0 || totalCardMoto > 0{
            self.arrReports.append(ReportModel.init(status: "Grand total", total:0, count: 0, rowType: 2))
            if totalCard > 0{
                self.arrReports.append(ReportModel.init(status: "Total Card", total: totalCard, showAll: true))
            }
            if totalCash > 0{
                self.arrReports.append(ReportModel.init(status: "Total Cash", total: totalCash, showAll: true))
            }
            if totalCardMoto > 0{
                self.arrReports.append(ReportModel.init(status: "Total Card Moto", total: totalCardMoto, showAll: true))
            }
            if totalCardManual > 0{
                self.arrReports.append(ReportModel.init(status: "Total Card Manual", total: totalCardManual, showAll: true))
            }
            if totalCheque > 0{
                self.arrReports.append(ReportModel.init(status: "Total Cheque", total: totalCheque, showAll: true))
            }
            self.arrReports.append(ReportModel.init(status: "Total", total: totalCash + totalCard + totalCheque + totalCardMoto + totalCardManual, showAll: true))
        }
        
        if arrReports.count > 0{
            PrintManager.shared.strHeaderDate = "\(fromDate.gatDateFormatAndTime()) to \(toDate.gatDateFormatAndTime())"
            PrintManager.shared.reportType = RerportType.kFullReport
            PrintManager.shared.connectToPrinterWithPrint(model: arrReports, controller: self)
        }
    }
}
