//
//  SelectCardReaderVC.swift
//  EPOS
//
//  Created by Apple on 31/05/21.
//

import UIKit
import StripeTerminal

class SelectCardReaderVC: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var tblCardReader:UITableView!
    @IBOutlet weak var constTblHeight:NSLayoutConstraint!
    
    //MARK:  Instances
    var selectedCard:Any?
    weak var delegate:CardReaderDelegate?
    var arrStripeCard:[Reader]?
    var arrCardReaders = [CardReaderModel]()
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        if let readers = AppConstants.businessData?.cardReaders{
            arrCardReaders = readers.filter{ $0.connectivity ?? "" != "TAPTOPAY" }
        }
        if arrStripeCard != nil{
            let height = 60 * CGFloat(arrStripeCard!.count)
            constTblHeight.constant = min(height, AppConstants.ScreenSize.SCREEN_HEIGHT-(AppConstants.ScreenSize.topPadding+AppConstants.ScreenSize.bottomPadding+368))
        }else{
            let height = 60 * CGFloat(arrCardReaders.count)
            constTblHeight.constant = min(height, AppConstants.ScreenSize.SCREEN_HEIGHT-(AppConstants.ScreenSize.topPadding+AppConstants.ScreenSize.bottomPadding+368))
        }
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController, selectedReader:Any? = nil, readers:[Reader]? = nil)->SelectCardReaderVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "SelectCardReaderVC") as? SelectCardReaderVC{
            container.arrStripeCard = readers
            container.selectedCard = selectedReader
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK: General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.closePopup()
        if self.delegate != nil{
            self.delegate!.cardReaderSelected(reader: nil)
        }
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        if selectedCard != nil{
            self.closePopup()
            if self.delegate != nil{
                self.delegate!.cardReaderSelected(reader: self.selectedCard)
            }
        }else{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_SELECT_CARDREADER, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in

            }
        }
    }
}

//MARK:  UITableViewDataSource
extension SelectCardReaderVC:UITableViewDelegate,UITableViewDataSource{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if arrStripeCard != nil{
            return arrStripeCard?.count ?? 0
        }
        return arrCardReaders.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "CardReaderViewCell", for: indexPath) as! CardReaderViewCell
        if arrStripeCard != nil{
            let model = arrStripeCard![indexPath.row]
            cell.lblName.text = model.label ?? model.serialNumber
            cell.imgSelect.image = UIImage.init(named: "ic_radio_unselected")
            if let card = selectedCard as? Reader{
                if card.stripeId ?? "" == model.stripeId ?? "" && card.serialNumber == model.serialNumber{
                    cell.imgSelect.image = UIImage.init(named: "ic_radio_selected")
                }
            }
        }else{
            let model = arrCardReaders[indexPath.row]
            cell.lblName.text = model.name ?? ""
            cell.imgSelect.image = UIImage.init(named: "ic_radio_unselected")
            if let card = selectedCard as? CardReaderModel{
                if card.id ?? 0 == model.id ?? 0{
                    cell.imgSelect.image = UIImage.init(named: "ic_radio_selected")
                }
            }
        }
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if arrStripeCard != nil{
            selectedCard = arrStripeCard![indexPath.row]
        }else{
            selectedCard = arrCardReaders[indexPath.row]
        }
        tblCardReader.reloadData()
    }
}
