//
//  SwapTableVC.swift
//  EPOS
//
//  Created by Apple on 17/05/21.
//

import UIKit
import BetterSegmentedControl

class SwapTableVC: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var segementFloor:BetterSegmentedControl!
    @IBOutlet weak var collectionTable:UICollectionView!
    @IBOutlet weak var lblPageCount:UILabel!
    @IBOutlet weak var lblViewTitle:UILabel!
    @IBOutlet weak var btnNextPage:UIButton!
    @IBOutlet weak var btnPreviousPage:UIButton!
    @IBOutlet weak var btnCancel:UIButton!
    @IBOutlet weak var lblMessage:UILabel!
    
    //MARK:  Instances
    var totalPage = 1
    var arrFloors = [FloorModel]()
    var arrTables = [TableModel]()
    weak var delegate:SwapTableDelegate?
    var pageLimit = 0
    var selectedTable:TableModel?
    var oldTable:TableModel?
    var orderId = 0
    var isFromSeatTable = false
    var offlineOrder = false
    var isMergeTable = false
    var orderType:OrderTypesModel?
    var orderTotal:Double?
    var orderPaid:Double?
    var orderTime:String?
    var mergeTable:TableModel?
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        let height = AppConstants.ScreenSize.SCREEN_HEIGHT
        var itemWidth = (AppConstants.ScreenSize.SCREEN_WIDTH-270)/4
        var itemHeight = (height-AppConstants.ScreenSize.bottomPadding-AppConstants.ScreenSize.topPadding-493)/3
        if height == 1024{
            pageLimit = 5*4
            itemWidth = (AppConstants.ScreenSize.SCREEN_WIDTH-270)/5
            itemHeight = (height-AppConstants.ScreenSize.bottomPadding-AppConstants.ScreenSize.topPadding-493)/4
        }else{
            pageLimit = 4*3
        }
        let horizontalCV = HorizontalCollectionViewLayout()
        horizontalCV.itemSize = CGSize(width: itemWidth, height: itemHeight)
        collectionTable.collectionViewLayout = horizontalCV
        FetchFloorList()
        if orderType != nil{
            lblViewTitle.text = "Select Table"
        }
        if isFromSeatTable{
            lblViewTitle.text = "Select Table"
            if selectedTable != nil{
                lblMessage.text = "It seems your selected table is occupied at the moment!, Please select different table"
            }
        }
        if isMergeTable{
            lblViewTitle.text = "Merge Table"
            if let table = SQLiteManage.fetchTableDataFromMergeId(id: oldTable?.id ?? 0){
                selectedTable = table
                mergeTable = table
            }
        }
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController, table:TableModel? = nil, orderId:Int = 0, isOfflineOrder:Bool = false, orderType:OrderTypesModel? = nil, orderTotal:Double? = nil, orderTime:String? = nil, orderPaid:Double? = nil, isFromSeatTable:Bool = false, isMergeTable:Bool = false)->SwapTableVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "SwapTableVC") as? SwapTableVC{
            container.selectedTable = table
            container.oldTable = table
            container.isFromSeatTable = isFromSeatTable
            container.offlineOrder = isOfflineOrder
            container.orderId = orderId
            container.orderType = orderType
            container.orderTotal = orderTotal
            container.orderTime = orderTime
            container.isMergeTable = isMergeTable
            container.orderPaid = orderPaid
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    //MARK:  Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.closePopup()
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        if orderId == 0 || self.orderType != nil{
            if self.selectedTable == nil{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.kSelectTable, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return
            }
            if self.delegate != nil{
                self.delegate?.tableSelected(table: self.selectedTable!, orderType: self.orderType, isMergedTable: false)
            }
            self.closePopup()
        }else{
            if self.oldTable!.id ?? 0 == self.selectedTable!.id ?? 0{
                self.closePopup()
            }else{
                if self.isMergeTable && self.mergeTable != nil{
                    if (self.mergeTable?.id ?? 0) != (self.selectedTable?.id ?? 0){
                        SQLiteManage.updateTableStatus(tableId: self.mergeTable!.id ?? 0, status: "vacant", lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", locked: 0)
                        AppCommonMethods.SaveTable(table: self.mergeTable!, status: "vacant", locked: 0)
                    }
                }
                self.delegate?.tableSelected(table: self.selectedTable!, orderType: self.orderType, isMergedTable: self.isMergeTable)
                self.closePopup()
            }
        }
    }
    
    @IBAction func btnNextAction(_ sender:UIButton){
        var offsetX = collectionTable.contentOffset.x
        offsetX = offsetX + collectionTable.frame.width
        collectionTable.contentOffset = CGPoint.init(x: offsetX, y: collectionTable.contentOffset.y)
    }
    
    @IBAction func btnPrevoiusAction(_ sender:UIButton){
        var offsetX = collectionTable.contentOffset.x
        offsetX = offsetX - collectionTable.frame.width
        collectionTable.contentOffset = CGPoint.init(x: offsetX, y: collectionTable.contentOffset.y)
    }
    
    @IBAction func segmentChangedAction(_ sender:BetterSegmentedControl){
        FetchTableList(floorData: arrFloors[sender.index])
    }
    
    //MARK:  Database Methods
    func FetchFloorList(){
        self.arrFloors = CoreDataHelper.shared.fetchFloorData()
        var arrFloorName = [String]()
        for model in self.arrFloors{
            arrFloorName.append(model.name ?? "")
        }
        self.segementFloor.superview?.isHidden = false
        self.segementFloor.segments = LabelSegment.segments(withTitles: arrFloorName, normalBackgroundColor: .white, normalFont: AppConstants.GlobalFontConstants.kBoldFont(size: 17), normalTextColor: AppConstants.Colors.kAppDarkGrayColor, selectedBackgroundColor: AppConstants.Colors.kAppThemeAquaColor , selectedFont: AppConstants.GlobalFontConstants.kBoldFont(size: 17), selectedTextColor: .white)
        if self.arrFloors.count > 0{
            self.FetchTableList(floorData: self.arrFloors[0])
        }
    }
    
    func fetchOfflineOrder(floorData:FloorModel){
        if isMergeTable{
            self.arrTables = SQLiteManage.fetchTablesWithMergeId(floorId: floorData.id ?? 0, id: self.oldTable?.id ?? 0)
        }else{
            if orderId != 0 || isFromSeatTable{
                self.arrTables = SQLiteManage.fetchTableData(floorId: floorData.id ?? 0, statusId: 1)
            }else{
                self.arrTables = SQLiteManage.fetchTableData(floorId: floorData.id ?? 0)
            }
        }
        
        
        floorData.tableData = self.arrTables
        if self.arrTables.count > self.pageLimit{
            self.lblPageCount.isHidden = false
            self.totalPage = Int(ceil(Double(self.arrTables.count)/Double(self.pageLimit)))
            self.lblPageCount.text = "Swipe for more - page 1/\(self.totalPage)"
            self.btnNextPage.isHidden = false
        }else{
            self.lblPageCount.isHidden = true
            self.btnNextPage.isHidden = true
            self.btnPreviousPage.isHidden = true
        }
        
        self.collectionTable.reloadData()
    }
    
    //MARK: WebService Methods
    func FetchTableList(floorData:FloorModel){
        if floorData.tableData != nil{
            arrTables = floorData.tableData!
            AppCommonMethods.stopProgressBar()
            if arrTables.count > self.pageLimit{
                self.lblPageCount.isHidden = false
                self.totalPage = Int(ceil(Double(arrTables.count)/Double(pageLimit)))
                self.lblPageCount.text = "Swipe for more - page 1/\(self.totalPage)"
                self.btnNextPage.isHidden = false
            }else{
                self.lblPageCount.isHidden = true
                self.btnNextPage.isHidden = true
                self.btnPreviousPage.isHidden = true
            }
            self.collectionTable.reloadData()
            return
        }
        self.fetchOfflineOrder(floorData: floorData)
    }
}

//MARK:  UICollectionViewDataSource
extension SwapTableVC: UICollectionViewDelegate,UICollectionViewDataSource{
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        DispatchQueue.main.async {
            if self.arrTables.count > self.pageLimit{
                self.lblPageCount.text = "Swipe for more - page \(scrollView.currentPage)/\(self.totalPage)"
                if scrollView.currentPage == 1{
                    self.btnPreviousPage.isHidden = true
                }else{
                    self.btnPreviousPage.isHidden = false
                }
                if (scrollView.currentPage) == self.totalPage{
                    self.btnNextPage.isHidden = true
                }else{
                    self.btnNextPage.isHidden = false
                }
            }
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return arrTables.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "TablesViewCell", for: indexPath) as! TablesViewCell
        let model = arrTables[indexPath.row]
        if model.id ?? 0 == selectedTable?.id ?? 0{
            cell.lblTitle.textColor = .white
            cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
        }else{
            cell.lblTitle.textColor = AppConstants.Colors.kAppDarkGrayColor
            cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        }
        cell.lblTitle.text = "\(model.number ?? "")"
        
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        selectedTable = arrTables[indexPath.row]
        self.collectionTable.reloadData()
    }
}
