//
//  TimeRangeVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 05/11/20.
//

import UIKit
import ActionSheetPicker_3_0

class TimeRangeVC: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var lblToTime:UILabel!
    @IBOutlet weak var lblFromTime:UILabel!
    
    //MARK:  Instances
    var strToTime = ""
    var strFromTime = ""
    weak var delegate:DateRangeDelegate?
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        lblToTime.text = strToTime
        lblFromTime.text = strFromTime
    }
    

    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController,fromTime:String,toTime:String)->TimeRangeVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "TimeRangeVC") as? TimeRangeVC{
            container.strToTime = toTime
            container.strFromTime = fromTime
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnToTimeAction(_ sender:UIButton){
        let date = strToTime.getDateFromString(format: "hh:mm a", locale: nil) ?? Date()
        let datePicker = ActionSheetDatePicker(title: "Select to time", datePickerMode: UIDatePicker.Mode.time, selectedDate: date, doneBlock: {
            picker, value, index in
            self.strToTime = (value as! Date).getDateInString(format: "hh:mm a")
            self.lblToTime.text = (value as! Date).getDateInString(format: "hh:mm a")
        }, cancel: { ActionStringCancelBlock in return }, origin: sender)
        if let fromDate = strFromTime.getDateFromString(format: "hh:mm a", locale: nil){
            datePicker?.minimumDate = fromDate
        }
        datePicker?.show()
    }
    
    @IBAction func btnFromTimeAction(_ sender:UIButton){
        let date = strFromTime.getDateFromString(format: "hh:mm a", locale: nil) ?? Date()
        let datePicker = ActionSheetDatePicker(title: "Select from time", datePickerMode: UIDatePicker.Mode.time, selectedDate: date, doneBlock: {
            picker, value, index in
            self.strFromTime = (value as! Date).getDateInString(format: "hh:mm a")
            self.lblFromTime.text = (value as! Date).getDateInString(format: "hh:mm a")
        }, cancel: { ActionStringCancelBlock in return }, origin: sender)
        datePicker?.maximumDate = strToTime.getDateFromString(format: "hh:mm a", locale: nil) ?? Date()
        datePicker?.show()
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        if strToTime == ""{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_SELECT_TOTIME, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
        }else if strFromTime == ""{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_SELECT_FROMTIME, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
        }else{
            let toTime = strToTime.getDateFromString(format: "hh:mm a", locale: nil) ?? Date()
            let fromTime = strFromTime.getDateFromString(format: "hh:mm a", locale: nil) ?? Date()
            if fromTime > toTime{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_TO_GREATER_FROM_TIME, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }else{
                if delegate != nil{
                    self.delegate!.dateSelected(toDate: strToTime, fromDate: strFromTime)
                }
                self.closePopup()
            }
            
        }
    }
    
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.closePopup()
    }
}
