//
//  DataManagementVC.swift
//  EPOS
//
//  Created by Apple on 15/06/21.
//

import UIKit

class DataManagementVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var tblSettings:UITableView!
    @IBOutlet weak var lblViewTitle:UILabel!
    @IBOutlet weak var btnBack:UIButton!
    
    //MARK: Instances
    var arrManagements:[ManagementCellData] = [.init("Factory Data Reset", .kFactoryDataReset),.init("Erase All Orders", .kEreaseAllOrders),.init("Erase All Reservations", .kEraseAllReservation),.init("Erase Cash Drawer Log", .kEraseCashDrawerLog),.init("Erase Caller ID Log", .kEraseCallerIDLog)]
    var settingData:SettingsCellData!
    var selectedDataType:SettingManagementType?
    var parentVC:SettingsMainVC!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        if selectedDataType != nil{
            if selectedDataType! == .kOpeningHours{
                lblViewTitle.text = "Opening Hours"
                arrManagements = [.init("Delivery hours", .kDeliveryHour),.init("Collection hours", .kCollectionHour)]
            }else if selectedDataType! == .kOrderOptions{
                lblViewTitle.text = "Order options"
                arrManagements = [.init("Delivery fees", .kDeliveryFee),.init("Order requirements", .kOrderRequirement)]
            }else if selectedDataType! == .kOffers{
                lblViewTitle.text = "Offers"
                arrManagements = [.init("Auto discounts", .kAutoDiscount),.init("Discount codes", .kDiscountCode)]
            }else if selectedDataType! == .kReservationOptions{
                lblViewTitle.text = "Reservation options"
                arrManagements = [ManagementCellData]()
            }
            btnBack.isHidden = false
        }else{
            lblViewTitle.text = settingData.title
            if settingData.type == .kRestaurantManagement{
                if (AppConstants.restaurantData?.restaurantDelivery ?? "").lowercased() == "yes"{
                    arrManagements = [.init("Opening hours", .kOpeningHours),.init("Order options", .kOrderOptions),.init("Reservation options", .kReservationOptions),.init("Dine in options", .kDineInOptions),.init("Offers", .kOffers)]
                }else{
                    arrManagements = [.init("Opening hours", .kOpeningHours),.init("Dine in options", .kDineInOptions),.init("Offers", .kOffers)]
                }
            }
        }
    }

    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:SettingsMainVC,settingsData:SettingsCellData? = nil,type:SettingManagementType? = nil)->DataManagementVC?{
        guard let VC = UIStoryboard.init(name: "Settings", bundle: nil).instantiateViewController(withIdentifier: "DataManagementVC") as? DataManagementVC else {
            return nil
        }
        if settingsData != nil{
            VC.settingData = settingsData!
        }
        if type != nil{
            VC.selectedDataType = type!
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: Button Action
    @IBAction func btnBackAction(_ sender:UIButton){
        self.view.removeFromSuperview()
        self.removeFromParent()
    }
    
    @IBAction func switchChangedAction(_ sender:UISwitch){
        var settings = AlertSetting()
        if selectedDataType! == .kReservationOptions{
            settings.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_OFF_RESERVATION
        }else{
            settings.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_OFF_ORDER
        }
        settings.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
        settings.type = .kEnterUserPassword
        settings.textPlcaeholder = "password"
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: settings){
            VC.delegate = self
        }
    }
    
    //MARK: WebService Methods
    func CallOnlineAccpetedAPI(password:String){
        var dictParam = [String:Any]()
        var isSwitchOn = false
        if let cell = tblSettings.cellForRow(at: IndexPath.init(row: 0, section: 0)) as? OnlineOptionViewCell{
            isSwitchOn = cell.switchOption.isOn
        }
        if selectedDataType == .kOrderOptions{
            dictParam["online_order"] = isSwitchOn ? "Yes" : "No"
        }else{
            dictParam["booking_status"] = isSwitchOn ? "Yes" : "No"
        }
        
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kRestaurant)\(AppConstants.webResId ?? "")", method: "POST", isRestaurantAPI:true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let result = response as? NSDictionary, let jsonData = AppCommonMethods.convertToJson(object: result), let aLoginData = try? jsonDecoder.decode(RestaurantDetailModel.self, from: jsonData){
                    var settings = BottomAlertSettings()
                    settings.strMessage = (self.selectedDataType == .kOrderOptions) ? "Order status has been updated" : "Reservation status has been updated"
                    AppValidation().showBottomAlertView(settings: settings)
                    if let encoded = AppCommonMethods.getjsonDataFromCodable(object: aLoginData) {
                        AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kUserData)
                    }
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func CallResetAPI(){
        let dictParam = [String:Any]()
        var strURL = AppConstants.APIURL.kFactoryReset
        if selectedDataType == .kEraseAllReservation{
            strURL = AppConstants.APIURL.kDeleteAllReservation
        }else if selectedDataType == .kEreaseAllOrders{
            strURL = AppConstants.APIURL.kDeletAllOrder
        }else if selectedDataType == .kEraseCashDrawerLog{
            strURL = AppConstants.APIURL.kCashDrawerLogDelete
        }else if selectedDataType == .kEraseCallerIDLog{
            strURL = AppConstants.APIURL.kCallLogDelete
        }
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "DELETE") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let response = result as? NSDictionary, let _ = response.getStringValue("message"){
                    if self.selectedDataType == .kEraseAllReservation{
                        CoreDataHelper.shared.deleteDataFromDatabase(entity: "Reservations")
                    }else if self.selectedDataType == .kEreaseAllOrders{
                        CoreDataHelper.shared.DeleteAllOrderData()
                    }else if self.selectedDataType == .kFactoryDataReset{
                        CoreDataHelper.shared.DeleteAllOrderData()
                        CoreDataHelper.shared.deleteDataFromDatabase(entity: "Reservations")
                        CoreDataHelper.shared.DeleteBlankCustomers()
                    }
                    self.parentVC.parentVC.AddContainerView(data: self.parentVC.parentVC.arrSideMenu.first!)
                    return
                }
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
}

//MARK: UITableViewDataSource
extension DataManagementVC:UITableViewDataSource,UITableViewDelegate{
    func numberOfSections(in tableView: UITableView) -> Int {
        if selectedDataType != nil{
            if selectedDataType! == .kReservationOptions || selectedDataType! == .kOrderOptions{
                return 2
            }
        }
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if selectedDataType != nil{
            if selectedDataType! == .kReservationOptions || selectedDataType! == .kOrderOptions{
                if section == 0{
                    return 1
                }
            }
        }
        return arrManagements.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if selectedDataType != nil{
            if selectedDataType! == .kReservationOptions || selectedDataType! == .kOrderOptions{
                if indexPath.section == 0{
                    let cell = tableView.dequeueReusableCell(withIdentifier: "OnlineOptionViewCell", for: indexPath) as! OnlineOptionViewCell
                    if selectedDataType! == .kReservationOptions{
                        cell.lblTitle.text = "Accepting reservation"
                        if let data = AppConstants.restaurantData, data.bookingStatus ?? "" == "Yes"{
                            cell.switchOption.isOn = true
                        }else{
                            cell.switchOption.isOn = false
                        }
                    }else{
                        cell.lblTitle.text = "Accepting order"
                        if let data = AppConstants.restaurantData, data.orderEnable ?? "" == "Yes"{
                            cell.switchOption.isOn = true
                        }else{
                            cell.switchOption.isOn = false
                        }
                    }
                    return cell
                }
            }
        }
        let cell = tableView.dequeueReusableCell(withIdentifier: "PaymentDashboardCell", for: indexPath) as! PaymentDashboardCell
        let model = arrManagements[indexPath.row]
        cell.lblTitle.text = model.title
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if selectedDataType != nil{
            if selectedDataType! == .kReservationOptions || selectedDataType! == .kOrderOptions{
                if indexPath.section == 0{
                    return
                }
            }
        }
        switch arrManagements[indexPath.row].type {
        case .kOrderOptions:
            if let _ = DataManagementVC.addToParentView(parentVC: self.parentVC, type: arrManagements[indexPath.row].type){
                
            }
            return
        case .kOpeningHours:
            if let _ = DataManagementVC.addToParentView(parentVC: self.parentVC, type: arrManagements[indexPath.row].type){
                
            }
            return
        case .kOffers:
            if let _ = DataManagementVC.addToParentView(parentVC: self.parentVC, type: arrManagements[indexPath.row].type){
                
            }
            return
        case .kDeliveryFee:
            if let _ = DeliveryFeeVC.instance(parentVC: self.parentVC){
            }
            return
        case .kOrderRequirement:
            if let _ = OrderRequirmentVC.instance(parentVC: self.parentVC){
            }
            return
        case .kPreOrderOptions:
            if let _ = PreOrderVC.instance(parentVC: self.parentVC){
            }
            return
        case .kDiscountCode:
            if let _ = AutoDiscountVC.instance(parentVC: self.parentVC, viewType: arrManagements[indexPath.row].type){
            }
            return
        case .kAutoDiscount:
            if let _ = AutoDiscountVC.instance(parentVC: self.parentVC, viewType: arrManagements[indexPath.row].type){
            }
            return
        case .kDineInOptions:
            if let _ = DineOptionVC.instance(parentVC: self.parentVC){
            }
            return
        case .kDeliveryHour:
            if let _ = DeliveryHoursVC.instance(parentVC: self.parentVC, viewType: arrManagements[indexPath.row].type){
            }
            return
        case .kCollectionHour:
            if let _ = DeliveryHoursVC.instance(parentVC: self.parentVC, viewType: arrManagements[indexPath.row].type){
            }
            return
        case .kReservationOptions:
            if let _ = DataManagementVC.addToParentView(parentVC: self.parentVC, type: arrManagements[indexPath.row].type){
                
            }
            return
        default:
            break
        }
        selectedDataType = arrManagements[indexPath.row].type
        var strMessage = AppConstants.GlobalAlert.ALERT_ALL_DATA_WIPE
        if selectedDataType == .kEreaseAllOrders{
            strMessage = AppConstants.GlobalAlert.ALERT_ALL_ORDER_WIPE
        }else if selectedDataType == .kEraseAllReservation{
            strMessage = AppConstants.GlobalAlert.ALERT_ALL_RESERVATION_WIPE
        }else if selectedDataType == .kEraseCallerIDLog{
            strMessage = AppConstants.GlobalAlert.ALERT_THECALLEDID_WIPE
        }else if selectedDataType == .kEraseCashDrawerLog{
            strMessage = AppConstants.GlobalAlert.ALERT_CASHDRAWER_WIPE
        }
        var setting = AlertSetting()
        setting.alertTitle = AppConstants.GlobalAlert.ALERT_CONFIRM_TITLE
        setting.alertMessage = strMessage
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: setting){
            VC.delegate = self
        }
    }
}

//MARK: AlertControllerDelegate
extension DataManagementVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            if type == .kNormal{
                var strMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_FACTRORY_RESET
                if selectedDataType == .kEreaseAllOrders{
                    strMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_ERASEORDER
                }else if selectedDataType == .kEraseAllReservation{
                    strMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_ERASERESERVATION
                }else if selectedDataType == .kEraseCallerIDLog{
                    strMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_ERASECALLEDID
                }else if selectedDataType == .kEraseCashDrawerLog{
                    strMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_ERASECASHDRAWER
                }
                var setting = AlertSetting()
                setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
                setting.alertMessage = strMessage
                setting.type = .kEnterUserPassword
                setting.textPlcaeholder = "password"
                setting.textType = .default
                if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: setting){
                    VC.delegate = self
                }
            }else{
                CallResetAPI()
            }
        }else{
            tblSettings.reloadData()
        }
    }
}
