//
//  DeliveryFeeVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 04/12/20.
//

import UIKit

class DeliveryFeeVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var switchFreeDelivery:UISwitch!
    @IBOutlet weak var lblFreeDeliveryDistance:UILabel!
    @IBOutlet weak var tblDeliveryFee:UITableView!
    @IBOutlet weak var viewForFreeDelivery:UIView!
    @IBOutlet weak var viewForFreeDeliveryDistance:UIView!
    
    //MARK: Instances
    var arrDeliveryFee = [deliverySettingsModel]()
    var selectedRowIndex = 0
    var freeDeliveryDitance:Double = 0
    var parentVC:SettingsMainVC!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        arrDeliveryFee = (AppConstants.restaurantData?.deliverySetting ?? [deliverySettingsModel]()).filter({ (model) -> Bool in
            return model.deliveryCharge ?? 0 != 0
        })
        let arr = (AppConstants.restaurantData?.deliverySetting ?? [deliverySettingsModel]()).filter { (model) -> Bool in
            return model.deliveryCharge ?? 0 == 0
        }
        if arr.count > 0{
            freeDeliveryDitance = arr[0].deliveryMile ?? 0
            viewForFreeDeliveryDistance.isHidden = false
            var deliveryRect = viewForFreeDelivery.frame
            deliveryRect.size.height = 106
            switchFreeDelivery.isOn = true
            viewForFreeDelivery.frame = deliveryRect
            lblFreeDeliveryDistance.text = String.init(format: "%.0f miles", freeDeliveryDitance)

        }
    }
    
    //MARK: Create Viewcontrlloer instance
    static func instance(parentVC:SettingsMainVC)->DeliveryFeeVC?{
        guard let VC = UIStoryboard.init(name: "Settings", bundle: nil).instantiateViewController(withIdentifier: "DeliveryFeeVC") as? DeliveryFeeVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: General Methods
    func checkValidation()->Bool{
        for model in arrDeliveryFee{
            if model.deliveryCharge ?? 0 == 0{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.deliveryFeeNotZero, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return false
            }
            if model.deliveryMile ?? 0 == 0{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.deliveryDistanceNotZero, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return false
            }
        }
        return true
    }
    
    //MARK: Button Action
    @IBAction func btnBackAction(_ sender:UIButton){
        self.view.removeFromSuperview()
        self.removeFromParent()
    }
    
    @IBAction func freeDeliveryChanged(_ sender:UISwitch){
        if switchFreeDelivery.isOn{
            var settings = AlertSetting()
            settings.alertTitle = AppConstants.GlobalAlert.ALERT_SELECT_DISTANCE_TITLE
            settings.type = .kEnterPercentage
            settings.textPlcaeholder = "distance"
            settings.titleColor = AppConstants.Colors.kAppLightGrayColor
            selectedRowIndex = 987654
            if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: settings){
                VC.delegate = self
            }
        }else{
            freeDeliveryDitance = 0
            viewForFreeDeliveryDistance.isHidden = true
            var deliveryRect = viewForFreeDelivery.frame
            deliveryRect.size.height = 36
            viewForFreeDelivery.frame = deliveryRect
            tblDeliveryFee.reloadData()
        }
        
    }
    
    @IBAction func btnUpdateAction(_ sender:UIButton){
        if checkValidation(){
            CallSaveDeliveryFee()
        }
    }
    
    @IBAction func btnRemoveFeeAction(_ sender:UIButton){
        arrDeliveryFee.remove(at: sender.tag)
        tblDeliveryFee.reloadData()
    }
    
    @IBAction func btnAddAnotherAction(_ sender:UIButton){
        var settings = AlertSetting()
        settings.alertTitle = AppConstants.GlobalAlert.ALERT_SELECT_DISTANCE_TITLE
        settings.type = .kEnterPercentage
        settings.textPlcaeholder = "distance"
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        selectedRowIndex = arrDeliveryFee.count
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: settings){
            VC.delegate = self
        }
    }
    
    @IBAction func btnDeliveryFeeAction(_ sender:UIButton){
        var settings = AlertSetting()
        settings.alertTitle = AppConstants.GlobalAlert.ALERT_SELECT_AMOUNT_TITLE
        settings.type = .kEnterAmount
        settings.textPlcaeholder = "amount"
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        settings.textTitle = String.init(format: "%@%.2f", AppConstants.currencySign,arrDeliveryFee[sender.tag].deliveryCharge ?? 0)
        selectedRowIndex = sender.tag
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: settings){
            VC.delegate = self
        }
    }
    
    @IBAction func btnDeliveryDistanceAction(_ sender:UIButton){
        var settings = AlertSetting()
        settings.alertTitle = AppConstants.GlobalAlert.ALERT_SELECT_DISTANCE_TITLE
        settings.type = .kEnterPercentage
        settings.textPlcaeholder = "distance"
        if sender.tag == 987654{
            settings.textTitle = String.init(format: "%.2f", freeDeliveryDitance)
        }else{
            settings.textTitle = String.init(format: "%.2f", arrDeliveryFee[sender.tag].deliveryMile ?? 0)
        }
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        selectedRowIndex = sender.tag
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: settings){
            VC.delegate = self
        }
    }
    
    //MARK: WebService Methods
    func CallSaveDeliveryFee(){
        var dictParam = [String:Any]()
        var arrFee = [NSMutableDictionary]()
        if freeDeliveryDitance != 0{
            let dict = NSMutableDictionary()
            dict["delivery_charge"] = "0"
            dict["delivery_miles"] = "\(freeDeliveryDitance)"
            arrFee.append(dict)
        }
        for arr in arrDeliveryFee{
            let dict = NSMutableDictionary()
            dict["delivery_charge"] = "\(arr.deliveryCharge ?? 0)"
            dict["delivery_miles"] = "\(arr.deliveryMile ?? 0)"
            arrFee.append(dict)
        }
        dictParam["delivery_setting"] = AppCommonMethods.convertJsontoString(json: arrFee)
        
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kRestaurant)\(AppConstants.webResId ?? "")", method: "POST", isRestaurantAPI:true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let result = response as? NSDictionary, let jsonData = AppCommonMethods.convertToJson(object: result), let aLoginData = try? jsonDecoder.decode(RestaurantDetailModel.self, from: jsonData){
                    var settings = BottomAlertSettings()
                    settings.strMessage = "Delivery fees has been updated"
                    AppValidation().showBottomAlertView(settings: settings)
                    if let encoded = AppCommonMethods.getjsonDataFromCodable(object: aLoginData) {
                        AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kUserData)
                    }
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
}

//MARK: UITableViewDataSource
extension DeliveryFeeVC:UITableViewDataSource,UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrDeliveryFee.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "DeliveryFeeCell", for: indexPath) as! DeliveryFeeCell
        let deliveryData = arrDeliveryFee[indexPath.row]
        cell.lblDeliveryFee.text = String.init(format: "%@%.2f", AppConstants.currencySign,deliveryData.deliveryCharge ?? 0)
        cell.lblDeliveryDitance.text = String.init(format: "%.1f miles", deliveryData.deliveryMile ?? 0)
        cell.btnRemove.tag = indexPath.row
        cell.btnDeliveryFee.tag = indexPath.row
        cell.btnDeliveryDistance.tag = indexPath.row
        cell.lblDeliveryFeeTitle.text = "Delivery Fee \(indexPath.row+1)"
        return cell
    }
}

//MARK: AlertControllerDelegate
extension DeliveryFeeVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            if selectedRowIndex == 987654{
                freeDeliveryDitance = Double(data.value) ?? 0
                viewForFreeDeliveryDistance.isHidden = false
                var deliveryRect = viewForFreeDelivery.frame
                deliveryRect.size.height = 106
                viewForFreeDelivery.frame = deliveryRect
                lblFreeDeliveryDistance.text = String.init(format: "%.0f miles", freeDeliveryDitance)
            }else{
                if selectedRowIndex < arrDeliveryFee.count{
                    if type == .kEnterAmount{
                        arrDeliveryFee[selectedRowIndex].deliveryCharge = Double(data.value) ?? 0
                    }else{
                        let index = arrDeliveryFee.firstIndex { (model) -> Bool in
                            return model.deliveryMile ?? 0 == Double(data.value) ?? 0
                        }
                        if index != nil{
                            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.DELIVERY_FEE_DISTANCE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                                
                            }
                        }else{
                            arrDeliveryFee[selectedRowIndex].deliveryMile = Double(data.value) ?? 0
                        }
                        
                    }
                }else{
                    arrDeliveryFee.append(deliverySettingsModel.init(deliveryCharge: 0, deliveryMile: Double(data.value) ?? 0))
                }
            }
            tblDeliveryFee.reloadData()
        }else{
            if selectedRowIndex == 987654{
                switchFreeDelivery.isOn = false
            }
        }
    }
}
