//
//  DeliveryHoursVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 21/12/20.
//

import UIKit
import RangeSeekSlider

class DeliveryHoursVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var tblMorningHours:UITableView!
    @IBOutlet weak var tblEveningHours:UITableView!
    @IBOutlet weak var lblOpenStatus:UILabel!
    @IBOutlet weak var switchStatus:UISwitch!
    @IBOutlet weak var lblMorningLine:UILabel!
    @IBOutlet weak var lblEveningLine:UILabel!
    
    //MARK: Instances
    var selectedTab = 0
    var userModel:RestaurantDetailModel?
    var viewType = SettingManagementType.kDeliveryHour
    var editTimeIndex = 0
    var parentVC:SettingsMainVC!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        userModel = AppConstants.restaurantData
    }
    
    //MARK: Create Viewcontrlloer instance
    static func instance(parentVC:SettingsMainVC,viewType:SettingManagementType)->DeliveryHoursVC?{
        guard let VC = UIStoryboard.init(name: "Settings", bundle: nil).instantiateViewController(withIdentifier: "DeliveryHoursVC") as? DeliveryHoursVC else {
            return nil
        }
        VC.parentVC = parentVC
        VC.viewType = viewType
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: Button Actions
    @IBAction func btnTabAction(_ sender:UIButton){
        selectedTab = sender.tag
        if selectedTab == 0{
            lblMorningLine.isHidden = false
            lblEveningLine.isHidden = true
            tblMorningHours.isHidden = false
            tblEveningHours.isHidden = true
        }else{
            lblMorningLine.isHidden = true
            lblEveningLine.isHidden = false
            tblMorningHours.isHidden = true
            tblEveningHours.isHidden = false
        }
    }
    
    @IBAction func btnEditTimeAction(_ sender:UIButton){
        editTimeIndex = sender.tag
        var strToTime = ""
        var strFromTime = ""
        switch sender.tag {
        case 0:
            if viewType == .kDeliveryHour{
                strFromTime = (selectedTab == 0) ? (userModel?.mondayFirstOpentime ?? "") : (userModel?.mondaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.mondayFirstClosetime ?? "") : (userModel?.mondaySecondClosetime ?? "")
            }else{
                strFromTime = (selectedTab == 0) ? (userModel?.pickupTime?.mondayFirstOpentime ?? "") : (userModel?.pickupTime?.mondaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.pickupTime?.mondayFirstClosetime ?? "") : (userModel?.pickupTime?.mondaySecondClosetime ?? "")
            }
        case 1:
            if viewType == .kDeliveryHour{
                strFromTime = (selectedTab == 0) ? (userModel?.tuesdayFirstOpentime ?? "") : (userModel?.tuesdaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.tuesdayFirstClosetime ?? "") : (userModel?.tuesdaySecondClosetime ?? "")
            }else{
                strFromTime = (selectedTab == 0) ? (userModel?.pickupTime?.tuesdayFirstOpentime ?? "") : (userModel?.pickupTime?.tuesdaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.pickupTime?.tuesdayFirstClosetime ?? "") : (userModel?.pickupTime?.tuesdaySecondClosetime ?? "")
            }
        case 2:
            if viewType == .kDeliveryHour{
                strFromTime = (selectedTab == 0) ? (userModel?.wednesdayFirstOpentime ?? "") : (userModel?.wednesdaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.wednesdayFirstClosetime ?? "") : (userModel?.wednesdaySecondClosetime ?? "")
            }else{
                strFromTime = (selectedTab == 0) ? (userModel?.pickupTime?.wednesdayFirstOpentime ?? "") : (userModel?.pickupTime?.wednesdaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.pickupTime?.wednesdayFirstClosetime ?? "") : (userModel?.pickupTime?.wednesdaySecondClosetime ?? "")
            }
        case 3:
            if viewType == .kDeliveryHour{
                strFromTime = (selectedTab == 0) ? (userModel?.thursdayFirstOpentime ?? "") : (userModel?.thursdaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.thursdayFirstClosetime ?? "") : (userModel?.thursdaySecondClosetime ?? "")
            }else{
                strFromTime = (selectedTab == 0) ? (userModel?.pickupTime?.thursdayFirstOpentime ?? "") : (userModel?.pickupTime?.thursdaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.pickupTime?.thursdayFirstClosetime ?? "") : (userModel?.pickupTime?.thursdaySecondClosetime ?? "")
            }
        case 4:
            if viewType == .kDeliveryHour{
                strFromTime = (selectedTab == 0) ? (userModel?.fridayFirstOpentime ?? "") : (userModel?.fridaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.fridayFirstClosetime ?? "") : (userModel?.fridaySecondClosetime ?? "")
            }else{
                strFromTime = (selectedTab == 0) ? (userModel?.pickupTime?.fridayFirstOpentime ?? "") : (userModel?.pickupTime?.fridaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.pickupTime?.fridayFirstClosetime ?? "") : (userModel?.pickupTime?.fridaySecondClosetime ?? "")
            }
        case 5:
            if viewType == .kDeliveryHour{
                strFromTime = (selectedTab == 0) ? (userModel?.saturdayFirstOpentime ?? "") : (userModel?.saturdaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.saturdayFirstClosetime ?? "") : (userModel?.saturdaySecondClosetime ?? "")
            }else{
                strFromTime = (selectedTab == 0) ? (userModel?.pickupTime?.saturdayFirstOpentime ?? "") : (userModel?.pickupTime?.saturdaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.pickupTime?.saturdayFirstClosetime ?? "") : (userModel?.pickupTime?.saturdaySecondClosetime ?? "")
            }
        case 6:
            if viewType == .kDeliveryHour{
                strFromTime = (selectedTab == 0) ? (userModel?.sundayFirstOpentime ?? "") : (userModel?.sundaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.sundayFirstClosetime ?? "") : (userModel?.sundaySecondClosetime ?? "")
            }else{
                strFromTime = (selectedTab == 0) ? (userModel?.pickupTime?.sundayFirstOpentime ?? "") : (userModel?.pickupTime?.sundaySecondOpentime ?? "")
                strToTime = (selectedTab == 0) ? (userModel?.pickupTime?.sundayFirstClosetime ?? "") : (userModel?.pickupTime?.sundaySecondClosetime ?? "")
            }
        default:
            break
        }
        if let VC = TimeRangeVC.showPopup(parentVC: self.parentVC.parentVC, fromTime: strFromTime, toTime: strToTime){
            VC.delegate = self
        }
    }
    
    @IBAction func btnBackAction(_ sender:UIButton){
        self.view.removeFromSuperview()
        self.removeFromParent()
    }
    
    @IBAction func btnUpdateAction(_ sender:UIButton){
        saveOpeningHourData()
    }
    
    @IBAction func switchMainStatusAction(_ sender:UISwitch){
        if switchStatus.isOn{
            lblOpenStatus.text = "Open"
            if viewType == .kDeliveryHour{
                userModel?.mondayStatus = ""
                userModel?.tuesdayStatus = ""
                userModel?.wednesdayStatus = ""
                userModel?.thursdayStatus = ""
                userModel?.fridayStatus = ""
                userModel?.saturdayStatus = ""
                userModel?.sundayStatus = ""
            }else{
                userModel?.pickupTime?.mondayStatus = ""
                userModel?.pickupTime?.tuesdayStatus = ""
                userModel?.pickupTime?.wednesdayStatus = ""
                userModel?.pickupTime?.thursdayStatus = ""
                userModel?.pickupTime?.fridayStatus = ""
                userModel?.pickupTime?.saturdayStatus = ""
                userModel?.pickupTime?.sundayStatus = ""
            }
        }else{
            lblOpenStatus.text = "Closed"
            if viewType == .kDeliveryHour{
                userModel?.mondayStatus = "Close"
                userModel?.tuesdayStatus = "Close"
                userModel?.wednesdayStatus = "Close"
                userModel?.thursdayStatus = "Close"
                userModel?.fridayStatus = "Close"
                userModel?.saturdayStatus = "Close"
                userModel?.sundayStatus = "Close"
            }else{
                userModel?.pickupTime?.mondayStatus = "Close"
                userModel?.pickupTime?.tuesdayStatus = "Close"
                userModel?.pickupTime?.wednesdayStatus = "Close"
                userModel?.pickupTime?.thursdayStatus = "Close"
                userModel?.pickupTime?.fridayStatus = "Close"
                userModel?.pickupTime?.saturdayStatus = "Close"
                userModel?.pickupTime?.sundayStatus = "Close"
            }
        }
        tblEveningHours.reloadData()
        tblMorningHours.reloadData()
    }
    
    @IBAction func switchDayStatusAction(_ sender:UISwitch){
        switch sender.tag {
        case 0:
            if viewType == .kDeliveryHour{
                userModel?.mondayStatus = sender.isOn ? "" : "Close"
            }else{
                userModel?.pickupTime?.mondayStatus = sender.isOn ? "" : "Close"
            }
        case 1:
            if viewType == .kDeliveryHour{
                userModel?.tuesdayStatus = sender.isOn ? "" : "Close"
            }else{
                userModel?.pickupTime?.tuesdayStatus = sender.isOn ? "" : "Close"
            }
        case 2:
            if viewType == .kDeliveryHour{
                userModel?.wednesdayStatus = sender.isOn ? "" : "Close"
            }else{
                userModel?.pickupTime?.wednesdayStatus = sender.isOn ? "" : "Close"
            }
        case 3:
            if viewType == .kDeliveryHour{
                userModel?.thursdayStatus = sender.isOn ? "" : "Close"
            }else{
                userModel?.pickupTime?.mondayStatus = sender.isOn ? "" : "Close"
            }
        case 4:
            if viewType == .kDeliveryHour{
                userModel?.fridayStatus = sender.isOn ? "" : "Close"
            }else{
                userModel?.pickupTime?.fridayStatus = sender.isOn ? "" : "Close"
            }
        case 5:
            if viewType == .kDeliveryHour{
                userModel?.saturdayStatus = sender.isOn ? "" : "Close"
            }else{
                userModel?.pickupTime?.saturdayStatus = sender.isOn ? "" : "Close"
            }
        case 6:
            if viewType == .kDeliveryHour{
                userModel?.sundayStatus = sender.isOn ? "" : "Close"
            }else{
                userModel?.pickupTime?.sundayStatus = sender.isOn ? "" : "Close"
            }
        default:
            break
        }
        tblEveningHours.reloadData()
        tblMorningHours.reloadData()
    }
    
    //MARK: WebService Methods
    func saveOpeningHourData(){
        var dictParam = [String:Any]()
        
        if viewType == .kCollectionHour{
            let dictPickTime = NSMutableDictionary()
            dictPickTime["pick_monday_status"] = userModel?.pickupTime?.mondayStatus ?? ""
            dictPickTime["pick_monday_first_opentime"] = userModel?.pickupTime?.mondayFirstOpentime ?? ""
            dictPickTime["pick_monday_first_closetime"] = userModel?.pickupTime?.mondayFirstClosetime ?? ""
            dictPickTime["pick_monday_second_opentime"] = userModel?.pickupTime?.mondaySecondOpentime ?? ""
            dictPickTime["pick_monday_second_closetime"] = userModel?.pickupTime?.mondaySecondClosetime ?? ""
            dictPickTime["pick_tuesday_status"] = userModel?.pickupTime?.tuesdayStatus ?? ""
            dictPickTime["pick_tuesday_first_opentime"] = userModel?.pickupTime?.tuesdayFirstOpentime ?? ""
            dictPickTime["pick_tuesday_first_closetime"] = userModel?.pickupTime?.tuesdayFirstClosetime ?? ""
            dictPickTime["pick_tuesday_second_opentime"] = userModel?.pickupTime?.tuesdaySecondOpentime ?? ""
            dictPickTime["pick_tuesday_second_closetime"] = userModel?.pickupTime?.tuesdaySecondClosetime ?? ""
            dictPickTime["pick_wednesday_status"] = userModel?.pickupTime?.wednesdayStatus ?? ""
            dictPickTime["pick_wednesday_first_opentime"] = userModel?.pickupTime?.wednesdayFirstOpentime ?? ""
            dictPickTime["pick_wednesday_first_closetime"] = userModel?.pickupTime?.wednesdayFirstClosetime ?? ""
            dictPickTime["pick_wednesday_second_opentime"] = userModel?.pickupTime?.wednesdaySecondOpentime ?? ""
            dictPickTime["pick_wednesday_second_closetime"] = userModel?.pickupTime?.wednesdaySecondClosetime ?? ""
            dictPickTime["pick_thursday_status"] = userModel?.pickupTime?.thursdayStatus ?? ""
            dictPickTime["pick_thursday_first_opentime"] = userModel?.pickupTime?.thursdayFirstOpentime ?? ""
            dictPickTime["pick_thursday_first_closetime"] = userModel?.pickupTime?.thursdayFirstClosetime ?? ""
            dictPickTime["pick_thursday_second_opentime"] = userModel?.pickupTime?.thursdaySecondOpentime ?? ""
            dictPickTime["pick_thursday_second_closetime"] = userModel?.pickupTime?.thursdaySecondClosetime ?? ""
            dictPickTime["pick_friday_status"] = userModel?.pickupTime?.fridayStatus ?? ""
            dictPickTime["pick_friday_first_opentime"] = userModel?.pickupTime?.fridayFirstOpentime ?? ""
            dictPickTime["pick_friday_first_closetime"] = userModel?.pickupTime?.fridayFirstClosetime ?? ""
            dictPickTime["pick_friday_second_opentime"] = userModel?.pickupTime?.fridaySecondOpentime ?? ""
            dictPickTime["pick_friday_second_closetime"] = userModel?.pickupTime?.fridaySecondClosetime ?? ""
            dictPickTime["pick_saturday_status"] = userModel?.pickupTime?.saturdayStatus ?? ""
            dictPickTime["pick_saturday_first_opentime"] = userModel?.pickupTime?.saturdayFirstOpentime ?? ""
            dictPickTime["pick_saturday_first_closetime"] = userModel?.pickupTime?.saturdayFirstClosetime ?? ""
            dictPickTime["pick_saturday_second_opentime"] = userModel?.pickupTime?.saturdaySecondOpentime ?? ""
            dictPickTime["pick_saturday_second_closetime"] = userModel?.pickupTime?.saturdaySecondClosetime ?? ""
            dictPickTime["pick_sunday_status"] = userModel?.pickupTime?.sundayStatus ?? ""
            dictPickTime["pick_sunday_first_opentime"] = userModel?.pickupTime?.sundayFirstOpentime ?? ""
            dictPickTime["pick_sunday_first_closetime"] = userModel?.pickupTime?.sundayFirstClosetime ?? ""
            dictPickTime["pick_sunday_second_opentime"] = userModel?.pickupTime?.sundaySecondOpentime ?? ""
            dictPickTime["pick_sunday_second_closetime"] = userModel?.pickupTime?.sundaySecondClosetime ?? ""
            dictPickTime["pick_sunday_second_closetime"] = userModel?.pickupTime?.sundaySecondClosetime ?? ""
            dictPickTime["pick_sunday_second_closetime"] = userModel?.pickupTime?.sundaySecondClosetime ?? ""
            
            dictPickTime["id"] = userModel?.pickupTime?.id ?? 0
            dictPickTime["pick_working_time"] = userModel?.pickupTime?.pickWorkingTime ?? ""
            dictPickTime["restaurant_id"] = AppConstants.webResId ?? ""
            dictParam["restaurant_timing"] = AppCommonMethods.convertJsontoString(json: dictPickTime)
            
        }else{
            dictParam["thursday_status"] = userModel?.thursdayStatus ?? ""
            dictParam["thursday_first_opentime"] = userModel?.thursdayFirstOpentime ?? ""
            dictParam["thursday_first_closetime"] = userModel?.thursdayFirstClosetime ?? ""
            dictParam["thursday_second_opentime"] = userModel?.thursdaySecondOpentime ?? ""
            dictParam["thursday_second_closetime"] = userModel?.thursdaySecondClosetime ?? ""
            dictParam["friday_status"] = userModel?.fridayStatus ?? ""
            dictParam["friday_first_opentime"] = userModel?.fridayFirstOpentime ?? ""
            dictParam["friday_first_closetime"] = userModel?.fridayFirstClosetime ?? ""
            dictParam["friday_second_opentime"] = userModel?.fridaySecondOpentime ?? ""
            dictParam["friday_second_closetime"] = userModel?.fridaySecondClosetime ?? ""
            dictParam["saturday_status"] = userModel?.saturdayStatus ?? ""
            dictParam["saturday_first_opentime"] = userModel?.saturdayFirstOpentime ?? ""
            dictParam["saturday_first_closetime"] = userModel?.saturdayFirstClosetime ?? ""
            dictParam["saturday_second_opentime"] = userModel?.saturdaySecondOpentime ?? ""
            dictParam["saturday_second_closetime"] = userModel?.saturdaySecondClosetime ?? ""
            dictParam["sunday_status"] = userModel?.sundayStatus ?? ""
            dictParam["sunday_first_opentime"] = userModel?.sundayFirstOpentime ?? ""
            dictParam["sunday_first_closetime"] = userModel?.sundayFirstClosetime ?? ""
            dictParam["sunday_second_opentime"] = userModel?.sundaySecondOpentime ?? ""
            dictParam["sunday_second_closetime"] = userModel?.sundaySecondClosetime ?? ""
            dictParam["wednesday_status"] = userModel?.wednesdayStatus ?? ""
            dictParam["wednesday_first_opentime"] = userModel?.wednesdayFirstOpentime ?? ""
            dictParam["wednesday_first_closetime"] = userModel?.wednesdayFirstClosetime ?? ""
            dictParam["wednesday_second_opentime"] = userModel?.wednesdaySecondOpentime ?? ""
            dictParam["wednesday_second_closetime"] = userModel?.wednesdaySecondClosetime ?? ""
            dictParam["tuesday_status"] = userModel?.tuesdayStatus ?? ""
            dictParam["tuesday_first_opentime"] = userModel?.tuesdayFirstOpentime ?? ""
            dictParam["tuesday_first_closetime"] = userModel?.tuesdayFirstClosetime ?? ""
            dictParam["tuesday_second_opentime"] = userModel?.tuesdaySecondOpentime ?? ""
            dictParam["tuesday_second_closetime"] = userModel?.tuesdaySecondClosetime ?? ""
            dictParam["monday_status"] = userModel?.mondayStatus ?? ""
            dictParam["monday_first_opentime"] = userModel?.mondayFirstOpentime ?? ""
            dictParam["monday_first_closetime"] = userModel?.mondayFirstClosetime ?? ""
            dictParam["monday_second_opentime"] = userModel?.mondaySecondOpentime ?? ""
            dictParam["monday_second_closetime"] = userModel?.mondaySecondClosetime ?? ""
        }
        
        if AppConstants.isInDevlopmentMode{
            print("rest time Parameter:",dictParam)
        }
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kRestaurant)\(AppConstants.webResId ?? "")", method: "POST", isRestaurantAPI:true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let result = response as? NSDictionary, let jsonData = AppCommonMethods.convertToJson(object: result), let aLoginData = try? jsonDecoder.decode(RestaurantDetailModel.self, from: jsonData){
                    var settings = BottomAlertSettings()
                    settings.strMessage = (self.viewType == .kCollectionHour) ? "Collection hours has been updated" : "Delivery hours has been updated"
                    AppValidation().showBottomAlertView(settings: settings)
                    if let encoded = AppCommonMethods.getjsonDataFromCodable(object: aLoginData) {
                        AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kUserData)
                    }
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    //MARK: General Methods
    func getProgressFromTime(strTime:String)->CGFloat{
        let timer = strTime.changeDateFormat(fromFormat: "hh:mm a", toFormat: "HH:mm") ?? ""
        let hour = Int(timer.components(separatedBy: ":").first ?? "") ?? 0
        let minute = Int(timer.components(separatedBy: ":").last ?? "") ?? 0
        let selectedMin = CGFloat(minute) + CGFloat(hour*60)
        return selectedMin
    }
    
    func getTimeFromProgress(progress:CGFloat)->String{
        var minute = Int(progress)
        let hr = Int(minute/60)
        minute = minute - (hr*60)
        return "\(hr):\(minute)".changeDateFormat(fromFormat: "H:m", toFormat: "hh:mm a") ?? ""
    }
}

//MARK: UITableViewDataSource
extension DeliveryHoursVC:UITableViewDataSource,UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 7
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "DeliveryHourCell", for: indexPath) as! DeliveryHourCell
        cell.btnEditTime.tag = indexPath.row
        cell.switchStatus.tag = indexPath.row
        let mondayOpen1 = (viewType == .kDeliveryHour) ? userModel?.mondayFirstOpentime ?? "" : userModel?.pickupTime?.mondayFirstOpentime ?? ""
        let mondayOpen2 = (viewType == .kDeliveryHour) ? userModel?.mondaySecondOpentime ?? "" : userModel?.pickupTime?.mondaySecondOpentime ?? ""
        let mondayClose1 = (viewType == .kDeliveryHour) ? userModel?.mondayFirstClosetime ?? "" : userModel?.pickupTime?.mondayFirstClosetime ?? ""
        let mondayClose2 = (viewType == .kDeliveryHour) ? userModel?.mondaySecondClosetime ?? "" : userModel?.pickupTime?.mondaySecondClosetime ?? ""
        
        let tuesdayOpen1 = (viewType == .kDeliveryHour) ? userModel?.tuesdayFirstOpentime ?? "" : userModel?.pickupTime?.tuesdayFirstOpentime ?? ""
        let tuesdayOpen2 = (viewType == .kDeliveryHour) ? userModel?.tuesdaySecondOpentime ?? "" : userModel?.pickupTime?.tuesdaySecondOpentime ?? ""
        let tuesdayClose1 = (viewType == .kDeliveryHour) ? userModel?.tuesdayFirstClosetime ?? "" : userModel?.pickupTime?.tuesdayFirstClosetime ?? ""
        let tuesdayClose2 = (viewType == .kDeliveryHour) ? userModel?.tuesdaySecondClosetime ?? "" : userModel?.pickupTime?.tuesdaySecondClosetime ?? ""
        
        let wednesdayOpen1 = (viewType == .kDeliveryHour) ? userModel?.wednesdayFirstOpentime ?? "" : userModel?.pickupTime?.wednesdayFirstOpentime ?? ""
        let wednesdayOpen2 = (viewType == .kDeliveryHour) ? userModel?.wednesdaySecondOpentime ?? "" : userModel?.pickupTime?.wednesdaySecondOpentime ?? ""
        let wednesdayClose1 = (viewType == .kDeliveryHour) ? userModel?.wednesdayFirstClosetime ?? "" : userModel?.pickupTime?.wednesdayFirstClosetime ?? ""
        let wednesdayClose2 = (viewType == .kDeliveryHour) ? userModel?.wednesdaySecondClosetime ?? "" : userModel?.pickupTime?.wednesdaySecondClosetime ?? ""
        
        let thursdayOpen1 = (viewType == .kDeliveryHour) ? userModel?.thursdayFirstOpentime ?? "" : userModel?.pickupTime?.thursdayFirstOpentime ?? ""
        let thursdayOpen2 = (viewType == .kDeliveryHour) ? userModel?.thursdaySecondOpentime ?? "" : userModel?.pickupTime?.thursdaySecondOpentime ?? ""
        let thursdayClose1 = (viewType == .kDeliveryHour) ? userModel?.thursdayFirstClosetime ?? "" : userModel?.pickupTime?.thursdayFirstClosetime ?? ""
        let thursdayClose2 = (viewType == .kDeliveryHour) ? userModel?.thursdaySecondClosetime ?? "" : userModel?.pickupTime?.thursdaySecondClosetime ?? ""
        
        let fridayOpen1 = (viewType == .kDeliveryHour) ? userModel?.fridayFirstOpentime ?? "" : userModel?.pickupTime?.fridayFirstOpentime ?? ""
        let fridayOpen2 = (viewType == .kDeliveryHour) ? userModel?.fridaySecondOpentime ?? "" : userModel?.pickupTime?.fridaySecondOpentime ?? ""
        let fridayClose1 = (viewType == .kDeliveryHour) ? userModel?.fridayFirstClosetime ?? "" : userModel?.pickupTime?.fridayFirstClosetime ?? ""
        let fridayClose2 = (viewType == .kDeliveryHour) ? userModel?.fridaySecondClosetime ?? "" : userModel?.pickupTime?.fridaySecondClosetime ?? ""
        
        let saturdayOpen1 = (viewType == .kDeliveryHour) ? userModel?.saturdayFirstOpentime ?? "" : userModel?.pickupTime?.saturdayFirstOpentime ?? ""
        let saturdayOpen2 = (viewType == .kDeliveryHour) ? userModel?.saturdaySecondOpentime ?? "" : userModel?.pickupTime?.saturdaySecondOpentime ?? ""
        let saturdayClose1 = (viewType == .kDeliveryHour) ? userModel?.saturdayFirstClosetime ?? "" : userModel?.pickupTime?.saturdayFirstClosetime ?? ""
        let saturdayClose2 = (viewType == .kDeliveryHour) ? userModel?.saturdaySecondClosetime ?? "" : userModel?.pickupTime?.saturdaySecondClosetime ?? ""
        
        let sundayOpen1 = (viewType == .kDeliveryHour) ? userModel?.sundayFirstOpentime ?? "" : userModel?.pickupTime?.sundayFirstOpentime ?? ""
        let sundayOpen2 = (viewType == .kDeliveryHour) ? userModel?.sundaySecondOpentime ?? "" : userModel?.pickupTime?.sundaySecondOpentime ?? ""
        let sundayClose1 = (viewType == .kDeliveryHour) ? userModel?.sundayFirstClosetime ?? "" : userModel?.pickupTime?.sundayFirstClosetime ?? ""
        let sundayClose2 = (viewType == .kDeliveryHour) ? userModel?.sundaySecondClosetime ?? "" : userModel?.pickupTime?.sundaySecondClosetime ?? ""
        
        let mondayStatus = (viewType == .kDeliveryHour) ? userModel?.mondayStatus ?? "" : userModel?.pickupTime?.mondayStatus ?? ""
        let tuesdayStatus = (viewType == .kDeliveryHour) ? userModel?.tuesdayStatus ?? "" : userModel?.pickupTime?.tuesdayStatus ?? ""
        let wednesdayStatus = (viewType == .kDeliveryHour) ? userModel?.wednesdayStatus ?? "" : userModel?.pickupTime?.wednesdayStatus ?? ""
        let thursdayStatus = (viewType == .kDeliveryHour) ? userModel?.thursdayStatus ?? "" : userModel?.pickupTime?.thursdayStatus ?? ""
        let fridayStatus = (viewType == .kDeliveryHour) ? userModel?.fridayStatus ?? "" : userModel?.pickupTime?.fridayStatus ?? ""
        let saturdayStatus = (viewType == .kDeliveryHour) ? userModel?.saturdayStatus ?? "" : userModel?.pickupTime?.saturdayStatus ?? ""
        let sundayStatus = (viewType == .kDeliveryHour) ? userModel?.sundayStatus ?? "" : userModel?.pickupTime?.sundayStatus ?? ""
        
        if tableView == tblMorningHours{
            cell.viewForSlider.tag = indexPath.row
            cell.viewForSlider.delegate = self
            cell.lblTiming.text = "Closed"
            cell.lblStatus.text = "Closed"
            cell.switchStatus.isOn = false
            cell.viewForSlider.handleColor = .clear
            cell.viewForSlider.colorBetweenHandles = .clear
            cell.viewForSlider.isUserInteractionEnabled = false
            cell.btnEditTime.isUserInteractionEnabled = false
            
            switch indexPath.row {
            case 0:
                cell.lblDayName.text = "Monday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: mondayClose1)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: mondayOpen1)
                if mondayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(mondayOpen1) - \(mondayClose1)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
                
            case 1:
                cell.lblDayName.text = "Tuesday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: tuesdayClose1)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: tuesdayOpen1)
                if tuesdayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(tuesdayOpen1) - \(tuesdayClose1)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
            case 2:
                cell.lblDayName.text = "Wednesday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: wednesdayClose1)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: wednesdayOpen1)
                if wednesdayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(wednesdayOpen1) - \(wednesdayClose1)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
            case 3:
                cell.lblDayName.text = "Thursday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: thursdayClose1)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: thursdayOpen1)
                if thursdayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(thursdayOpen1) - \(thursdayClose1)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
            case 4:
                cell.lblDayName.text = "Friday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: fridayClose1)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: fridayOpen1)
                if fridayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(fridayOpen1) - \(fridayClose1)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
            case 5:
                cell.lblDayName.text = "Saturday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: saturdayClose1)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: saturdayOpen1)
                if saturdayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(saturdayOpen1) - \(saturdayClose1)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
            case 6:
                cell.lblDayName.text = "Sunday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: sundayClose1)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: sundayOpen1)
                if sundayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(sundayOpen1) - \(sundayClose1)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
            default:
                break
            }
            
            
            cell.viewForSlider.layoutSubviews()
        }else{
            cell.viewForSlider.tag = indexPath.row
            cell.viewForSlider.delegate = self
            cell.lblTiming.text = "Closed"
            cell.lblStatus.text = "Closed"
            cell.switchStatus.isOn = false
            cell.viewForSlider.handleColor = .clear
            cell.viewForSlider.colorBetweenHandles = .clear
            cell.viewForSlider.isUserInteractionEnabled = false
            cell.btnEditTime.isUserInteractionEnabled = false
            
            switch indexPath.row {
            case 0:
                cell.lblDayName.text = "Monday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: mondayClose2)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: mondayOpen2)
                if mondayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(mondayOpen2) - \(mondayClose2)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
                
            case 1:
                cell.lblDayName.text = "Tuesday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: tuesdayClose2)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: tuesdayOpen2)
                if tuesdayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(tuesdayOpen2) - \(tuesdayClose2)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
            case 2:
                cell.lblDayName.text = "Wednesday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: wednesdayClose2)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: wednesdayOpen2)
                if wednesdayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(wednesdayOpen2) - \(wednesdayClose2)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
            case 3:
                cell.lblDayName.text = "Thursday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: thursdayClose2)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: thursdayOpen2)
                if thursdayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(thursdayOpen2) - \(thursdayClose2)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
            case 4:
                cell.lblDayName.text = "Friday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: fridayClose2)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: fridayOpen2)
                if fridayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(fridayOpen2) - \(fridayClose2)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
            case 5:
                cell.lblDayName.text = "Saturday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: saturdayClose2)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: saturdayOpen2)
                if saturdayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(saturdayOpen2) - \(saturdayClose2)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
            case 6:
                cell.lblDayName.text = "Sunday"
                cell.viewForSlider.selectedMaxValue = getProgressFromTime(strTime: sundayClose2)
                cell.viewForSlider.selectedMinValue = getProgressFromTime(strTime: sundayOpen2)
                if sundayStatus.lowercased() != "close"{
                    cell.lblStatus.text = "Open"
                    cell.switchStatus.isOn = true
                    cell.lblTiming.text = "\(sundayOpen2) - \(sundayClose2)"
                    cell.viewForSlider.handleColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.viewForSlider.colorBetweenHandles = AppConstants.Colors.kAppMediumGrayColor
                    cell.viewForSlider.isUserInteractionEnabled = true
                    cell.btnEditTime.isUserInteractionEnabled = true
                }
            default:
                break
            }
            
            
            cell.viewForSlider.layoutSubviews()
        }
        
        
        return cell
        
    }
}

//MARK: RangeSeekSliderDelegate
extension DeliveryHoursVC:RangeSeekSliderDelegate{
    func rangeSeekSlider(_ slider: RangeSeekSlider, didChange minValue: CGFloat, maxValue: CGFloat) {
        let tblView = selectedTab == 0 ? tblMorningHours : tblEveningHours
        if let cell = tblView?.cellForRow(at: IndexPath.init(row: slider.tag, section: 0)) as? DeliveryHourCell{
            cell.lblTiming.text = "\(getTimeFromProgress(progress: minValue)) - \(getTimeFromProgress(progress: maxValue))"
            switch slider.tag {
            case 0:
                if viewType == .kDeliveryHour{
                    if selectedTab == 0{
                        userModel?.mondayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.mondayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.mondaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.mondaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }else{
                    if selectedTab == 0{
                        userModel?.pickupTime?.mondayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.mondayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.pickupTime?.mondaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.mondaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }
            case 1:
                if viewType == .kDeliveryHour{
                    if selectedTab == 0{
                        userModel?.tuesdayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.tuesdayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.tuesdaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.tuesdaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }else{
                    if selectedTab == 0{
                        userModel?.pickupTime?.tuesdayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.tuesdayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.pickupTime?.tuesdaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.tuesdaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }
            case 2:
                if viewType == .kDeliveryHour{
                    if selectedTab == 0{
                        userModel?.wednesdayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.wednesdayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.wednesdaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.wednesdaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }else{
                    if selectedTab == 0{
                        userModel?.pickupTime?.wednesdayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.wednesdayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.pickupTime?.wednesdaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.wednesdaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }
            case 3:
                if viewType == .kDeliveryHour{
                    if selectedTab == 0{
                        userModel?.thursdayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.thursdayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.thursdaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.thursdaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }else{
                    if selectedTab == 0{
                        userModel?.pickupTime?.thursdayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.thursdayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.pickupTime?.thursdaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.thursdaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }
            case 4:
                if viewType == .kDeliveryHour{
                    if selectedTab == 0{
                        userModel?.fridayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.fridayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.fridaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.fridaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }else{
                    if selectedTab == 0{
                        userModel?.pickupTime?.fridayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.fridayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.pickupTime?.fridaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.fridaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }
            case 5:
                if viewType == .kDeliveryHour{
                    if selectedTab == 0{
                        userModel?.saturdayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.saturdayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.saturdaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.saturdaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }else{
                    if selectedTab == 0{
                        userModel?.pickupTime?.saturdayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.saturdayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.pickupTime?.saturdaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.saturdaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }
            case 6:
                if viewType == .kDeliveryHour{
                    if selectedTab == 0{
                        userModel?.sundayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.sundayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.sundaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.sundaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }else{
                    if selectedTab == 0{
                        userModel?.pickupTime?.sundayFirstOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.sundayFirstClosetime = getTimeFromProgress(progress: maxValue)
                    }else{
                        userModel?.pickupTime?.sundaySecondOpentime = getTimeFromProgress(progress: minValue)
                        userModel?.pickupTime?.sundaySecondClosetime = getTimeFromProgress(progress: maxValue)
                    }
                }
            default:
                break
            }
        }
    }
}

//MARK: DateRangeDelegate
extension DeliveryHoursVC:DateRangeDelegate{
    func dateSelected(toDate: String, fromDate: String) {
        switch editTimeIndex {
        case 0:
            if viewType == .kDeliveryHour{
                if selectedTab == 0{
                    userModel?.mondayFirstOpentime = fromDate
                    userModel?.mondayFirstClosetime = toDate
                }else{
                    userModel?.mondaySecondOpentime = fromDate
                    userModel?.mondaySecondClosetime = toDate
                }
            }else{
                if selectedTab == 0{
                    userModel?.pickupTime?.mondayFirstOpentime = fromDate
                    userModel?.pickupTime?.mondayFirstClosetime = toDate
                }else{
                    userModel?.pickupTime?.mondaySecondOpentime = fromDate
                    userModel?.pickupTime?.mondaySecondClosetime = toDate
                }
            }
        case 1:
            if viewType == .kDeliveryHour{
                if selectedTab == 0{
                    userModel?.tuesdayFirstOpentime = fromDate
                    userModel?.tuesdayFirstClosetime = toDate
                }else{
                    userModel?.tuesdaySecondOpentime = fromDate
                    userModel?.tuesdaySecondClosetime = toDate
                }
            }else{
                if selectedTab == 0{
                    userModel?.pickupTime?.tuesdayFirstOpentime = fromDate
                    userModel?.pickupTime?.tuesdayFirstClosetime = toDate
                }else{
                    userModel?.pickupTime?.tuesdaySecondOpentime = fromDate
                    userModel?.pickupTime?.tuesdaySecondClosetime = toDate
                }
            }
        case 2:
            if viewType == .kDeliveryHour{
                if selectedTab == 0{
                    userModel?.wednesdayFirstOpentime = fromDate
                    userModel?.wednesdayFirstClosetime = toDate
                }else{
                    userModel?.wednesdaySecondOpentime = fromDate
                    userModel?.wednesdaySecondClosetime = toDate
                }
            }else{
                if selectedTab == 0{
                    userModel?.pickupTime?.wednesdayFirstOpentime = fromDate
                    userModel?.pickupTime?.wednesdayFirstClosetime = toDate
                }else{
                    userModel?.pickupTime?.wednesdaySecondOpentime = fromDate
                    userModel?.pickupTime?.wednesdaySecondClosetime = toDate
                }
            }
        case 3:
            if viewType == .kDeliveryHour{
                if selectedTab == 0{
                    userModel?.thursdayFirstOpentime = fromDate
                    userModel?.thursdayFirstClosetime = toDate
                }else{
                    userModel?.thursdaySecondOpentime = fromDate
                    userModel?.thursdaySecondClosetime = toDate
                }
            }else{
                if selectedTab == 0{
                    userModel?.pickupTime?.thursdayFirstOpentime = fromDate
                    userModel?.pickupTime?.thursdayFirstClosetime = toDate
                }else{
                    userModel?.pickupTime?.thursdaySecondOpentime = fromDate
                    userModel?.pickupTime?.thursdaySecondClosetime = toDate
                }
            }
        case 4:
            if viewType == .kDeliveryHour{
                if selectedTab == 0{
                    userModel?.fridayFirstOpentime = fromDate
                    userModel?.fridayFirstClosetime = toDate
                }else{
                    userModel?.fridaySecondOpentime = fromDate
                    userModel?.fridaySecondClosetime = toDate
                }
            }else{
                if selectedTab == 0{
                    userModel?.pickupTime?.fridayFirstOpentime = fromDate
                    userModel?.pickupTime?.fridayFirstClosetime = toDate
                }else{
                    userModel?.pickupTime?.fridaySecondOpentime = fromDate
                    userModel?.pickupTime?.fridaySecondClosetime = toDate
                }
            }
        case 5:
            if viewType == .kDeliveryHour{
                if selectedTab == 0{
                    userModel?.saturdayFirstOpentime = fromDate
                    userModel?.saturdayFirstClosetime = toDate
                }else{
                    userModel?.saturdaySecondOpentime = fromDate
                    userModel?.saturdaySecondClosetime = toDate
                }
            }else{
                if selectedTab == 0{
                    userModel?.pickupTime?.saturdayFirstOpentime = fromDate
                    userModel?.pickupTime?.saturdayFirstClosetime = toDate
                }else{
                    userModel?.pickupTime?.saturdaySecondOpentime = fromDate
                    userModel?.pickupTime?.saturdaySecondClosetime = toDate
                }
            }
        case 6:
            if viewType == .kDeliveryHour{
                if selectedTab == 0{
                    userModel?.sundayFirstOpentime = fromDate
                    userModel?.sundayFirstClosetime = toDate
                }else{
                    userModel?.sundaySecondOpentime = fromDate
                    userModel?.sundaySecondClosetime = toDate
                }
            }else{
                if selectedTab == 0{
                    userModel?.pickupTime?.sundayFirstOpentime = fromDate
                    userModel?.pickupTime?.sundayFirstClosetime = toDate
                }else{
                    userModel?.pickupTime?.sundaySecondOpentime = fromDate
                    userModel?.pickupTime?.sundaySecondClosetime = toDate
                }
            }
        default:
            break
        }
        tblEveningHours.reloadData()
        tblMorningHours.reloadData()
    }
}
