//
//  DineOptionVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 07/12/20.
//

import UIKit

class DineOptionVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var switchOrder:UISwitch!
    @IBOutlet weak var switchTips:UISwitch!
    @IBOutlet weak var switchCashPayment:UISwitch!
    
    //MARK: Instances
    var model:RestaurantDetailModel!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        model = AppConstants.restaurantData!
        switchOrder.isOn = (model.dineIn ?? 0 == 1)
        switchTips.isOn = (model.gratuity ?? 0 == 1)
        switchCashPayment.isOn = (model.gratuity ?? 0 == 1)
    }

    //MARK: Create Viewcontrlloer instance
    static func instance(parentVC:SettingsMainVC)->DineOptionVC?{
        guard let VC = UIStoryboard.init(name: "Settings", bundle: nil).instantiateViewController(withIdentifier: "DineOptionVC") as? DineOptionVC else {
            return nil
        }
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: Button Actions
    @IBAction func btnBackAction(_ sender:UIButton){
        self.view.removeFromSuperview()
        self.removeFromParent()
    }
    
    @IBAction func btnUpdateAction(_ sender:UIButton){
        CallSaveDineInOption()
    }
    
    //MARK: WebService Methods
    func CallSaveDineInOption(){
        var dictParam = [String:Any]()
        dictParam["dine_in"] = switchOrder.isOn ? "1" : "0"
        dictParam["gratuity"] = switchTips.isOn ? "1" : "0"
        
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kRestaurant)\(AppConstants.webResId ?? "")", method: "POST", isRestaurantAPI:true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let result = response as? NSDictionary, let jsonData = AppCommonMethods.convertToJson(object: result), let aLoginData = try? jsonDecoder.decode(RestaurantDetailModel.self, from: jsonData){
                    var settings = BottomAlertSettings()
                    settings.strMessage = "Dine in option has been updated"
                    AppValidation().showBottomAlertView(settings: settings)
                    if let encoded = AppCommonMethods.getjsonDataFromCodable(object: aLoginData) {
                        AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kUserData)
                    }
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
}
