//
//  OrderRequirmentVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 07/12/20.
//

import UIKit

class OrderRequirmentVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var lblMinOrder:UILabel!
    
    //MARK: Instances
    var parentVC:SettingsMainVC!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        lblMinOrder.text = String.init(format: "%@%d", AppConstants.currencySign ,AppConstants.restaurantData?.minOrder ?? 0)
    }
    
    //MARK: Create Viewcontrlloer instance
    static func instance(parentVC:SettingsMainVC)->OrderRequirmentVC?{
        guard let VC = UIStoryboard.init(name: "Settings", bundle: nil).instantiateViewController(withIdentifier: "OrderRequirmentVC") as? OrderRequirmentVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: Button Actions
    @IBAction func btnBackAction(_ sender:UIButton){
        self.view.removeFromSuperview()
        self.removeFromParent()
    }
    
    @IBAction func btnMinOrderAction(_ sender:UIButton){
        var settings = AlertSetting()
        settings.alertTitle = AppConstants.GlobalAlert.ALERT_SELECT_AMOUNT_TITLE
        settings.type = .kEnterAmount
        settings.textPlcaeholder = "amount"
        settings.textTitle = String.init(format: "%.2f", Double(AppConstants.restaurantData?.minOrder ?? 0))
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: settings){
            VC.delegate = self
        }
    }
    
    //MARK: WebService Methods
    func CallSaveMinOrder(order:Int){
        var dictParam = [String:Any]()
        dictParam["minimum_order"] = order
        
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kRestaurant)\(AppConstants.webResId ?? "")", method: "POST", isRestaurantAPI:true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let result = response as? NSDictionary, let jsonData = AppCommonMethods.convertToJson(object: result), let aLoginData = try? jsonDecoder.decode(RestaurantDetailModel.self, from: jsonData){
                    var settings = BottomAlertSettings()
                    settings.strMessage = "Minimum order has been updated"
                    AppValidation().showBottomAlertView(settings: settings)
                    if let encoded = AppCommonMethods.getjsonDataFromCodable(object: aLoginData) {
                        AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kUserData)
                    }
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
}

//MARK: AlertControllerDelegate
extension OrderRequirmentVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            CallSaveMinOrder(order: Int(data.value) ?? 0)
        }
    }
}
